/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.transforms.common.IOrderBy;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.common.OrderBySelectorTableModel;
import com.sas.wadmin.visuals.common.SortingColumnsTreeTableSelector;
import com.sas.wadmin.visuals.common.TablesPaletteTree;
import com.sas.wadmin.visuals.common.TablesPaletteTreeModel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.visuals.dualselector.DefaultSelectorTable;
import com.sas.workspace.visuals.dualselector.TreeTableSelector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;

public class OrderByPanel
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(OrderByPanel.class);
    private TreeTableSelector m_treeTableSelector;
    private TablesPaletteTree m_tree;
    private DefaultSelectorTable m_table;
    private IOrderBy m_orderBy;
    private TablesPaletteTreeModel m_treeModel;
    private OrderBySelectorTableModel m_tableModel;
    private JCheckBox m_ckbSortColumns;
    private ITable[] m_sourceTables;
    private ITable[] m_targetTables;

    public OrderByPanel(IOrderBy orderBy, ITable[] sourceTables, ITable[] targetTables) {
        this.m_orderBy = orderBy;
        this.m_sourceTables = sourceTables;
        this.m_targetTables = targetTables;
        this.initialize();
    }

    protected void initialize() {
        this.setHelpProduct("wdb");
        this.setHelpTopic("order_by_columns_tab");
        this.m_treeModel = new TablesPaletteTreeModel(this.m_sourceTables, this.m_targetTables);
        this.m_tree = new TablesPaletteTree((ITreeModel)this.m_treeModel);
        this.m_tree.setScrollsOnExpand(true);
        this.m_tree.setEditable(false);
        this.m_tree.setRootVisible(false);
        this.m_tableModel = new OrderBySelectorTableModel(this.m_orderBy);
        this.m_table = new DefaultSelectorTable((WsAbstractTableModel)this.m_tableModel);
        this.m_table.hideColumn(this.m_tableModel.getObjectColumnIndex());
        this.m_treeTableSelector = new SortingColumnsTreeTableSelector((JTree)((Object)this.m_tree), (JTable)this.m_table, this.m_tableModel.getObjectColumnIndex());
        boolean actionEnabled = this.isEditable();
        this.m_treeTableSelector.setCopyModeEnabled(actionEnabled);
        this.m_treeTableSelector.setCopyModeDuplicatesAllowed(false);
        this.m_treeTableSelector.setTransferAllControlsVisible(false);
        this.m_treeTableSelector.setDragAndDropEnabled(false);
        this.m_treeTableSelector.setParentNodesMoveable(false);
        this.m_treeTableSelector.setTargetControlsVisible(actionEnabled);
        JLabel treeLbl = (JLabel)this.m_treeTableSelector.getTargetLabelComponent();
        treeLbl.setText(bundle.getString("OrderByPanel.SelectedColumns.txt"));
        treeLbl.setDisplayedMnemonic(bundle.getString("OrderByPanel.SelectedColumns.mnem").charAt(0));
        JLabel tblLbl = (JLabel)this.m_treeTableSelector.getSourceLabelComponent();
        tblLbl.setText(bundle.getString("OrderByPanel.AvailableColumns.txt"));
        tblLbl.setDisplayedMnemonic(bundle.getString("OrderByPanel.AvailableColumns.mnem").charAt(0));
        this.m_ckbSortColumns = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"OrderByPanel.Checkbox.SortColumns", (int)5);
        this.m_ckbSortColumns.addActionListener(new cSortColumnsListener());
        this.setPreferredSize(new Dimension(450, 300));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_treeTableSelector, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_ckbSortColumns, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void updateComponents() {
        boolean actionEnabled = this.isEditable();
        this.m_treeTableSelector.setEnabled(actionEnabled);
        this.m_table.setEditable(actionEnabled);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_tableModel.moveDataToModel();
        IQuery query = this.m_orderBy.getParentQuery();
        if (query != null) {
            this.m_treeModel.removeAllChildren((ITreeNode)this.m_treeModel.getRoot());
            this.m_treeModel.addSourceAndTargetTables(query.getSourcesInFrom(), new ITable[]{query.getTargetTable()});
        } else {
            this.m_treeModel.moveDataToModel();
        }
        this.m_tree.expandRoot();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_tableModel != null) {
            this.m_tableModel.moveDataToStore();
        }
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.updateComponents();
    }

    public void saveSettingsAndCleanUp() {
        this.m_tableModel.saveSettingsAndCleanUp();
        this.m_tree.dispose();
        this.m_treeModel.dispose();
    }

    protected class cSortColumnsListener
    implements ActionListener {
        protected cSortColumnsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OrderByPanel.this.m_treeModel.setSortColumns(OrderByPanel.this.m_ckbSortColumns.isSelected());
        }
    }
}

