/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.impl.PromptDataProvider;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class OptionsPane
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(OptionsPane.class);
    private PromptPropertiesPanel m_pnlPrompt;
    protected IPromptModel m_promptModel;
    protected boolean m_bShowRequiredCheckbox = true;
    protected LoggerFactoryInterface m_logger;

    public OptionsPane(boolean bShowRequiredCheckbox) {
        this.m_bShowRequiredCheckbox = bShowRequiredCheckbox;
        this.setLayout(new BorderLayout());
    }

    public OptionsPane(IPromptModel model, boolean showRequiredCheckbox) {
        this(showRequiredCheckbox);
        this.m_promptModel = model;
        this.initialize();
    }

    public void setPromptModel(IPromptModel model) {
        if (this.m_promptModel == model) {
            return;
        }
        if (this.m_pnlPrompt != null) {
            this.validateData();
            this.m_pnlPrompt.onClose();
            this.remove((Component)this.m_pnlPrompt);
        }
        this.m_promptModel = model;
        if (this.m_promptModel != null) {
            try {
                this.m_pnlPrompt = this.createMainRunTimePanel();
                this.add((Component)this.m_pnlPrompt, "Center");
                this.validate();
                this.moveDataToView();
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (ServerConnectionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage());
            }
            catch (ServiceException e) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)e);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
        }
    }

    public void initialize() {
        try {
            this.m_pnlPrompt = this.createMainRunTimePanel();
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_pnlPrompt, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 5, 5), 0, 0));
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
    }

    public IPromptModel getModel() {
        return this.m_promptModel;
    }

    protected PromptPropertiesPanel createMainRunTimePanel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
        PromptValuesInterface values = this.m_promptModel.getPromptValues();
        PromptDataProvider prov = this.m_promptModel.getDataProvider();
        PromptPropertiesPanel panel = new PromptPropertiesPanel(values, (DataProviderInterface)prov, Locale.getDefault());
        panel.setShowRequiredCheckBox(this.m_bShowRequiredCheckbox);
        panel.setShowChildGroupPanels(false);
        panel.setShowResetPerDefinition(this.isEditable());
        panel.setPreferredSize(new Dimension(400, 400));
        return panel;
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        if (this.m_pnlPrompt != null) {
            this.m_pnlPrompt.onClose();
        }
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (this.m_pnlPrompt != null) {
            this.m_pnlPrompt.setEditable(editable);
            this.m_pnlPrompt.setShowResetPerDefinition(editable);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        if (this.m_pnlPrompt != null) {
            this.m_pnlPrompt.setPromptValues(this.m_promptModel.getPromptValues());
            List<IPromptDefinitionValue> refreshDefs = Arrays.asList(this.m_promptModel.getPromptDefinitionValues());
            if (refreshDefs != null) {
                int size = refreshDefs.size();
                for (int i = 0; i < size; ++i) {
                    this.m_pnlPrompt.refresh(refreshDefs.get(i).getDefinition());
                }
            }
        }
        this.setListeningForChanges(true);
    }

    public boolean validateData() {
        this.m_pnlPrompt.commitChanges();
        return true;
    }
}

