/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.INotesContainer;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.INote;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.app.AppDialogFactory;
import com.sas.wadmin.visuals.common.NotePreviewPane;
import com.sas.wadmin.visuals.common.NotesListModel;
import com.sas.workspace.CustomLayoutFocusTraversalPolicy;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsList;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectsSelectorPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NotesPane
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(NotesPane.class);
    private INotesContainer m_container;
    private INote m_currentNote;
    private JPopupMenu m_mnuNotesListPopup;
    private JLabel m_lblNotesList;
    private WsList m_lstNotesList;
    private JScrollPane m_scrNotesList;
    private NotesListModel m_mdlNotesList;
    private NotePreviewPane m_txtNote;
    private JButton m_btnDelete;
    private JButton m_btnNew;
    private JButton m_btnAttach;
    private WsAbstractAction m_actNew;
    private WsAbstractAction m_actDelete;
    private WsAbstractAction m_actAttach;
    private IModelListener m_lsnrModel;
    private boolean m_bNotesListChanged = false;
    private boolean m_bNoteChanged = false;

    public NotesPane(INotesContainer container) {
        this.m_container = container;
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.createActions();
        this.createNotesPopupMenu();
        this.m_mdlNotesList = new NotesListModel(this.m_container);
        this.m_lstNotesList = new WsList((ListModel)this.m_mdlNotesList);
        this.m_lstNotesList.setToolTipText(bundle.getString("NotesPane.NotesList.tip"));
        this.m_lstNotesList.setComponentPopupMenu(this.m_mnuNotesListPopup);
        this.m_lstNotesList.getSelectionModel().addListSelectionListener(new NotesListSelectionListener());
        this.m_lstNotesList.setSelectionMode(0);
        this.m_lstNotesList.getActionMap().put(this.m_actDelete, (Action)this.m_actDelete);
        this.m_lstNotesList.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDelete);
        this.m_lblNotesList = new JLabel(bundle.getString("NotesPane.Label.Assigned.txt"));
        this.m_lblNotesList.setDisplayedMnemonic(bundle.getString("NotesPane.Label.Assigned.mnem").charAt(0));
        this.m_lblNotesList.setLabelFor((Component)this.m_lstNotesList);
        this.m_txtNote = new NotePreviewPane();
        this.m_txtNote.setEnabled(false);
        JLabel lblNotesText = this.m_txtNote.getTextLabel();
        lblNotesText.setText(bundle.getString("NotesPane.Label.NoteText.txt"));
        lblNotesText.setDisplayedMnemonic(bundle.getString("NotesPane.Label.NoteText.mnem").charAt(0));
        this.m_btnNew = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNew);
        this.m_btnDelete = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDelete);
        this.m_btnAttach = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actAttach);
        CustomLayoutFocusTraversalPolicy.setNextFocusableComponent((Component)this.m_lstNotesList, (Component)this.m_txtNote);
        CustomLayoutFocusTraversalPolicy.setNextFocusableComponent((Component)this.m_txtNote, (Component)this.m_btnNew);
        this.m_txtNote.setDocumentListener(new NotesDocumentListener());
        this.m_lsnrModel = new ModelListener();
        this.m_container.getModel().addModelListener(this.m_lsnrModel);
        this.setHelpProduct("shared");
        this.setHelpTopic("sel_note");
    }

    private void createActions() {
        this.m_actNew = this.createNewAction();
        this.m_actDelete = this.createDeleteAction();
        this.m_actAttach = this.createAttachAction();
    }

    private WsAbstractAction createNewAction() {
        return new cNewAction();
    }

    private WsAbstractAction createDeleteAction() {
        return new cDeleteAction();
    }

    private WsAbstractAction createAttachAction() {
        return new cAttachAction();
    }

    private void createNotesPopupMenu() {
        this.m_mnuNotesListPopup = new JPopupMenu();
        this.m_mnuNotesListPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actNew));
        this.m_mnuNotesListPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actDelete));
    }

    private void updateActions() {
        boolean bEditable = this.isEditable();
        int[] aRows = this.m_lstNotesList.getSelectedIndices();
        boolean bSelected = aRows != null && aRows.length > 0;
        this.m_actNew.setEnabled(bEditable);
        this.m_actDelete.setEnabled(bEditable && bSelected);
        this.m_actAttach.setEnabled(bEditable);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.hasDataChanged()) {
            this.saveNoteText();
        }
    }

    public void saveSettingsAndCleanUp() {
        this.m_container.getModel().removeModelListener(this.m_lsnrModel);
        this.m_mdlNotesList.dispose();
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_lstNotesList.setEditable(bEditable);
        this.m_txtNote.setEditable(bEditable);
        this.updateActions();
    }

    public Component getDefaultFocusComponent() {
        return this.m_lstNotesList;
    }

    public boolean validateData() {
        if (this.m_bNotesListChanged) {
            ArrayList noteNameConflicts = new ArrayList();
            if (noteNameConflicts.isEmpty()) {
                return true;
            }
            if (noteNameConflicts.size() == 1) {
                int changeDuplicateName = MessageUtil.displayMessage((String)bundle.formatString("NotesPane.Error.OneDuplicateName.fmt.txt", noteNameConflicts.get(0)), (String)bundle.getString("NotesPane.DuplicateNameWarning.txt"), (int)2, (int)0);
                return changeDuplicateName != 0;
            }
            Collections.sort(noteNameConflicts);
            int changeDuplicateName = MessageUtil.displayListMessage((String)bundle.getString("NotesPane.Error.ManyDuplicateNames.txt"), noteNameConflicts, (String)bundle.getString("NotesPane.DuplicateNameWarning.txt"), (int)2, (int)0);
            return changeDuplicateName != 0;
        }
        return true;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("NotesPane.notesString.txt")));
        this.m_scrNotesList = new JScrollPane((Component)this.m_lstNotesList);
        this.m_scrNotesList.setToolTipText(bundle.getString("NotesPane.NotesList.tip"));
        this.m_txtNote.getTextPane().setToolTipText(bundle.getString("NotesPane.NoteText.tip"));
        JPanel m_pnlButtons = new JPanel((LayoutManager)new WsButtonsLayout());
        m_pnlButtons.add(this.m_btnNew);
        m_pnlButtons.add(this.m_btnDelete);
        m_pnlButtons.add(this.m_btnAttach);
        this.add(this.m_lblNotesList, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_scrNotesList, new GridBagConstraints(0, 1, 1, 1, 0.4, 1.0, 18, 1, new Insets(5, 0, 0, 10), 0, 0));
        this.add(this.m_txtNote, new GridBagConstraints(1, 0, 2, 2, 0.6, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(m_pnlButtons, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 0), 0, 0));
    }

    public void addNotesFocusListener(FocusListener f) {
        this.m_lstNotesList.addFocusListener(f);
        this.m_txtNote.getTextPane().addFocusListener(f);
    }

    public WsAbstractAction getDeleteAction() {
        return this.m_actDelete;
    }

    private void doDelete() {
        int iRow;
        if (this.m_lstNotesList.isEditing()) {
            this.m_lstNotesList.cancelCellEditing();
        }
        if ((iRow = this.getSelectedRow()) != -1) {
            this.m_container.getNotesList().remove(iRow);
            this.m_bNotesListChanged = true;
            this.setDataChanged(true);
        }
    }

    private void setNoteText() {
        if (this.m_currentNote != null) {
            if (!this.m_txtNote.getContents().equals(this.m_currentNote.getText())) {
                this.m_txtNote.setContents(this.m_currentNote.getText());
            }
            this.m_bNoteChanged = false;
        }
    }

    private void saveNoteText() {
        if (this.m_currentNote != null && this.m_bNoteChanged) {
            this.m_currentNote.setText(this.m_txtNote.getContents());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private INote[] loadNotesFromIDs(IModel mdl, String[] aIDs) throws RemoteException, MdException {
        OMRAdapter omr = new OMRAdapter(mdl, Workspace.getMdFactory(), "LoadNewNote");
        try {
            INote[] aNotes = new INote[aIDs.length];
            for (int iNote = 0; iNote < aIDs.length; ++iNote) {
                aNotes[iNote] = mdl.getObjectFactory().createNote(aIDs[iNote]);
                omr.populateFor((IOMRPersistable)aNotes[iNote]);
                aNotes[iNote].loadFromOMR(omr);
            }
            INote[] iNoteArray = aNotes;
            return iNoteArray;
        }
        finally {
            omr.dispose();
        }
    }

    private void doNew() {
        SimpleObject obj = AppDialogFactory.getInstance().showNewNoteDialog((JFrame)Workspace.getWorkspace(), null);
        if (obj == null) {
            return;
        }
        try {
            INote oNote = this.loadNotesFromIDs(this.m_container.getModel(), new String[]{obj.getID()})[0];
            this.m_container.getNotesList().add(oNote);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        this.m_bNotesListChanged = true;
        this.setDataChanged(true);
        this.m_lstNotesList.setSelectedIndex(this.m_mdlNotesList.getSize() - 1);
        this.m_lstNotesList.editCellAt(this.m_mdlNotesList.getSize() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAttach() throws RemoteException {
        ArrayList<String> salErrorValues = new ArrayList<String>();
        ObjectsSelectorPanel pnl = new ObjectsSelectorPanel(Workspace.getWorkspace().getUserContext(), 5);
        String sImportDialogTitle = bundle.getString("NotesPane.Attach.Title.txt");
        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sImportDialogTitle, true, (WAPanel)pnl);
        dlg.setResizable(true);
        dlg.setHelpProduct("shared");
        dlg.setHelpTopic("sel_note");
        dlg.show();
        if (dlg.getReturnValue() == 1) {
            SimpleObject[] aSelectedObjects = pnl.getSelectedObjects();
            if (aSelectedObjects.length == 0) {
                return;
            }
            ArrayList<String> lIDs = new ArrayList<String>();
            for (int iNote = 0; iNote < aSelectedObjects.length; ++iNote) {
                SimpleObject simpleObj = aSelectedObjects[iNote];
                if (!"Note".equals(simpleObj.getPublicType())) continue;
                if (!this.isDuplicate(simpleObj.getID())) {
                    lIDs.add(simpleObj.getID());
                    continue;
                }
                salErrorValues.add(simpleObj.getName());
            }
            this.m_container.getModel().startCompoundUndoable();
            try {
                String[] aIDs = lIDs.toArray(new String[lIDs.size()]);
                INote[] aNotes = this.loadNotesFromIDs(this.m_container.getModel(), aIDs);
                for (int iNote = 0; iNote < aNotes.length; ++iNote) {
                    this.m_container.getNotesList().add(aNotes[iNote]);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            finally {
                this.m_container.getModel().endCompoundUndoable();
            }
            if (salErrorValues.size() > 0) {
                MessageUtil.displayListMessage((String)bundle.getString("NotesTab.DuplicateObject.txt"), salErrorValues, (int)1);
            }
        }
        int inumNotes = this.m_container.getNotesList().size();
        String s_ids = "";
        for (int x = 0; x < inumNotes; ++x) {
            INote note = this.m_container.getNotes()[x];
            s_ids = s_ids + note.getID();
        }
    }

    private boolean isDuplicate(String strFQID) {
        List notesList = this.m_container.getNotesList();
        for (int i = 0; i < notesList.size(); ++i) {
            INote note = (INote)notesList.get(i);
            if (!note.getID().equalsIgnoreCase(strFQID)) continue;
            return true;
        }
        return false;
    }

    private int getSelectedRow() {
        int[] aRows = this.m_lstNotesList.getSelectedIndices();
        int iRow = aRows != null && aRows.length > 0 ? aRows[0] : -1;
        return iRow;
    }

    private class NotesListSelectionListener
    implements ListSelectionListener {
        private NotesListSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean bEnabled;
            NotesPane.this.m_lstNotesList.cancelCellEditing();
            boolean bTextEditable = false;
            boolean bDeleteEnabled = true;
            int iRow = NotesPane.this.getSelectedRow();
            if (iRow != -1) {
                INote newSelNote = NotesPane.this.m_container.getNotes()[iRow];
                if (NotesPane.this.m_currentNote != newSelNote) {
                    NotesPane.this.saveNoteText();
                    NotesPane.this.m_currentNote = newSelNote;
                    NotesPane.this.setNoteText();
                    NotesPane.this.m_txtNote.setEditable(Workspace.isObjectEditable((SimpleObject)newSelNote));
                }
                bDeleteEnabled = true;
                bTextEditable = true;
                OMRAdapter omrAdapter = null;
                try {
                    omrAdapter = new OMRAdapter(newSelNote.getModel(), Workspace.getMdFactory(), "NotesPane." + newSelNote.getName());
                    Document mdoDoc = (Document)omrAdapter.acquireOMRObject((IOMRPersistable)newSelNote);
                    bTextEditable = Workspace.getWorkspace().isObjectEditable((CMetadata)mdoDoc);
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
                finally {
                    omrAdapter.dispose();
                }
                bEnabled = bTextEditable;
            } else {
                NotesPane.this.saveNoteText();
                NotesPane.this.m_currentNote = null;
                NotesPane.this.m_txtNote.setContents("");
                bEnabled = false;
                bDeleteEnabled = false;
            }
            NotesPane.this.m_txtNote.setEnabled(bEnabled && NotesPane.this.isEditable() && bTextEditable);
            NotesPane.this.m_actDelete.setEnabled(bDeleteEnabled);
        }
    }

    private class NotesDocumentListener
    implements DocumentListener {
        private NotesDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            NotesPane.this.m_bNoteChanged = true;
            NotesPane.this.setDataChanged(true);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            NotesPane.this.m_bNoteChanged = true;
            NotesPane.this.setDataChanged(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            NotesPane.this.m_bNoteChanged = true;
            NotesPane.this.setDataChanged(true);
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            NotesPane.this.m_lstNotesList.cancelCellEditing();
            if (ev.getType() == "Note:TextChanged") {
                INote oNote = (INote)ev.getModelObject();
                int iRow = NotesPane.this.m_container.getNotesList().indexOf(oNote);
                if (iRow != -1) {
                    NotesPane.this.setNoteText();
                }
            }
        }
    }

    private class cNewAction
    extends WsAbstractAction {
        public cNewAction() {
            super(bundle, "NotesPane.New", 544);
        }

        public void actionPerformed(ActionEvent e) {
            NotesPane.this.doNew();
        }
    }

    private class cDeleteAction
    extends WsAbstractAction {
        public cDeleteAction() {
            super(bundle, "NotesPane.Delete", 544);
        }

        public void actionPerformed(ActionEvent e) {
            NotesPane.this.doDelete();
        }
    }

    private class cAttachAction
    extends WsAbstractAction {
        public cAttachAction() {
            super(bundle, "NotesPane.Attach");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                NotesPane.this.doAttach();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }
}

