/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.wadmin.visuals.common.KeysTreeModel;
import com.sas.workspace.WsActionContext;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.visuals.tree.AbstractCategoryTree;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;

public class KeysTree
extends AbstractCategoryTree {
    private WsPopupMenuRequestListener m_lsnrPopupMenuRequest;

    public KeysTree(KeysTreeModel mdlKeys) {
        super((ITreeModel)mdlKeys);
        this.getSelectionModel().setSelectionMode(1);
    }

    protected WsActionContextInterface createActionContext() {
        return new WsActionContext("KeysTab", (WsSelectionProvider)this);
    }

    public void setPopupMenuRequestListener(WsPopupMenuRequestListener lsnrPopupMenuRequest) {
        this.m_lsnrPopupMenuRequest = lsnrPopupMenuRequest;
    }

    protected void onPopup(Component component, int x, int y) {
        if (this.isContextMenusEnabled()) {
            if (!this.isEnabled() || this.m_lsnrPopupMenuRequest == null) {
                return;
            }
            Point pt = new Point(x, y);
            pt = SwingUtilities.convertPoint((Component)((Object)this), pt, component);
            MouseEvent e = new MouseEvent(component, 501, 0L, 0, pt.x, pt.y, 1, true);
            this.m_lsnrPopupMenuRequest.popupMenuRequested(e);
        }
    }

    public void selectObject(String id) {
        this.clearSelection();
        List lNodes = ((ITreeModel)this.getModel()).findNodes(id);
        for (int j = 0; j < lNodes.size(); ++j) {
            this.addSelectionPath(this.getPathFor((ITreeNode)lNodes.get(j)));
        }
        this.scrollPathToVisible(this.getLeadSelectionPath());
    }

    public void editObject(String id) {
        this.clearSelection();
        List lNodes = ((ITreeModel)this.getModel()).findNodes(id);
        for (int j = 0; j < lNodes.size(); ++j) {
            this.addSelectionPath(this.getPathFor((ITreeNode)lNodes.get(j)));
        }
        this.scrollPathToVisible(this.getLeadSelectionPath());
        this.startEditingAtPath(this.getLeadSelectionPath());
    }
}

