/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.common.IGroupBy;
import com.sas.etl.models.job.transforms.common.ISQLSortingColumn;
import com.sas.etl.models.job.transforms.common.ISortColumn;
import com.sas.wadmin.visuals.common.AbstractSQLSelectorTableModel;
import com.sas.wadmin.visuals.common.TablesPaletteTreeModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.util.ArrayList;
import java.util.List;

public class GroupBySelectorTableModel
extends AbstractSQLSelectorTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(GroupBySelectorTableModel.class);
    protected static final int COLUMN_REF_COL = 2;
    protected static final int GROUPBYCOLUMN_COL = 3;
    private ModelListener m_lsnrModel;

    public GroupBySelectorTableModel(IGroupBy groupBy) {
        this.m_mdlSorting = groupBy;
        this.m_aColumns = new WsAbstractTableColumn[4];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("AbstractSQLSelectorTableModel.TableName.txt"), 100);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("AbstractSQLSelectorTableModel.ColumnName.txt"), 100);
        this.m_aColumns[2] = new AbstractSQLSelectorTableModel.cListTableColumn(2, bundle.getString("AbstractSQLSelectorTableModel.ColumnRef.txt"), 75, this.getColumnReferenceTranslatedValues(), this.getColumnReferenceUnTranslatedValues(), DEFAULTCOLUMNREFERENCE);
        this.m_aColumns[3] = new WsObjectTableColumn();
        this.m_aColumns[3].setModelIndex(3);
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1].setEditable(false);
        this.addSQLModelListener();
        this.m_lsnrModel = new ModelListener();
        this.m_mdlSorting.getModel().addModelListener((IModelListener)this.m_lsnrModel);
    }

    @Override
    public int getAscDescColumnIndex() {
        return -1;
    }

    @Override
    public int getObjectColumnIndex() {
        return 3;
    }

    @Override
    public boolean hasAscendingDescendingColumn() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List createRowValues(Object obj) {
        if (obj instanceof TablesPaletteTreeModel.cColumnNode) {
            ArrayList<String> lRowValues = new ArrayList<String>();
            this.m_lsnrModel.setStopUpdating(true);
            this.m_mdlSorting.getModel().startCompoundUndoable();
            try {
                TablesPaletteTreeModel.cColumnNode columnTreeNode = (TablesPaletteTreeModel.cColumnNode)((Object)obj);
                String sColName = columnTreeNode.getName();
                IColumn oColumn = (IColumn)columnTreeNode.getData();
                ITable oTable = columnTreeNode.getTable();
                String sTableName = oTable.getName();
                ISQLSortingColumn groupByColumn = this.m_mdlSorting.getModel().getObjectFactory().createNewSQLSortingColumn(this.m_mdlSorting.getID(), oColumn);
                groupByColumn.setName(sTableName + "." + sColName);
                this.m_mdlSorting.addSortColumn((ISortColumn)groupByColumn);
                lRowValues.add(sTableName);
                lRowValues.add(sColName);
                lRowValues.add(DEFAULTCOLUMNREFERENCE);
                lRowValues.add((String)groupByColumn);
            }
            finally {
                this.m_lsnrModel.setStopUpdating(false);
                this.m_mdlSorting.getModel().endCompoundUndoable();
            }
            return lRowValues;
        }
        if (obj instanceof List) {
            ArrayList lRowValues = new ArrayList();
            lRowValues = (ArrayList)obj;
            return lRowValues;
        }
        return null;
    }

    public Object getRow(int iRow) {
        String sTable = (String)this.getValueAt(iRow, 0);
        String sName = (String)this.getValueAt(iRow, 1);
        String sRef = (String)this.getValueAt(iRow, 2);
        ISortColumn groupByColumn = (ISortColumn)this.getValueAt(iRow, 3);
        ArrayList<String> lRowValues = new ArrayList<String>();
        lRowValues.add(sTable);
        lRowValues.add(sName);
        lRowValues.add(sRef);
        lRowValues.add((String)groupByColumn);
        return lRowValues;
    }

    @Override
    public void updateSortingColumn(Object value, int row, int column) {
        ISQLSortingColumn oColumn = (ISQLSortingColumn)this.m_mdlSorting.getSortColumnList().get(row);
        switch (column) {
            case 2: {
                oColumn.setColumnReference(Integer.parseInt((String)value));
            }
        }
    }

    private void addSortingColumnToTable(ISQLSortingColumn oColumn, int iIndex) {
        if (iIndex < this.getRowCount() && this.getValueAt(iIndex, 3) == oColumn) {
            return;
        }
        String sTable = oColumn.getColumn().getTable().getName();
        String sName = oColumn.getColumn().getName();
        String sRef = Integer.toString(oColumn.getColumnReference());
        ArrayList<String> lRowValues = new ArrayList<String>();
        lRowValues.add(sTable);
        lRowValues.add(sName);
        lRowValues.add(sRef);
        lRowValues.add((String)oColumn);
        this.m_lData.add(iIndex, lRowValues);
        ++this.m_nRowInstances;
        this.fireTableRowsInserted(iIndex, iIndex);
    }

    private void deleteSortingColumnFromTable(ISQLSortingColumn oColumn) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            if (lValues.get(3) != oColumn) continue;
            List lDeleted = (List)this.m_lData.remove(iRow);
            this.fireTableRowDeleted(iRow, lDeleted);
            break;
        }
    }

    public void saveSettingsAndCleanUp() {
        this.removeSQLModelListener();
        this.m_mdlSorting.getModel().removeModelListener((IModelListener)this.m_lsnrModel);
    }

    private class ModelListener
    implements IModelListener {
        private boolean m_bStopUpdating = false;

        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            if (this.isStopUpdating()) {
                return;
            }
            String sType = ev.getType();
            if (sType.equalsIgnoreCase("SortingColumn:ReferenceChanged")) {
                ISQLSortingColumn oColumn;
                int iRow;
                if (ev.getModelObject() instanceof ISQLSortingColumn && (iRow = GroupBySelectorTableModel.this.m_mdlSorting.indexOfSortColumn((ISortColumn)(oColumn = (ISQLSortingColumn)ev.getModelObject()))) >= 0) {
                    GroupBySelectorTableModel.this.setValueAt(Integer.toString(oColumn.getColumnReference()), iRow, 2);
                }
            } else if (sType.equalsIgnoreCase("Sorting:ColumnAdded")) {
                ISQLSortingColumn oColumn;
                int iRow;
                if (ev.getData() instanceof ISQLSortingColumn && (iRow = GroupBySelectorTableModel.this.m_mdlSorting.indexOfSortColumn((ISortColumn)(oColumn = (ISQLSortingColumn)ev.getData()))) >= 0) {
                    GroupBySelectorTableModel.this.addSortingColumnToTable(oColumn, iRow);
                }
            } else if (sType.equalsIgnoreCase("Sorting:ColumnRemoved") && ev.getData() instanceof ISQLSortingColumn) {
                ISQLSortingColumn oColumn = (ISQLSortingColumn)ev.getData();
                GroupBySelectorTableModel.this.deleteSortingColumnFromTable(oColumn);
            }
        }

        public void setStopUpdating(boolean bStopUpdating) {
            this.m_bStopUpdating = bStopUpdating;
        }

        public boolean isStopUpdating() {
            return this.m_bStopUpdating;
        }
    }
}

