/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IExtendedAttributesContainer;
import com.sas.etl.models.other.IExtendedAttribute;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.visuals.common.ExtendedAttributesTableModel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsUndoManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class ExtendedAttributesTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ExtendedAttributesTab.class);
    private static final int UP = 0;
    private static final int DOWN = 1;
    private IExtendedAttributesContainer m_container;
    private ExtendedAttributesTableModel m_mdlExtAttrs;
    private WsTable m_tblExtAttrs;
    private JScrollPane m_scrExtAttrs;
    private JToolBar m_barTools;
    private JPopupMenu m_mnuTablePopup;
    private WsAbstractAction m_actNew;
    private WsAbstractAction m_actMoveUp;
    private WsAbstractAction m_actMoveDown;
    private WsAbstractAction m_actUndo;
    private WsAbstractAction m_actRedo;
    private WsAbstractAction m_actDelete;
    private ChangeListener m_lsnrUndo;
    private String m_sSettingsName;
    private static final String DEFAULT_SETTINGS_NAME = "ExtendedAttributesTab";
    private static final int DEFAULT_SCROLLABLE_VIEW_ROW_SIZE = 10;
    private int m_iScrollableViewSize;
    private JButton m_btnUndo;
    private JButton m_btnRedo;
    private JToolBar.Separator m_undoRedoSeparator;

    public ExtendedAttributesTab(IExtendedAttributesContainer container) {
        this(container, DEFAULT_SETTINGS_NAME, 10);
    }

    public ExtendedAttributesTab(IExtendedAttributesContainer container, String tableSettingsName, int scrollableViewSize) {
        this.m_iScrollableViewSize = scrollableViewSize;
        this.m_sSettingsName = tableSettingsName;
        this.m_container = container;
        this.initialize();
        this.setHelpProduct("shared");
        this.setHelpTopic("exattr_tab");
        this.setName(bundle.getString("ExtendedAttributesTab.Title.txt"));
    }

    protected void initialize() {
        this.createActions();
        this.createExtAttrsTable();
        this.createToolBar();
        this.createTablePopupMenu();
        this.setLayout(new GridBagLayout());
        this.add(this.m_barTools, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_scrExtAttrs, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void createExtAttrsTable() {
        this.m_mdlExtAttrs = new ExtendedAttributesTableModel(this.m_container);
        this.m_tblExtAttrs = new WsTable((WsAbstractTableModel)this.m_mdlExtAttrs);
        this.m_tblExtAttrs.setColumnsReorderable(false);
        this.m_tblExtAttrs.setColumnHoldingEnabled(false);
        this.m_tblExtAttrs.setColumnHidingEnabled(false);
        this.m_tblExtAttrs.setRowHoldingEnabled(false);
        this.m_tblExtAttrs.setAutoResizeMode(3);
        this.m_tblExtAttrs.setKeepSortedEnabled(true);
        this.m_tblExtAttrs.setDeleteKeyAction((Action)this.m_actDelete);
        TablePopupMenuRequestListener lsnr = new TablePopupMenuRequestListener();
        this.m_tblExtAttrs.setRowHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)lsnr);
        this.m_tblExtAttrs.setViewportPopupMenuRequestListener((WsPopupMenuRequestListener)lsnr);
        this.m_tblExtAttrs.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)lsnr);
        this.m_tblExtAttrs.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        ((WsDefaultTableRowModel)this.m_tblExtAttrs.getRowModel()).addRowModelListener((WsTableRowModelListener)new TableRowModelListener());
        WsUIUtilities.adjustPreferredScrollableViewportSize((JTable)this.m_tblExtAttrs, (int)this.m_iScrollableViewSize);
        this.m_scrExtAttrs = new JScrollPane((Component)this.m_tblExtAttrs);
        WsUIUtilities.adjustScrollPanePreferredSize((JScrollPane)this.m_scrExtAttrs);
    }

    public void setUndoRedoVisible(boolean isVisible) {
        this.m_btnUndo.setVisible(isVisible);
        this.m_btnRedo.setVisible(isVisible);
        this.m_undoRedoSeparator.setVisible(isVisible);
        this.m_actUndo.setActive(isVisible);
        this.m_actRedo.setActive(isVisible);
    }

    private void createToolBar() {
        this.m_barTools = WsUIUtilities.createToolBar();
        this.m_barTools.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actNew));
        this.m_barTools.addSeparator();
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actMoveUp));
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actMoveDown));
        this.m_barTools.addSeparator();
        this.m_btnUndo = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actUndo);
        this.m_btnRedo = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actRedo);
        this.m_undoRedoSeparator = new JToolBar.Separator();
        this.m_barTools.add(this.m_btnUndo);
        this.m_barTools.add(this.m_btnRedo);
        this.m_barTools.add(this.m_undoRedoSeparator);
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actDelete));
    }

    private void createTablePopupMenu() {
        this.m_mnuTablePopup = new JPopupMenu();
        this.m_mnuTablePopup.add(new JMenuItem((Action)this.m_actMoveUp));
        this.m_mnuTablePopup.add(new JMenuItem((Action)this.m_actMoveDown));
        this.m_mnuTablePopup.addSeparator();
        this.m_mnuTablePopup.add(new JMenuItem((Action)this.m_actDelete));
    }

    private void createActions() {
        this.m_actNew = new NewAction();
        this.m_actDelete = new DeleteAction();
        this.m_actMoveUp = new MoveUpAction();
        this.m_actMoveDown = new MoveDownAction();
        this.m_actUndo = new UndoAction();
        this.m_actRedo = new RedoAction();
    }

    private void initializeUndo() {
        if (this.m_lsnrUndo != null) {
            return;
        }
        WsUndoManager mgrUndo = (WsUndoManager)this.m_container.getModel().getUndoManager();
        this.m_lsnrUndo = new UndoManagerListener();
        mgrUndo.addChangeListener(this.m_lsnrUndo);
        this.m_actUndo.setEnabled(mgrUndo.canUndo());
        this.m_actRedo.setEnabled(mgrUndo.canRedo());
    }

    public boolean validateData() {
        return this.m_tblExtAttrs.stopCellEditing();
    }

    public void moveDataToView() {
        this.m_mdlExtAttrs.moveDataToModel();
        this.initializeUndo();
    }

    public void moveDataToStore() {
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tblExtAttrs.setEditable(bEditable);
        this.m_tblExtAttrs.setRowsReorderable(bEditable);
        this.updateActions();
    }

    public void saveSettingsAndCleanUp() {
        this.m_mdlExtAttrs.dispose();
        ((WsUndoManager)this.m_container.getModel().getUndoManager()).removeChangeListener(this.m_lsnrUndo);
        this.m_tblExtAttrs.saveSettings(this.m_sSettingsName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewExtendedAttribute() {
        if (!this.m_tblExtAttrs.stopCellEditing()) {
            return;
        }
        this.m_container.getModel().startCompoundUndoable();
        try {
            int iRow = this.m_tblExtAttrs.getLastSelectedRow();
            int iEA = iRow == -1 ? this.m_container.getExtendedAttributesList().size() - 1 : this.m_container.getExtendedAttributesList().indexOf(this.m_mdlExtAttrs.getExtendedAttributeForRow(iRow));
            this.m_tblExtAttrs.clearSelection();
            this.m_container.getModel().undoableEditHappened(this.m_tblExtAttrs.createClearSelectionUndoable(true, false));
            IExtendedAttribute ea = this.m_container.getModel().getObjectFactory().createNewExtendedAttribute(this.m_container.getID());
            ea.setName(this.m_mdlExtAttrs.createUniqueNameForNewExtendedAttribute());
            this.m_container.getExtendedAttributesList().add(iEA + 1, ea);
            this.m_tblExtAttrs.selectRow(iRow + 1);
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectExtendedAttributesUndoable(ea, false, true));
            int iEditColumn = Math.max(this.m_tblExtAttrs.convertColumnIndexToView(this.m_mdlExtAttrs.getDefaultEditColumnIndex()), 0);
            this.m_tblExtAttrs.editCellAt(iRow + 1, iEditColumn);
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSelectedExtendedAttributes() {
        if (!this.m_tblExtAttrs.stopCellEditing()) {
            return;
        }
        List lEAs = this.m_container.getExtendedAttributesList();
        this.m_container.getModel().startCompoundUndoable();
        try {
            int iRow;
            int[] aRows = this.m_tblExtAttrs.getSelectedRowsFromSelectedCells();
            IExtendedAttribute[] aExtAttrs = new IExtendedAttribute[aRows.length];
            for (iRow = 0; iRow < aRows.length; ++iRow) {
                int iModelRow = this.m_tblExtAttrs.convertRowIndexToModel(aRows[iRow]);
                aExtAttrs[iRow] = this.m_mdlExtAttrs.getExtendedAttributeForRow(iModelRow);
            }
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectExtendedAttributesUndoable(aExtAttrs, true, false));
            for (int iExtAttr = 0; iExtAttr < aExtAttrs.length; ++iExtAttr) {
                lEAs.remove(aExtAttrs[iExtAttr]);
            }
            this.m_container.getModel().undoableEditHappened(this.m_tblExtAttrs.createClearSelectionUndoable(true, true));
            iRow = Math.min(aRows[aRows.length - 1] - (aRows.length - 1), this.m_tblExtAttrs.getRowCount() - 1);
            if (iRow >= 0) {
                this.m_tblExtAttrs.selectRow(iRow);
            }
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveSelectedExtendedAttributes(int eDir) {
        if (!this.m_tblExtAttrs.stopCellEditing()) {
            return;
        }
        List lEAs = this.m_container.getExtendedAttributesList();
        this.m_container.getModel().startCompoundUndoable();
        try {
            int iExtAttr;
            int[] aRows = this.m_tblExtAttrs.getSelectedRowsFromSelectedCells();
            IExtendedAttribute[] aExtAttrs = new IExtendedAttribute[aRows.length];
            for (int iRow = 0; iRow < aRows.length; ++iRow) {
                aExtAttrs[iRow] = this.m_mdlExtAttrs.getExtendedAttributeForRow(aRows[iRow]);
            }
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectExtendedAttributesUndoable(aExtAttrs, true, false));
            if (eDir == 1) {
                for (iExtAttr = aExtAttrs.length - 1; iExtAttr >= 0; --iExtAttr) {
                    int index = lEAs.indexOf(aExtAttrs[iExtAttr]);
                    lEAs.add(index + 1, lEAs.remove(index));
                }
            } else {
                for (iExtAttr = 0; iExtAttr < aExtAttrs.length; ++iExtAttr) {
                    int index = lEAs.indexOf(aExtAttrs[iExtAttr]);
                    lEAs.add(index - 1, lEAs.remove(index));
                }
            }
            this.selectExtendedAttributes(aExtAttrs);
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectExtendedAttributesUndoable(aExtAttrs, false, true));
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveExtendedAttribute(int iFrom, int iTo) {
        if (!this.m_tblExtAttrs.stopCellEditing()) {
            return;
        }
        this.m_container.getModel().startCompoundUndoable();
        try {
            this.m_tblExtAttrs.clearSelection();
            IExtendedAttribute ea = this.m_mdlExtAttrs.getExtendedAttributeForRow(iFrom);
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectExtendedAttributesUndoable(ea, true, false));
            List lExtAttrs = this.m_container.getExtendedAttributesList();
            lExtAttrs.remove(ea);
            lExtAttrs.add(iTo, ea);
            this.m_tblExtAttrs.selectRow(iTo);
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectExtendedAttributesUndoable(ea, false, true));
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    private void updateActions() {
        boolean bSelected;
        int[] aSelectedRows = this.m_tblExtAttrs.getSelectedRowsFromSelectedCells();
        boolean bEditable = this.isEditable();
        boolean bNotSorted = !this.m_tblExtAttrs.isSorted();
        boolean bNotFirst = bSelected = aSelectedRows.length > 0;
        boolean bNotLast = bSelected;
        int iLastRow = this.m_tblExtAttrs.getRowCount() - 1;
        for (int iSelectedRow = 0; iSelectedRow < aSelectedRows.length; ++iSelectedRow) {
            if (aSelectedRows[iSelectedRow] == 0) {
                bNotFirst = false;
            }
            if (aSelectedRows[iSelectedRow] != iLastRow) continue;
            bNotLast = false;
        }
        this.m_actNew.setEnabled(bEditable && bNotSorted);
        this.m_actDelete.setEnabled(bEditable && bSelected);
        this.m_actMoveUp.setEnabled(bEditable && bNotSorted && bNotFirst);
        this.m_actMoveDown.setEnabled(bEditable && bNotSorted && bNotLast);
    }

    private void selectExtendedAttributes(IExtendedAttribute[] aExtAttrs) {
        this.m_tblExtAttrs.clearSelection();
        for (int iExtAttr = 0; iExtAttr < aExtAttrs.length; ++iExtAttr) {
            int iRow = this.m_mdlExtAttrs.getRowIndex(aExtAttrs[iExtAttr]);
            if (iRow == -1) continue;
            this.m_tblExtAttrs.addRowToSelection(this.m_tblExtAttrs.convertRowIndexToView(iRow));
        }
    }

    private class TablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        private TablePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            ExtendedAttributesTab.this.m_mnuTablePopup.show((Component)ev.getSource(), ev.getX(), ev.getY());
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ExtendedAttributesTab.this.updateActions();
        }
    }

    private class TableRowModelListener
    implements WsTableRowModelListener {
        private TableRowModelListener() {
        }

        public void rowDragged(TableRowModelEvent ev) {
            WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)ExtendedAttributesTab.this.m_tblExtAttrs.getRowModel();
            mdlRows.clearRowMoves();
            ExtendedAttributesTab.this.moveExtendedAttribute(ev.getFromIndex(), ev.getToIndex());
        }

        public void rowsHidden(WsTableRowModelEvent e) {
        }

        public void rowsShown(WsTableRowModelEvent e) {
        }

        public void rowsRemapped(ChangeEvent e) {
            ExtendedAttributesTab.this.updateActions();
        }
    }

    private class NewAction
    extends WsAbstractAction {
        public NewAction() {
            super(bundle, "ExtendedAttributesTab.Action.New", 2);
        }

        public void actionPerformed(ActionEvent e) {
            ExtendedAttributesTab.this.createNewExtendedAttribute();
        }
    }

    private class DeleteAction
    extends WsAbstractAction {
        public DeleteAction() {
            super(bundle, "ExtendedAttributesTab.Action.Delete", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:DeleteRows"));
        }

        public void actionPerformed(ActionEvent e) {
            ExtendedAttributesTab.this.deleteSelectedExtendedAttributes();
        }
    }

    private class MoveUpAction
    extends WsAbstractAction {
        public MoveUpAction() {
            super(bundle, "ExtendedAttributesTab.Action.MoveUp", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveUp"));
            this.setToolTipText(bundle.getString("ExtendedAttributesTab.Action.MoveUp.tip"));
        }

        public void actionPerformed(ActionEvent e) {
            ExtendedAttributesTab.this.moveSelectedExtendedAttributes(0);
        }
    }

    private class MoveDownAction
    extends WsAbstractAction {
        public MoveDownAction() {
            super(bundle, "ExtendedAttributesTab.Action.MoveDown", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveDown"));
            this.setToolTipText(bundle.getString("ExtendedAttributesTab.Action.MoveDown.tip"));
        }

        public void actionPerformed(ActionEvent e) {
            ExtendedAttributesTab.this.moveSelectedExtendedAttributes(1);
        }
    }

    private class UndoAction
    extends WsAbstractAction {
        public UndoAction() {
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Undo"));
            this.setToolTipText(bundle.getString("ExtendedAttributesTab.Action.Undo.tip"));
        }

        public void actionPerformed(ActionEvent ev) {
            ExtendedAttributesTab.this.m_container.getModel().getUndoManager().undo();
        }
    }

    private class RedoAction
    extends WsAbstractAction {
        public RedoAction() {
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Redo"));
            this.setToolTipText(bundle.getString("ExtendedAttributesTab.Action.Redo.tip"));
        }

        public void actionPerformed(ActionEvent ev) {
            ExtendedAttributesTab.this.m_container.getModel().getUndoManager().redo();
        }
    }

    private class UndoManagerListener
    implements ChangeListener {
        private UndoManagerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            UndoManager mgrUndo = ExtendedAttributesTab.this.m_container.getModel().getUndoManager();
            ExtendedAttributesTab.this.m_actUndo.setEnabled(mgrUndo.canUndo());
            ExtendedAttributesTab.this.m_actRedo.setEnabled(mgrUndo.canRedo());
        }
    }

    private class SelectExtendedAttributesUndoable
    extends AbstractUndoableEdit {
        private IExtendedAttribute[] m_aExtendedAttributes;
        private boolean m_bOnUndo;
        private boolean m_bOnRedo;

        public SelectExtendedAttributesUndoable(IExtendedAttribute column, boolean bOnUndo, boolean bOnRedo) {
            this(new IExtendedAttribute[]{column}, bOnUndo, bOnRedo);
        }

        public SelectExtendedAttributesUndoable(IExtendedAttribute[] aExtendedAttributes, boolean bOnUndo, boolean bOnRedo) {
            this.m_aExtendedAttributes = aExtendedAttributes;
            this.m_bOnUndo = bOnUndo;
            this.m_bOnRedo = bOnRedo;
        }

        @Override
        public void undo() {
            super.undo();
            ExtendedAttributesTab.this.m_tblExtAttrs.cancelCellEditing();
            if (this.m_bOnUndo) {
                ExtendedAttributesTab.this.selectExtendedAttributes(this.m_aExtendedAttributes);
            }
        }

        @Override
        public void redo() {
            super.redo();
            ExtendedAttributesTab.this.m_tblExtAttrs.cancelCellEditing();
            if (this.m_bOnRedo) {
                ExtendedAttributesTab.this.selectExtendedAttributes(this.m_aExtendedAttributes);
            }
        }

        @Override
        public void die() {
            super.die();
            Arrays.fill(this.m_aExtendedAttributes, null);
            this.m_aExtendedAttributes = null;
        }
    }
}

