/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.scd.ISCDTransformModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.common.DateRangeTableModel;
import com.sas.wadmin.visuals.common.ExpressionBuilderTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDialogTableCellEditor;
import com.sas.workspace.WsDialogTableCellEditorInterface;
import com.sas.workspace.WsTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.rmi.RemoteException;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class DateRangePanel
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(DateRangePanel.class);
    private WsTable m_dateRangeTable;
    private DateRangeTableModel m_dateRangeModel;
    private JScrollPane m_dateRangeScrollPane;
    private TableModelListener m_lsnrTableModel;
    private ISCDTransformModel m_model;

    public DateRangePanel(ISCDTransformModel model) {
        this.m_model = model;
        this.initialize();
        this.setName(bundle.getString("DateRangePanel.Name.txt"));
        this.setHelpTopic("change_tracking_key_tab");
        this.setHelpProduct("wdb");
    }

    protected void initialize() {
        this.createListeners();
        this.createDateRangeTable();
        this.setLayout(new BorderLayout());
        this.add(this.m_dateRangeScrollPane, "Center");
    }

    protected void createDateRangeTable() {
        this.m_dateRangeModel = new DateRangeTableModel(this.m_model);
        this.m_dateRangeTable = new WsTable((WsAbstractTableModel)this.m_dateRangeModel);
        this.m_dateRangeTable.setToolTipText(bundle.getString("DateRangePanel.Table.ToolTip.txt"));
        this.m_dateRangeTable.setRowsReorderable(false);
        this.m_dateRangeTable.setPopupMenuEnabled(false);
        this.m_dateRangeTable.setRowHoldingEnabled(false);
        this.m_dateRangeTable.setRowHeaderVisible(false);
        this.m_dateRangeTable.setColumnHoldingEnabled(false);
        this.m_dateRangeTable.setColumnHeaderPopupMenuEnabled(false);
        this.m_dateRangeTable.setSortingEnabled(false);
        this.m_dateRangeTable.setColumnsReorderable(false);
        this.m_dateRangeTable.setAutoResizeMode(4);
        this.m_dateRangeScrollPane = new JScrollPane((Component)this.m_dateRangeTable);
        this.m_dateRangeModel.addTableModelListener(this.m_lsnrTableModel);
        int iColumn = this.m_dateRangeTable.convertColumnIndexToView(2);
        if (iColumn >= 0) {
            WsDialogTableCellEditor edtExpression = new WsDialogTableCellEditor();
            edtExpression.setDialog((WsDialogTableCellEditorInterface)new cExpressionDialog());
            edtExpression.setStopEditingOnDialogClose(true);
            TableColumn colExpression = this.m_dateRangeTable.getColumnModel().getColumn(iColumn);
            colExpression.setCellEditor((TableCellEditor)edtExpression);
        }
    }

    protected void createListeners() {
        this.m_lsnrTableModel = this.createTableModelListener();
    }

    public boolean validateData() {
        if (!this.m_dateRangeModel.isModelLoaded()) {
            return true;
        }
        if (!this.m_dateRangeTable.stopCellEditing()) {
            return false;
        }
        IColumn fromDateColumn = this.m_model.getFromDateColumn();
        if (fromDateColumn == null) {
            MessageUtil.displayMessage((String)bundle.getString("DateRangePanel.NoFromDateColumn.txt"), (int)0);
            this.m_dateRangeTable.selectCell(0, 1);
            return false;
        }
        IColumn toDateColumn = this.m_model.getToDateColumn();
        if (toDateColumn == null) {
            MessageUtil.displayMessage((String)bundle.getString("DateRangePanel.NoToDateColumn.txt"), (int)0);
            this.m_dateRangeTable.selectCell(1, 1);
            return false;
        }
        if (toDateColumn.getID().equalsIgnoreCase(fromDateColumn.getID())) {
            MessageUtil.displayMessage((String)bundle.getString("DateRangePanel.NoSameDateColumn.txt"), (int)0);
            this.m_dateRangeTable.selectCell(1, 1);
            return false;
        }
        if (fromDateColumn.getType() != 1) {
            MessageUtil.displayMessage((String)bundle.formatString("DateRangePanel.ColumnNotNumeric.txt", (Object)fromDateColumn.getName(), (Object)bundle.getString("DateRangePanel.TableRowName0.txt")), (int)0);
            this.m_dateRangeTable.selectCell(0, 1);
            return false;
        }
        if (toDateColumn.getType() != 1) {
            MessageUtil.displayMessage((String)bundle.formatString("DateRangePanel.ColumnNotNumeric.txt", (Object)toDateColumn.getName(), (Object)bundle.getString("DateRangePanel.TableRowName1.txt")), (int)0);
            this.m_dateRangeTable.selectCell(1, 1);
            return false;
        }
        ITextExpression fromExpression = this.m_model.getFromDateExpression();
        ITextExpression toExpression = this.m_model.getToDateExpression();
        if (fromExpression != null && toExpression != null) {
            try {
                String fromText = fromExpression.getText(null, this.m_model.isQuotingNeeded());
                String toText = this.m_model.getToDateExpression().getText(null, this.m_model.isQuotingNeeded());
                if (fromText != null && toText != null && fromText.length() > 0 && toText.length() > 0 && fromText.equalsIgnoreCase(toText)) {
                    MessageUtil.displayMessage((String)bundle.getString("DateRangePanel.SameExprError.txt"), (int)0);
                    this.m_dateRangeTable.selectCell(1, 2);
                    return false;
                }
            }
            catch (RemoteException e1) {
                Workspace.handleRemoteException((RemoteException)e1);
            }
            catch (CodegenException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (MdException e1) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
            }
            catch (BadServerDefinitionException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (ServerException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
        }
        return true;
    }

    public void moveDataToView() {
        this.setListeningForChanges(false);
        this.m_dateRangeModel.moveDataToModel();
        this.setListeningForChanges(true);
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_dateRangeTable.setEditable(bEditable);
    }

    public boolean stopTableEditing() {
        return this.m_dateRangeTable.stopCellEditing();
    }

    public void saveSettingsAndCleanUp() {
        this.m_dateRangeModel.dispose();
    }

    protected TableModelListener createTableModelListener() {
        return new cTableModelListener();
    }

    protected String showExpressionBuilderDialog(int iRow, String sExpression) {
        ITable[] targets = this.m_model.getTargetTables();
        if (targets == null || targets.length == 0) {
            return null;
        }
        String rowName = bundle.getString("DateRangePanel.TableRowName" + iRow + ".txt");
        String title = bundle.formatString("DateRangePanel.Expression.Title.txt", (Object)rowName);
        ExpressionBuilderTab expressionBuilder = new ExpressionBuilderTab(null, targets, false);
        expressionBuilder.setExpression(sExpression);
        expressionBuilder.setUseQuotes(targets[0].isQuoted());
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), title, true, (WAPanel)expressionBuilder);
        dialog.setResizable(true);
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            return expressionBuilder.getExpression();
        }
        return null;
    }

    public void selectFirstRow() {
        this.m_dateRangeTable.setRowSelectionInterval(0, 1);
    }

    public void clearSelection() {
        this.m_dateRangeTable.clearSelection();
    }

    protected class cExpressionDialog
    implements WsDialogTableCellEditorInterface {
        protected cExpressionDialog() {
        }

        public String showDialog(JTable tbl, int iRow, int iCol, String sValue) {
            iRow = ((WsTable)tbl).convertRowIndexToModel(iRow);
            return DateRangePanel.this.showExpressionBuilderDialog(iRow, sValue);
        }
    }

    class cTableModelListener
    implements TableModelListener {
        cTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (DateRangePanel.this.isListeningForChanges()) {
                DateRangePanel.this.setDataChanged(true);
            }
        }
    }
}

