/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.etl.models.IExtendedAttributesContainer;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.externalfile.IFixedWidthExternalFile;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.app.AppViewFactory;
import com.sas.wadmin.visuals.common.ColumnsTableModel;
import com.sas.wadmin.visuals.common.ExtendedAttributesTab;
import com.sas.wadmin.visuals.common.ImportNewColumnsPanel;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsUndoManager;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectsSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class ColumnsTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ColumnsTab.class);
    private static final int UP = 0;
    private static final int DOWN = 1;
    public static final int NEW_COLUMN_ACTION = 0;
    public static final int IMPORT_ACTION = 1;
    public static final int PROPERTIES_ACTION = 2;
    public static final int ANALYZE_ACTION = 3;
    public static final int MOVE_UP_ACTION = 4;
    public static final int MOVE_DOWN_ACTION = 5;
    public static final int UNDO_ACTION = 6;
    public static final int REDO_ACTION = 7;
    public static final int SELECT_ALL_ACTION = 8;
    public static final int DELETE_ACTION = 9;
    public static final int OVERLAP_ACTION = 10;
    public static final int SAVE_CURRENT_COLUMN_ORDER_ACTION = 11;
    private Configuration m_configuration;
    private ITable m_table;
    private ColumnsTableModel m_mdlColumns;
    private WsTable m_tblColumns;
    private JScrollPane m_scrColumns;
    private JToolBar m_barTools;
    private JCheckBox m_ckbOverlap;
    private JPopupMenu m_mnuTablePopup;
    private JPopupMenu m_mnuRowHeaderPopup;
    private JPopupMenu m_mnuViewportPopup;
    private WsAbstractAction m_actNewColumn;
    private WsAbstractAction m_actImport;
    private WsAbstractAction m_actProperties;
    private WsAbstractAction m_actAnalyze;
    private WsAbstractAction m_actMoveUp;
    private WsAbstractAction m_actMoveDown;
    private WsAbstractAction m_actUndo;
    private WsAbstractAction m_actRedo;
    private WsAbstractAction m_actSelectAll;
    private WsAbstractAction m_actDelete;
    private WsAbstractToggleAction m_actOverlap;
    private WsAbstractAction m_actSaveCurrentColumnOrder;
    private ChangeListener m_lsnrUndo;
    private IModelListener m_lsnrModel;

    public ColumnsTab(ITable table) {
        this(table, new Configuration());
    }

    public ColumnsTab(ITable table, Configuration configuration) {
        this.m_table = table;
        this.m_configuration = configuration;
        this.initialize();
        this.setName(bundle.getString("ColumnsTab.Name.txt"));
        this.setHelpTopic("columns_tab");
        this.setHelpProduct("shared");
    }

    protected void initialize() {
        this.createActions();
        this.m_mdlColumns = this.createModel(this.m_table);
        this.createTable();
        this.createToolBar();
        this.createTablePopupMenu();
        this.createRowHeaderPopupMenu();
        this.createViewportPopupMenu();
        this.createOverlapCheckBox();
        this.layoutComponents();
        this.m_lsnrModel = new ModelListener();
        if (this.m_table != null) {
            this.m_table.getModel().addModelListener(this.m_lsnrModel);
        }
    }

    private void createActions() {
        this.m_actNewColumn = new NewColumnAction();
        this.m_actImport = new ImportColumnsAction();
        this.m_actMoveUp = new MoveUpAction();
        this.m_actMoveDown = new MoveDownAction();
        this.m_actProperties = new PropertiesAction();
        this.m_actAnalyze = new AnalyzeAction();
        this.m_actUndo = new UndoAction();
        this.m_actRedo = new RedoAction();
        this.m_actSelectAll = new SelectAllColumnsAction();
        this.m_actDelete = new DeleteColumnsAction();
        this.m_actOverlap = new OverlapAction();
        this.m_actSaveCurrentColumnOrder = new SaveCurrentColumnOrderAction();
    }

    protected ColumnsTableModel createModel(ITable table) {
        return new ColumnsTableModel(this.m_table);
    }

    protected ColumnsTableModel getModel() {
        return this.m_mdlColumns;
    }

    private void createTable() {
        this.m_tblColumns = new WsTable((WsAbstractTableModel)this.m_mdlColumns);
        this.m_scrColumns = new JScrollPane((Component)this.m_tblColumns);
        this.m_tblColumns.setKeepSortedEnabled(true);
        this.m_tblColumns.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)new TablePopupMenuListener());
        this.m_tblColumns.setRowHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)new RowHeaderPopupMenuListener());
        this.m_tblColumns.setViewportPopupMenuRequestListener((WsPopupMenuRequestListener)new ViewportPopupMenuListener());
        this.m_tblColumns.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        ((WsDefaultTableRowModel)this.m_tblColumns.getRowModel()).addRowModelListener((WsTableRowModelListener)new RowModelListener());
        if (!this.m_configuration.isActionHidden(9)) {
            this.m_tblColumns.setDeleteKeyAction((Action)this.m_actDelete);
        }
        int[] aHiddenColumns = this.m_configuration.getPermanentlyHiddenColumns();
        for (int iColumn = 0; iColumn < aHiddenColumns.length; ++iColumn) {
            this.m_tblColumns.removeColumn(aHiddenColumns[iColumn]);
        }
        this.m_tblColumns.restoreSettings(this.m_configuration.getSettingsPrefix() + ".Table");
    }

    private void createToolBar() {
        this.m_barTools = WsUIUtilities.createToolBar();
        boolean bAddSeparator = this.addFlatToolButton(0, this.m_actNewColumn);
        if (bAddSeparator |= this.addFlatToolButton(1, this.m_actImport)) {
            this.m_barTools.addSeparator();
        }
        bAddSeparator = this.addFlatToolButton(2, this.m_actProperties);
        if (bAddSeparator |= this.addFlatToolButton(3, this.m_actAnalyze)) {
            this.m_barTools.addSeparator();
        }
        bAddSeparator = this.addFlatToolButton(4, this.m_actMoveUp);
        if (bAddSeparator |= this.addFlatToolButton(5, this.m_actMoveDown)) {
            this.m_barTools.addSeparator();
        }
        bAddSeparator = this.addFlatToolButton(6, this.m_actUndo);
        if (bAddSeparator |= this.addFlatToolButton(7, this.m_actRedo)) {
            this.m_barTools.addSeparator();
        }
        if (!(bAddSeparator = this.addFlatToolButton(9, this.m_actDelete))) {
            this.removeLastSeparator(this.m_barTools);
        }
    }

    private boolean addFlatToolButton(int eAction, WsAbstractAction action) {
        if (this.m_configuration.isActionHidden(eAction)) {
            return false;
        }
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)action));
        return true;
    }

    private void createTablePopupMenu() {
        this.m_mnuTablePopup = new JPopupMenu();
        boolean bAddSeparator = this.addMenuItem(this.m_mnuTablePopup, 0, this.m_actNewColumn);
        if (bAddSeparator |= this.addMenuItem(this.m_mnuTablePopup, 1, this.m_actImport)) {
            this.m_mnuTablePopup.addSeparator();
        }
        bAddSeparator = this.addMenuItem(this.m_mnuTablePopup, 2, this.m_actProperties);
        if (bAddSeparator |= this.addMenuItem(this.m_mnuTablePopup, 3, this.m_actAnalyze)) {
            this.m_mnuTablePopup.addSeparator();
        }
        bAddSeparator = this.addMenuItem(this.m_mnuTablePopup, 4, this.m_actMoveUp);
        if (bAddSeparator |= this.addMenuItem(this.m_mnuTablePopup, 5, this.m_actMoveDown)) {
            this.m_mnuTablePopup.addSeparator();
        }
        bAddSeparator = this.addMenuItem(this.m_mnuTablePopup, 9, this.m_actDelete);
        if (bAddSeparator |= this.addMenuItem(this.m_mnuTablePopup, 8, this.m_actSelectAll)) {
            this.m_mnuTablePopup.addSeparator();
        }
        if (!(bAddSeparator = this.addMenuItem(this.m_mnuTablePopup, 11, this.m_actSaveCurrentColumnOrder))) {
            this.removeLastSeparator(this.m_mnuTablePopup);
        }
    }

    private void createRowHeaderPopupMenu() {
        this.m_mnuRowHeaderPopup = new JPopupMenu();
        boolean bAddSeparator = this.addMenuItem(this.m_mnuRowHeaderPopup, 0, this.m_actNewColumn);
        if (bAddSeparator |= this.addMenuItem(this.m_mnuRowHeaderPopup, 1, this.m_actImport)) {
            this.m_mnuRowHeaderPopup.addSeparator();
        }
        bAddSeparator = this.addMenuItem(this.m_mnuRowHeaderPopup, 2, this.m_actProperties);
        if (bAddSeparator |= this.addMenuItem(this.m_mnuRowHeaderPopup, 3, this.m_actAnalyze)) {
            this.m_mnuRowHeaderPopup.addSeparator();
        }
        bAddSeparator = this.addMenuItem(this.m_mnuRowHeaderPopup, 4, this.m_actMoveUp);
        if (bAddSeparator |= this.addMenuItem(this.m_mnuRowHeaderPopup, 5, this.m_actMoveDown)) {
            this.m_mnuRowHeaderPopup.addSeparator();
        }
        bAddSeparator = this.addMenuItem(this.m_mnuRowHeaderPopup, 9, this.m_actDelete);
        if (bAddSeparator |= this.addMenuItem(this.m_mnuRowHeaderPopup, 8, this.m_actSelectAll)) {
            this.m_mnuRowHeaderPopup.addSeparator();
        }
        if (!(bAddSeparator = this.addMenuItem(this.m_mnuRowHeaderPopup, 11, this.m_actSaveCurrentColumnOrder))) {
            this.removeLastSeparator(this.m_mnuRowHeaderPopup);
        }
        this.m_tblColumns.addRowHeaderMenuItems(this.m_mnuRowHeaderPopup);
        WsUIUtilities.addSpaceIconToPopupMenu((JPopupMenu)this.m_mnuRowHeaderPopup);
    }

    private void createViewportPopupMenu() {
        this.m_mnuViewportPopup = new JPopupMenu();
        boolean bAddSeparator = this.addMenuItem(this.m_mnuViewportPopup, 0, this.m_actNewColumn);
        if (bAddSeparator |= this.addMenuItem(this.m_mnuViewportPopup, 1, this.m_actImport)) {
            this.m_mnuViewportPopup.addSeparator();
        }
        if (bAddSeparator = this.addMenuItem(this.m_mnuViewportPopup, 8, this.m_actSelectAll)) {
            this.m_mnuViewportPopup.addSeparator();
        }
        if (!(bAddSeparator = this.addMenuItem(this.m_mnuViewportPopup, 11, this.m_actSaveCurrentColumnOrder))) {
            this.removeLastSeparator(this.m_mnuViewportPopup);
        }
    }

    private boolean addMenuItem(JPopupMenu mnuPopup, int eAction, WsAbstractAction action) {
        if (this.m_configuration.isActionHidden(eAction)) {
            return false;
        }
        mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)action));
        return true;
    }

    private boolean removeLastSeparator(JComponent cmp) {
        int nComponents = cmp.getComponentCount();
        if (nComponents == 0) {
            return false;
        }
        Component cmpLast = cmp.getComponent(nComponents - 1);
        if (cmpLast instanceof JSeparator) {
            cmp.remove(cmpLast);
            return true;
        }
        return false;
    }

    private void createOverlapCheckBox() {
        this.m_ckbOverlap = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actOverlap);
        this.m_ckbOverlap.setVisible(!this.m_configuration.isActionHidden(10));
    }

    private void initializeUndo() {
        if (this.m_lsnrUndo != null) {
            return;
        }
        WsUndoManager mgrUndo = (WsUndoManager)this.m_table.getModel().getUndoManager();
        this.m_lsnrUndo = new UndoManagerListener();
        mgrUndo.addChangeListener(this.m_lsnrUndo);
        this.m_actUndo.setEnabled(mgrUndo.canUndo());
        this.m_actRedo.setEnabled(mgrUndo.canRedo());
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add(this.m_barTools, "North");
        this.add(this.m_scrColumns, "Center");
        this.add(this.m_ckbOverlap, "South");
    }

    public void moveDataToView() {
        this.m_mdlColumns.moveDataToModel();
        if (!this.m_configuration.isActionHidden(10)) {
            IExternalTable extTable = (IExternalTable)this.m_table;
            boolean bEnabled = ((IFixedWidthExternalFile)extTable.getFile()).isOverlapEnabled();
            this.m_ckbOverlap.setSelected(bEnabled);
        }
        this.initializeUndo();
        this.updateActions();
    }

    public boolean validateData() {
        if (!this.m_tblColumns.stopCellEditing()) {
            return false;
        }
        int iViewInformatColumn = this.m_tblColumns.convertColumnIndexToView(4);
        int iViewFormatColumn = this.m_tblColumns.convertColumnIndexToView(5);
        for (int iRow = 0; iRow < this.m_tblColumns.getRowCount(); ++iRow) {
            int iModelRow = this.m_tblColumns.convertRowIndexToModel(iRow);
            String sType = this.m_mdlColumns.getColumnForRow(iModelRow).getType() == 0 ? WsColumnMetadataUtil.getDataCharacterType() : WsColumnMetadataUtil.getDataNumericType();
            String sInformat = (String)this.m_mdlColumns.getValueAt(iModelRow, 4);
            if (!sInformat.equals(WsColumnMetadataUtil.NONE) && !WsColumnMetadataUtil.isInformatNameValid((String)sInformat, (String)sType)) {
                String sMessage = bundle.getString("ColumnsTab.Error.InvalidInformat.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                if (iViewFormatColumn != -1) {
                    this.m_tblColumns.selectCell(iRow, iViewInformatColumn);
                    this.m_tblColumns.editCellAt(iRow, iViewInformatColumn);
                }
                return false;
            }
            String sFormat = (String)this.m_mdlColumns.getValueAt(iModelRow, 5);
            if (sFormat.equals(WsColumnMetadataUtil.NONE) || WsColumnMetadataUtil.isFormatNameValid((String)sFormat, (String)sType)) continue;
            String sMessage = bundle.getString("ColumnsTab.Error.InvalidFormat.txt");
            MessageUtil.displayMessage((String)sMessage, (int)0);
            if (iViewFormatColumn != -1) {
                this.m_tblColumns.selectCell(iRow, iViewFormatColumn);
                this.m_tblColumns.editCellAt(iRow, iViewFormatColumn);
            }
            return false;
        }
        return true;
    }

    public void saveSettingsAndCleanUp() {
        this.m_tblColumns.saveSettings(this.m_configuration.getSettingsPrefix() + ".Table");
        this.m_mdlColumns.dispose();
        IModel mdl = this.m_table.getModel();
        ((WsUndoManager)mdl.getUndoManager()).removeChangeListener(this.m_lsnrUndo);
        mdl.removeModelListener(this.m_lsnrModel);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tblColumns.setEditable(bEditable);
        this.m_tblColumns.setRowsReorderable(bEditable && this.m_configuration.isColumnReorderingEnabled());
        this.updateActions();
    }

    private void updateActions() {
        boolean bEditable = this.isEditable();
        boolean bNotSorted = !this.m_tblColumns.isSorted();
        int[] aRows = this.m_tblColumns.getSelectedRowsFromSelectedCells();
        boolean bOneSelected = aRows.length == 1;
        boolean bAtLeastOneSelected = aRows.length > 0;
        boolean bFirstSelected = bAtLeastOneSelected && aRows[0] == 0;
        boolean bLastSelected = bAtLeastOneSelected && aRows[aRows.length - 1] == this.m_tblColumns.getRowCount() - 1;
        boolean bNewColumnSelected = bOneSelected && this.m_mdlColumns.getColumnForRow(this.m_tblColumns.convertRowIndexToModel(aRows[0])).isNew();
        this.m_actNewColumn.setEnabled(bEditable && bNotSorted);
        this.m_actImport.setEnabled(bEditable && bNotSorted);
        this.m_actMoveUp.setEnabled(bEditable && bAtLeastOneSelected && bNotSorted && !bFirstSelected);
        this.m_actMoveDown.setEnabled(bEditable && bAtLeastOneSelected && bNotSorted && !bLastSelected);
        this.m_actProperties.setEnabled(bOneSelected);
        this.m_actAnalyze.setEnabled(bOneSelected && !bNewColumnSelected);
        this.m_actSelectAll.setEnabled(this.m_tblColumns.getRowCount() > 0);
        this.m_actDelete.setEnabled(bEditable && bAtLeastOneSelected);
        this.m_actSaveCurrentColumnOrder.setEnabled(bEditable && !bNotSorted);
        this.m_tblColumns.setRowsReorderable(bEditable && bNotSorted && this.m_configuration.isColumnReorderingEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewColumn() {
        if (!this.m_tblColumns.stopCellEditing()) {
            return;
        }
        this.m_table.getModel().startCompoundUndoable();
        try {
            int iRow = this.m_tblColumns.getLastSelectedRow();
            int iColumn = iRow == -1 ? this.m_table.getColumnCount() - 1 : this.m_table.indexOfColumn(this.m_mdlColumns.getColumnForRow(iRow));
            this.m_tblColumns.clearSelection();
            this.m_table.getModel().undoableEditHappened(this.m_tblColumns.createClearSelectionUndoable(true, false));
            IColumn colNew = this.m_table.getModel().getObjectFactory().createNewColumn(this.m_table.getID());
            colNew.setName(this.m_mdlColumns.createUniqueNameForNewColumn());
            this.m_table.addColumn(iColumn + 1, colNew);
            this.m_tblColumns.selectRow(iRow + 1);
            this.m_table.getModel().undoableEditHappened((UndoableEdit)new SelectColumnsUndoable(colNew, false, true));
            int iEditColumn = Math.max(this.m_tblColumns.convertColumnIndexToView(this.m_mdlColumns.getDefaultEditColumnIndex()), 0);
            this.m_tblColumns.editCellAt(iRow + 1, iEditColumn);
        }
        finally {
            this.m_table.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSelectedColumns() {
        int iRow;
        if (!this.m_tblColumns.stopCellEditing()) {
            return;
        }
        int[] aRows = this.m_tblColumns.getSelectedRowsFromSelectedCells();
        IColumn[] aColumns = new IColumn[aRows.length];
        for (iRow = 0; iRow < aRows.length; ++iRow) {
            int iModelRow = this.m_tblColumns.convertRowIndexToModel(aRows[iRow]);
            aColumns[iRow] = this.m_mdlColumns.getColumnForRow(iModelRow);
            if (!(this.m_table instanceof IPhysicalTable) || !((IPhysicalTable)this.m_table).isColumnUsedInConstraint(aColumns[iRow])) continue;
            String sMessage = bundle.formatString("ColumnsTab.Error.DeleteColumnInConstraint.txt", (Object)aColumns[iRow].getName());
            MessageUtil.displayMessage((String)sMessage, (int)0);
            return;
        }
        this.m_table.getModel().startCompoundUndoable();
        try {
            this.m_table.getModel().undoableEditHappened((UndoableEdit)new SelectColumnsUndoable(aColumns, true, false));
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                this.m_table.removeColumn(aColumns[iColumn]);
            }
            this.m_table.getModel().undoableEditHappened(this.m_tblColumns.createClearSelectionUndoable(true, true));
        }
        finally {
            this.m_table.getModel().endCompoundUndoable();
        }
        iRow = Math.min(aRows[aRows.length - 1] - (aRows.length - 1), this.m_tblColumns.getRowCount() - 1);
        if (iRow >= 0) {
            this.m_tblColumns.selectRow(iRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveSelectedColumns(int eDir) {
        if (eDir != 0 && eDir != 1) {
            throw new IllegalArgumentException("Direction must be UP or DOWN but is: " + eDir);
        }
        if (!this.m_tblColumns.stopCellEditing()) {
            return;
        }
        this.m_table.getModel().startCompoundUndoable();
        try {
            int iRow;
            int[] aRows = this.m_tblColumns.getSelectedRowsFromSelectedCells();
            IColumn[] aColumns = new IColumn[aRows.length];
            for (iRow = 0; iRow < aRows.length; ++iRow) {
                aColumns[iRow] = this.m_mdlColumns.getColumnForRow(aRows[iRow]);
            }
            this.m_table.getModel().undoableEditHappened((UndoableEdit)new SelectColumnsUndoable(aColumns, true, false));
            this.m_tblColumns.clearSelection();
            if (eDir == 1) {
                for (iRow = aRows.length - 1; iRow >= 0; --iRow) {
                    this.m_table.moveColumn(aColumns[iRow], aRows[iRow] + 1);
                }
            } else {
                for (iRow = 0; iRow < aRows.length; ++iRow) {
                    this.m_table.moveColumn(aColumns[iRow], aRows[iRow] - 1);
                }
            }
            this.selectColumns(aColumns);
            this.m_table.getModel().undoableEditHappened((UndoableEdit)new SelectColumnsUndoable(aColumns, false, true));
        }
        finally {
            this.m_table.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveColumn(int iFrom, int iTo) {
        if (!this.m_tblColumns.stopCellEditing()) {
            return;
        }
        this.m_table.getModel().startCompoundUndoable();
        try {
            this.m_tblColumns.clearSelection();
            IColumn column = this.m_mdlColumns.getColumnForRow(iFrom);
            this.m_table.getModel().undoableEditHappened((UndoableEdit)new SelectColumnsUndoable(column, true, false));
            this.m_table.moveColumn(column, iTo);
            this.m_tblColumns.selectRow(iTo);
            this.m_table.getModel().undoableEditHappened((UndoableEdit)new SelectColumnsUndoable(column, false, true));
        }
        finally {
            this.m_table.getModel().endCompoundUndoable();
        }
    }

    private void saveCurrentColumnOrder() {
        if (!this.m_tblColumns.stopCellEditing()) {
            return;
        }
        this.m_table.getModel().startCompoundUndoable();
        try {
            IColumn[] aColumns = new IColumn[this.m_tblColumns.getRowCount()];
            for (int iViewRow = 0; iViewRow < this.m_tblColumns.getRowCount(); ++iViewRow) {
                aColumns[iViewRow] = this.m_mdlColumns.getColumnForRow(this.m_tblColumns.convertRowIndexToModel(iViewRow));
            }
            this.m_tblColumns.resetToOriginalOrder();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                this.m_table.moveColumn(aColumns[iColumn], iColumn);
            }
        }
        finally {
            this.m_table.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importColumns() {
        block17: {
            try {
                if (!this.m_tblColumns.stopCellEditing()) {
                    return;
                }
                if (this.m_table instanceof IExternalTable) {
                    ((IExternalTable)this.m_table).setIsImporting(true);
                }
                if (this.m_configuration.isExtraImportOptions()) {
                    this.showExtraImportOptionsDialog();
                    break block17;
                }
                String[] aIDs = this.showColumnsSelectionDialog();
                if (aIDs == null) {
                    return;
                }
                BaseModel mdl = new BaseModel();
                try {
                    IColumn[] aColumns = this.loadColumns((IModel)mdl, aIDs);
                    this.addCopyOfColumns(aColumns);
                }
                finally {
                    mdl.dispose();
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            finally {
                if (this.m_table instanceof IExternalTable) {
                    ((IExternalTable)this.m_table).setIsImporting(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showExtraImportOptionsDialog() throws RemoteException {
        block14: {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore();
            try {
                ImportNewColumnsPanel pnl = new ImportNewColumnsPanel((IExternalTable)this.m_table);
                pnl.setObjectStore(store);
                String sImportDialogTitle = bundle.getString("ColumnsTab.Dialog.ExtraImportColumns.Title.txt");
                WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sImportDialogTitle, true, (WAPanel)pnl);
                dlg.setResizable(true);
                dlg.setHelpProduct("shared");
                dlg.setHelpTopic("import_column_win");
                this.m_table.getModel().startCompoundUndoable();
                try {
                    dlg.show();
                    if (dlg.getReturnValue() != 1) break block14;
                    List lColumns = pnl.getColumns();
                    if (lColumns == null) {
                        this.updateNames(pnl.getNames());
                        break block14;
                    }
                    if (pnl.isColumnsExist()) {
                        String[] aIDs = new String[lColumns.size()];
                        for (int iColumn = 0; iColumn < lColumns.size(); ++iColumn) {
                            aIDs[iColumn] = ((Column)lColumns.get(iColumn)).getFQID();
                        }
                        BaseModel mdl = new BaseModel();
                        try {
                            IColumn[] aColumns = this.loadColumns((IModel)mdl, aIDs);
                            this.addCopyOfColumns(aColumns);
                            break block14;
                        }
                        finally {
                            mdl.dispose();
                        }
                    }
                    IColumn[] aColumns = lColumns.toArray(new IColumn[0]);
                    this.addCopyOfColumns(aColumns);
                }
                finally {
                    this.m_table.getModel().endCompoundUndoable();
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            finally {
                store.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNames(List lNames) {
        ArrayList<String> lDuplicates = new ArrayList<String>();
        ArrayList<IColumn> lAddedCols = new ArrayList<IColumn>();
        int nUpdates = Math.min(lNames.size(), this.m_mdlColumns.getRowCount());
        this.m_tblColumns.clearSelection();
        this.m_table.getModel().startCompoundUndoable();
        try {
            String sColumn;
            int iName;
            for (iName = 0; iName < nUpdates; ++iName) {
                sColumn = (String)lNames.get(iName);
                if (sColumn.length() == 0) {
                    sColumn = this.m_mdlColumns.createUniqueNameForNewColumn();
                }
                if (sColumn.equals(this.m_mdlColumns.getValueAt(iName, 0))) continue;
                if (!this.isColumnNameUnique(sColumn, this.m_table.getColumns())) {
                    lDuplicates.add(sColumn);
                    continue;
                }
                IColumn col = this.m_mdlColumns.getColumnForRow(iName);
                col.setName(sColumn);
                lAddedCols.add(col);
            }
            for (iName = nUpdates; iName < lNames.size(); ++iName) {
                sColumn = (String)lNames.get(iName);
                if (sColumn.length() == 0) {
                    sColumn = this.m_mdlColumns.createUniqueNameForNewColumn();
                }
                if (!this.isColumnNameUnique(sColumn, this.m_table.getColumns())) {
                    lDuplicates.add(sColumn);
                    continue;
                }
                IColumn column = this.m_table.getModel().getObjectFactory().createNewColumn(this.m_table.getID());
                column.setName(sColumn);
                this.m_table.addColumn(column);
                lAddedCols.add(column);
            }
            if (lDuplicates.size() > 0) {
                String sMessage = bundle.getString("ColumnsTab.Warning.DuplicateColumnsRemoved.txt");
                MessageUtil.displayListMessage((String)sMessage, lDuplicates);
            }
            if (lAddedCols.size() > 0) {
                IColumn[] aAddedColumns = lAddedCols.toArray(new IColumn[0]);
                this.selectColumns(aAddedColumns);
                this.m_table.getModel().undoableEditHappened((UndoableEdit)new SelectColumnsUndoable(aAddedColumns, false, true));
            }
        }
        finally {
            this.m_table.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] showColumnsSelectionDialog() throws MdException, RemoteException {
        MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ImportColumns");
        try {
            ObjectsSelectorPanel pnl = new ObjectsSelectorPanel(Workspace.getWorkspace().getUserContext(), 4);
            String sImportDialogTitle = bundle.getString("ColumnsTab.ImportColumns.Title.txt");
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sImportDialogTitle, true, (WAPanel)pnl);
            dlg.setResizable(true);
            dlg.setHelpProduct("shared");
            dlg.setHelpTopic("import_column_win");
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                SimpleObject[] aColumns = pnl.getSelectedObjects();
                String[] aIDs = new String[aColumns.length];
                for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                    aIDs[iColumn] = aColumns[iColumn].getID();
                }
                String[] stringArray = aIDs;
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            store.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IColumn[] loadColumns(IModel mdl, String[] aIDs) throws RemoteException, MdException {
        OMRAdapter omr = new OMRAdapter(mdl, Workspace.getMdFactory(), "LoadImportedColumns");
        try {
            IColumn[] aColumns = new IColumn[aIDs.length];
            for (int iID = 0; iID < aIDs.length; ++iID) {
                aColumns[iID] = mdl.getObjectFactory().createColumn(aIDs[iID]);
                omr.populateFor((IOMRPersistable)aColumns[iID]);
                aColumns[iID].loadFromOMR(omr);
            }
            IColumn[] iColumnArray = aColumns;
            return iColumnArray;
        }
        finally {
            omr.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCopyOfColumns(IColumn[] aColumns) {
        ArrayList<String> lDuplicateColumns = new ArrayList<String>();
        ArrayList<IColumn> lAddedColumns = new ArrayList<IColumn>();
        IColumn[] aOriginalColumns = this.m_table.getColumns();
        int iRow = this.m_tblColumns.getLastSelectedRow();
        int iStart = iRow == -1 ? this.m_table.getColumnCount() : this.m_table.indexOfColumn(this.m_mdlColumns.getColumnForRow(iRow)) + 1;
        this.m_tblColumns.clearSelection();
        this.m_table.getModel().startCompoundUndoable();
        try {
            int iInsert = iStart;
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                IColumn column = aColumns[iColumn];
                if (this.isColumnNameUnique(column.getName(), aOriginalColumns)) {
                    IColumn columnNew = this.m_table.getModel().getObjectFactory().createNewColumn(this.m_table.getID());
                    column.deepCopy(columnNew);
                    this.m_table.addColumn(iInsert++, columnNew);
                    lAddedColumns.add(columnNew);
                    continue;
                }
                lDuplicateColumns.add(column.getName());
            }
            if (!lAddedColumns.isEmpty()) {
                IColumn[] aAddedColumns = lAddedColumns.toArray(new IColumn[lAddedColumns.size()]);
                this.selectColumns(aAddedColumns);
                this.m_table.getModel().undoableEditHappened((UndoableEdit)new SelectColumnsUndoable(aAddedColumns, false, true));
            }
            if (!lDuplicateColumns.isEmpty()) {
                String sMessage = bundle.getString("ColumnsTab.Warning.DuplicateColumnsRemoved.txt");
                MessageUtil.displayListMessage((String)sMessage, lDuplicateColumns);
            }
        }
        finally {
            this.m_table.getModel().endCompoundUndoable();
        }
    }

    private boolean isColumnNameUnique(String sTestName, IColumn[] aColumns) {
        boolean bCaseSensitive = this.m_table.isCaseSensitive();
        for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            boolean bEquals;
            String sColumnName = aColumns[iColumn].getName();
            boolean bl = bEquals = bCaseSensitive ? sTestName.equals(sColumnName) : sTestName.equalsIgnoreCase(sColumnName);
            if (!bEquals) continue;
            return false;
        }
        return true;
    }

    private void showPropertiesForSelectedColumn() {
        int[] aSelectedRows = this.m_tblColumns.getSelectedRowsFromSelectedCells();
        int iRow = this.m_tblColumns.convertRowIndexToModel(aSelectedRows[0]);
        IColumn column = this.m_mdlColumns.getColumnForRow(iRow);
        WAPropertyTab[] aTabs = new WAPropertyTab[]{new NotesTab((INotesAndDocumentsContainer)column), new ExtendedAttributesTab((IExtendedAttributesContainer)column)};
        ModelUIUtilities.showPropertiesDialog((IComplexPersistableObject)column, aTabs);
    }

    private void showColumnAnalysis() {
        int[] aSelectedRows = this.m_tblColumns.getSelectedRowsFromSelectedCells();
        int iRow = this.m_tblColumns.convertRowIndexToModel(aSelectedRows[0]);
        AppViewFactory.getInstance().showAnalysisView((SimpleObject)this.m_mdlColumns.getColumnForRow(iRow));
    }

    private void selectAllColumns() {
        this.m_tblColumns.selectAll();
    }

    private void selectColumns(IColumn[] aColumns) {
        this.m_tblColumns.clearSelection();
        for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            int iRow = this.m_mdlColumns.getRowIndex(aColumns[iColumn]);
            if (iRow == -1) continue;
            this.m_tblColumns.addRowToSelection(this.m_tblColumns.convertRowIndexToView(iRow));
        }
    }

    private void setOverlapped(boolean bOverlap) {
        IExternalTable extTable = (IExternalTable)this.m_table;
        if (bOverlap) {
            int eAnswer = MessageUtil.displayMessage((String)bundle.getString("ColumnsTab.Warning.OverlapColumns.txt"), (int)2, (int)2);
            if (eAnswer == 0) {
                this.m_mdlColumns.setOverlappingColumnsAllowed(bOverlap);
                ((IFixedWidthExternalFile)extTable.getFile()).setOverlapEnabled(bOverlap);
            } else {
                this.m_actOverlap.setSelected(false);
            }
        } else {
            int overlappingColumn = this.getFirstOverlappingColumn();
            if (overlappingColumn > -1) {
                MessageUtil.displayMessage((String)bundle.getString("ColumnsTab.Error.RemainingOverlapColumns.txt"), (int)0, (int)-1);
                this.m_actOverlap.setSelected(true);
                this.selectColumns(new IColumn[]{extTable.getColumns()[overlappingColumn]});
            } else {
                this.m_mdlColumns.setOverlappingColumnsAllowed(bOverlap);
                ((IFixedWidthExternalFile)extTable.getFile()).setOverlapEnabled(bOverlap);
            }
        }
    }

    private int getFirstOverlappingColumn() {
        int minBegin = 0;
        IColumn[] aColumns = this.m_table.getColumns();
        for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            int begin = aColumns[iColumn].getBeginPosition();
            int end = aColumns[iColumn].getEndPosition();
            if (minBegin > begin) {
                return iColumn;
            }
            minBegin = end + 1;
        }
        return -1;
    }

    public ColumnsTableModel getTableModel() {
        return this.m_mdlColumns;
    }

    public WsTable getTable() {
        return this.m_tblColumns;
    }

    public static class Configuration {
        private int[] m_aPermanentlyHiddenColumns = new int[]{9, 10};
        private String m_sSettingsPrefix = "ColumnsTab";
        private boolean m_bExtraImportOptions = false;
        private boolean m_bColumnReorderingEnabled = true;
        private int[] m_aHiddenActions = new int[]{3, 10};

        public void setPermanentlyHiddenColumns(int[] aColumnIndexes) {
            this.m_aPermanentlyHiddenColumns = aColumnIndexes;
        }

        public int[] getPermanentlyHiddenColumns() {
            return this.m_aPermanentlyHiddenColumns;
        }

        public void setSettingsPrefix(String sPrefix) {
            this.m_sSettingsPrefix = sPrefix;
        }

        public String getSettingsPrefix() {
            return this.m_sSettingsPrefix;
        }

        public void setHiddenActions(int[] aHiddenActions) {
            this.m_aHiddenActions = aHiddenActions;
        }

        public int[] getHiddenActions() {
            return this.m_aHiddenActions;
        }

        public boolean isActionHidden(int eAction) {
            for (int iAction = 0; iAction < this.m_aHiddenActions.length; ++iAction) {
                if (this.m_aHiddenActions[iAction] != eAction) continue;
                return true;
            }
            return false;
        }

        public void setExtraImportOptions(boolean bExtraImportOptions) {
            this.m_bExtraImportOptions = bExtraImportOptions;
        }

        public boolean isExtraImportOptions() {
            return this.m_bExtraImportOptions;
        }

        public void setColumnReorderingEnabled(boolean bColumnReorderingEnabled) {
            this.m_bColumnReorderingEnabled = bColumnReorderingEnabled;
        }

        public boolean isColumnReorderingEnabled() {
            return this.m_bColumnReorderingEnabled;
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            ColumnsTab.this.m_tblColumns.cancelCellEditing();
            if (ev.getType().equals("ExternalTable:OverlapChanged")) {
                boolean bOverlap = ((IFixedWidthExternalFile)((IExternalTable)ColumnsTab.this.m_table).getFile()).isOverlapEnabled();
                ColumnsTab.this.m_ckbOverlap.setSelected(bOverlap);
                ColumnsTab.this.m_mdlColumns.setOverlappingColumnsAllowed(bOverlap);
            }
        }
    }

    private class NewColumnAction
    extends WsAbstractAction {
        public NewColumnAction() {
            super(bundle, "ColumnsTab.Action.NewColumn", 0);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:NewColumn"));
        }

        public void actionPerformed(ActionEvent ev) {
            ColumnsTab.this.createNewColumn();
        }
    }

    private class ImportColumnsAction
    extends WsAbstractAction {
        public ImportColumnsAction() {
            super(bundle, "ColumnsTab.Action.ImportColumns", 0);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:ImportColumns"));
        }

        public void actionPerformed(ActionEvent ev) {
            ColumnsTab.this.importColumns();
        }
    }

    private class MoveUpAction
    extends WsAbstractAction {
        public MoveUpAction() {
            super(bundle, "ColumnsTab.Action.MoveUp", 0);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:MoveUp"));
        }

        public void actionPerformed(ActionEvent ev) {
            ColumnsTab.this.moveSelectedColumns(0);
        }
    }

    private class MoveDownAction
    extends WsAbstractAction {
        public MoveDownAction() {
            super(bundle, "ColumnsTab.Action.MoveDown", 0);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:MoveDown"));
        }

        public void actionPerformed(ActionEvent ev) {
            ColumnsTab.this.moveSelectedColumns(1);
        }
    }

    private class PropertiesAction
    extends WsAbstractAction {
        public PropertiesAction() {
            super(bundle, "ColumnsTab.Action.Properties", 0);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Properties"));
        }

        public void actionPerformed(ActionEvent ev) {
            ColumnsTab.this.showPropertiesForSelectedColumn();
        }
    }

    private class AnalyzeAction
    extends WsAbstractAction {
        public AnalyzeAction() {
            super(bundle, "ColumnsTab.Action.Analyze", 0);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Analyze"));
        }

        public void actionPerformed(ActionEvent ev) {
            ColumnsTab.this.showColumnAnalysis();
        }
    }

    private class UndoAction
    extends WsAbstractAction {
        public UndoAction() {
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Undo"));
            this.setToolTipText(bundle.getString("ColumnsTab.Action.Undo.tip"));
        }

        public void actionPerformed(ActionEvent ev) {
            ColumnsTab.this.m_table.getModel().getUndoManager().undo();
        }
    }

    private class RedoAction
    extends WsAbstractAction {
        public RedoAction() {
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Redo"));
            this.setToolTipText(bundle.getString("ColumnsTab.Action.Redo.tip"));
        }

        public void actionPerformed(ActionEvent ev) {
            ColumnsTab.this.m_table.getModel().getUndoManager().redo();
        }
    }

    private class SelectAllColumnsAction
    extends WsAbstractAction {
        public SelectAllColumnsAction() {
            super(bundle, "ColumnsTab.Action.SelectAll", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            ColumnsTab.this.selectAllColumns();
        }
    }

    private class DeleteColumnsAction
    extends WsAbstractAction {
        public DeleteColumnsAction() {
            super(bundle, "ColumnsTab.Action.Delete", 0);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Delete"));
        }

        public void actionPerformed(ActionEvent ev) {
            ColumnsTab.this.deleteSelectedColumns();
        }
    }

    private class OverlapAction
    extends WsAbstractToggleAction {
        public OverlapAction() {
            super(bundle, "ColumnsTab.CheckBox.Overlap", 0);
        }

        public void actionPerformed(ActionEvent ev) {
            ColumnsTab.this.setOverlapped(this.isSelected());
        }
    }

    private class SaveCurrentColumnOrderAction
    extends WsAbstractAction {
        public SaveCurrentColumnOrderAction() {
            super(bundle, "ColumnsTab.Action.SaveCurrentColumnOrder", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            ColumnsTab.this.saveCurrentColumnOrder();
        }
    }

    private class TablePopupMenuListener
    implements WsPopupMenuRequestListener {
        private TablePopupMenuListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            ColumnsTab.this.m_mnuTablePopup.show((Component)ev.getSource(), ev.getX(), ev.getY());
        }
    }

    private class RowHeaderPopupMenuListener
    implements WsPopupMenuRequestListener {
        private RowHeaderPopupMenuListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            ColumnsTab.this.m_mnuRowHeaderPopup.show((Component)ev.getSource(), ev.getX(), ev.getY());
        }
    }

    private class ViewportPopupMenuListener
    implements WsPopupMenuRequestListener {
        private ViewportPopupMenuListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            ColumnsTab.this.m_mnuViewportPopup.show((Component)ev.getSource(), ev.getX(), ev.getY());
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            ColumnsTab.this.updateActions();
        }
    }

    private class RowModelListener
    implements WsTableRowModelListener {
        private RowModelListener() {
        }

        public void rowDragged(TableRowModelEvent ev) {
            WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)ColumnsTab.this.m_tblColumns.getRowModel();
            mdlRows.clearRowMoves();
            ColumnsTab.this.moveColumn(ev.getFromIndex(), ev.getToIndex());
        }

        public void rowsRemapped(ChangeEvent ev) {
            ColumnsTab.this.updateActions();
        }

        public void rowsHidden(WsTableRowModelEvent ev) {
        }

        public void rowsShown(WsTableRowModelEvent ev) {
        }
    }

    private class UndoManagerListener
    implements ChangeListener {
        private UndoManagerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            UndoManager mgrUndo = ColumnsTab.this.m_table.getModel().getUndoManager();
            ColumnsTab.this.m_actUndo.setEnabled(mgrUndo.canUndo());
            ColumnsTab.this.m_actRedo.setEnabled(mgrUndo.canRedo());
        }
    }

    private class SelectColumnsUndoable
    extends AbstractUndoableEdit {
        private IColumn[] m_aColumns;
        private boolean m_bOnUndo;
        private boolean m_bOnRedo;

        public SelectColumnsUndoable(IColumn column, boolean bOnUndo, boolean bOnRedo) {
            this(new IColumn[]{column}, bOnUndo, bOnRedo);
        }

        public SelectColumnsUndoable(IColumn[] aColumns, boolean bOnUndo, boolean bOnRedo) {
            this.m_aColumns = aColumns;
            this.m_bOnUndo = bOnUndo;
            this.m_bOnRedo = bOnRedo;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_bOnUndo) {
                ColumnsTab.this.selectColumns(this.m_aColumns);
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_bOnRedo) {
                ColumnsTab.this.selectColumns(this.m_aColumns);
            }
        }

        @Override
        public void die() {
            super.die();
            Arrays.fill(this.m_aColumns, null);
            this.m_aColumns = null;
        }
    }
}

