/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IObject;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.impl.CodeGenerationEnvironment;
import com.sas.etl.models.other.IServer;
import com.sas.workspace.Workspace;

public class CodeGenerationEnvironmentFactory {
    private static CodeGenerationEnvironmentFactory m_factory = null;

    private CodeGenerationEnvironmentFactory() {
    }

    public static CodeGenerationEnvironmentFactory getInstance() {
        if (m_factory == null) {
            m_factory = new CodeGenerationEnvironmentFactory();
        }
        return m_factory;
    }

    public ICodeGenerationEnvironment createCodeGenerationEnvironment(IJob job, IServer server) {
        CodeGenerationEnvironment environment = new CodeGenerationEnvironment(server);
        environment.setUserName(Workspace.getWorkspace().getUsername());
        environment.setApplicationVersion(Workspace.getWorkspace().getApplicationName());
        if (job != null) {
            environment.setRunStatisticsEnabled(job.isCollectingStatistics());
            environment.setRunTableStatisticsEnabled(job.isCollectingTableStatistics());
        }
        return environment;
    }

    public ICodeSegment createCodeSegment(IJob job, IServer server, IObject modelObject) {
        ICodeGenerationEnvironment env = this.createCodeGenerationEnvironment(job, server);
        return env.createNewCodeSegment(modelObject);
    }
}

