/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.common.CodeGenerationEnvironmentFactory;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAppServer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;

public class CodeGenerationController {
    private boolean m_bNeedToGenerate;
    private ICodeGenerator m_codeGenerator;
    private ICodeGenerationEnvironment m_environment;
    private ICodeSegment[] m_segments;
    private ModelListener _modelListener;
    private PropertyChangeListener _defaultsListener;

    public CodeGenerationController(ICodeGenerator codeGenerator) {
        this.m_codeGenerator = codeGenerator;
        this._modelListener = new ModelListener();
        this.m_codeGenerator.getModel().addModelListener((IModelListener)this._modelListener);
        WorkspaceFile wsf = Workspace.getWorkspace().getWorkspaceFile();
        this._defaultsListener = new cPropertyChanged();
        wsf.addPropertyChangeListener(this._defaultsListener);
    }

    public ICodeGenerator getCodeGenerator() {
        return this.m_codeGenerator;
    }

    public ICodeGenerationEnvironment getEnvironment() {
        return this.m_environment;
    }

    public boolean isCodeNeedingUpdate() {
        return this.m_bNeedToGenerate;
    }

    public void setCodeNeedingUpdate() {
        IServer defaultServer = this.m_environment != null ? this.m_environment.getDefaultServer() : null;
        this.m_environment = null;
        this.refreshEnvironment(defaultServer);
    }

    private void checkStaleness() throws RemoteException, MdException, CodegenException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        if (this.m_bNeedToGenerate || this.m_environment == null) {
            this.setCodeNeedingUpdate();
            this.forceRegeneration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICodeGenerationEnvironment refreshEnvironment(IServer oldServer) {
        if (this.m_environment == null) {
            CodeGenerationEnvironmentFactory factory = CodeGenerationEnvironmentFactory.getInstance();
            IServer defaultServer = oldServer;
            if (oldServer == null || !oldServer.getID().equals(WsAppServer.getDefaultAppServerFQID())) {
                boolean listen = this._modelListener.isListening();
                this._modelListener.setListening(false);
                try {
                    defaultServer = ModelUIUtilities.acquireModelForDefaultSASAppServer(this.m_codeGenerator.getModel());
                }
                finally {
                    this._modelListener.setListening(listen);
                }
            }
            this.m_environment = factory.createCodeGenerationEnvironment(this.m_codeGenerator.getJob(), defaultServer);
            this.m_bNeedToGenerate = true;
        }
        return this.m_environment;
    }

    private void forceRegeneration() throws RemoteException, MdException, CodegenException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        boolean listen = this._modelListener.isListening();
        this._modelListener.setListening(false);
        try {
            this.refreshEnvironment(this.m_environment != null ? this.m_environment.getDefaultServer() : null);
            this.m_segments = this.m_codeGenerator.getCodeSegments(this.m_environment);
            this.m_bNeedToGenerate = false;
        }
        finally {
            this._modelListener.setListening(listen);
        }
    }

    public StringBuffer getCode() throws RemoteException, MdException, CodegenException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return this.getCode(true);
    }

    public StringBuffer getCode(boolean doUpdate) throws RemoteException, MdException, CodegenException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        if (doUpdate) {
            this.checkStaleness();
        }
        return this.m_environment.getGeneratedCode();
    }

    public StringBuffer getBodyCode(boolean doUpdate) throws RemoteException, MdException, CodegenException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        if (doUpdate) {
            this.checkStaleness();
        }
        StringBuffer code = new StringBuffer();
        if (this.m_segments != null) {
            for (int i = 0; i < this.m_segments.length; ++i) {
                if (!this.m_segments[i].isBody()) continue;
                code.append(this.m_segments[i].getGeneratedCode());
            }
        }
        return code;
    }

    public void dispose() {
        if (this.m_codeGenerator != null) {
            IModel model = this.m_codeGenerator.getModel();
            if (model != null) {
                model.removeModelListener((IModelListener)this._modelListener);
            }
            this.m_codeGenerator = null;
        }
        WorkspaceFile wsf = Workspace.getWorkspace().getWorkspaceFile();
        wsf.removePropertyChangeListener(this._defaultsListener);
    }

    public ICodeSegment[] getSegments() throws RemoteException, MdException, CodegenException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        this.checkStaleness();
        return this.m_segments;
    }

    private class ModelListener
    implements IModelListener {
        private boolean _isListening = true;

        public void setListening(boolean listening) {
            this._isListening = listening;
        }

        public boolean isListening() {
            return this._isListening;
        }

        public void modelChanged(ModelEvent ev) {
            if (this.isListening() && !"BaseModel:EditableChanged".equals(ev.getType()) && !"DataTransform.RefreshDBMSType".equals(ev.getType())) {
                CodeGenerationController.this.setCodeNeedingUpdate();
            }
        }
    }

    private class cPropertyChanged
    implements PropertyChangeListener {
        private cPropertyChanged() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("AppServer.Default".equals(evt.getPropertyName())) {
                CodeGenerationController.this.setCodeNeedingUpdate();
            }
        }
    }
}

