/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.common.ISQLSortingColumn;
import com.sas.etl.models.job.transforms.common.ISortColumn;
import com.sas.etl.models.job.transforms.common.ISorting;
import com.sas.wadmin.visuals.properties.AbstractPropertiesModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.visuals.dualselector.DefaultSelectorTableModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractSQLSelectorTableModel
extends DefaultSelectorTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(AbstractSQLSelectorTableModel.class);
    protected static String DEFAULTCOLUMNREFERENCE = Integer.toString(0);
    protected static final int TABLE_COL = 0;
    protected static final int COLUMN_COL = 1;
    protected ISorting m_mdlSorting;
    private IModelListener m_lsnrSQLModel;

    public abstract int getObjectColumnIndex();

    public abstract int getAscDescColumnIndex();

    public abstract boolean hasAscendingDescendingColumn();

    public abstract void updateSortingColumn(Object var1, int var2, int var3);

    public void moveDataToStore() {
    }

    public void populateStore() {
    }

    public void addSQLModelListener() {
        this.m_lsnrSQLModel = new ModelListener();
        this.m_mdlSorting.getModel().addModelListener(this.m_lsnrSQLModel);
    }

    public void removeSQLModelListener() {
        this.m_mdlSorting.getModel().removeModelListener(this.m_lsnrSQLModel);
    }

    public void moveDataToModel() {
        super.clear();
        List m_sortColumns = this.m_mdlSorting.getSortColumnList();
        for (int index = 0; index < m_sortColumns.size(); ++index) {
            ISQLSortingColumn sortColumn = (ISQLSortingColumn)m_sortColumns.get(index);
            ArrayList<String> row = new ArrayList<String>();
            row.add(sortColumn.getColumn().getTable().getName());
            row.add(sortColumn.getColumn().getName());
            if (this.hasAscendingDescendingColumn()) {
                row.add(sortColumn.getDirection());
            }
            row.add(Integer.toString(sortColumn.getColumnReference()));
            row.add((String)sortColumn);
            this.m_lData.add(row);
            ++this.m_nRowInstances;
        }
        this.fireTableModelPopulated();
    }

    public void deleteRow(int iRow) {
        List lDeletedRowValues = (List)this.m_lData.remove(iRow);
        this.fireTableRowDeleted(iRow, lDeletedRowValues);
        this.m_mdlSorting.removeSortColumn((ISortColumn)this.m_mdlSorting.getSortColumnList().get(iRow));
    }

    public void clear() {
        super.clear();
        List lSortColumns = this.m_mdlSorting.getSortColumnList();
        int size = lSortColumns.size();
        for (int i = size - 1; i > -1; --i) {
            this.m_mdlSorting.removeSortColumn((ISortColumn)lSortColumns.get(i));
        }
    }

    public int getRowIndex(ISortColumn sortCol) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            if (lValues.get(this.getObjectColumnIndex()) != sortCol) continue;
            return iRow;
        }
        return -1;
    }

    public void setValueAt(Object value, int row, int column) {
        this.updateSortingColumn(value, row, column);
        super.setValueAt(value, row, column);
    }

    protected void addSortRow(ISortColumn sortCol) {
        int iRowIndex = this.getRowIndex(sortCol);
        if (iRowIndex > -1) {
            return;
        }
        int iRow = this.m_mdlSorting.indexOfSortColumn(sortCol);
        this.insertRow(iRow - 1, this.createRowValues(sortCol));
    }

    protected void removeSortRow(ISortColumn sortCol) {
        this.deleteRow(this.getRowIndex(sortCol));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveSortModelItems(int[] selectedIndices, boolean bMovingUp) {
        int i;
        int offset;
        int n = offset = bMovingUp ? -1 : 1;
        if (selectedIndices == null || selectedIndices.length <= 0) {
            return;
        }
        List sortingColumns = this.m_mdlSorting.getSortColumnList();
        ISortColumn[] movingColumns = new ISortColumn[selectedIndices.length];
        for (i = 0; i < selectedIndices.length; ++i) {
            ISortColumn column;
            movingColumns[i] = column = (ISortColumn)sortingColumns.get(selectedIndices[i]);
        }
        this.m_mdlSorting.getModel().startCompoundUndoable();
        try {
            for (i = 0; i < selectedIndices.length; ++i) {
                sortingColumns.remove(movingColumns[i]);
            }
            for (i = 0; i < movingColumns.length; ++i) {
                this.m_mdlSorting.addSortColumn(selectedIndices[i] + offset, movingColumns[i]);
            }
        }
        finally {
            this.m_mdlSorting.getModel().endCompoundUndoable();
        }
    }

    protected List getColumnReferenceTranslatedValues() {
        ArrayList<String> columnReferenceTranslated = new ArrayList<String>();
        columnReferenceTranslated.add(bundle.getString("AbstractSQLSelectorTableModel.ColumnReference.Name.txt"));
        columnReferenceTranslated.add(bundle.getString("AbstractSQLSelectorTableModel.ColumnReference.Position.txt"));
        return columnReferenceTranslated;
    }

    protected List getColumnReferenceUnTranslatedValues() {
        ArrayList<String> columnReferenceUnTranslated = new ArrayList<String>();
        columnReferenceUnTranslated.add(Integer.toString(0));
        columnReferenceUnTranslated.add(Integer.toString(1));
        return columnReferenceUnTranslated;
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            IColumn col;
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                AbstractSQLSelectorTableModel.this.moveDataToModel();
            } else if (obj instanceof IColumn && AbstractSQLSelectorTableModel.this.m_mdlSorting.containsColumn(col = (IColumn)obj)) {
                ISortColumn sortCol = AbstractSQLSelectorTableModel.this.m_mdlSorting.getSortColumnContainingColumn(col);
                int iRowIndex = AbstractSQLSelectorTableModel.this.getRowIndex(sortCol);
                if (sType == "Object:NameChanged") {
                    AbstractSQLSelectorTableModel.super.setValueAt(col.getName(), iRowIndex, 1);
                    AbstractSQLSelectorTableModel.this.fireTableCellUpdated(iRowIndex, 1);
                }
            }
        }
    }

    protected class cListTableColumn
    extends WsEnumeratedTableColumn {
        protected List m_unTranslatedValues;
        protected List m_translatedValues;

        public cListTableColumn(int iModelIndex, String sName, int cxWidth, List translatedValues, List unTranslatedValues, String sDefault) {
            super(iModelIndex, sName, cxWidth, translatedValues.toArray(new String[translatedValues.size()]), sDefault);
            this.m_translatedValues = translatedValues;
            this.m_unTranslatedValues = unTranslatedValues;
        }

        public TableCellEditor createCellEditor() {
            return new AbstractPropertiesModel.DefaultListTableCellEditor(this.m_translatedValues, this.m_unTranslatedValues);
        }

        protected TableCellRenderer createCellRenderer() {
            return new AbstractPropertiesModel.DefaultListTableCellRenderer(this.m_translatedValues, this.m_unTranslatedValues);
        }
    }
}

