/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.wadmin.visuals.DBMSLibraryConnectWizardTab;
import com.sas.wadmin.visuals.SASImporter;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.plugins.MultipleNodeInterface;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class XMLV2Importer
extends SASImporter
implements MultipleNodeInterface {
    private static WAdminResource bundle = WAdminResource.getBundle(XMLV2Importer.class);
    private ArrayList m_XMLNameList;
    private ArrayList m_ToolTipList;
    private ArrayList m_DescriptionsList;
    private ArrayList m_ImageIconList;

    @Override
    public void initPlugin() {
        this.m_LIBRARY_TAB = "XMLV2Importertab1";
        this.m_TABLES_TAB = "XMLV2Importertab2";
        String[][] standardTransitionList = new String[][]{{this.m_LIBRARY_TAB, "NEXT", this.m_TABLES_TAB}, {this.m_TABLES_TAB, "NEXT", "SASImportertab4"}};
        this.m_transitionList = standardTransitionList;
        this.m_name = bundle.getString("XMLImporter.pluginname.txt");
        this.m_icon = bundle.getImageIcon("XMLImporter.image");
        this.m_tooltip = bundle.getString("XMLImporter.ToolTip.txt");
        this.buildNameList();
        this.buildTooltipList();
        this.buildIconList();
        this.buildDescriptionList();
    }

    public void buildDescriptionList() {
        this.m_DescriptionsList = new ArrayList();
        this.m_DescriptionsList.add(bundle.getString("XMLImporter.description.XMLV2ALL.notrans"));
        this.m_DescriptionsList.add(bundle.getString("XMLImporter.description.XMLV2XMLMAP.notrans"));
    }

    private void buildIconList() {
        this.m_ImageIconList = new ArrayList();
        for (int j = 0; j < 2; ++j) {
            this.m_ImageIconList.add(bundle.getImageIcon("XMLImporter.image"));
        }
    }

    public void buildTooltipList() {
        this.m_ToolTipList = new ArrayList();
        this.m_ToolTipList.add(bundle.getString("XMLImporter.ToolTip.XMLV2ALL.txt"));
        this.m_ToolTipList.add(bundle.getString("XMLImporter.ToolTip.XMLV2XMLMAP.txt"));
    }

    private void buildNameList() {
        this.m_XMLNameList = new ArrayList();
        String folderName = bundle.getString("XMLImporter.FolderName.DatabaseSources.txt") + ".";
        this.m_XMLNameList.add(folderName + bundle.getString("XMLImporter.Name.XMLV2ALL.txt"));
        this.m_XMLNameList.add(folderName + bundle.getString("XMLImporter.Name.XMLV2XMLMAP.txt"));
    }

    public ArrayList getDescriptions() {
        return this.m_DescriptionsList;
    }

    public ArrayList getIcons() {
        return this.m_ImageIconList;
    }

    public ArrayList getNames() {
        return this.m_XMLNameList;
    }

    public ArrayList getToolTips() {
        return this.m_ToolTipList;
    }

    @Override
    public String getDescription() {
        return bundle.getString("XMLImporter.description.txt");
    }

    @Override
    protected void createLibraryTab() {
        ImageIcon image = bundle.getImageIcon("SourceDesigner.ConnectInfo.image");
        this.m_libraryTab = new DBMSLibraryConnectWizardTab("XMLV2", bundle.getString("XMLV2ConnectWizardTab.Description.txt"));
        this.m_libraryTab.setHelpTopic("xmlv2_win");
        this.m_wizardDialog.addTab(bundle.getString("XMLV2ConnectWizardTab.Title.txt"), this.m_LIBRARY_TAB, (WAPropertyTab)this.m_libraryTab, "wa_source_connectInfo.gif", (Icon)image, false);
    }

    public void updateEngineName(WAWizardDialog wizardDialog) {
        String nodeName = (String)wizardDialog.getWizardData("SELECTEDNODE");
        if (nodeName.equalsIgnoreCase(bundle.getString("XMLImporter.Name.XMLV2ALL.txt"))) {
            this.m_strEngine = bundle.getString("XMLImporter.description.XMLV2ALL.notrans");
        } else if (nodeName.equalsIgnoreCase(bundle.getString("XMLImporter.Name.XMLV2XMLMAP.txt"))) {
            this.m_strEngine = bundle.getString("XMLImporter.description.XMLV2XMLMAP.notrans");
        }
        wizardDialog.addWizardData("ENGINETYPE", (Object)this.m_strEngine);
    }

    @Override
    public boolean isEngineSupported(String engineName) {
        return engineName.startsWith("XMLV2");
    }
}

