/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.plugins.PluginLoader;
import com.sas.services.user.UserContextInterface;
import com.sas.wadmin.changeanalysis.ComparisonResultsTree;
import com.sas.wadmin.model.LogicalSimpleObjectFilter;
import com.sas.wadmin.model.tree.LogicalPublicTypeInventoryFilter;
import com.sas.wadmin.model.tree.LogicalTreeNodeFactory;
import com.sas.wadmin.model.tree.MetadataTypeEventFilter;
import com.sas.wadmin.model.tree.TransformationsTreeModel;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.wadmin.visuals.WAdminTree_Inventory;
import com.sas.wadmin.visuals.WAdminTree_Process;
import com.sas.wadmin.visuals.WAdminTree_Project;
import com.sas.wadmin.visuals.WAdminTree_Warehouse;
import com.sas.wadmin.visuals.properties.PropertiesTable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WorkspaceTreeObject;
import com.sas.workspace.WsAbstractApplicationFrameworkManager;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.WsSplittableTabbedPane2;
import com.sas.workspace.WsWorkspaceComponent;
import com.sas.workspace.models.IMetadataTypeFilter;
import com.sas.workspace.models.IPublicTypeFilter;
import com.sas.workspace.models.ISimpleObjectFilter;
import com.sas.workspace.models.tree.CheckoutsTreeModel;
import com.sas.workspace.models.tree.FoldersTreeModel;
import com.sas.workspace.models.tree.ITransformationsTreeModel;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNodeFactory;
import com.sas.workspace.models.tree.InventoryTreeModel;
import com.sas.workspace.plugins.MainTabbedPanePlugin;
import com.sas.workspace.visuals.tree.CheckoutsTree;
import com.sas.workspace.visuals.tree.FoldersTree;
import com.sas.workspace.visuals.tree.IBaseTree;
import com.sas.workspace.visuals.tree.InventoryTree;
import com.sas.workspace.visuals.tree.TransformationsTree;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WAdminTreeObject
implements WorkspaceTreeObject {
    public static final String WarehouseTree = "WarehouseTree";
    public static final String InventoryTree = "InventoryTree";
    public static final String ProjectsTree = "ProjectsTree";
    public static final String ProcessLibraryTree = "ProcessLibraryTree";
    public static final String ComparisonResultsTree = "ComparisonResultsTree";
    public static final String QuickProperties = "QuickProperties";
    public static final String FoldersTree = "FoldersTree";
    public static final String Inventory2Tree = "Inventory2Tree";
    public static final String CheckoutsTree = "CheckoutsTree";
    public static final String TransformationsTree = "TransformationsTree";
    private static final int FOLDERS_TREE = 0;
    private static final int TRANSFORMATIONS_TREE = 1;
    private static final int INVENTORY_TREE = 2;
    private static final int CHECKOUTS_TREE = 3;
    private static final int COMPARISON_RESULTS_TREE = 4;
    private static final int FOLDERS2_TREE = 5;
    private static final int CHECKOUTS2_TREE = 6;
    private static final int INVENTORY2_TREE = 7;
    private static final int TRANSFORMATIONS2_TREE = 8;
    private static final int NUMBER_OF_TREES = 9;
    protected WsSplittableTabbedPane2 m_treesTabbedPane;
    protected Vector m_vTypes;
    protected Vector m_vViewableTypes;
    private static WAdminResource bundle = WAdminResource.getBundle(WAdminTreeObject.class);
    protected TransformManager m_transformManager;
    protected Component m_cmpActive;
    protected boolean m_bActive;
    protected boolean m_bInitialized;
    protected cTreeItem[] m_aTrees = new cTreeItem[0];

    public WAdminTreeObject() {
        this.m_treesTabbedPane = new WsSplittableTabbedPane2(3, false, 1);
        this.m_treesTabbedPane.addChangeListener(this.createChangeListener());
    }

    public Component getTreeComponent() {
        return this.m_treesTabbedPane;
    }

    public void initialize() {
        this.m_transformManager = TransformManager.createInstance();
        boolean bChangeManagement = Workspace.getWorkspace().isChangeManagementOn();
        UserContextInterface userContext = Workspace.getWorkspace().getUserContext();
        LogicalTreeNodeFactory nodeFactory = new LogicalTreeNodeFactory();
        MetadataTypeEventFilter eventFilter = new MetadataTypeEventFilter();
        FoldersTreeModel foldersTreeModel = new FoldersTreeModel(userContext);
        foldersTreeModel.setNodeFactory((ITreeNodeFactory)nodeFactory);
        foldersTreeModel.setEventFilter((IMetadataTypeFilter)eventFilter);
        FoldersTree foldersTree = new FoldersTree((ITreeModel)foldersTreeModel);
        InventoryTreeModel inventoryTreeModel = new InventoryTreeModel(userContext);
        inventoryTreeModel.setNodeFactory((ITreeNodeFactory)nodeFactory);
        inventoryTreeModel.setEventFilter((IMetadataTypeFilter)eventFilter);
        if (System.getProperty("ShowAllTypes", "false").equalsIgnoreCase("false")) {
            inventoryTreeModel.setCategoryFilter((IPublicTypeFilter)new LogicalPublicTypeInventoryFilter());
        }
        InventoryTree inventoryTree = new InventoryTree((ITreeModel)inventoryTreeModel);
        TransformationsTreeModel transformationsTreeModel = TransformManager.getInstance().getTransformationsTreeModel();
        TransformationsTree transformationsTree = new TransformationsTree((ITransformationsTreeModel)transformationsTreeModel);
        CheckoutsTree checkoutsTree = null;
        if (bChangeManagement) {
            CheckoutsTreeModel checkoutsTreeModel = new CheckoutsTreeModel(userContext);
            checkoutsTreeModel.setNodeFactory((ITreeNodeFactory)nodeFactory);
            checkoutsTreeModel.setNodeFilter((ISimpleObjectFilter)new LogicalSimpleObjectFilter());
            checkoutsTreeModel.setEventFilter((IMetadataTypeFilter)eventFilter);
            checkoutsTree = new CheckoutsTree((ITreeModel)checkoutsTreeModel);
        }
        boolean bShowOldTrees = System.getProperty("ShowOldTrees", "false").equalsIgnoreCase("true");
        this.m_aTrees = new cTreeItem[9];
        this.m_aTrees[5] = new cTreeItem((JTree)foldersTree, FoldersTree, false);
        this.m_aTrees[8] = new cTreeItem((JTree)transformationsTree, TransformationsTree, true);
        this.m_aTrees[7] = new cTreeItem((JTree)inventoryTree, Inventory2Tree, true);
        if (bChangeManagement) {
            this.m_aTrees[6] = new cTreeItem((JTree)checkoutsTree, CheckoutsTree, true);
        }
        if (bShowOldTrees) {
            WAdminTree_Warehouse treeCustom = new WAdminTree_Warehouse();
            treeCustom.setMain(true);
            this.m_aTrees[0] = new cTreeItem((JTree)((Object)treeCustom), WarehouseTree, false);
            this.m_aTrees[1] = new cTreeItem((JTree)((Object)new WAdminTree_Process()), ProcessLibraryTree, true);
            this.m_aTrees[2] = new cTreeItem((JTree)((Object)new WAdminTree_Inventory()), InventoryTree, true);
            this.m_aTrees[3] = new cTreeItem((JTree)((Object)new WAdminTree_Project()), ProjectsTree, true);
            this.m_aTrees[4] = new cTreeItem((JTree)((Object)new ComparisonResultsTree()), ComparisonResultsTree, true);
        }
        this.m_aTrees[5].initialize(true, true);
        this.m_aTrees[8].initialize(true, true);
        this.m_aTrees[7].initialize(true, true);
        if (bChangeManagement) {
            this.m_aTrees[6].initialize(true, bChangeManagement);
        }
        if (bShowOldTrees) {
            this.m_aTrees[0].initialize(true, true);
            this.m_aTrees[1].initialize(true, true);
            this.m_aTrees[2].initialize(true, true);
            this.m_aTrees[3].initialize(true, bChangeManagement);
            this.m_aTrees[4].initialize(true, true);
            this.setVisible(ComparisonResultsTree, true);
        }
        this.addPluginTabs();
        this.m_treesTabbedPane.restoreState("WAdminTreeObject");
        this.m_bInitialized = true;
        Workspace.getWorkspace().clearStatusText();
    }

    public void setVisible(String sTree, boolean bVisible) {
        cTreeItem it = this.findTreeItem(sTree);
        if (it != null) {
            it.setVisible(bVisible);
        }
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        if (this.m_cmpActive != null) {
            this.updateActiveUIComponents(this.m_cmpActive, bActive);
        }
        this.m_bActive = bActive;
    }

    private void updateActiveUIComponents(Component cmp, boolean bActive) {
        WsAbstractApplicationFrameworkManager frameworkMgr;
        if (cmp instanceof WsWorkspaceComponent) {
            ((WsWorkspaceComponent)cmp).updateWorkspaceUIComponents(bActive);
        } else if (cmp instanceof WsSelectionProvider && (frameworkMgr = WsAbstractApplicationFrameworkManager.getInstance()) != null) {
            frameworkMgr.setSelectionProvider(bActive ? (WsSelectionProvider)cmp : null);
        }
    }

    protected void addPluginTabs() {
        PluginLoader pluginLoader = Workspace.getWorkspace().getPluginLoader();
        if (pluginLoader == null) {
            return;
        }
        ArrayList alPlugins = pluginLoader.getPlugins("com.sas.workspace.plugins.MainTabbedPanePlugin");
        int nPlugins = alPlugins.size();
        for (int iPlugin = 0; iPlugin < nPlugins; ++iPlugin) {
            MainTabbedPanePlugin plugTab = (MainTabbedPanePlugin)alPlugins.get(iPlugin);
            JComponent cmpTab = plugTab.getTab();
            if (cmpTab == null) continue;
            this.m_treesTabbedPane.addTab(plugTab.getTabTitle(), (Component)cmpTab, plugTab.getTabIcon(), plugTab.getTabToolTipText());
        }
    }

    public Component getSelectedComponent() {
        Component cmpSelected = this.m_treesTabbedPane.getSelectedTab();
        if (cmpSelected instanceof JScrollPane) {
            Component cmpView = ((JScrollPane)cmpSelected).getViewport().getView();
            if (cmpView instanceof PropertiesTable) {
                return ((PropertiesTable)((Object)cmpView)).getWorkspaceTree();
            }
            return cmpView;
        }
        return cmpSelected;
    }

    public void saveState() {
        if (this.m_bInitialized) {
            this.m_treesTabbedPane.saveState("WAdminTreeObject");
        }
    }

    public Object findTree(String sName) {
        cTreeItem it = this.findTreeItem(sName);
        if (it != null) {
            return it.getTree();
        }
        return null;
    }

    protected cTreeItem findTreeItem(String sName) {
        int nTrees = this.m_aTrees.length;
        for (int iTree = 0; iTree < nTrees; ++iTree) {
            if (this.m_aTrees[iTree] == null || !this.m_aTrees[iTree].getName().equals(sName)) continue;
            return this.m_aTrees[iTree];
        }
        return null;
    }

    protected int findInsertIndex(cTreeItem tree) {
        int nPrevTrees = 0;
        int nTrees = this.m_aTrees.length;
        for (int iTree = 0; iTree < nTrees && this.m_aTrees[iTree] != tree; ++iTree) {
            if (this.m_aTrees[iTree] == null || !this.m_aTrees[iTree].isVisible()) continue;
            ++nPrevTrees;
        }
        return nPrevTrees;
    }

    public void refresh() {
        Component cmp = this.getSelectedComponent();
        if (cmp != null && cmp instanceof WorkspaceTree) {
            ((WorkspaceTree)cmp).refresh();
        }
    }

    public void refreshAll() {
        int nTrees = this.m_aTrees.length;
        for (int iTree = 0; iTree < nTrees; ++iTree) {
            if (!this.m_aTrees[iTree].isVisible()) continue;
            this.m_aTrees[iTree].refresh();
        }
    }

    public boolean hasFocus() {
        return this.m_treesTabbedPane.hasFocus();
    }

    public TransformManager getTransformManager() {
        return this.m_transformManager;
    }

    public WAdminTree_Inventory getInventoryTree() {
        return (WAdminTree_Inventory)((Object)this.findTree(InventoryTree));
    }

    public WAdminTree_Warehouse getWarehouseTree() {
        return (WAdminTree_Warehouse)((Object)this.findTree(WarehouseTree));
    }

    public WAdminTree_Process getProcessLibraryTree() {
        return (WAdminTree_Process)((Object)this.findTree(ProcessLibraryTree));
    }

    public WAdminTree_Project getProjectTree() {
        return (WAdminTree_Project)((Object)this.findTree(ProjectsTree));
    }

    public FoldersTree getFoldersTree() {
        return (FoldersTree)this.findTree(FoldersTree);
    }

    public InventoryTree getInventory2Tree() {
        return (InventoryTree)this.findTree(Inventory2Tree);
    }

    public TransformationsTree getTransformationsTree() {
        return (TransformationsTree)this.findTree(TransformationsTree);
    }

    public CheckoutsTree getCheckoutsTree() {
        return (CheckoutsTree)this.findTree(CheckoutsTree);
    }

    public void removeAll() {
        this.m_bInitialized = false;
        if (this.m_bActive) {
            this.updateWorkspaceUIComponents(false);
        }
        this.m_treesTabbedPane.removeAll();
        int nTrees = this.m_aTrees.length;
        for (int iTree = 0; iTree < nTrees; ++iTree) {
            if (this.m_aTrees[iTree] == null) continue;
            this.m_aTrees[iTree].dispose();
        }
        this.m_aTrees = new cTreeItem[0];
    }

    protected ChangeListener createChangeListener() {
        return new cChangeListener();
    }

    protected class cTreeItem {
        protected Component m_scroll;
        protected JTree m_tree;
        protected String m_sName;
        protected boolean m_bVisible;
        protected boolean m_bAllowSplit;

        public cTreeItem(JTree tree, String sName, boolean bAllowSplit) {
            if (tree != null) {
                this.m_tree = tree;
                this.m_scroll = this.m_tree instanceof WorkspaceTree ? ((WorkspaceTree)tree).getTreeScrollPane() : new JScrollPane(tree);
            }
            this.m_sName = sName;
            this.m_bAllowSplit = bAllowSplit;
        }

        public Component getComponent() {
            return this.m_scroll;
        }

        public Object getTree() {
            return this.m_tree;
        }

        public String getName() {
            return this.m_sName;
        }

        public boolean isVisible() {
            return this.m_bVisible;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setVisible(boolean bVisible) {
            if (bVisible == this.m_bVisible) {
                if (bVisible) {
                    WAdminTreeObject.this.m_treesTabbedPane.setSelectedTab(this.m_scroll);
                }
                return;
            }
            if (bVisible) {
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    if (this.m_tree instanceof WorkspaceTree) {
                        ((WorkspaceTree)this.m_tree).initialize();
                    }
                    String sTabName = bundle.getString(this.m_sName + ".Title.txt");
                    int iTab = WAdminTreeObject.this.findInsertIndex(this);
                    WAdminTreeObject.this.m_treesTabbedPane.insertTab(sTabName, this.m_scroll, iTab, this.m_bAllowSplit);
                    WAdminTreeObject.this.m_treesTabbedPane.setSelectedTab(this.m_scroll);
                }
                finally {
                    Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                }
            } else {
                WAdminTreeObject.this.m_treesTabbedPane.removeTab(this.m_scroll);
                if (this.m_tree instanceof WorkspaceTree) {
                    ((WorkspaceTree)this.m_tree).dispose();
                }
            }
            this.m_bVisible = bVisible;
            Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean("Trees." + this.m_sName + ".Visible", bVisible);
        }

        public void initialize(boolean bVisibleByDefault, boolean bAvailable) {
            Workspace workspace = Workspace.getWorkspace();
            if (bAvailable) {
                workspace.setStatusText(bundle.getString(this.m_sName + ".Loading.txt"));
                if (this.m_tree instanceof WorkspaceTree) {
                    ((WorkspaceTree)this.m_tree).setDraggingEnabled(true);
                }
                if (workspace.getChangeManagementState() == Workspace.CHANGEMANAGEMENT_ON && this.m_tree instanceof WorkspaceTree) {
                    ((WorkspaceTree)this.m_tree).setDroppingEnabled(false);
                }
                if (this.m_tree instanceof WorkspaceTree) {
                    ((WorkspaceTree)this.m_tree).setToolTipsEnabled(workspace.getAppDefaultsFile().getPropertyBoolean("Trees.EnableToolTips", false));
                }
                this.setVisible(workspace.getAppDefaultsFile().getPropertyBoolean("Trees." + this.m_sName + ".Visible", bVisibleByDefault));
            }
        }

        public void refresh() {
            if (this.m_tree instanceof WorkspaceTree) {
                ((WorkspaceTree)this.m_tree).refresh();
            }
        }

        public void dispose() {
            if (this.m_tree instanceof WorkspaceTree) {
                ((WorkspaceTree)this.m_tree).dispose();
            } else if (this.m_tree instanceof IBaseTree) {
                ((IBaseTree)this.m_tree).dispose();
            }
        }
    }

    protected class cChangeListener
    implements ChangeListener {
        protected cChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (WAdminTreeObject.this.m_bActive && WAdminTreeObject.this.m_cmpActive != null) {
                WAdminTreeObject.this.updateActiveUIComponents(WAdminTreeObject.this.m_cmpActive, false);
            }
            WAdminTreeObject.this.m_cmpActive = WAdminTreeObject.this.getSelectedComponent();
            if (WAdminTreeObject.this.m_bActive && WAdminTreeObject.this.m_cmpActive != null) {
                WAdminTreeObject.this.updateActiveUIComponents(WAdminTreeObject.this.m_cmpActive, true);
            }
        }
    }
}

