/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.model.NotesTableModel;
import com.sas.wadmin.visuals.WANoteSelectionDialog;
import com.sas.wadmin.visuals.WANotesPreviewPane;
import com.sas.workspace.AbstractDesigner;
import com.sas.workspace.CustomLayoutFocusTraversalPolicy;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATable;
import com.sas.workspace.WATableModel;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAUndoable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.visuals.BaseTableMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellEditor;
import javax.swing.undo.UndoableEdit;

public class WANotesPane
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(WANotesPane.class);
    private static final int MAX_NAME_GENERATION_ATTEMPTS = 4;
    boolean stillEdit = false;
    protected Root m_oMetadata;
    protected TextStore currentNote;
    NotesListPopup m_menuNotesListPopup;
    JLabel m_lblNotesList;
    WATable m_tblNotesList;
    JScrollPane m_scrNotesList;
    NotesTableModel m_mdlNotes;
    WANotesPreviewPane m_txtNote;
    JButton m_btnDelete;
    JButton m_btnNew;
    JButton m_btnAttach;
    WsAbstractAction m_actNew;
    WsAbstractAction m_actDelete;
    WsAbstractAction m_actAttach;
    boolean lastClicked = false;
    boolean m_bNotesListChanged = false;
    boolean m_bNoteChanged = false;

    public WANotesPane(Root oMetadata) {
        this.m_oMetadata = oMetadata;
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.createActions();
        this.m_mdlNotes = new NotesTableModel();
        this.m_tblNotesList = new WATable((WATableModel)this.m_mdlNotes);
        this.m_tblNotesList.enableDefaultKeyTraversal(false);
        this.m_tblNotesList.setUI((TableUI)new NotesListUI());
        this.m_tblNotesList.setToolTipText(bundle.getString("WANotesPropertyTab.listTip.txt"));
        this.m_tblNotesList.setShowGrid(false);
        this.m_tblNotesList.setDefaultEditBehavior(2);
        this.m_tblNotesList.setTableHeader(null);
        this.m_tblNotesList.getSelectionModel().addListSelectionListener(new NotesListSelectionListener());
        this.m_tblNotesList.setSelectionMode(0);
        WATextField jtf = new WATextField();
        jtf.setBorder((Border)new LineBorder(Color.black));
        jtf.setMaxCharacters(60);
        DefaultCellEditor dce = new DefaultCellEditor((JTextField)jtf);
        this.m_tblNotesList.getColumnModel().getColumn(0).setCellEditor(dce);
        dce.addCellEditorListener(new TableEditListener());
        AbstractAction editAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WANotesPane.this.activateNote();
            }
        };
        this.m_tblNotesList.getActionMap().put(this.m_actDelete, (Action)this.m_actDelete);
        this.m_tblNotesList.getActionMap().put(editAction, editAction);
        this.m_tblNotesList.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDelete);
        this.m_tblNotesList.getInputMap().put(KeyStroke.getKeyStroke(10, 0), editAction);
        this.m_tblNotesList.getInputMap().put(KeyStroke.getKeyStroke(9, 0), editAction);
        this.m_menuNotesListPopup = new NotesListPopup(this.m_tblNotesList);
        this.m_tblNotesList.addMouseListener((MouseListener)((Object)this.m_menuNotesListPopup));
        this.m_lblNotesList = new JLabel(bundle.getString("WANotesPropertyTab.assigned.txt"));
        this.m_lblNotesList.setDisplayedMnemonic(bundle.getString("WANotesPropertyTab.assigned.mnem").charAt(0));
        this.m_lblNotesList.setLabelFor((Component)this.m_tblNotesList);
        this.m_txtNote = new WANotesPreviewPane();
        this.m_txtNote.setUndoableEditListener(new NoteUndoableEditListener());
        this.m_txtNote.setEnabled(false);
        JLabel lblNotesText = this.m_txtNote.getTextLabel();
        lblNotesText.setText(bundle.getString("WANotesPropertyTab.noteEntry.txt"));
        lblNotesText.setDisplayedMnemonic(bundle.getString("WANotesPropertyTab.noteEntry.mnem").charAt(0));
        this.m_btnNew = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNew);
        this.m_btnDelete = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDelete);
        this.m_btnAttach = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actAttach);
        CustomLayoutFocusTraversalPolicy.setNextFocusableComponent((Component)this.m_tblNotesList, (Component)this.m_txtNote);
        CustomLayoutFocusTraversalPolicy.setNextFocusableComponent((Component)this.m_txtNote, (Component)this.m_btnNew);
        this.m_txtNote.setDocumentListener(new NotesDocumentListener());
    }

    protected void createActions() {
        this.m_actNew = this.createNewAction();
        this.m_actDelete = this.createDeleteAction();
        this.m_actAttach = this.createAttachAction();
    }

    protected WsAbstractAction createNewAction() {
        return new cNewAction();
    }

    protected WsAbstractAction createDeleteAction() {
        return new cDeleteAction();
    }

    protected WsAbstractAction createAttachAction() {
        return new cAttachAction();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actNew.setActive(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tblNotesList.setEditable(bEditable);
        this.m_txtNote.setEditable(bEditable);
        this.m_actNew.setEnabled(bEditable);
        this.m_actDelete.setEnabled(bEditable && this.m_tblNotesList.getSelectedRows().length > 0);
        this.m_actAttach.setEnabled(bEditable);
    }

    public Component getDefaultFocusComponent() {
        return this.m_tblNotesList;
    }

    public boolean validateData() {
        boolean duplicateNameWarnings = Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("Workspace.EnableDuplicateNameWarnings", false);
        if (duplicateNameWarnings && this.m_bNotesListChanged) {
            int changeDuplicateName;
            ArrayList<String> noteNameConflicts = new ArrayList<String>();
            for (int i = 0; i < this.m_mdlNotes.getRowCount(); ++i) {
                String name = (String)this.m_mdlNotes.getValueAt(i, 0);
                TextStore note = (TextStore)this.m_mdlNotes.getValueAt(i, 1);
                boolean nameConflictOnServer = note != null ? !WsMetadataNameUtil.isNameUnique((Root)note, (String)name) : !WsMetadataNameUtil.isNameUnique((String)"TextStore", (String)name);
                boolean nameConflictOnTab = false;
                for (int j = 0; j < this.m_mdlNotes.getRowCount(); ++j) {
                    if (i == j || !this.m_mdlNotes.getValueAt(j, 0).equals(name)) continue;
                    nameConflictOnTab = true;
                    break;
                }
                if (!nameConflictOnServer && !nameConflictOnTab) continue;
                noteNameConflicts.add(name);
            }
            if (noteNameConflicts.isEmpty()) {
                return true;
            }
            if (noteNameConflicts.size() == 1) {
                changeDuplicateName = MessageUtil.displayMessage((String)bundle.formatString("WANotesPane.Error.OneDuplicateName.fmt.txt", noteNameConflicts.get(0)), (String)bundle.getString("Common.DuplicateNameWarning.txt"), (int)2, (int)0);
                return changeDuplicateName != 0;
            }
            Collections.sort(noteNameConflicts);
            changeDuplicateName = MessageUtil.displayListMessage((String)bundle.getString("WANotesPane.Error.ManyDuplicateNames.txt"), noteNameConflicts, (String)bundle.getString("Common.DuplicateNameWarning.txt"), (int)2, (int)0);
            return changeDuplicateName != 0;
        }
        return true;
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        try {
            if (!bSaveToModel) {
                this.m_mdlNotes.setObject(this.m_oMetadata);
                this.m_mdlNotes.moveDataToModel();
            } else {
                if (this.m_tblNotesList.isEditing()) {
                    this.m_tblNotesList.getCellEditor().stopCellEditing();
                }
                if (this.hasDataChanged()) {
                    this.saveNoteText();
                    if (this.m_bNotesListChanged) {
                        this.m_mdlNotes.moveDataToStore();
                    }
                }
            }
        }
        finally {
            this.m_bNotesListChanged = false;
            this.setDataChanged(false);
            this.waum.discardAllEdits();
        }
        return true;
    }

    public ArrayList getNotes() {
        this.saveNoteText();
        ArrayList<TextStore> nl = new ArrayList<TextStore>();
        for (int i = 0; i < this.m_mdlNotes.getRowCount(); ++i) {
            TextStore oNote = (TextStore)this.m_mdlNotes.getValueAt(i, 1);
            try {
                String tName = (String)this.m_mdlNotes.getValueAt(i, 0);
                if (!tName.equals(oNote.getName())) {
                    oNote.setName(tName);
                }
                oNote.setTextRole("Note");
                oNote.setTextType("html");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            nl.add(oNote);
        }
        return nl;
    }

    public boolean doLocalDataExchange(boolean bSaveToModel) {
        try {
            if (!bSaveToModel) {
                this.m_mdlNotes.localSetup((CMetadata)this.m_oMetadata);
            } else if (this.m_bNoteChanged || this.m_bNotesListChanged) {
                this.m_oMetadata.addElementToChangeList((CMetadata)this.m_oMetadata);
                if (this.currentNote != null) {
                    int index = this.m_tblNotesList.getSelectedRow();
                    try {
                        String s = this.m_txtNote.getContents();
                        this.currentNote.setStoredText(s);
                    }
                    catch (Exception e) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                    }
                    this.m_mdlNotes.setValueAt(this.currentNote, index, 1);
                }
                AssociationList noteList = this.m_oMetadata.getNotes();
                noteList.removeAllElements();
                TextStore n = null;
                for (int i = 0; i < this.m_mdlNotes.getRowCount(); ++i) {
                    n = (TextStore)this.m_mdlNotes.getValueAt(i, 1);
                    String tName = (String)this.m_mdlNotes.getValueAt(i, 0);
                    if (!tName.equals(n.getName())) {
                        n.setName(tName);
                    }
                    n.getObjects(false).add((Object)this.m_oMetadata);
                    if (!noteList.contains((Object)n)) {
                        noteList.addElement((Object)n);
                    }
                    this.m_oMetadata.addElementToChangeList((CMetadata)n);
                }
                this.m_oMetadata.setNotes(noteList);
            }
            this.setDataChanged(false);
            return true;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            return false;
        }
    }

    public void saveSettingsAndCleanUp() {
        this.m_txtNote.dispose();
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("  " + bundle.getString("WANotesPropertyTab.notesString.txt") + "  "));
        this.m_scrNotesList = new JScrollPane((Component)this.m_tblNotesList);
        this.m_scrNotesList.addMouseListener((MouseListener)((Object)this.m_menuNotesListPopup));
        this.m_scrNotesList.addMouseListener(new NTMListener());
        this.m_scrNotesList.setToolTipText(bundle.getString("WANotesPropertyTab.listTip.txt"));
        this.m_txtNote.getTextPane().setToolTipText(bundle.getString("WANotesPropertyTab.notesTip.txt"));
        JPanel m_pnlButtons = new JPanel((LayoutManager)new WsButtonsLayout());
        m_pnlButtons.add(this.m_btnNew);
        m_pnlButtons.add(this.m_btnDelete);
        m_pnlButtons.add(this.m_btnAttach);
        this.add(this.m_lblNotesList, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_scrNotesList, new GridBagConstraints(0, 1, 1, 1, 0.4, 1.0, 18, 1, new Insets(5, 0, 0, 10), 0, 0));
        this.add(this.m_txtNote, new GridBagConstraints(1, 0, 2, 2, 0.6, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(m_pnlButtons, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 0), 0, 0));
    }

    public void addNotesFocusListener(FocusListener f) {
        this.m_tblNotesList.addFocusListener(f);
        this.m_txtNote.getTextPane().addFocusListener(f);
    }

    protected void doDelete() {
        int iRow;
        if (this.m_tblNotesList.isEditing()) {
            this.m_tblNotesList.getCellEditor().cancelCellEditing();
        }
        if ((iRow = this.m_tblNotesList.getSelectedRow()) != -1) {
            try {
                ArrayList noteObject = (ArrayList)this.m_mdlNotes.getValueAt(iRow);
                CMetadata note = (CMetadata)noteObject.get(1);
                ((MdObjectStore)this.m_oMetadata.getObjectStore()).deleteObjectFromStore(note.getFQID());
                if (note.getFQID().indexOf("$") != -1) {
                    note.delete();
                }
                WAUndoable wau = this.m_mdlNotes.undoableDeleteRow(iRow);
                this.getWAUndoManager().addEdit((UndoableEdit)wau);
                this.m_bNotesListChanged = true;
                this.setDataChanged(true);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    protected void activateNote() {
        FocusManager.getCurrentManager().focusNextComponent((Component)((Object)this));
    }

    protected void editNote() {
        Workspace.getDefaultLogger().debug((Object)"how did i get here?");
    }

    protected void setNoteText() {
        if (this.currentNote != null) {
            try {
                this.m_txtNote.setContents(this.currentNote.getStoredText());
                this.m_bNoteChanged = false;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    protected void saveNoteText() {
        if (this.currentNote != null && this.m_bNoteChanged) {
            try {
                this.currentNote.setStoredText(this.m_txtNote.getContents());
                this.currentNote.setTextRole("Note");
                this.currentNote.setTextType("html");
                this.m_bNoteChanged = false;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    protected String generateNewNoteName() {
        String newName;
        int attempts = 0;
        do {
            newName = WsMetadataNameUtil.getUniqueNameForType((String)"TextStore", (String)bundle.getString("Common.Untitled.txt"));
        } while (++attempts < 4 && this.isNoteNameAttached(newName));
        return newName;
    }

    protected boolean isNoteNameAttached(String newName) {
        int nNotes = this.m_mdlNotes.getRowCount();
        for (int iNote = 0; iNote < nNotes; ++iNote) {
            String sNoteName = (String)this.m_mdlNotes.getValueAt(iNote, 0);
            if (!sNoteName.equals(newName)) continue;
            return true;
        }
        return false;
    }

    protected void doNew() {
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            String sNoteName = this.generateNewNoteName();
            TextStore oNote = (TextStore)factory.createComplexMetadataObject((MdObjectStore)this.m_oMetadata.getObjectStore(), sNoteName, "TextStore", this.m_oMetadata.getRepositoryID());
            oNote.setTextRole("Note");
            oNote.setTextType("html");
            try {
                Tree defaultGroup = AbstractDesigner.getDefaultGroup((MdObjectStore)((MdObjectStore)this.m_oMetadata.getObjectStore()), (CMetadata)Workspace.getWorkspace().getDefaultRepository(), (String)"Notes");
                oNote.getTrees().add((Object)defaultGroup);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            WAUndoable wau = this.m_mdlNotes.undoableInsertRow(oNote);
            this.getWAUndoManager().addEdit((UndoableEdit)wau);
            this.m_bNotesListChanged = true;
            this.setDataChanged(true);
            this.m_tblNotesList.editCellAt(this.m_tblNotesList.getRowCount() - 1, 0);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    protected void doAttach() {
        try {
            int inumNotes = this.m_mdlNotes.getRowCount();
            String s_ids = "";
            for (int x = 0; x < inumNotes; ++x) {
                TextStore tempTS = (TextStore)this.m_mdlNotes.getValueAt(x, 1);
                s_ids = s_ids + tempTS.getFQID();
                String changeState = tempTS.getChangeState();
                if (changeState.length() <= 0) continue;
                s_ids = s_ids + changeState.substring(11);
            }
            WANoteSelectionDialog noteDlg = new WANoteSelectionDialog((CMetadata)this.m_oMetadata, s_ids);
            noteDlg.show();
            Vector v_newadds = noteDlg.getSelections();
            for (int i = 0; i < v_newadds.size(); ++i) {
                TextStore o_addedTS = (TextStore)v_newadds.elementAt(i);
                WAUndoable wau = this.m_mdlNotes.undoableInsertRow(o_addedTS);
                this.getWAUndoManager().addEdit((UndoableEdit)wau);
                this.m_bNotesListChanged = true;
                this.setDataChanged(true);
            }
            TextStore lastTS = (TextStore)this.m_mdlNotes.getValueAt(this.m_tblNotesList.getRowCount() - 1, 1);
            if (v_newadds.size() > 0 && Workspace.getWorkspace().isObjectEditable((CMetadata)lastTS)) {
                this.m_tblNotesList.editCellAt(this.m_tblNotesList.getRowCount() - 1, 0);
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    public WsAbstractAction getDeleteAction() {
        return this.m_actDelete;
    }

    class NotesListUI
    extends BasicTableUI {
        NotesListUI() {
        }

        @Override
        protected MouseInputListener createMouseInputListener() {
            return new MouseInputHandlerTable();
        }

        public class MouseInputHandlerTable
        extends BasicTableUI.MouseInputHandler {
            public MouseInputHandlerTable() {
                super(NotesListUI.this);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    WANotesPane.this.stillEdit = false;
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                int row = NotesListUI.this.table.rowAtPoint(p);
                int column = NotesListUI.this.table.columnAtPoint(p);
                if (column == -1 || row == -1) {
                    NotesListUI.this.table.clearSelection();
                    return;
                }
                boolean isLMB = true;
                isLMB = (e.getModifiers() & 0x10) > 0;
                int sRow = NotesListUI.this.table.getSelectedRow();
                if (sRow == row && isLMB) {
                    int i = e.getClickCount();
                    if (i == 1) {
                        int iRow = WANotesPane.this.m_tblNotesList.getSelectedRow();
                        TextStore newSelNote = (TextStore)WANotesPane.this.m_mdlNotes.getValueAt(iRow, 1);
                        if (Workspace.getWorkspace().isObjectEditable((CMetadata)newSelNote)) {
                            WANotesPane.this.stillEdit = true;
                            EThread elmo = new EThread(200L, row);
                            elmo.start();
                        }
                    } else if (i == 2) {
                        WANotesPane.this.stillEdit = false;
                        WANotesPane.this.activateNote();
                    }
                } else {
                    TableCellEditor ce = NotesListUI.this.table.getCellEditor();
                    if (ce != null && NotesListUI.this.table.isEditing()) {
                        ce.stopCellEditing();
                    }
                    super.mousePressed(e);
                }
            }
        }
    }

    class NotesListSelectionListener
    implements ListSelectionListener {
        NotesListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean bEnabled;
            boolean bTextEditable = false;
            int iRow = WANotesPane.this.m_tblNotesList.getSelectedRow();
            if (iRow != -1) {
                TextStore newSelNote = (TextStore)WANotesPane.this.m_mdlNotes.getValueAt(iRow, 1);
                if (WANotesPane.this.currentNote != newSelNote) {
                    WANotesPane.this.saveNoteText();
                    WANotesPane.this.currentNote = newSelNote;
                    WANotesPane.this.setNoteText();
                }
                bTextEditable = Workspace.getWorkspace().isObjectEditable((CMetadata)WANotesPane.this.currentNote);
                bEnabled = true;
            } else {
                WANotesPane.this.saveNoteText();
                WANotesPane.this.currentNote = null;
                WANotesPane.this.m_txtNote.setContents("");
                bEnabled = false;
            }
            WANotesPane.this.m_txtNote.setEnabled(bEnabled && bTextEditable);
            WANotesPane.this.m_actDelete.setEnabled(bEnabled && WANotesPane.this.isEditable());
        }
    }

    class TableEditListener
    implements CellEditorListener {
        TableEditListener() {
        }

        @Override
        public void editingCanceled(ChangeEvent ce) {
        }

        @Override
        public void editingStopped(ChangeEvent ce) {
            block4: {
                try {
                    if (!WANotesPane.this.m_mdlNotes.getUndoableSet()) break block4;
                    WAUndoable wau = WANotesPane.this.m_mdlNotes.getPersistedUndo();
                    if (wau != null) {
                        Object newV;
                        Object oldV;
                        if (wau instanceof WATableModel.UndoableSet && !(oldV = ((WATableModel.UndoableSet)wau).getOldValue()).equals(newV = ((WATableModel.UndoableSet)wau).getNewValue())) {
                            WANotesPane.this.getWAUndoManager().addEdit((UndoableEdit)wau);
                            WANotesPane.this.currentNote.setName((String)newV);
                            WANotesPane.this.setDataChanged(true);
                        }
                        WANotesPane.this.m_mdlNotes.resetUndoableSet();
                        WANotesPane.this.m_mdlNotes.resetPersistedUndo();
                        WANotesPane.this.activateNote();
                        break block4;
                    }
                    JOptionPane.showMessageDialog((Component)((Object)WANotesPane.this), bundle.getString("WANotesPropertyTab.nameError.txt"), bundle.getString("WANotesPropertyTab.nameErrorTitle.txt"), 0);
                    int row = WANotesPane.this.m_tblNotesList.getSelectedRow();
                    WANotesPane.this.m_tblNotesList.clearSelection();
                    WANotesPane.this.m_tblNotesList.setCellEditor(null);
                    WANotesPane.this.m_tblNotesList.editCellAt(row, 0);
                    return;
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                }
            }
        }
    }

    class NotesListPopup
    extends BaseTableMenu {
        public NotesListPopup(WATable tblNotes) {
            super(tblNotes);
        }

        public void actionPerformed(ActionEvent e) {
            String sCommand = e.getActionCommand();
            if (sCommand.equals("delRow")) {
                WANotesPane.this.doDelete();
            } else if (sCommand.equals("new")) {
                WANotesPane.this.doNew();
            }
        }

        public void postPopup(int x, int y) {
            Point p = new Point(x, y);
            int r = this.parent.rowAtPoint(p);
            TableCellEditor ce = this.parent.getCellEditor();
            if (ce != null && this.parent.isEditing()) {
                ce.stopCellEditing();
            }
            if (r == -1) {
                this.parent.clearSelection();
                this.pMenu.getComponent(1).setEnabled(false);
            } else {
                this.pMenu.getComponent(1).setEnabled(true);
                this.parent.changeSelection(r, -1, false, false);
            }
            super.postPopup(x, y);
        }
    }

    class NoteUndoableEditListener
    implements UndoableEditListener {
        NoteUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            WANotesPane.this.m_tblNotesList.getSelectionModel().addListSelectionListener(new UndoWorkaround(e.getEdit()));
            WANotesPane.this.getWAUndoManager().addEdit(e.getEdit());
        }
    }

    class NotesDocumentListener
    implements DocumentListener {
        NotesDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            WANotesPane.this.m_bNoteChanged = true;
            WANotesPane.this.setDataChanged(true);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            WANotesPane.this.m_bNoteChanged = true;
            WANotesPane.this.setDataChanged(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            WANotesPane.this.m_bNoteChanged = true;
            WANotesPane.this.setDataChanged(true);
        }
    }

    protected class cNewAction
    extends WsAbstractAction {
        public cNewAction() {
            super(bundle, "WANotesPane.New", 544);
            this.setMenuSupportId("new");
        }

        public void actionPerformed(ActionEvent e) {
            WANotesPane.this.doNew();
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction {
        public cDeleteAction() {
            super(bundle, "WANotesPane.Delete", 544);
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent e) {
            WANotesPane.this.doDelete();
        }
    }

    protected class cAttachAction
    extends WsAbstractAction {
        public cAttachAction() {
            super(bundle, "WANotesPane.Attach");
        }

        public void actionPerformed(ActionEvent e) {
            WANotesPane.this.doAttach();
        }
    }

    class NTMListener
    extends MouseAdapter {
        NTMListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point p = new Point(e.getX(), e.getY());
            int r = WANotesPane.this.m_tblNotesList.rowAtPoint(p);
            int sRow = WANotesPane.this.m_tblNotesList.getSelectedRow();
            if (r == -1) {
                WANotesPane.this.m_tblNotesList.clearSelection();
                return;
            }
            if (r == sRow) {
                WANotesPane.this.m_tblNotesList.editCellAt(r, 0);
            } else {
                WANotesPane.this.m_tblNotesList.changeSelection(r, -1, false, false);
            }
        }
    }

    class NotesKeyAdapter
    extends KeyAdapter {
        JTable table = null;

        public NotesKeyAdapter(JTable t) {
            this.table = t;
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            if (ke.getKeyCode() == 9) {
                boolean columnS = this.table.getColumnSelectionAllowed();
                boolean rowS = this.table.getRowSelectionAllowed();
                boolean shift = ke.isShiftDown();
                ListSelectionModel rsm = this.table.getSelectionModel();
                ListSelectionModel csm = this.table.getColumnModel().getSelectionModel();
                int leadRow = rsm.getLeadSelectionIndex();
                int leadCol = csm.getLeadSelectionIndex();
                int maxCol = this.table.getColumnCount();
                int maxRow = this.table.getRowCount();
                if (columnS && rowS) {
                    if (shift) {
                        if (leadCol > 0) {
                            --leadCol;
                        } else if (leadRow > 0) {
                            leadCol = maxCol - 1;
                            --leadRow;
                        }
                    } else if (leadCol < maxCol - 1) {
                        ++leadCol;
                    } else if (leadRow < maxRow - 1) {
                        leadCol = 0;
                        ++leadRow;
                    }
                } else if (rowS) {
                    if (shift) {
                        if (leadRow > 0) {
                            --leadRow;
                        }
                    } else if (leadRow < maxRow - 1) {
                        ++leadRow;
                    }
                } else if (columnS) {
                    if (shift) {
                        if (leadCol > 0) {
                            --leadCol;
                        }
                    } else if (leadCol < maxCol - 1) {
                        ++leadCol;
                    }
                }
                TableCellEditor ce = this.table.getCellEditor();
                if (ce != null && this.table.isEditing()) {
                    ce.stopCellEditing();
                }
                this.table.changeSelection(leadRow, leadCol, false, false);
                ke.consume();
            }
        }
    }

    class EThread
    extends Thread {
        long milliSecs = 0L;
        int row = 0;

        public EThread(long waitSecs, int r) {
            this.milliSecs = waitSecs;
            this.row = r;
        }

        @Override
        public void run() {
            try {
                EThread.sleep(this.milliSecs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (WANotesPane.this.stillEdit) {
                WANotesPane.this.m_tblNotesList.editCellAt(this.row, 0);
            }
            WANotesPane.this.stillEdit = false;
        }
    }

    class UndoWorkaround
    implements ListSelectionListener {
        UndoableEdit ed = null;

        public UndoWorkaround(UndoableEdit ue) {
            this.ed = ue;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.ed.die();
            WANotesPane.this.m_tblNotesList.getSelectionModel().removeListSelectionListener(this);
        }
    }
}

