/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.model.WAExtAttrTableModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.undo.UndoManager;

public class WAExtAttrPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(WAExtAttrPanel.class);
    protected Root m_oData;
    protected WAExtAttrTableModel m_mdlExtAttrs;
    protected WsTable m_tblExtAttrs;
    protected JScrollPane m_scrExtAttrs;
    protected JPanel m_pnlButtons;
    protected JButton m_btnNew;
    protected JButton m_btnDelete;
    protected JButton m_btnMoveUp;
    protected JButton m_btnMoveDown;
    protected WsAbstractAction m_actNew;
    protected WsAbstractAction m_actDelete;
    protected WsAbstractAction m_actMoveUp;
    protected WsAbstractAction m_actMoveDown;
    protected boolean m_bOrderChanged;
    protected boolean m_bSaveOrder;

    public WAExtAttrPanel(CMetadata oData) {
        this.m_oData = (Root)oData;
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("shared");
        this.setHelpTopic("exattr_tab");
    }

    public void initialize() {
        this.createActions();
        this.createExtAttrsTable();
        this.createButtonsPanel();
    }

    protected void createExtAttrsTable() {
        this.m_mdlExtAttrs = new WAExtAttrTableModel();
        this.m_mdlExtAttrs.setMetadataObject(this.m_oData);
        this.m_mdlExtAttrs.addTableModelListener(this.createTableModelListener());
        this.m_tblExtAttrs = new WsTable((WsAbstractTableModel)this.m_mdlExtAttrs);
        this.m_tblExtAttrs.getSelectionModel().addListSelectionListener(this.createTableSelectionListener());
        this.m_tblExtAttrs.setUndoManager((UndoManager)this.getWAUndoManager());
        this.m_tblExtAttrs.setColumnsReorderable(false);
        this.m_tblExtAttrs.setColumnHoldingEnabled(false);
        this.m_tblExtAttrs.setColumnHidingEnabled(false);
        this.m_tblExtAttrs.setRowHoldingEnabled(false);
        this.m_tblExtAttrs.setAutoResizeMode(3);
        this.m_tblExtAttrs.getActionMap().put(this.m_actDelete, (Action)this.m_actDelete);
        this.m_tblExtAttrs.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDelete);
        this.m_tblExtAttrs.restoreSettings("WAExtAttrPanel");
        this.m_tblExtAttrs.setRowHeaderPopupMenuRequestListener(this.createRowHeaderPopupMenuRequestListener());
        this.m_tblExtAttrs.setTablePopupMenuRequestListener(this.createTablePopupMenuRequestListener());
        this.m_tblExtAttrs.setViewportPopupMenuRequestListener(this.createViewportPopupMenuRequestListener());
        this.m_tblExtAttrs.getSelectionModel().addListSelectionListener(this.createTableSelectionListener());
        this.m_mdlExtAttrs.addTableModelListener(this.createTableModelListener());
        ((WsDefaultTableRowModel)this.m_tblExtAttrs.getRowModel()).addRowModelListener(this.createTableRowModelListener());
        this.m_scrExtAttrs = new JScrollPane((Component)this.m_tblExtAttrs);
    }

    protected void createButtonsPanel() {
        this.m_btnMoveUp = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actMoveUp);
        this.m_btnMoveDown = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actMoveDown);
        this.m_btnNew = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNew);
        this.m_btnDelete = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDelete);
        this.m_btnMoveUp.setIcon((Icon)this.m_actMoveUp.getValue("SmallIcon"));
        this.m_btnMoveDown.setIcon((Icon)this.m_actMoveDown.getValue("SmallIcon"));
        JPanel pnlLeft = new JPanel((LayoutManager)new WsButtonsLayout());
        JPanel pnlRight = new JPanel((LayoutManager)new WsButtonsLayout());
        pnlLeft.add(this.m_btnMoveUp);
        pnlLeft.add(this.m_btnMoveDown);
        pnlRight.add(this.m_btnNew);
        pnlRight.add(this.m_btnDelete);
        this.m_pnlButtons = new JPanel(new BorderLayout(10, 0));
        this.m_pnlButtons.add((Component)pnlLeft, "West");
        this.m_pnlButtons.add((Component)pnlRight, "East");
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_scrExtAttrs, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_pnlButtons, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        TableCellEditor editor = this.m_tblExtAttrs.getCellEditor();
        if (editor != null && !editor.stopCellEditing()) {
            return false;
        }
        if (this.m_bOrderChanged && !this.m_tblExtAttrs.isOriginalOrder()) {
            int eAnswer = MessageUtil.displayMessage((String)bundle.getString("WAExtAttrPanel.SaveOrderMessage.txt"), (String)bundle.getString("WAExtAttrPanel.SaveOrderTitle.txt"), (int)2, (int)1);
            switch (eAnswer) {
                case 0: {
                    break;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case -1: {
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)this.m_tblExtAttrs.getRowModel();
        this.m_mdlExtAttrs.setRowMappings(mdlRows.getRowMappings());
        return true;
    }

    public void setStorePopulated(boolean bStorePopulated) {
        super.setStorePopulated(bStorePopulated);
        if (!bStorePopulated) {
            this.m_mdlExtAttrs.setStorePopulated(bStorePopulated);
        }
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.m_mdlExtAttrs.populateStore();
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_mdlExtAttrs.moveDataToModel();
        if (this.m_mdlExtAttrs.getRowCount() > 0) {
            this.m_tblExtAttrs.selectCell(0, 0);
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        this.m_oData.setName(this.m_oData.getName());
        this.m_mdlExtAttrs.moveDataToStore();
        this.m_mdlExtAttrs.setRowMappings(null);
        this.setDataChanged(false);
        this.m_bOrderChanged = false;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actNew.setActive(bActive);
        this.m_actDelete.setActive(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tblExtAttrs.setEditable(bEditable);
        this.m_tblExtAttrs.setSortingEnabled(bEditable);
        this.m_tblExtAttrs.setRowsReorderable(bEditable);
        this.updateActions();
    }

    public void saveSettingsAndCleanUp() {
        this.m_tblExtAttrs.saveSettings("WAExtAttrPanel");
    }

    public void setWAUndoManager(WAUndoManager mgrUndo) {
        super.setWAUndoManager(mgrUndo);
        this.m_tblExtAttrs.setUndoManager((UndoManager)mgrUndo);
    }

    protected ListSelectionListener createTableSelectionListener() {
        return new cTableSelectionListener();
    }

    protected WsTableRowModelListener createTableRowModelListener() {
        return new cTableRowModelListener();
    }

    protected TableModelListener createTableModelListener() {
        return new cTableModelListener();
    }

    protected WsPopupMenuRequestListener createRowHeaderPopupMenuRequestListener() {
        return new cRowHeaderPopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createTablePopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createViewportPopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    protected void createActions() {
        this.m_actNew = this.createNewAction();
        this.m_actDelete = this.createDeleteAction();
        this.m_actMoveUp = this.createMoveUpAction();
        this.m_actMoveDown = this.createMoveDownAction();
    }

    protected void updateActions() {
        boolean bSelected;
        int[] aSelectedRows = this.m_tblExtAttrs.getSelectedRowsFromSelectedCells();
        boolean bEditable = this.isEditable();
        boolean bNotFirst = bSelected = aSelectedRows.length > 0;
        boolean bNotLast = bSelected;
        int iLastRow = this.m_tblExtAttrs.getRowCount() - 1;
        int nSelectedRows = aSelectedRows.length;
        for (int iSelectedRow = 0; iSelectedRow < nSelectedRows; ++iSelectedRow) {
            if (aSelectedRows[iSelectedRow] == 0) {
                bNotFirst = false;
            }
            if (aSelectedRows[iSelectedRow] != iLastRow) continue;
            bNotLast = false;
        }
        this.m_actDelete.setEnabled(bEditable && bSelected);
        this.m_actNew.setEnabled(bEditable);
        this.m_actMoveUp.setEnabled(bEditable && bNotFirst);
        this.m_actMoveDown.setEnabled(bEditable && bNotLast);
    }

    protected WsAbstractAction createNewAction() {
        return new cNewAction();
    }

    protected WsAbstractAction createDeleteAction() {
        return new cDeleteAction();
    }

    protected WsAbstractAction createMoveUpAction() {
        return new cMoveUpAction();
    }

    protected WsAbstractAction createMoveDownAction() {
        return new cMoveDownAction();
    }

    protected class cTableSelectionListener
    implements ListSelectionListener {
        protected cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            WAExtAttrPanel.this.updateActions();
        }
    }

    protected class cTableRowModelListener
    implements WsTableRowModelListener {
        protected cTableRowModelListener() {
        }

        public void rowDragged(TableRowModelEvent e) {
            WAExtAttrPanel.this.setDataChanged(true);
            WAExtAttrPanel.this.m_bOrderChanged = true;
        }

        public void rowsHidden(WsTableRowModelEvent e) {
        }

        public void rowsShown(WsTableRowModelEvent e) {
        }

        public void rowsRemapped(ChangeEvent e) {
            WAExtAttrPanel.this.setDataChanged(true);
            WAExtAttrPanel.this.m_bOrderChanged = true;
        }
    }

    protected class cTableModelListener
    implements TableModelListener {
        protected cTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (WAExtAttrPanel.this.isListeningForChanges()) {
                WAExtAttrPanel.this.setDataChanged(true);
            }
        }
    }

    public class cRowHeaderPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = WAExtAttrPanel.this.m_tblExtAttrs.createRowHeaderPopupMenu();
            WsUIUtilities.addSpaceIconToPopupMenu((JPopupMenu)mnuPopup);
            if (mnuPopup.getComponentCount() != 0) {
                mnuPopup.addSeparator();
            }
            mnuPopup.add(new JMenuItem((Action)WAExtAttrPanel.this.m_actNew));
            mnuPopup.add(new JMenuItem((Action)WAExtAttrPanel.this.m_actDelete));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    public class cTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem((Action)WAExtAttrPanel.this.m_actNew));
            mnuPopup.add(new JMenuItem((Action)WAExtAttrPanel.this.m_actDelete));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cNewAction
    extends WsAbstractAction {
        public cNewAction() {
            super(bundle, "WAExtAttrPanel.New", true);
        }

        public void actionPerformed(ActionEvent e) {
            WAExtAttrPanel.this.m_tblExtAttrs.undoableInsertNewRowAfterLastSelectedRow();
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction {
        public cDeleteAction() {
            super(bundle, "WAExtAttrPanel.Delete", true);
        }

        public void actionPerformed(ActionEvent e) {
            WAExtAttrPanel.this.m_tblExtAttrs.undoableDeleteSelectedRows();
        }
    }

    protected class cMoveUpAction
    extends WsAbstractAction {
        public cMoveUpAction() {
            super(bundle, "WAExtAttrPanel.MoveUp", true);
        }

        public void actionPerformed(ActionEvent e) {
            WAExtAttrPanel.this.m_tblExtAttrs.undoableMoveSelectedRows(-1);
            WAExtAttrPanel.this.setDataChanged(true);
            WAExtAttrPanel.this.m_bOrderChanged = true;
        }
    }

    protected class cMoveDownAction
    extends WsAbstractAction {
        public cMoveDownAction() {
            super(bundle, "WAExtAttrPanel.MoveDown", true);
        }

        public void actionPerformed(ActionEvent e) {
            WAExtAttrPanel.this.m_tblExtAttrs.undoableMoveSelectedRows(1);
            WAExtAttrPanel.this.setDataChanged(true);
            WAExtAttrPanel.this.m_bOrderChanged = true;
        }
    }
}

