/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.codegen.TransformationActivityCG;
import com.sas.io.File;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TransformationStep;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.undo.UndoableEdit;

public class WADocumentDetailTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(WADocumentDetailTab.class);
    com.sas.metadata.remote.Document m_doc = null;
    CMetadata m_metadata;
    protected cDocPanel m_pnlDoc;
    protected boolean m_bFileChanged;

    public WADocumentDetailTab(CMetadata metadata) {
        this.m_metadata = metadata;
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("shared");
        this.setHelpTopic("details_tab_documents");
    }

    public void initialize() {
        this.m_pnlDoc = new cDocPanel(this.m_metadata);
        this.m_pnlDoc.setWAUndoManager(this.getWAUndoManager());
    }

    public boolean validateData() {
        return true;
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        try {
            this.m_pnlDoc.doDataExchange(bSaveToModel);
        }
        finally {
            this.setDataChanged(false);
            this.waum.discardAllEdits();
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_pnlDoc.setEditable(bEditable);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_pnlDoc), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_pnlDoc.updateWorkspaceUIComponents(bActive);
    }

    class cDocPanel
    extends WAPanel {
        private boolean m_isLocal;
        protected WATextField m_txtDoc;
        protected JLabel m_doclabel;
        protected CMetadata m_docMetadata;
        protected com.sas.metadata.remote.Document m_document;
        protected JButton m_pathButton;
        protected JButton m_btnRemoteFile;

        public cDocPanel(CMetadata metadata) {
            this.m_docMetadata = metadata;
            this.m_document = (com.sas.metadata.remote.Document)this.m_docMetadata;
            this.initialize();
            this.layoutWidgets();
        }

        public void initialize() {
            this.m_txtDoc = new WATextField();
            this.m_txtDoc.setToolTipText(bundle.getString("WADocumentDetailTab.Path.Tooltip.txt"));
            this.m_txtDoc.setFocusAccelerator(bundle.getString("WADocumentDetailTab.Path.mnem").charAt(0));
            PlainDocument pd = new PlainDocument();
            this.m_txtDoc.setDocument((Document)pd);
            pd.addDocumentListener(new DocDetailListener());
            pd.addUndoableEditListener(new DocUndoableEditListener());
            this.m_txtDoc.setEnabled(true);
            this.m_doclabel = new JLabel(bundle.getString("WADocumentDetailTab.Label.Path.txt"));
            this.m_doclabel.setDisplayedMnemonic(bundle.getString("WADocumentDetailTab.Path.mnem").charAt(0));
            this.m_doclabel.setLabelFor((Component)this.m_txtDoc);
            this.m_pathButton = new JButton(bundle.getString("WADocumentDetailTab.PathButton.txt"));
            this.m_pathButton.setMnemonic(bundle.getString("WADocumentDetailTab.PathButton.mnem").charAt(0));
            this.m_pathButton.setToolTipText(bundle.getString("WADocumentDetailTab.PathButton.Tooltip.txt"));
            this.m_pathButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    block18: {
                        try {
                            AssociationList objList = null;
                            try {
                                objList = cDocPanel.this.m_document.getObjects();
                            }
                            catch (MdException exc) {
                                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                            }
                            catch (RemoteException re) {
                                Workspace.handleRemoteException((RemoteException)re);
                            }
                            if (!cDocPanel.this.m_document.getTextRole().equals("HPFOUTPUT") || objList.isEmpty()) {
                                FileDialog m_fileSelect = null;
                                String m_selectedDir = null;
                                m_fileSelect = new FileDialog((Frame)Workspace.getWorkspace());
                                if (cDocPanel.this.m_txtDoc != null && cDocPanel.this.m_txtDoc.getText().length() > 0) {
                                    File tempFile = new File(cDocPanel.this.m_txtDoc.getText());
                                    m_selectedDir = tempFile.getParent();
                                }
                                if (m_selectedDir != null) {
                                    m_fileSelect.setDirectory(m_selectedDir);
                                } else {
                                    m_fileSelect.setDirectory(Workspace.getWorkspace().getDefaultPath());
                                }
                                m_fileSelect.setTitle(bundle.getString("WADocumentDetailTab.SelectFileDialog.Title.txt"));
                                m_fileSelect.setMode(0);
                                m_fileSelect.setVisible(true);
                                String uFile = m_fileSelect.getFile();
                                m_selectedDir = m_fileSelect.getDirectory();
                                if (uFile != null) {
                                    cDocPanel.this.m_isLocal = true;
                                    WADocumentDetailTab.this.m_bFileChanged = true;
                                    String uDir = m_fileSelect.getDirectory();
                                    String wholeName = uDir + uFile;
                                    if (wholeName != null) {
                                        cDocPanel.this.m_txtDoc.setText(wholeName);
                                    }
                                }
                                break block18;
                            }
                            try {
                                for (int i = 0; i < objList.size(); ++i) {
                                    TransformationStep tStep;
                                    if (!(objList.get(i) instanceof TransformationStep) || !(tStep = (TransformationStep)objList.get(i)).getTransformRole().equals("com.sas.wadmin.transform.hpf")) continue;
                                    ServerContext server = TransformationActivityCG.getServerForStep(tStep, WsAppServer.createDefaultAppServer().getServerContext());
                                    WsAppServer appServer = null;
                                    appServer = server != null ? WsAppServer.createAppServer((ServerContext)server) : WsAppServer.createDefaultAppServer();
                                    try {
                                        String filepath = appServer.promptForFilename(bundle.getString("RemoteFilePanel.RemoteFileSelector.Title.txt"), cDocPanel.this.m_txtDoc.getText(), null);
                                        cDocPanel.this.m_isLocal = false;
                                        WADocumentDetailTab.this.m_bFileChanged = true;
                                        if (filepath == null) continue;
                                        cDocPanel.this.m_txtDoc.setText(filepath);
                                        continue;
                                    }
                                    catch (GenericError err) {
                                        MessageUtil.displayMessage((String)err.getLocalizedMessage());
                                        continue;
                                    }
                                    catch (WsAppServerFailException exc) {
                                        MessageUtil.displayMessage((String)exc.getLocalizedMessage());
                                    }
                                }
                            }
                            catch (MdException exc) {
                                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                            }
                            catch (RemoteException re) {
                                Workspace.handleRemoteException((RemoteException)re);
                            }
                        }
                        catch (RemoteException e) {
                            Workspace.handleRemoteException((RemoteException)e);
                        }
                    }
                }
            });
            this.m_btnRemoteFile = WsUIUtilities.createTextButton((WsAbstractAction)new cSelectRemoteFileAction());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getRemoteFilename() {
            String sSelectedFile = null;
            try (WsAppServer appserver = WsAppServer.createDefaultAppServer((boolean)true);){
                if (appserver == null) {
                    String string = "";
                    return string;
                }
                if (!appserver.isOpen()) {
                    appserver.open();
                }
                String file = this.m_txtDoc.getText();
                sSelectedFile = appserver.promptForFilename(bundle.getString("NewDocumentDialog.SelectFileDialog.Title.txt"), file, null);
            }
            return sSelectedFile;
        }

        public void setEditable(boolean bEditable) {
            super.setEditable(bEditable);
            this.m_txtDoc.setEditable(bEditable);
            this.m_pathButton.setEnabled(bEditable);
        }

        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add(this.m_doclabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.m_txtDoc, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
            JPanel btnsPanel = new JPanel();
            btnsPanel.add(this.m_pathButton);
            btnsPanel.add(this.m_btnRemoteFile);
            this.add(btnsPanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 0), 0, 0));
        }

        public boolean doDataExchange(boolean bSaveToModel) {
            try {
                if (!bSaveToModel) {
                    this.m_txtDoc.setText(this.m_document.getURI());
                    this.m_isLocal = !this.m_document.getURIType().equals("REMOTE");
                } else if (WADocumentDetailTab.this.m_bFileChanged) {
                    this.m_document.setURI(this.m_txtDoc.getText());
                    if (!this.m_isLocal) {
                        this.m_document.setURIType("REMOTE");
                    } else {
                        this.m_document.setURIType("");
                    }
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            finally {
                this.setDataChanged(false);
                this.waum.discardAllEdits();
            }
            return true;
        }

        public boolean validateData() {
            return true;
        }

        public void updateWorkspaceUIComponents(boolean bActive) {
            super.updateWorkspaceUIComponents(bActive);
        }

        protected class cSelectRemoteFileAction
        extends WsAbstractAction {
            private static final long serialVersionUID = 1L;

            public cSelectRemoteFileAction() {
                super(bundle, "WADocumentDetailTab.SelecteRemoteFile", 0);
            }

            public void actionPerformed(ActionEvent e) {
                String sFileName = cDocPanel.this.getRemoteFilename();
                if (sFileName != null && sFileName.length() > 0) {
                    cDocPanel.this.m_txtDoc.setText(sFileName);
                    cDocPanel.this.m_isLocal = false;
                    WADocumentDetailTab.this.m_bFileChanged = true;
                }
            }
        }
    }

    class UndoWorkaround
    implements ListSelectionListener {
        UndoableEdit ed = null;

        public UndoWorkaround(UndoableEdit ue) {
            this.ed = ue;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.ed.die();
        }
    }

    class DocUndoableEditListener
    implements UndoableEditListener {
        DocUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            WADocumentDetailTab.this.getWAUndoManager().addEdit(e.getEdit());
        }
    }

    class DocDetailListener
    implements DocumentListener {
        DocDetailListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            WADocumentDetailTab.this.setDataChanged(true);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            WADocumentDetailTab.this.setDataChanged(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            WADocumentDetailTab.this.setDataChanged(true);
        }
    }
}

