/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.codegen.CodegenRequest;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Text;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.workspace.AppServer;
import com.sas.workspace.AppServerException;
import com.sas.workspace.IOMWorkspaceUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.ParametersInterface;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;

public class WADeploymentTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(WADeploymentTab.class);
    private Job m_oJob;
    private JFJob m_oJFJob;
    protected WATextArea m_lblServerDesc;
    protected JLabel m_lblServer;
    protected WAComboBox m_cbServer;
    protected JSeparator m_separator;
    protected JLabel m_lblDirectory;
    protected WAComboBox m_cbDirectory;
    protected JLabel m_lblFilename;
    protected WATextField m_tfFilename;
    protected List m_lServers;
    protected List m_lDirectory;
    protected ServerContext m_SelectedServer;
    protected Directory m_SelectedDirectory;
    protected File m_Source;
    protected cDeploy m_Deploy;

    public WADeploymentTab(Job oJob) {
        this.m_oJob = oJob;
        this.initialize();
        this.layoutWidgets();
        this.createListeners();
    }

    protected void initialize() {
        this.m_lblServerDesc = new WATextArea();
        this.m_lblServerDesc.setColumns(50);
        this.m_lblServerDesc.setBehavior(1);
        this.m_lblServerDesc.setText(bundle.getString("WADeploymentTab.ServerDesc.Label.txt"));
        this.m_lblServerDesc.setAutosize(true);
        this.m_lblServer = new JLabel(bundle.getString("WADeploymentTab.Server.Label.txt"));
        this.m_lblServer.setDisplayedMnemonic(bundle.getString("WADeploymentTab.Server.Label.mnem").charAt(0));
        this.m_cbServer = new WAComboBox();
        this.m_lblServer.setLabelFor((Component)this.m_cbServer);
        this.m_lblDirectory = new JLabel(bundle.getString("WADeploymentTab.Directory.Label.txt"));
        this.m_lblDirectory.setDisplayedMnemonic(bundle.getString("WADeploymentTab.Directory.Label.mnem").charAt(0));
        this.m_cbDirectory = new WAComboBox();
        this.m_lblDirectory.setLabelFor((Component)this.m_cbDirectory);
        this.m_lblFilename = new JLabel(bundle.getString("WADeploymentTab.Filename.Label.txt"));
        this.m_lblFilename.setDisplayedMnemonic(bundle.getString("WADeploymentTab.Filename.Label.mnem").charAt(0));
        this.m_tfFilename = new WATextField();
        this.m_lblFilename.setLabelFor((Component)this.m_tfFilename);
        this.setHelpTopic("deploy_for_sched");
        this.m_lDirectory = new ArrayList();
    }

    protected void layoutWidgets() {
        TitledBorder titledBorder = new TitledBorder(bundle.getString("WADeploymentTab.SubPanelTitle.Label.txt"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_lblServerDesc, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 15, 0), 0, 0));
        JPanel box1 = new JPanel();
        box1.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add(box1, gbc);
        JPanel box2 = new JPanel();
        box2.setLayout(new GridBagLayout());
        box2.setBorder(titledBorder);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(40, 0, 0, 0);
        this.add(box2, gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        box1.add((Component)this.m_lblServer, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        box1.add((Component)this.m_cbServer, gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        box2.add((Component)this.m_lblDirectory, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        box2.add((Component)this.m_cbDirectory, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        box2.add((Component)this.m_lblFilename, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        box2.add((Component)this.m_tfFilename, gbc);
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.setupServerData();
        this.setupDirectoryData();
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.updateServerView();
        this.updateDirectoryView();
        this.m_tfFilename.setText(this.makeFilename());
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.createJFJobObject();
        this.m_oJob.getJFJobs().removeAllElements();
        this.m_oJob.getJFJobs().add((Object)this.m_oJFJob);
        this.createSourceCodeObject();
        this.m_oJFJob.setSourceCode((Text)this.m_Source);
        this.m_Source.getDirectories().removeAllElements();
        this.m_Source.getDirectories().add((Object)this.m_SelectedDirectory);
        this.m_oJFJob.getComputeLocations().removeAllElements();
        this.m_oJFJob.getComputeLocations().add((Object)this.m_SelectedServer);
    }

    public boolean validateData() {
        String errorTitle = bundle.getString("WADeploymentTab.DeploymentError.title.txt");
        if (this.m_SelectedServer == null) {
            MessageUtil.displayMessage((String)bundle.getString("WADeploymentTab.DeploymentError.NoServer.txt"), (String)errorTitle, (int)0);
            return false;
        }
        try {
            int response;
            AssociationList usingComponents = this.m_SelectedServer.getUsingComponents();
            boolean batchFound = false;
            for (int i = 0; i < usingComponents.size(); ++i) {
                LogicalServer logicalServer = (LogicalServer)usingComponents.get(i);
                if (!logicalServer.getClassIdentifier().equalsIgnoreCase("e20e54b3-e5f4-47ed-b21d-03109bf9a4b8")) continue;
                batchFound = true;
                break;
            }
            if (!batchFound && (response = MessageUtil.displayMessage((String)bundle.getString("WADeploymentTab.MissingBatch.msg.txt"), (String)bundle.getString("WADeploymentTab.MissingBatch.title.txt"), (int)2, (int)0)) == 1) {
                return false;
            }
        }
        catch (MdException mdExcp) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mdExcp, (String)"Accessing");
            return false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        if (this.m_SelectedDirectory == null) {
            MessageUtil.displayMessage((String)bundle.getString("WADeploymentTab.DeploymentError.NoDirectory.txt"), (String)errorTitle, (int)0);
            return false;
        }
        if (this.m_tfFilename.getText().length() <= 0 || !WADeploymentTab.isValidFilename(this.m_tfFilename.getText())) {
            MessageUtil.displayMessage((String)bundle.getString("WADeploymentTab.DeploymentError.BadFilename.txt"), (String)errorTitle, (int)0);
            return false;
        }
        this.m_Deploy = new cDeploy();
        this.setCursor(Cursor.getPredefinedCursor(3));
        OpRequestUI cgOpRequestUI = new OpRequestUI((Frame)Workspace.getWorkspace(), bundle.getString("WADeploymentTab.Executing.msg.txt"), bundle.getString("WADeploymentTab.Executing.title.txt"));
        cgOpRequestUI.setDelayBeforeProgressCancelDialog(0);
        cgOpRequestUI.setProgressShownOnStatusBar(false);
        cgOpRequestUI.execute(this.createDeployRunnable());
        this.setCursor(Cursor.getDefaultCursor());
        if (this.m_Deploy.getResult()) {
            MessageUtil.displayMessage((String)bundle.getString("WADeploymentTab.Success.msg.txt"), (String)bundle.getString("WADeploymentTab.Success.title.txt"), (int)1);
            return true;
        }
        return false;
    }

    private static boolean isValidFilename(String strName) {
        String invalidCharacters = bundle.getString("WADeployment.invalidCharacters.txt.notrans");
        for (int i = 0; i < invalidCharacters.length(); ++i) {
            char c = invalidCharacters.charAt(i);
            if (strName.indexOf(c) <= 0) continue;
            return false;
        }
        return true;
    }

    private void setupServerData() throws MdException, RemoteException {
        String reposID = "A0000001." + this.m_oJob.getId().substring(0, 8);
        String strOptions = "";
        int flags = 8588;
        this.m_lServers = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_oJob.getObjectStore(), reposID, "ServerContext", flags, strOptions);
        if (this.m_lServers.size() > 0) {
            AssociationList lJfjobs = this.m_oJob.getJFJobs();
            if (lJfjobs.size() > 0) {
                this.m_oJFJob = (JFJob)lJfjobs.get(0);
                AssociationList lServers = this.m_oJFJob.getComputeLocations();
                if (lServers.size() > 0) {
                    this.m_SelectedServer = (ServerContext)lServers.get(0);
                    return;
                }
            }
            this.m_SelectedServer = (ServerContext)this.m_lServers.get(0);
            return;
        }
    }

    private void updateServerView() {
        this.m_cbServer.removeAllItems();
        this.m_cbServer.setSorted(true);
        for (int i = 0; i < this.m_lServers.size(); ++i) {
            this.m_cbServer.addItem(this.m_lServers.get(i));
        }
        this.m_cbServer.setSelectedItem((Object)this.m_SelectedServer);
    }

    private void setupDirectoryData() throws MdException, RemoteException {
        this.m_lDirectory.clear();
        if (this.m_SelectedServer == null) {
            return;
        }
        AssociationList lPkgs = this.m_SelectedServer.getDataPackages();
        if (lPkgs.size() > 0) {
            for (int i = 0; i < lPkgs.size(); ++i) {
                DeployedDataPackage iPkg = (DeployedDataPackage)lPkgs.get(i);
                if (!(iPkg instanceof Directory)) continue;
                this.m_lDirectory.add(iPkg);
            }
            if (this.m_oJFJob != null) {
                this.m_Source = (File)this.m_oJFJob.getSourceCode();
                if (this.m_Source != null) {
                    AssociationList lDirs = this.m_Source.getDirectories();
                    if (lDirs.size() > 0) {
                        this.m_SelectedDirectory = (Directory)lDirs.get(0);
                    }
                    return;
                }
                this.m_SelectedDirectory = (Directory)this.m_lDirectory.get(0);
            }
        }
    }

    private void updateDirectoryView() {
        this.m_cbDirectory.removeAllItems();
        this.m_cbDirectory.setSorted(true);
        if (this.m_lDirectory.size() == 0) {
            this.m_cbDirectory.setEnabled(false);
        } else {
            this.m_cbDirectory.setEnabled(true);
        }
        for (int i = 0; i < this.m_lDirectory.size(); ++i) {
            this.m_cbDirectory.addItem(this.m_lDirectory.get(i));
        }
        if (this.m_SelectedDirectory == null && this.m_cbDirectory.getItemCount() > 0) {
            this.m_cbDirectory.setSelectedIndex(0);
            this.m_SelectedDirectory = (Directory)this.m_cbDirectory.getItemAt(0);
        } else {
            this.m_cbDirectory.setSelectedItem((Object)this.m_SelectedDirectory);
        }
    }

    private String makeFilename() {
        return this.makeFilename(true);
    }

    private String makeFilename(boolean includeSASExtension) {
        try {
            if (this.m_Source != null) {
                return this.m_Source.getFileName();
            }
            String retStr = this.m_oJob.getName();
            String invalidCharacters = bundle.getString("WADeployment.invalidCharacters.txt.notrans");
            for (int i = 0; i < invalidCharacters.length(); ++i) {
                char c = invalidCharacters.charAt(i);
                if (retStr.indexOf(c) <= 0) continue;
                retStr = retStr.replace(c, '_');
            }
            if (includeSASExtension) {
                return retStr.trim() + ".sas";
            }
            return retStr;
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            return null;
        }
    }

    protected void createJFJobObject() {
        try {
            if (this.m_oJFJob == null) {
                MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                String reposID = this.m_oJob.getId().substring(0, 8);
                this.m_oJFJob = (JFJob)factory.createComplexMetadataObject((MdObjectStore)this.m_oJob.getObjectStore(), this.makeFilename(false), "JFJob", reposID);
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    protected void createSourceCodeObject() {
        try {
            String strFilename = this.m_tfFilename.getText();
            if (this.m_Source == null) {
                MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                String reposID = this.m_oJob.getId().substring(0, 8);
                this.m_Source = (File)factory.createComplexMetadataObject((MdObjectStore)this.m_oJob.getObjectStore(), strFilename, "File", reposID);
            }
            this.m_Source.setFileName(strFilename);
            this.m_Source.setIsARelativeName(1);
            this.m_Source.setTextRole("SourceCode");
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    protected void createListeners() {
        this.listenForDataChangesTo((JTextComponent)this.m_tfFilename);
        this.m_cbServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WADeploymentTab.this.isListeningForChanges()) {
                    try {
                        ServerContext iServer = (ServerContext)WADeploymentTab.this.m_cbServer.getSelectedItem();
                        if (!WADeploymentTab.this.m_SelectedServer.getId().equals(iServer.getId())) {
                            try {
                                WADeploymentTab.this.m_SelectedServer = iServer;
                                WADeploymentTab.this.setupDirectoryData();
                                WADeploymentTab.this.updateDirectoryView();
                                WADeploymentTab.this.setDataChanged(true);
                            }
                            catch (MdException mde) {
                                Workspace.getDefaultLogger().error((Object)"", (Throwable)mde);
                            }
                            catch (RemoteException re) {
                                Workspace.handleRemoteException((RemoteException)re);
                            }
                        }
                    }
                    catch (RemoteException e1) {
                        Workspace.handleRemoteException((RemoteException)e1);
                    }
                }
            }
        });
        this.m_cbDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (WADeploymentTab.this.isListeningForChanges()) {
                        boolean hasChanged = false;
                        Directory iDir = (Directory)WADeploymentTab.this.m_cbDirectory.getSelectedItem();
                        if (WADeploymentTab.this.m_SelectedDirectory != null && iDir != null) {
                            if (!WADeploymentTab.this.m_SelectedDirectory.getId().equals(iDir.getId())) {
                                WADeploymentTab.this.m_SelectedDirectory = iDir;
                                hasChanged = true;
                            }
                        } else if (iDir != null) {
                            WADeploymentTab.this.m_SelectedDirectory = iDir;
                            hasChanged = true;
                        } else if (WADeploymentTab.this.m_SelectedDirectory != null) {
                            WADeploymentTab.this.m_SelectedDirectory = null;
                            hasChanged = true;
                        }
                        WADeploymentTab.this.setDataChanged(hasChanged);
                    }
                }
                catch (RemoteException e1) {
                    Workspace.handleRemoteException((RemoteException)e1);
                }
            }
        });
    }

    private String generateCode() {
        try {
            AppServer iAppServer = Workspace.getWorkspace().makeAppServer(this.m_SelectedServer.getId(), false);
            CodegenRequest cgReq = new CodegenRequest((CMetadata)this.m_oJob, iAppServer, 1, true, (ParametersInterface)new ParametersModel());
            cgReq.doCodegen();
            if (cgReq.getRC() == -1) {
                MessageUtil.displayMessage((String)cgReq.getErrorMessage(), (String)bundle.getString("WADeploymentTab.CodegenError.title.txt"), (int)0, (int)-1);
                cgReq.cleanupCodeGen();
                cgReq = null;
                return null;
            }
            String code = cgReq.getSource();
            iAppServer.termAppServer();
            return code;
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveToExternalFile(String code) {
        try {
            AppServer iAppServer = Workspace.getWorkspace().makeAppServer(this.m_SelectedServer.getId(), false);
            try {
                IWorkspace iworkspace = iAppServer.makeConnection();
                String hostname = this.m_SelectedServer.getName();
                String dirName = this.m_SelectedDirectory.getDirectoryName();
                String fileName = this.m_tfFilename.getText();
                IFileService rio = iworkspace.FileService();
                boolean bl = IOMWorkspaceUtil.saveToRemoteFile((IFileService)rio, (String)fileName, (String)dirName, (String)code, (String)hostname);
                return bl;
            }
            catch (Exception e) {
                String title = e instanceof AppServerException ? bundle.getString("WADeploymentTab.AppServerError.title.txt") : bundle.getString("WADeploymentTab.FileSaveError.title.txt");
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (String)title, (int)0);
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                return false;
            }
            finally {
                iAppServer.termAppServer();
            }
        }
        catch (RemoteException e2) {
            Workspace.handleRemoteException((RemoteException)e2);
        }
        return false;
    }

    protected Runnable createDeployRunnable() {
        return new cDeployRunnable();
    }

    protected class cDeploy {
        boolean m_result = true;

        public void deployJob() {
            this.m_result = true;
            String strSourceCode = WADeploymentTab.this.generateCode();
            if (strSourceCode == null) {
                this.m_result = false;
            } else if (!WADeploymentTab.this.saveToExternalFile(strSourceCode)) {
                this.m_result = false;
            }
        }

        public boolean getResult() {
            return this.m_result;
        }
    }

    protected class cDeployRunnable
    implements Runnable {
        protected cDeployRunnable() {
        }

        @Override
        public void run() {
            WADeploymentTab.this.m_Deploy.deployJob();
        }
    }
}

