/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.visuals.SASSortByPropertyTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.JLabel;

public class TransformListOptionsPropertyTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(TransformListOptionsPropertyTab.class);
    protected TransformPanel m_cmpTransformPanel;
    protected CMetadata m_metadata;
    protected ActionListener m_lsnrShowColumns;
    protected WAComboBox m_cmbShowColumns = new WAComboBox();
    protected PhysicalTable m_inputTable;
    protected PhysicalTable m_outputTable;
    protected AssociationList m_properties;
    protected boolean m_fInitialized = false;

    public TransformListOptionsPropertyTab(CMetadata metadata) {
        this.setHelpProduct("wdb");
        this.setHelpTopic("column_options");
        this.m_metadata = metadata;
        this.createListeners();
        this.initialize();
        this.layoutWidgets();
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_cmpTransformPanel.setEditable(bEditable);
    }

    public boolean validateData() {
        return this.m_cmpTransformPanel.validateData();
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        ClassifierMap map = (ClassifierMap)((TransformationStep)this.m_metadata).getTransformations().elementAt(0);
        if (map.getClassifierSources().size() > 0) {
            this.m_inputTable = (PhysicalTable)map.getClassifierSources().elementAt(0);
        }
        if (map.getClassifierTargets().size() > 0) {
            this.m_outputTable = (PhysicalTable)map.getClassifierTargets().elementAt(0);
        }
        this.m_cmpTransformPanel.populateStore();
        this.m_properties = this.getMacroProperties();
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.removeComboListener();
        if (this.m_properties == null || this.m_properties.size() == 0) {
            return;
        }
        if (!this.m_fInitialized) {
            for (int i = 0; i < this.m_properties.size(); ++i) {
                Property elementAt = (Property)this.m_properties.elementAt(i);
                Property prop = elementAt;
                if (prop.getPropertyRole().indexOf("INPUTS") <= -1 && prop.getPropertyRole().indexOf("OUTPUTS") <= -1) continue;
                this.m_cmbShowColumns.addItem((Object)elementAt);
            }
            this.m_fInitialized = true;
        }
        this.addComboListener();
        if (this.m_cmbShowColumns.getItemCount() > 0) {
            this.m_cmbShowColumns.setSelectedIndex(0);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_cmpTransformPanel.moveDataToStore();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_cmpTransformPanel.updateWorkspaceUIComponents(bActive);
    }

    public void saveSettingsAndCleanUp() {
        this.m_cmpTransformPanel.saveSettingsAndCleanUp();
    }

    public Component getDefaultFocusComponent() {
        return this.m_cmbShowColumns;
    }

    protected void initialize() {
        this.m_cmpTransformPanel = new TransformPanel(this.m_metadata, "TransformListOptionsPropertyTab", "importwiz_5");
        this.m_cmpTransformPanel.setParentPanel((WAPanel)this);
        this.m_cmbShowColumns.addActionListener(this.m_lsnrShowColumns);
        this.m_cmbShowColumns.setEditable(false);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        JLabel label = new JLabel(bundle.getString("TransformListOptionsPropertyTab.option.txt"));
        label.setDisplayedMnemonic(bundle.getString("TransformListOptionsPropertyTab.Label.Name.mnem").charAt(0));
        this.m_cmbShowColumns.setToolTipText(bundle.getString("TransformListOptionsPropertyTab.nameTooltip.txt"));
        label.setLabelFor((Component)this.m_cmbShowColumns);
        this.add(label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_cmbShowColumns, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_cmpTransformPanel), new GridBagConstraints(0, 1, 3, 3, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    protected void createListeners() {
        this.m_lsnrShowColumns = this.createComboListener();
    }

    protected ActionListener createComboListener() {
        return new cComboListener();
    }

    protected void removeComboListener() {
        this.m_cmbShowColumns.removeActionListener(this.m_lsnrShowColumns);
    }

    protected void addComboListener() {
        this.m_cmbShowColumns.addActionListener(this.m_lsnrShowColumns);
    }

    public AssociationList getMacroProperties() throws MdException, RemoteException {
        ClassifierMap map = (ClassifierMap)((TransformationStep)this.m_metadata).getTransformations(false).elementAt(0);
        AssociationList propertySets = map.getPropertySets();
        AssociationList properties = null;
        for (int i = 0; i < propertySets.size(); ++i) {
            PropertySet set = (PropertySet)propertySets.elementAt(i);
            if (set.getSetRole().indexOf("MACROOPTIONS") <= -1) continue;
            properties = set.getProperties();
        }
        return properties;
    }

    public class TransformPanel
    extends SASSortByPropertyTab {
        protected PhysicalTable m_metadataTable;
        protected WAPanel m_parentPanel;

        public TransformPanel(CMetadata metadata) {
            super(metadata);
            this.m_metadataTable = null;
        }

        public TransformPanel(CMetadata metadata, String bundlePrefix, String helpTopic) {
            super(metadata, false, bundlePrefix, helpTopic);
            this.m_metadataTable = null;
        }

        @Override
        protected SASSortByPropertyTab.SASSortByModel createTableModel() {
            return new TransformPluginModel();
        }

        protected void setPhysicalTable(PhysicalTable table) {
            this.m_metadataTable = table;
        }

        protected void setParentPanel(WAPanel panel) {
            this.m_parentPanel = panel;
        }

        protected void setMetadata(CMetadata metadata) {
            this.m_metadata = metadata;
        }

        @Override
        public void setEditable(boolean bEditable) {
            super.setEditable(bEditable);
        }

        @Override
        public boolean validateData() {
            return true;
        }

        @Override
        public void populateStore() {
        }

        @Override
        public void moveDataToView() throws MdException, RemoteException {
            this.m_tableModel.moveDataToModel();
            if (this.m_metadataTable == null) {
                return;
            }
            AssociationList columnsList = this.m_metadataTable.getColumns();
            this.m_columns.clear();
            for (int i = 0; i < columnsList.size(); ++i) {
                Column col = (Column)columnsList.get(i);
                String colName = col.getSASColumnName();
                this.m_columns.addElement(colName);
            }
            this.fillListBox();
            this.enableButtons();
            this.setDataChanged(false);
        }

        @Override
        public void moveDataToStore() throws MdException, RemoteException {
            boolean change = false;
            if (!(this.m_metadata instanceof Property)) {
                return;
            }
            Transformation transform = (Transformation)((Property)this.m_metadata).getSpecTargetTransformations().elementAt(0);
            AssociationList byColumns = transform.getSourceSpecifications();
            if (byColumns.size() != this.m_tableModel.getRowCount()) {
                change = true;
            } else {
                for (int i = 0; i < this.m_tableModel.getRowCount(); ++i) {
                    int index = this.m_table.convertRowIndexToModel(i);
                    String dm_colName = (String)this.m_tableModel.getValueAt(index, 0);
                    Column col = (Column)byColumns.get(i);
                    String cl_colName = col.getSASColumnName();
                    if (cl_colName.compareTo(dm_colName) == 0) continue;
                    change = true;
                    break;
                }
            }
            if (this.m_metadataTable == null) {
                return;
            }
            AssociationList allColumns = this.m_metadataTable.getColumns();
            if (change) {
                byColumns.removeAllElements();
                block1: for (int i = 0; i < this.m_tableModel.getRowCount(); ++i) {
                    int index = this.m_table.convertRowIndexToModel(i);
                    String dm_colName = (String)this.m_tableModel.getValueAt(index, 0);
                    for (int j = 0; j < allColumns.size(); ++j) {
                        Column col = (Column)allColumns.get(j);
                        String cl_colName = col.getSASColumnName();
                        if (!cl_colName.equals(dm_colName)) continue;
                        byColumns.add((Object)col);
                        continue block1;
                    }
                }
            }
            if (change) {
                this.setDataChanged(true);
            }
        }

        @Override
        public void updateWorkspaceUIComponents(boolean bActive) {
            super.updateWorkspaceUIComponents(bActive);
        }

        public void saveSettingsAndCleanUp() {
        }

        public Component getDefaultFocusComponent() {
            return this.m_list;
        }

        public void setDataChanged(boolean fChanged) {
            this.m_parentPanel.setDataChanged(fChanged);
        }

        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            if (!bSaveToModel) {
                this.moveDataToView();
                return true;
            }
            this.moveDataToStore();
            return true;
        }

        public class TransformPluginModel
        extends SASSortByPropertyTab.SASSortByModel {
            public static final int NAME_COLUMN = 0;
            protected static final int NAME_COLUMN_WIDTH = 225;

            public TransformPluginModel() {
                this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
                this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("Transform.column.name.txt"), 225);
            }

            @Override
            public void moveDataToModel() throws MdException, RemoteException {
                this.clear();
                Property property = (Property)TransformPanel.this.m_metadata;
                if (property.getSpecTargetTransformations().size() > 0) {
                    Transformation transformation = (Transformation)property.getSpecTargetTransformations().elementAt(0);
                    AssociationList byColumnsList = transformation.getSourceSpecifications();
                    for (int i = 0; i < byColumnsList.size(); ++i) {
                        Column col = (Column)byColumnsList.get(i);
                        String colName = col.getSASColumnName();
                        this.insertRow(colName, null);
                    }
                }
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public boolean insertRow(String colName, String sortOrder) {
                ArrayList<String> m = new ArrayList<String>();
                m.add(colName);
                super.insertRow(this.getRowCount() - 1, m);
                TransformPanel.this.setDataChanged(true);
                return true;
            }
        }
    }

    protected class cComboListener
    implements ActionListener {
        protected cComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TransformListOptionsPropertyTab.this.m_cmpTransformPanel.moveDataToStore();
                Property property = (Property)TransformListOptionsPropertyTab.this.m_cmbShowColumns.getSelectedItem();
                TransformListOptionsPropertyTab.this.m_cmpTransformPanel.setMetadata((CMetadata)property);
                String type = property.getPropertyRole();
                if (type.indexOf("INPUT") > -1) {
                    TransformListOptionsPropertyTab.this.m_cmpTransformPanel.setPhysicalTable(TransformListOptionsPropertyTab.this.m_inputTable);
                } else {
                    TransformListOptionsPropertyTab.this.m_cmpTransformPanel.setPhysicalTable(TransformListOptionsPropertyTab.this.m_outputTable);
                }
                TransformListOptionsPropertyTab.this.m_cmpTransformPanel.moveDataToView();
                String desc = property.getDesc();
                if (desc.trim().compareTo("") == 0) {
                    desc = bundle.getString("TransformListOptionsPropertyTab.nameTooltip.txt");
                }
                TransformListOptionsPropertyTab.this.m_cmbShowColumns.setToolTipText(desc);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }
}

