/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MiningResult;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.swing.visuals.dualselector.TreeListSelector;
import com.sas.wadmin.pfd.PFDDnDAdapter;
import com.sas.wadmin.pfd.PFDException;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDLink;
import com.sas.wadmin.pfd.WAPFDNodeInterface;
import com.sas.wadmin.pfd.WAPFDTemplateNode;
import com.sas.wadmin.pfd.WAPFDTransformNode;
import com.sas.wadmin.pfd.WAPFDTransformNodeModel;
import com.sas.wadmin.pfd.WAPFDWorkTableNode;
import com.sas.wadmin.visuals.NewObjectWizard;
import com.sas.wadmin.visuals.TargetTableDesigner;
import com.sas.wadmin.visuals.WAPFDEditorOMAView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsViewFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TargetTableColumnsPropertyTab
extends WAPropertyTab {
    private static WAdminResource m_bundle = WAdminResource.getBundle(TargetTableColumnsPropertyTab.class);
    private static final boolean g_bGotoServer = true;
    private CMetadata m_repos = null;
    private String m_reposId = null;
    private String m_OutputTableName = null;
    private List m_lBeginningColumns;
    protected List m_lAllInputs;
    protected List m_lSourceTables;
    protected AssociationList m_lTargetTables;
    protected List m_lOutputTables;
    protected List m_lGeneratedColumns;
    protected List m_lRequiredInputs;
    protected List m_lSelectedList;
    private Vector m_columns;
    protected JButton m_btnCreateTarget;
    protected JPanel m_pnlButtons;
    protected WsAbstractAction m_actCreateTarget;
    protected TreeListSelector m_columnsSelector;
    protected DefaultTreeModel m_oAvailableTreeModel;
    protected DefaultListModel m_oSelectedListModel;
    protected boolean m_bShowButtons;
    protected boolean m_bEditable;
    private final Icon m_PhysicalTableIcon = WAdminResource.getTypeIcon((String)"PhysicalTable", (boolean)true);
    private final Icon m_EnvironmentIcon = m_bundle.getImageIcon("Common.Environment.image");
    private final Icon m_FolderIcon = WorkspaceTree.getClosedFolderIcon();
    private final Icon m_FolderOpenIcon = WorkspaceTree.getOpenedFolderIcon();
    private List m_lChangedColumns;
    protected MdObjectStore m_oStore;
    protected TransformationStep m_oTS;
    protected MiningResult m_oMR;
    protected List m_lTargetColumns;
    protected List m_lNewTargetColumns;
    protected List m_lTargetTableColumns;
    protected AssociationList m_lTargetColumnObjects;
    protected PhysicalTable m_newTargetTable;

    public TargetTableColumnsPropertyTab(TransformationStep oTS) {
        try {
            this.m_oTS = oTS;
            this.m_oStore = (MdObjectStore)this.m_oTS.getObjectStore();
            this.m_repos = Workspace.getWorkspace().getDefaultRepository();
            this.m_reposId = oTS.getRepositoryID();
            this.m_bShowButtons = true;
            this.m_bEditable = true;
            this.initialize();
            this.setHelpProduct("wdb");
            this.setHelpTopic("propagate_model_cols_tab");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void saveSettingsAndCleanUp() {
        if (this.m_newTargetTable != null) {
            this.dropTargetTable();
        }
        if (this.m_columnsSelector != null) {
            this.m_columnsSelector.removeAll();
        }
        this.m_repos = null;
        this.m_reposId = null;
        this.m_columnsSelector = null;
        this.m_oAvailableTreeModel = null;
        this.m_oSelectedListModel = null;
    }

    public void setRepository(CMetadata repos) {
        this.m_repos = repos;
    }

    public void setStore(MdObjectStore store) {
        this.m_oStore = store;
    }

    private void selectTargetTableNodes(JTree sourceTree, DefaultTreeModel treemodel, List lTargetTableColumns) throws RemoteException {
        Object availableRootNode = treemodel.getRoot();
        int numChildren = treemodel.getChildCount(availableRootNode);
        ArrayList<TreePath> SelectedColumns = new ArrayList<TreePath>();
        int nextRow = 0;
        TreePath Path2 = sourceTree.getPathForRow(0);
        for (int i = 0; i <= numChildren; ++i) {
            DefaultMutableTreeNode TreeNode2 = (DefaultMutableTreeNode)Path2.getLastPathComponent();
            CMetadata node = (CMetadata)TreeNode2.getUserObject();
            if (node == null) continue;
            String nodeType = node.getCMetadataType();
            if (nodeType.compareTo("DataTable") == 0 || nodeType.compareTo("RelationalTable") == 0 || nodeType.compareTo("WorkTable") == 0 || nodeType.compareTo("PhysicalTable") == 0) {
                int numNodes = treemodel.getChildCount(TreeNode2);
                for (int iNode = 0; iNode < numNodes; ++iNode) {
                    nextRow = sourceTree.getRowForPath(Path2);
                    Path2 = sourceTree.getPathForRow(nextRow + 1);
                    DefaultMutableTreeNode ColumnTreeNode = (DefaultMutableTreeNode)Path2.getLastPathComponent();
                    String columnName = ((Column)ColumnTreeNode.getUserObject()).getSASColumnName();
                    for (int iTargetColumn = 0; iTargetColumn < lTargetTableColumns.size(); ++iTargetColumn) {
                        String TargetColumnName = (String)lTargetTableColumns.get(iTargetColumn);
                        if (!columnName.equals(TargetColumnName)) continue;
                        SelectedColumns.add(Path2);
                    }
                }
            } else if (nodeType.compareTo("Column") == 0) {
                String columnName = ((Column)node).getSASColumnName();
                for (int iTargetColumn = 0; iTargetColumn < lTargetTableColumns.size(); ++iTargetColumn) {
                    String TargetColumnName = (String)lTargetTableColumns.get(iTargetColumn);
                    if (!columnName.equals(TargetColumnName)) continue;
                    SelectedColumns.add(Path2);
                }
            }
            nextRow = sourceTree.getRowForPath(Path2);
            Path2 = sourceTree.getPathForRow(nextRow + 1);
        }
        TreePath[] TreePathArray = SelectedColumns.toArray(new TreePath[0]);
        sourceTree.setSelectionPaths(TreePathArray);
        this.m_columnsSelector.transferSourceItems();
        sourceTree.setSelectionRow(0);
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        if (this.m_oTS.getFQID().indexOf(36) == -1) {
            String sTemplate = "<Templates>";
            sTemplate = sTemplate + "<ClassifierMap><ClassifierSources/><ClassifierTargets/><SourceSpecifications/><FeatureMaps/></ClassifierMap>";
            sTemplate = sTemplate + "<DataTable><Columns/></DataTable>";
            sTemplate = sTemplate + "<WorkTable><Columns/></WorkTable>";
            sTemplate = sTemplate + "<PhysicalTable><Columns/></PhysicalTable>";
            sTemplate = sTemplate + "<FeatureMap><FeatureSources/><FeatureTargets/><SourceCode/></FeatureMap>";
            sTemplate = sTemplate + "<MiningResult><Extensions/><TransformationSources/><TransformationTargets/><SourceCode/></MiningResult>";
            sTemplate = sTemplate + "</Templates>";
            Vector<String> vComplexAttrs = new Vector<String>();
            vComplexAttrs.add("Transformations");
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_oTS, null, vComplexAttrs, sTemplate, 12);
        }
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_lOutputTables = new ArrayList();
        this.m_lRequiredInputs = new ArrayList();
        this.m_lAllInputs = new ArrayList();
        this.m_lGeneratedColumns = new ArrayList();
        this.m_lTargetColumns = new ArrayList();
        this.m_lTargetTableColumns = new ArrayList();
        this.m_lNewTargetColumns = new ArrayList();
        Extension oModelKeyExtension = null;
        AssociationList alCMs = this.m_oTS.getTransformations();
        int nCMs = alCMs.size();
        for (int iCM = 0; iCM < nCMs; ++iCM) {
            ClassifierMap oCM = (ClassifierMap)alCMs.get(iCM);
            this.m_lSourceTables = oCM.getClassifierSources();
            this.m_lTargetTables = oCM.getClassifierTargets();
            AssociationList alSourceSpecifications = oCM.getSourceSpecifications();
            int nMiningResults = alSourceSpecifications.size();
            for (int iMiningResult = 0; iMiningResult < nMiningResults; ++iMiningResult) {
                Root oRoot = (Root)alSourceSpecifications.get(iMiningResult);
                if (!(oRoot instanceof MiningResult)) continue;
                MiningResult oMiningResult = (MiningResult)oRoot;
                AssociationList alOutputTables = oMiningResult.getTransformationTargets();
                if (!alOutputTables.isEmpty()) {
                    this.m_lOutputTables.add(alOutputTables.get(0));
                    this.m_OutputTableName = ((DataTable)alOutputTables.get(0)).getName();
                }
                AssociationList alExtensions = oMiningResult.getExtensions();
                for (int iExtension = 0; iExtension < alExtensions.size(); ++iExtension) {
                    Extension oExtension = (Extension)alExtensions.get(iExtension);
                    if (!oExtension.getName().equals("Key")) continue;
                    oModelKeyExtension = oExtension;
                }
            }
            int nTargetTables = this.m_lTargetTables.size();
            for (int iTargetTable = 0; iTargetTable < nTargetTables; ++iTargetTable) {
                DataTable oTargetTable = (DataTable)this.m_lTargetTables.get(iTargetTable);
                this.m_lTargetColumnObjects = oTargetTable.getColumns();
                int nTargetColumns = this.m_lTargetColumnObjects.size();
                for (int iTargetColumn = 0; iTargetColumn < nTargetColumns; ++iTargetColumn) {
                    Column oTargetColumn = (Column)this.m_lTargetColumnObjects.get(iTargetColumn);
                    this.m_lTargetColumns.add(oTargetColumn.getSASColumnName());
                    this.m_lBeginningColumns.add(oTargetColumn.getSASColumnName());
                }
            }
        }
        this.m_lGeneratedColumns = this.createGeneratedColumnsList(oModelKeyExtension, this.m_oStore);
        this.m_oAvailableTreeModel.setRoot(new DefaultMutableTreeNode(this.m_repos));
        DefaultMutableTreeNode oRootTreeNode = (DefaultMutableTreeNode)this.m_oAvailableTreeModel.getRoot();
        oRootTreeNode.setAllowsChildren(true);
        TreeSet sortedList = new TreeSet(new cDataTableComparator());
        sortedList.addAll(this.m_lSourceTables);
        if (this.m_lOutputTables.size() > 0) {
            sortedList.addAll(this.m_lOutputTables);
        }
        for (DataTable oDataTable : sortedList) {
            DefaultMutableTreeNode oTableTreeNode = new DefaultMutableTreeNode(oDataTable);
            oTableTreeNode.setAllowsChildren(true);
            this.m_oAvailableTreeModel.insertNodeInto(oTableTreeNode, oRootTreeNode, oRootTreeNode.getChildCount());
        }
        for (int iColumn = 0; iColumn < this.m_lGeneratedColumns.size(); ++iColumn) {
            Column oGeneratedColumn = (Column)this.m_lGeneratedColumns.get(iColumn);
            DefaultMutableTreeNode oColumnTreeNode = new DefaultMutableTreeNode(oGeneratedColumn);
            oColumnTreeNode.setAllowsChildren(false);
            this.m_oAvailableTreeModel.insertNodeInto(oColumnTreeNode, oRootTreeNode, oRootTreeNode.getChildCount());
        }
        this.m_oAvailableTreeModel.reload();
        JTree sourcetree = (JTree)this.m_columnsSelector.getSourceComponent();
        this.expandAvailableNodes(sourcetree, this.m_oAvailableTreeModel);
        if (!this.m_lTargetColumns.isEmpty()) {
            this.selectTargetTableNodes(sourcetree, this.m_oAvailableTreeModel, this.m_lTargetColumns);
        } else {
            JList targetList = (JList)this.m_columnsSelector.getTargetComponent();
            int lastIndex = targetList.getLastVisibleIndex();
            if (lastIndex != -1) {
                int[] indexArray = new int[lastIndex];
                for (int k = 0; k < lastIndex; ++k) {
                    indexArray[k] = k;
                }
                targetList.setSelectedIndices(indexArray);
                this.m_columnsSelector.transferAllTargetItems();
            }
        }
        for (int iTempColumn = 0; iTempColumn < this.m_lGeneratedColumns.size(); ++iTempColumn) {
            Column otempColumn = (Column)this.m_lGeneratedColumns.get(iTempColumn);
            this.m_oStore.removeObjectFromStore((CMetadata)otempColumn, "<Column/>");
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        this.m_columns = new Vector(0);
        for (int i = 0; i < this.m_oSelectedListModel.getSize(); ++i) {
            TreePath path = (TreePath)this.m_oSelectedListModel.elementAt(i);
            Column existingColumn = (Column)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            Column newColumn = (Column)Workspace.getMdFactory().createComplexMetadataObject(this.m_oStore, null, existingColumn.getName(), "Column", this.m_reposId, null);
            newColumn.setPublicType("Column");
            newColumn.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
            newColumn.setColumnName(existingColumn.getColumnName());
            newColumn.setColumnLength(existingColumn.getColumnLength());
            newColumn.setColumnType(existingColumn.getColumnType());
            newColumn.setSASColumnName(existingColumn.getSASColumnName());
            newColumn.setSASColumnLength(existingColumn.getSASColumnLength());
            newColumn.setSASColumnType(existingColumn.getSASColumnType());
            newColumn.setIsDiscrete(existingColumn.getIsDiscrete());
            newColumn.setIsNullable(existingColumn.getIsNullable());
            newColumn.setSASFormat(existingColumn.getSASFormat());
            newColumn.setSASInformat(existingColumn.getSASInformat());
            newColumn.setSortOrder(existingColumn.getSortOrder());
            newColumn.setSummaryRole(existingColumn.getSummaryRole());
            newColumn.setDesc(existingColumn.getDesc());
            this.m_columns.add(newColumn);
        }
        int nDataTables = this.m_lTargetTables.size();
        AssociationList[] aColumnsAssociationLists = new AssociationList[nDataTables];
        ArrayList lOldColumns = new ArrayList();
        for (int iDataTable = 0; iDataTable < nDataTables; ++iDataTable) {
            DataTable oDataTable = (DataTable)this.m_lTargetTables.get(iDataTable);
            aColumnsAssociationLists[iDataTable] = oDataTable.getColumns(false);
            lOldColumns.addAll(aColumnsAssociationLists[iDataTable]);
            aColumnsAssociationLists[iDataTable].removeAllElements();
            int nColumns = this.m_columns.size();
            for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                Column oColumn = (Column)this.m_columns.get(iColumn);
                aColumnsAssociationLists[iDataTable].add((Object)oColumn);
                if (!lOldColumns.contains(oColumn)) continue;
                lOldColumns.remove(oColumn);
            }
        }
        int nColumns = lOldColumns.size();
        for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
            Column oColumn = (Column)lOldColumns.get(iColumn);
            this.m_oStore.removeObjectFromStore((CMetadata)oColumn, "<Column><SourceFeatureMaps/><TargetFeatureMaps/><PropertySets><SetProperties/><Properties/></PropertySets></Column>");
        }
        this.m_oStore.flushUpdatesToParentStore();
    }

    public FeatureMap findFeatureMapForColumn(AssociationList alFMs, Column oColumn) throws MdException, RemoteException {
        int nFMs = alFMs.size();
        for (int iFM = 0; iFM < nFMs; ++iFM) {
            AssociationList alFeatureTargets;
            FeatureMap oFM = (FeatureMap)alFMs.get(iFM);
            if (oFM.getIsUserDefined() != 0 || !(alFeatureTargets = oFM.getFeatureTargets()).contains((Object)oColumn)) continue;
            return oFM;
        }
        return null;
    }

    private void expandAvailableNodes(JTree sourceTree, DefaultTreeModel treeModel) {
        int numChildren;
        Object availableRootNode = treeModel.getRoot();
        for (int iChild = numChildren = treeModel.getChildCount(availableRootNode); iChild >= 0; --iChild) {
            sourceTree.expandRow(iChild);
        }
    }

    public Vector getColumns() {
        return this.m_columns;
    }

    protected List createGeneratedColumnsList(Extension oModelKeyExtension, MdObjectStore store) throws MdException, RemoteException {
        MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
        Column oDate = (Column)factory.createComplexMetadataObject(store, "Date", "Column", this.m_oTS.getRepositoryID());
        oDate.setPublicType("Column");
        oDate.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
        oDate.setSASColumnLength(8);
        oDate.setName("Date");
        oDate.setDesc("Generated Date Column");
        oDate.setSASColumnName("Date");
        oDate.setSASColumnType(WsColumnMetadataUtil.getDataNumericType());
        oDate.setSASFormat("MMDDYY10.");
        Column oDateTime = (Column)factory.createComplexMetadataObject(store, "DateTime", "Column", this.m_oTS.getRepositoryID());
        oDateTime.setPublicType("Column");
        oDateTime.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
        oDateTime.setSASColumnLength(8);
        oDateTime.setName("DateTime");
        oDateTime.setDesc("Generated DateTime Column");
        oDateTime.setSASColumnName("DateTime");
        oDateTime.setSASColumnType(WsColumnMetadataUtil.getDataNumericType());
        oDateTime.setSASFormat("DATETIME20.");
        Column oModelKey = (Column)factory.createComplexMetadataObject(store, "ModelKey", "Column", this.m_oTS.getRepositoryID());
        oModelKey.setPublicType("Column");
        oModelKey.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
        oModelKey.setSASColumnLength(32);
        oModelKey.setName("ModelKey");
        oModelKey.setDesc("Generated ModelKey Column");
        oModelKey.setSASColumnName("ModelKey");
        oModelKey.setSASColumnType(WsColumnMetadataUtil.getDataCharacterType());
        oModelKey.setSASFormat("$32.");
        if (oModelKeyExtension != null) {
            oModelKey.getExtensions().add((Object)oModelKeyExtension);
        }
        ArrayList<Column> lColumnsGenerated = new ArrayList<Column>();
        lColumnsGenerated.add(oDate);
        lColumnsGenerated.add(oDateTime);
        lColumnsGenerated.add(oModelKey);
        return lColumnsGenerated;
    }

    public static String getDataTableDisplayName(DataTable oDataTable) {
        try {
            if (oDataTable instanceof PhysicalTable) {
                return ((PhysicalTable)oDataTable).getSASTableName();
            }
            return oDataTable.getName();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public boolean validateData() {
        return true;
    }

    public void onParentOK() {
        this.propagateSelectedColumns();
    }

    public void onParentApply() {
        this.propagateSelectedColumns();
    }

    public void propagateSelectedColumns() {
        try {
            for (int i = 0; i < this.m_oSelectedListModel.getSize(); ++i) {
                TreePath path = (TreePath)this.m_oSelectedListModel.elementAt(i);
                Column existingColumn = (Column)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                this.m_lChangedColumns.add(existingColumn.getSASColumnName());
            }
            for (int j = 0; j < this.m_lBeginningColumns.size(); ++j) {
                String oString = (String)this.m_lBeginningColumns.get(j);
                if (!this.m_lChangedColumns.contains(oString)) continue;
                this.m_lChangedColumns.remove(oString);
            }
            if (this.m_newTargetTable == null && !this.m_lChangedColumns.isEmpty()) {
                this.propagateMappingsforTargetTable();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected void initialize() {
        this.createActions();
        this.m_lSelectedList = new ArrayList();
        this.m_columnsSelector = new cTreeListSelector();
        this.m_oAvailableTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.m_oAvailableTreeModel.setAsksAllowsChildren(true);
        this.m_oSelectedListModel = new DefaultListModel();
        this.m_lBeginningColumns = new ArrayList();
        this.m_lChangedColumns = new ArrayList();
        this.m_columnsSelector.setModel((TreeModel)this.m_oAvailableTreeModel);
        this.m_columnsSelector.setSourceLabel(m_bundle.getString("TargetTableColumnsPropertyTab.AvailableColumns.txt"));
        ((JLabel)this.m_columnsSelector.getSourceLabelComponent()).setDisplayedMnemonic(m_bundle.getString("TargetTableColumnsPropertyTab.AvailableColumns.mnem").charAt(0));
        this.m_columnsSelector.setSourceCellRenderer((TreeCellRenderer)new SourceTreeCellRenderer());
        this.m_columnsSelector.setTargetModel((ListModel)this.m_oSelectedListModel);
        this.m_columnsSelector.setTargetLabel(m_bundle.getString("TargetTableColumnsPropertyTab.SelectedColumns.txt"));
        ((JLabel)this.m_columnsSelector.getTargetLabelComponent()).setDisplayedMnemonic(m_bundle.getString("TargetTableColumnsPropertyTab.SelectedColumns.mnem").charAt(0));
        this.m_columnsSelector.setTargetCellRenderer((ListCellRenderer)new TargetListCellRenderer());
        this.m_columnsSelector.setTransferAllControlsVisible(false);
        this.m_columnsSelector.setDragAndDropEnabled(false);
        this.m_columnsSelector.setTargetControlsVisible(true);
        this.m_columnsSelector.setCopyModeEnabled(true);
        this.m_columnsSelector.setCopyModeDuplicatesAllowed(false);
        this.m_columnsSelector.setParentNodesMoveable(false);
        JTree srcTree = (JTree)this.m_columnsSelector.getSourceComponent();
        srcTree.addTreeExpansionListener(new cExpansionListener());
        srcTree.addTreeSelectionListener(new cSelectionListener());
        this.createButtonsPanel();
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)this.m_columnsSelector, "Center");
        if (this.m_bShowButtons) {
            this.add(this.m_pnlButtons, "South");
        }
    }

    protected void createButtonsPanel() {
        this.m_btnCreateTarget = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actCreateTarget);
        JPanel pnlRight = new JPanel((LayoutManager)new WsButtonsLayout());
        pnlRight.add(this.m_btnCreateTarget);
        this.m_pnlButtons = new JPanel(new BorderLayout(10, 0));
        this.m_pnlButtons.add((Component)pnlRight, "East");
    }

    public void createTargetTable() throws MdException, RemoteException {
        this.m_lTargetTableColumns.clear();
        for (int i = 0; i < this.m_oSelectedListModel.getSize(); ++i) {
            TreePath path = (TreePath)this.m_oSelectedListModel.elementAt(i);
            Column existingColumn = (Column)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            this.m_lTargetTableColumns.add(existingColumn);
        }
        this.promptAndShowTargetDesigner(this.m_oStore, this.m_lTargetTableColumns);
    }

    protected void createColumnforStore(Column existingColumn, MdObjectStore store) throws MdException, RemoteException {
        Column newColumn = (Column)Workspace.getMdFactory().createComplexMetadataObject(store, null, existingColumn.getName(), "Column", this.m_oTS.getRepositoryID(), null);
        newColumn.setPublicType("Column");
        newColumn.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
        newColumn.setColumnName(existingColumn.getColumnName());
        newColumn.setColumnLength(existingColumn.getColumnLength());
        newColumn.setColumnType(existingColumn.getColumnType());
        newColumn.setSASColumnName(existingColumn.getSASColumnName());
        newColumn.setSASColumnLength(existingColumn.getSASColumnLength());
        newColumn.setSASColumnType(existingColumn.getSASColumnType());
        newColumn.setIsDiscrete(existingColumn.getIsDiscrete());
        newColumn.setIsNullable(existingColumn.getIsNullable());
        newColumn.setSASFormat(existingColumn.getSASFormat());
        newColumn.setSASInformat(existingColumn.getSASInformat());
        newColumn.setSortOrder(existingColumn.getSortOrder());
        newColumn.setSummaryRole(existingColumn.getSummaryRole());
        newColumn.setDesc(existingColumn.getDesc());
        this.m_lNewTargetColumns.add(newColumn);
    }

    private static Job getJobFor(TransformationStep oTS) throws MdException, RemoteException {
        TransformationActivity oTA;
        AssociationList lJobs;
        AssociationList lTAs = oTS.getActivities();
        if (lTAs.size() > 0 && (lJobs = (oTA = (TransformationActivity)lTAs.get(0)).getJobs()).size() > 0) {
            return (Job)lJobs.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropTargetTable() {
        block16: {
            try {
                AssociationList oPredecessor = this.m_oTS.getPredecessorDependencies(false);
                if (oPredecessor.size() > 0) {
                    if (!this.m_lChangedColumns.isEmpty()) {
                        this.propagateMappingsforTargetTable();
                    }
                    return;
                }
                Job oJob = TargetTableColumnsPropertyTab.getJobFor(this.m_oTS);
                WAPFDEditorOMAView m_omaView = (WAPFDEditorOMAView)WsViewFactory.findExistingView((CMetadata)oJob, (String)WAPFDEditorOMAView.class.getName());
                boolean bSuccessful = false;
                ArrayList tempList = new ArrayList();
                if (m_omaView == null) break block16;
                PFDPanel m_parentPanel = m_omaView.getPFDPanel();
                WAPFDTransformNodeModel nodeModel = (WAPFDTransformNodeModel)m_parentPanel.getNodeModel(this.m_oTS.getFQID());
                WAPFDTransformNode node = (WAPFDTransformNode)nodeModel.getViewNode();
                WAPFDLink link = (WAPFDLink)node.getOutputLinks().get(0);
                WAPFDTemplateNode templateNode = null;
                WAPFDNodeInterface tonode = link.getWAToNode();
                if (tonode instanceof WAPFDTemplateNode) {
                    templateNode = (WAPFDTemplateNode)tonode;
                } else if (tonode instanceof WAPFDWorkTableNode) {
                    link = (WAPFDLink)tonode.getOutputLinks().get(0);
                    WAPFDNodeInterface tonode2 = link.getWAToNode();
                    if (tonode2 instanceof WAPFDTemplateNode) {
                        templateNode = (WAPFDTemplateNode)tonode2;
                    }
                } else if (tonode.getWAPFDNodeModel().getMetadataObject().getCMetadataType().equalsIgnoreCase("PhysicalTable")) {
                    return;
                }
                PFDDnDAdapter dropAdapter = m_parentPanel.getDNDAdapter();
                try {
                    bSuccessful = dropAdapter.dropHelper((PFDPrimitive)templateNode, this.m_newTargetTable, tempList);
                }
                catch (PFDException ex) {
                    PFDPanel.displayPFDErrorMessage(ex.getMessage());
                }
                finally {
                    dropAdapter.dropComplete(bSuccessful, tempList);
                }
            }
            catch (MdException ex2) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex2, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    protected void propagateMappingsforTargetTable() {
        try {
            AssociationList oPredecessor = this.m_oTS.getPredecessorDependencies(false);
            if (oPredecessor.isEmpty() || this.m_oSelectedListModel.isEmpty()) {
                return;
            }
            Job m_object = TargetTableColumnsPropertyTab.getJobFor(this.m_oTS);
            WAPFDEditorOMAView m_omaView = (WAPFDEditorOMAView)WsViewFactory.findExistingView((CMetadata)m_object, (String)WAPFDEditorOMAView.class.getName());
            if (m_omaView != null) {
                PFDPanel m_parentPanel = m_omaView.getPFDPanel();
                int val = MessageUtil.displayMessage((String)m_bundle.getString("MiningResultsPropagateMessage.txt"), (int)2, (int)0);
                if (val == 0) {
                    m_parentPanel.setDataChanged(true);
                    m_parentPanel.mapAllOutputs();
                    MessageUtil.displayMessage((String)m_bundle.getString("MiningResultsPropagateMessage.Complete.txt"), (int)1);
                }
            }
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected void promptAndShowTargetDesigner(MdObjectStore store, List lColumns) throws MdException, RemoteException {
        MdObjectStore storeTargetChild = Workspace.getMdFactory().createObjectStore();
        storeTargetChild.setIsGotToServerForMetadata(true);
        int nColumns = lColumns.size();
        this.m_lNewTargetColumns.clear();
        for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
            Column oColumn = (Column)lColumns.get(iColumn);
            this.createColumnforStore(oColumn, storeTargetChild);
        }
        TargetTableDesigner plugin = new TargetTableDesigner(this.m_lNewTargetColumns, storeTargetChild);
        NewObjectWizard dialog = new NewObjectWizard((Frame)Workspace.getWorkspace(), "", plugin, "");
        dialog.show();
        CMetadata onewTable = (CMetadata)dialog.getWizardData("NEWSIMPLETABLE");
        if (onewTable != null) {
            store.setIsGotToServerForMetadata(true);
            this.m_newTargetTable = (PhysicalTable)Workspace.getMdFactory().createComplexMetadataObject(store, onewTable);
            String sTemplate = "<TEMPLATES><PhysicalTable><UniqueKeys/><Properties/><Indexes/><Documents/><Notes/><Roles/><PropertySet/><SourceClassifierMaps/><TargetClassifierMaps/><Groups/><Extensions/><Columns/></PhysicalTable></TEMPLATES>";
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_newTargetTable, null, null, sTemplate, 12);
        }
        storeTargetChild.dispose();
    }

    protected void createActions() {
        this.m_actCreateTarget = this.createCreateTargetAction();
    }

    protected void updateActions() {
        this.m_actCreateTarget.setEnabled(this.m_bEditable);
    }

    protected WsAbstractAction createCreateTargetAction() {
        return new cCreateTargetAction();
    }

    private class cDataTableComparator
    implements Comparator {
        private cDataTableComparator() {
        }

        public int compare(Object o1, Object o2) {
            DataTable one = (DataTable)o1;
            DataTable two = (DataTable)o2;
            try {
                String oneString = one.getName() + one.getId();
                String twoString = two.getName() + two.getId();
                return oneString.compareToIgnoreCase(twoString);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return Integer.MIN_VALUE;
            }
        }
    }

    class cTreeListSelector
    extends TreeListSelector {
        JDialog m_dialog = null;

        cTreeListSelector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void transferItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter) {
            Vector<String> dupNames = new Vector<String>();
            int maxCnt = -1;
            TargetTableColumnsPropertyTab.this.setDataChanged(false);
            if (fromAdapter == this.sourceAdapter) {
                maxCnt = super.getTargetMaximumCount();
            }
            int selectedCount = fromAdapter.getSelectedCount();
            int index = fromAdapter.getLastSelectedIndex();
            List selectedItems1 = selectedCount > 0 ? fromAdapter.getSelectedItems() : null;
            if (selectedItems1 != null) {
                DualSelectorInterface dualSelectorInterface = fromAdapter;
                synchronized (dualSelectorInterface) {
                    DualSelectorInterface dualSelectorInterface2 = toAdapter;
                    synchronized (dualSelectorInterface2) {
                        int count = selectedItems1.size() + toAdapter.getCount();
                        if (maxCnt == -1 || count <= maxCnt) {
                            try {
                                int currentCount;
                                if (!this.copyModeEnabled || this.copyModeEnabled && fromAdapter == this.targetAdapter) {
                                    fromAdapter.removeItems(selectedItems1);
                                }
                                if (!this.copyModeDuplicatesAllowed) {
                                    for (int j = 0; j < selectedItems1.size(); ++j) {
                                        DefaultMutableTreeNode selected_treeNode = (DefaultMutableTreeNode)((TreePath)selectedItems1.get(j)).getLastPathComponent();
                                        if (selected_treeNode.getUserObject() instanceof Column) {
                                            Column selected_column = (Column)selected_treeNode.getUserObject();
                                            String selected_SASColumnName = selected_column.getSASColumnName();
                                            if (!this._DupFoundInSelectedItems(selectedItems1, selected_SASColumnName, j)) continue;
                                            selectedItems1.remove(j--);
                                            continue;
                                        }
                                        selectedItems1.remove(j--);
                                    }
                                    List toItems = toAdapter.getAllItems();
                                    int toItemsSize = toItems.size();
                                    int size = selectedItems1.size();
                                    block9: for (int j = size - 1; j >= 0; --j) {
                                        DefaultMutableTreeNode selected_treeNode = (DefaultMutableTreeNode)((TreePath)selectedItems1.get(j)).getLastPathComponent();
                                        Column selected_column = (Column)selected_treeNode.getUserObject();
                                        String selected_SASColumnName = selected_column.getSASColumnName();
                                        for (int i = 0; i <= toItemsSize - 1; ++i) {
                                            Column toItems_column;
                                            String toItems_SASColumnName;
                                            DefaultMutableTreeNode toItems_treeNode;
                                            if (selectedItems1.get(j).equals(toItems.get(i))) {
                                                selectedItems1.remove(j);
                                                continue block9;
                                            }
                                            if (!(toAdapter.getComponent() instanceof JList) || !((toItems_treeNode = (DefaultMutableTreeNode)((TreePath)toItems.get(i)).getLastPathComponent()).getUserObject() instanceof Column) || !selected_SASColumnName.equalsIgnoreCase(toItems_SASColumnName = (toItems_column = (Column)toItems_treeNode.getUserObject()).getSASColumnName())) continue;
                                            dupNames.addElement(selected_SASColumnName);
                                            selectedItems1.remove(j);
                                            continue block9;
                                        }
                                    }
                                }
                                if (selectedItems1.size() > 0 && (this.copyModeEnabled && fromAdapter == this.sourceAdapter || !this.copyModeEnabled)) {
                                    toAdapter.addItems(selectedItems1);
                                }
                                if (TargetTableColumnsPropertyTab.this.isListeningForChanges()) {
                                    TargetTableColumnsPropertyTab.this.setDataChanged(true);
                                }
                                if (!this.copyModeEnabled) {
                                    index = index - selectedCount + 1;
                                }
                                if (index >= (currentCount = fromAdapter.getCount())) {
                                    index = currentCount - 1;
                                }
                                fromAdapter.setSelectedIndex(index);
                            }
                            catch (RemoteException ex) {
                                Workspace.handleRemoteException((RemoteException)ex);
                            }
                        }
                    }
                }
                fromAdapter.setSelectedIndex(0);
            }
        }

        private boolean _DupFoundInSelectedItems(List selectedItems1, String newName, int row) throws RemoteException {
            if (newName.trim().length() == 0) {
                return false;
            }
            for (int i = row; i < selectedItems1.size(); ++i) {
                Column curr_column;
                String curr_SASColumnName;
                DefaultMutableTreeNode curr_treeNode = (DefaultMutableTreeNode)((TreePath)selectedItems1.get(i)).getLastPathComponent();
                if (!(curr_treeNode.getUserObject() instanceof Column) || (curr_SASColumnName = (curr_column = (Column)curr_treeNode.getUserObject()).getSASColumnName()).compareToIgnoreCase(newName) != 0 || i == row) continue;
                return true;
            }
            return false;
        }
    }

    public class SourceTreeCellRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected1, boolean expanded, boolean leaf, int row, boolean hasFocus1) {
            JLabel label = new JLabel();
            if (value instanceof DefaultMutableTreeNode) {
                try {
                    DefaultMutableTreeNode treenode = (DefaultMutableTreeNode)value;
                    CMetadata node = (CMetadata)treenode.getUserObject();
                    if (node != null) {
                        String nodeType = node.getCMetadataType();
                        if (nodeType.equals("Column")) {
                            label.setText(((Column)node).getSASColumnName());
                            label.setIcon(WsColumnMetadataUtil.getColumnTypeIcon((Column)((Column)node)));
                        } else if (nodeType.equals("DataTable") || nodeType.equals("WorkTable") || nodeType.equals("PhysicalTable") || nodeType.equals("RelationalTable")) {
                            if (node.getName().equals(TargetTableColumnsPropertyTab.this.m_OutputTableName)) {
                                label.setText(m_bundle.getString("TargetTableColumnsPropertyTab.ModelOutputResults.txt"));
                                label.setIcon(TargetTableColumnsPropertyTab.this.m_PhysicalTableIcon);
                            } else {
                                label.setText(m_bundle.getString("TargetTableColumnsPropertyTab.SourceTable.txt") + node.getName());
                                label.setIcon(TargetTableColumnsPropertyTab.this.m_PhysicalTableIcon);
                            }
                        } else {
                            label.setText(m_bundle.getString("TargetTableColumnsPropertyTab.Tables.txt"));
                            label.setIcon(TargetTableColumnsPropertyTab.this.m_EnvironmentIcon);
                        }
                    } else {
                        label.setText(treenode.toString());
                        label.setIcon(TargetTableColumnsPropertyTab.this.m_FolderIcon);
                    }
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
            label.setOpaque(true);
            this.setOpenIcon(TargetTableColumnsPropertyTab.this.m_FolderOpenIcon);
            if (selected1) {
                label.setBackground(SystemColor.textHighlight);
                label.setForeground(SystemColor.textHighlightText);
            } else {
                label.setBackground(SystemColor.window);
                label.setForeground(SystemColor.textText);
            }
            return label;
        }
    }

    public class TargetListCellRenderer
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = new JLabel();
            if (value instanceof TreePath) {
                TreePath path = (TreePath)value;
                Column node = (Column)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                try {
                    label.setText(node.getName());
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
                label.setIcon(WsColumnMetadataUtil.getColumnTypeIcon((Column)node));
            }
            label.setOpaque(true);
            if (isSelected) {
                label.setBackground(SystemColor.textHighlight);
                label.setForeground(SystemColor.textHighlightText);
            } else {
                label.setBackground(SystemColor.window);
                label.setForeground(SystemColor.textText);
            }
            return label;
        }
    }

    public class cExpansionListener
    implements TreeExpansionListener {
        @Override
        public void treeExpanded(TreeExpansionEvent tee) {
            DefaultMutableTreeNode treenode = (DefaultMutableTreeNode)tee.getPath().getLastPathComponent();
            CMetadata PhyTableNode = (CMetadata)treenode.getUserObject();
            if (PhyTableNode != null && PhyTableNode instanceof DataTable && treenode.getChildCount() <= 0) {
                String str1 = m_bundle.getString("TargetTableColumnsPropertyTab.BuildColumnInfoProgressIndicator.Message.txt");
                String str2 = m_bundle.getString("TargetTableColumnsPropertyTab.BuildColumnInfoProgressIndicator.Title.txt");
                String str3 = m_bundle.getString("TargetTableColumnsPropertyTab.BuildColumnInfoProgressIndicator.Description.txt");
                OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2, str3);
                request.setDelayBeforeProgressCancelDialog(200);
                request.execute((Runnable)new cRunnable(PhyTableNode, treenode));
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent tee) {
        }
    }

    public class cSelectionListener
    implements TreeSelectionListener {
        boolean m_ResetSelection = false;

        @Override
        public void valueChanged(TreeSelectionEvent tse) {
            DefaultMutableTreeNode nodePath = (DefaultMutableTreeNode)tse.getPath().getLastPathComponent();
            CMetadata node = (CMetadata)nodePath.getUserObject();
            if (node != null) {
                try {
                    if (node.getCMetadataType().compareTo("Environment") == 0) {
                        if (!this.m_ResetSelection) {
                            JTree tree = (JTree)tse.getSource();
                            TreePath npath = tse.getPath();
                            TreePath[] spaths = tree.getSelectionPaths();
                            int scount = spaths.length;
                            int tcount = 0;
                            TreePath[] tpaths = new TreePath[scount];
                            for (int i = 0; i < scount; ++i) {
                                boolean found = false;
                                if (npath.equals(spaths[i])) {
                                    found = true;
                                }
                                if (found) continue;
                                tpaths[tcount++] = spaths[i];
                            }
                            this.m_ResetSelection = true;
                            tree.setSelectionPaths(tpaths);
                            this.m_ResetSelection = false;
                        }
                    } else if (node.getCMetadataType().compareTo("DataTable") == 0) {
                        if (nodePath.getChildCount() <= 0) {
                            String str1 = m_bundle.getString("TargetTableColumnsPropertyTab.BuildColumnInfoProgressIndicator.Message.txt");
                            String str2 = m_bundle.getString("TargetTableColumnsPropertyTab.BuildColumnInfoProgressIndicator.Title.txt");
                            String str3 = m_bundle.getString("TargetTableColumnsPropertyTab.BuildColumnInfoProgressIndicator.Description.txt");
                            OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2, str3);
                            request.setDelayBeforeProgressCancelDialog(200);
                            request.execute((Runnable)new cRunnable(node, nodePath));
                        } else if (tse.getPaths().length > 1) {
                            this._removeTableNode(tse);
                        }
                    } else if (!this.m_ResetSelection) {
                        this._removeTableNode(tse);
                    }
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
        }

        private void _removeTableNode(TreeSelectionEvent tse) throws RemoteException {
            TreePath[] tpaths = tse.getPaths();
            int tcount = tpaths.length;
            TreePath[] npaths = new TreePath[tcount];
            int ncount = 0;
            boolean NotJustTables = false;
            for (int i = 0; i < tcount; ++i) {
                CMetadata tnode = (CMetadata)((DefaultMutableTreeNode)tpaths[i].getLastPathComponent()).getUserObject();
                if (tnode.getCMetadataType().compareTo("DataTable") == 0 || tnode.getCMetadataType().compareTo("Environment") == 0) {
                    npaths[ncount++] = tpaths[i];
                    continue;
                }
                NotJustTables = true;
            }
            if (ncount > 0 && NotJustTables) {
                JTree tree = (JTree)tse.getSource();
                TreePath[] spaths = tree.getSelectionPaths();
                int scount = spaths.length;
                tcount = 0;
                tpaths = new TreePath[scount];
                for (int i = 0; i < scount; ++i) {
                    boolean found = false;
                    for (int j = 0; j < ncount; ++j) {
                        if (!npaths[j].equals(spaths[i])) continue;
                        found = true;
                    }
                    if (found) continue;
                    tpaths[tcount++] = spaths[i];
                }
                this.m_ResetSelection = true;
                tree.setSelectionPaths(tpaths);
                this.m_ResetSelection = false;
            }
        }
    }

    protected class cCreateTargetAction
    extends WsAbstractAction {
        public cCreateTargetAction() {
            super(m_bundle, "TargetTableColumnsPropertyTab.CreateTargetAction");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                TargetTableColumnsPropertyTab.this.createTargetTable();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    protected class cRunnable
    implements Runnable {
        CMetadata m_DataTable;
        DefaultMutableTreeNode m_treeNode;

        cRunnable(CMetadata PhyTableNode, DefaultMutableTreeNode treenode) {
            this.m_DataTable = PhyTableNode;
            this.m_treeNode = treenode;
        }

        @Override
        public void run() {
            AssociationList vTableColumns = new Vector();
            Vector<String> vComplex = new Vector<String>();
            vComplex.add("Columns");
            vComplex.add("Indexes");
            try {
                TargetTableColumnsPropertyTab.this.m_columnsSelector.setCursor(Cursor.getPredefinedCursor(3));
                vTableColumns = ((DataTable)this.m_DataTable).getColumns();
                if (vTableColumns.size() > 0) {
                    for (int k = 0; k < vTableColumns.size(); ++k) {
                        CMetadata metadata = (CMetadata)vTableColumns.get(k);
                        DefaultMutableTreeNode oColumnTreeNode = new DefaultMutableTreeNode(metadata);
                        TargetTableColumnsPropertyTab.this.m_oAvailableTreeModel.insertNodeInto(oColumnTreeNode, this.m_treeNode, this.m_treeNode.getChildCount());
                        oColumnTreeNode.setAllowsChildren(false);
                    }
                }
                TargetTableColumnsPropertyTab.this.m_oAvailableTreeModel.reload(this.m_treeNode);
                TargetTableColumnsPropertyTab.this.m_columnsSelector.setCursor(Cursor.getDefaultCursor());
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }
}

