/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TablePanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(TablePanel.class);
    protected boolean m_fBorder = false;
    DefaultListModel m_listModel;
    JList m_list;
    Object[] m_tableList;
    JButton m_jbSelectNone;

    public TablePanel(boolean fBorder) {
        this.m_fBorder = fBorder;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean validateData() {
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        if (saveToModel) {
            Object[] objs = this.m_list.getSelectedValues();
            this.m_tableList = new Object[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                this.m_tableList[i] = objs[i];
            }
        }
        return true;
    }

    private void _layoutWidgets() {
        JPanel tableList = new JPanel(new BorderLayout());
        this.m_listModel = new DefaultListModel();
        this.m_list = new JList(this.m_listModel);
        tableList.add((Component)new JScrollPane(this.m_list), "Center");
        tableList.setPreferredSize(new Dimension(200, 200));
        this.m_list.setToolTipText(bundle.getString("TablePanel.TableList.Tooltip.txt"));
        this.add(tableList, new GridBagConstraints(0, 0, 2, 5, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 5), 0, 0));
        JButton jbSelectAll = new JButton(bundle.getString("TablePanel.SelectAll.txt"));
        jbSelectAll.setMnemonic(bundle.getString("TablePanel.SelectAll.mnem").charAt(0));
        jbSelectAll.setToolTipText(bundle.getString("TablePanel.SelectAll.Tooltip.txt"));
        jbSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int endpoint = TablePanel.this.m_listModel.size();
                Workspace.getDefaultLogger().debug((Object)("Endpoint is " + String.valueOf(endpoint)));
                TablePanel.this.m_list.setSelectionInterval(0, endpoint - 1);
            }
        });
        this.add(jbSelectAll, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.m_jbSelectNone = new JButton(bundle.getString("TablePanel.SelectNone.txt"));
        this.m_jbSelectNone.setMnemonic(bundle.getString("TablePanel.SelectNone.mnem").charAt(0));
        this.m_jbSelectNone.setToolTipText(bundle.getString("TablePanel.SelectNone.Tooltip.txt"));
        this.m_jbSelectNone.setEnabled(false);
        this.m_jbSelectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TablePanel.this.m_list.clearSelection();
            }
        });
        this.add(this.m_jbSelectNone, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (TablePanel.this.m_list.getSelectedIndex() == -1) {
                    TablePanel.this.m_jbSelectNone.setEnabled(false);
                } else {
                    TablePanel.this.m_jbSelectNone.setEnabled(true);
                }
            }
        });
        TitledBorder titledBorder1 = new TitledBorder(bundle.getString("TablePanel.Groupbox.txt"));
        this.setBorder(titledBorder1);
    }

    public DefaultListModel getListModel() {
        return this.m_listModel;
    }

    public Object[] getTableList() {
        return this.m_tableList;
    }

    public Object[] getSelectedList() {
        Object[] objs = this.m_list.getSelectedValues();
        return objs;
    }
}

