/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.Key;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.Root;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.model.ColumnsTableModel2;
import com.sas.wadmin.visuals.ColumnsTableNameCellRenderer;
import com.sas.wadmin.visuals.ImpactAnalysisOMAView;
import com.sas.wadmin.visuals.JOMANotesTab;
import com.sas.wadmin.visuals.WAExtAttrPropertyTab;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WASplittablePropertyFrame;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsUniqueNameTableColumn;
import com.sas.workspace.WsViewFactory;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectsSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.undo.UndoManager;

public class TableColumnsPanel2
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(TableColumnsPanel2.class);
    protected DataTable m_oTable;
    protected ColumnsTableModel2 m_mdlColumns;
    protected WsTable m_tblColumns;
    protected JScrollPane m_scrColumns;
    protected JButton m_btnNew;
    protected JButton m_btnImport;
    protected JButton m_btnDelete;
    protected JButton m_btnMoveUp;
    protected JButton m_btnMoveDown;
    protected JPanel m_pnlButtons;
    protected JPanel m_pnlRight;
    protected WsAbstractAction m_actNew;
    protected WsAbstractAction m_actImport;
    protected WsAbstractAction m_actDelete;
    protected WsAbstractAction m_actNotes;
    protected WsAbstractAction m_actExtAttrs;
    protected WsAbstractAction m_actMoveUp;
    protected WsAbstractAction m_actMoveDown;
    protected WsAbstractAction m_actImpactAnalysis;
    protected WsAbstractAction m_actReverseImpactAnalysis;
    protected boolean m_bShowButtons;
    protected boolean m_bOrderChanged;
    protected boolean m_bRowsReorderable;
    protected boolean m_bSortIgnore;
    protected boolean m_bShowColumnImpact;
    protected String m_sSettingsPrefix;

    public TableColumnsPanel2() {
        this(null, null, true);
    }

    public TableColumnsPanel2(DataTable oTable) {
        this(oTable, null, true);
    }

    public TableColumnsPanel2(DataTable oTable, ColumnsTableModel2 mdlTable) {
        this(oTable, mdlTable, true);
    }

    public TableColumnsPanel2(DataTable oTable, boolean bShowButtons) {
        this(oTable, null, bShowButtons);
    }

    public TableColumnsPanel2(DataTable oTable, ColumnsTableModel2 mdlTable, boolean bShowButtons) {
        this(oTable, mdlTable, bShowButtons, true);
    }

    public TableColumnsPanel2(DataTable oTable, ColumnsTableModel2 mdlTable, boolean bShowButtons, boolean bShowColumnImpact) {
        this.m_oTable = oTable;
        this.m_mdlColumns = mdlTable != null ? mdlTable : new ColumnsTableModel2();
        this.m_bShowButtons = bShowButtons;
        this.m_bShowColumnImpact = bShowColumnImpact;
        this.m_bRowsReorderable = true;
        this.m_bSortIgnore = false;
        this.m_mdlColumns.setMetadataTable(oTable);
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("shared");
        this.setHelpTopic("columns_tab");
    }

    protected void initialize() {
        this.createActions();
        this.m_tblColumns = new WsTable((WsAbstractTableModel)this.m_mdlColumns);
        this.m_tblColumns.setToolTipText(bundle.getString("TableColumnsPanel2.Table.ToolTip.txt"));
        this.m_tblColumns.setUndoManager((UndoManager)this.waum);
        ColumnsTableNameCellRenderer rdrName = new ColumnsTableNameCellRenderer();
        rdrName.showKeyIcon(true);
        rdrName.showNotesIcon(true);
        rdrName.showExtAttrsIcon(true);
        TableColumn colName = this.m_tblColumns.getColumnModel().getColumn(0);
        colName.setCellRenderer((TableCellRenderer)((Object)rdrName));
        WsDefaultCellEditor edtName = (WsDefaultCellEditor)colName.getCellEditor();
        WATextField txtName = (WATextField)edtName.getComponent();
        txtName.setCaret(rdrName.getCaretForEditor());
        this.removeUnwantedColumns();
        this.initializeSettingsPrefix();
        if (this.m_sSettingsPrefix != null) {
            this.m_tblColumns.restoreSettings(this.m_sSettingsPrefix);
        }
        this.m_tblColumns.setRowHeaderPopupMenuRequestListener(this.createRowHeaderPopupMenuRequestListener());
        this.m_tblColumns.setTablePopupMenuRequestListener(this.createTablePopupMenuRequestListener());
        this.m_tblColumns.setViewportPopupMenuRequestListener(this.createViewportPopupMenuRequestListener());
        this.m_tblColumns.getSelectionModel().addListSelectionListener(this.createTableSelectionListener());
        this.m_mdlColumns.addTableModelListener(this.createTableModelListener());
        ((WsDefaultTableRowModel)this.m_tblColumns.getRowModel()).addRowModelListener(this.createTableRowModelListener());
        this.m_tblColumns.getActionMap().put(this.m_actDelete, (Action)this.m_actDelete);
        this.m_tblColumns.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDelete);
        this.createButtonsPanel();
    }

    protected void createButtonsPanel() {
        if (!this.m_bShowButtons) {
            return;
        }
        this.m_btnNew = this.createTextButton(this.m_actNew);
        this.m_btnImport = this.createTextButton(this.m_actImport);
        this.m_btnDelete = this.createTextButton(this.m_actDelete);
        this.m_btnMoveUp = this.createToolButton(this.m_actMoveUp);
        this.m_btnMoveDown = this.createToolButton(this.m_actMoveDown);
        JPanel pnlLeft = new JPanel((LayoutManager)new WsButtonsLayout());
        this.m_pnlRight = new JPanel((LayoutManager)new WsButtonsLayout());
        pnlLeft.add(this.m_btnMoveUp);
        pnlLeft.add(this.m_btnMoveDown);
        this.m_pnlRight.add(this.m_btnNew);
        this.m_pnlRight.add(this.m_btnImport);
        this.m_pnlRight.add(this.m_btnDelete);
        this.m_pnlButtons = new JPanel(new BorderLayout(10, 0));
        this.m_pnlButtons.add((Component)pnlLeft, "West");
        this.m_pnlButtons.add((Component)this.m_pnlRight, "East");
    }

    protected JButton createTextButton(WsAbstractAction act) {
        JButton btn = new JButton((Action)act);
        btn.setIcon(null);
        return btn;
    }

    protected JButton createToolButton(WsAbstractAction act) {
        JButton btn = new JButton((Action)act);
        btn.setText(null);
        Insets ins = btn.getMargin();
        ins.left = ins.top;
        ins.right = ins.bottom;
        btn.setMargin(ins);
        return btn;
    }

    protected void layoutWidgets() {
        this.m_scrColumns = new JScrollPane((Component)this.m_tblColumns);
        this.setLayout(new BorderLayout(0, 5));
        this.add(this.m_scrColumns, "Center");
        if (this.m_bShowButtons) {
            this.add(this.m_pnlButtons, "South");
        }
    }

    protected void initializeSettingsPrefix() {
        this.m_sSettingsPrefix = "TableColumnsPanel2";
    }

    protected void removeUnwantedColumns() {
        this.removeColumn(9);
        this.removeColumn(10);
    }

    protected void removeColumn(int iModelColumn) {
        int iViewColumn = this.m_tblColumns.convertColumnIndexToView(iModelColumn);
        if (iViewColumn != -1) {
            this.m_tblColumns.removeColumn(this.m_tblColumns.getColumnModel().getColumn(iViewColumn));
        }
    }

    public void setMetadataTable(DataTable oTable) {
        this.m_oTable = oTable;
        this.m_mdlColumns.setMetadataTable(oTable);
    }

    public DataTable getMetadataTable() {
        return this.m_oTable;
    }

    public ColumnsTableModel2 getTableModel() {
        return this.m_mdlColumns;
    }

    public boolean validateData() {
        if (!this.m_tblColumns.stopCellEditing()) {
            return false;
        }
        int iViewInformatColumn = this.m_tblColumns.convertColumnIndexToView(6);
        int iViewFormatColumn = this.m_tblColumns.convertColumnIndexToView(7);
        for (int iRow = 0; iRow < this.m_tblColumns.getRowCount(); ++iRow) {
            int iModelRow = this.m_tblColumns.convertRowIndexToModel(iRow);
            String sType = WsColumnMetadataUtil.convertColumnTypeToData((String)((String)this.m_mdlColumns.getValueAt(iModelRow, 3)));
            String sInformat = (String)this.m_mdlColumns.getValueAt(iModelRow, 6);
            if (!sInformat.equals(WsColumnMetadataUtil.NONE) && !WsColumnMetadataUtil.isInformatNameValid((String)sInformat, (String)sType)) {
                String sMessage = bundle.getString("TableColumnsPanel2.Error.InvalidInformat.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                if (iViewFormatColumn != -1) {
                    this.m_tblColumns.selectCell(iRow, iViewInformatColumn);
                    this.m_tblColumns.editCellAt(iRow, iViewInformatColumn);
                }
                return false;
            }
            String sFormat = (String)this.m_mdlColumns.getValueAt(iModelRow, 7);
            if (sFormat.equals(WsColumnMetadataUtil.NONE) || WsColumnMetadataUtil.isFormatNameValid((String)sFormat, (String)sType)) continue;
            String sMessage = bundle.getString("TableColumnsPanel2.Error.InvalidFormat.txt");
            MessageUtil.displayMessage((String)sMessage, (int)0);
            if (iViewFormatColumn != -1) {
                this.m_tblColumns.selectCell(iRow, iViewFormatColumn);
                this.m_tblColumns.editCellAt(iRow, iViewFormatColumn);
            }
            return false;
        }
        if (this.m_bOrderChanged && !this.m_tblColumns.isOriginalOrder()) {
            int eAnswer = MessageUtil.displayMessage((String)bundle.getString("TableColumnsPanel2.SaveOrderMessage.txt"), (String)bundle.getString("TableColumnsPanel2.SaveOrderTitle.txt"), (int)2, (int)1);
            switch (eAnswer) {
                case 0: {
                    break;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case -1: {
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        if (this.m_bSortIgnore) {
            return true;
        }
        WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)this.m_tblColumns.getRowModel();
        this.m_mdlColumns.setRowMappings(mdlRows.getRowMappings());
        return true;
    }

    public void setStorePopulated(boolean bStorePopulated) {
        super.setStorePopulated(bStorePopulated);
        if (!bStorePopulated) {
            this.m_mdlColumns.setStorePopulated(bStorePopulated);
        }
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.m_mdlColumns.populateStore();
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_mdlColumns.moveDataToModel();
        if (this.m_mdlColumns.getRowCount() > 0) {
            this.m_tblColumns.selectCell(0, 0);
        } else {
            this.updateActions();
        }
        WsUniqueNameTableColumn colName = (WsUniqueNameTableColumn)this.m_mdlColumns.getColumn(0);
        colName.setCaseSensitive(DBMSNamesPropertyHandler.needQuotes((DataTable)this.m_oTable));
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_tblColumns.cancelCellEditing();
        if (!this.hasDataChanged()) {
            return;
        }
        this.m_mdlColumns.moveDataToStore();
        this.m_mdlColumns.setRowMappings(null);
        this.setDataChanged(false);
        this.m_bOrderChanged = false;
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            this.populateStore();
            this.moveDataToView();
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actNew.setActive(bActive);
        this.m_actImport.setActive(bActive);
        this.m_actDelete.setActive(bActive);
        if (this.m_bShowColumnImpact) {
            this.m_actImpactAnalysis.setActive(bActive);
            this.m_actReverseImpactAnalysis.setActive(bActive);
        }
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tblColumns.setEditable(bEditable);
        this.m_tblColumns.setRowsReorderable(bEditable && this.m_bRowsReorderable);
        this.m_tblColumns.setSortingEnabled(bEditable);
        this.updateActions();
    }

    public void setRowsReorderable(boolean bReorderable) {
        this.m_tblColumns.setRowsReorderable(bReorderable);
        this.m_bRowsReorderable = bReorderable;
        this.updateActions();
        this.updateComponents();
    }

    public void setSortIgnore(boolean bSortIgnore) {
        this.m_bSortIgnore = bSortIgnore;
    }

    public void updateComponents() {
        this.m_btnMoveDown.setVisible(this.m_bRowsReorderable);
        this.m_btnMoveUp.setVisible(this.m_bRowsReorderable);
    }

    public void saveSettingsAndCleanUp() {
        if (this.m_sSettingsPrefix != null) {
            this.m_tblColumns.saveSettings(this.m_sSettingsPrefix);
        }
    }

    public void setWAUndoManager(WAUndoManager mgrUndo) {
        super.setWAUndoManager(mgrUndo);
        this.m_tblColumns.setUndoManager((UndoManager)mgrUndo);
    }

    protected void createNewRow() {
        this.m_tblColumns.undoableInsertNewRowAfterLastSelectedRow();
        int[] aSelectedRows = this.m_tblColumns.getSelectedRowsFromSelectedCells();
        int iNewRow = aSelectedRows[0];
        Workspace.getWorkspace();
        MdFactory factory = Workspace.getMdFactory();
        String sName = (String)this.m_mdlColumns.getValueAt(iNewRow, 0);
        try {
            Column oColumn = (Column)factory.createComplexMetadataObject((MdObjectStore)this.m_oTable.getObjectStore(), sName, "Column", this.m_oTable.getRepositoryID());
            oColumn.setPublicType("Column");
            oColumn.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
            oColumn.setTable(this.m_oTable);
            oColumn.setSASColumnName(sName);
            this.m_mdlColumns.setValueAt(oColumn, iNewRow, 14);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected void showNotesDialog() {
        block8: {
            if (!this.m_tblColumns.stopCellEditing()) {
                return;
            }
            try {
                this.moveDataToStore();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            int[] aSelectedRows = this.m_tblColumns.getSelectedRowsFromSelectedCells();
            int iSelectedRow = this.m_tblColumns.convertRowIndexToModel(aSelectedRows[0]);
            Column oColumn = (Column)this.m_mdlColumns.getValueAt(iSelectedRow, 14);
            String sName = (String)this.m_mdlColumns.getValueAt(iSelectedRow, 0);
            try {
                MdObjectStore store = (MdObjectStore)oColumn.getObjectStore();
                MdObjectStore storeDialog = Workspace.getMdFactory().createObjectStore((MdStore)store);
                Column oColumnDialog = (Column)Workspace.getMdFactory().createComplexMetadataObject(storeDialog, (CMetadata)oColumn);
                String sTitle = bundle.formatString("TableColumnsPanel2.NotesDialogTitle.fmt", (Object)sName);
                WAPropertyDialog dlg = new WAPropertyDialog((Frame)Workspace.getWorkspace(), sTitle, true);
                dlg.setEditable(this.isEditable());
                dlg.setMetadataObject((CMetadata)oColumnDialog);
                JOMANotesTab tabNotes = new JOMANotesTab((Root)oColumnDialog);
                dlg.setMainPanel((WAPanel)tabNotes);
                dlg.show();
                if (dlg.getReturnValue() != 1) break block8;
                try {
                    boolean bNotes = !oColumn.getNotes().isEmpty() || !oColumn.getDocuments().isEmpty();
                    this.m_mdlColumns.setValueAt(new Boolean(bNotes), iSelectedRow, 12);
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                }
                this.m_tblColumns.selectRow(aSelectedRows[0]);
                this.setDataChanged(true);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    protected void showExtAttrsDialog() {
        block6: {
            if (!this.m_tblColumns.stopCellEditing()) {
                return;
            }
            int[] aSelectedRows = this.m_tblColumns.getSelectedRowsFromSelectedCells();
            int iSelectedRow = this.m_tblColumns.convertRowIndexToModel(aSelectedRows[0]);
            Column oColumn = (Column)this.m_mdlColumns.getValueAt(iSelectedRow, 14);
            String sName = (String)this.m_mdlColumns.getValueAt(iSelectedRow, 0);
            try {
                MdObjectStore store = (MdObjectStore)oColumn.getObjectStore();
                MdObjectStore storeDialog = Workspace.getMdFactory().createObjectStore((MdStore)store);
                Column oColumnDialog = (Column)Workspace.getMdFactory().createComplexMetadataObject(storeDialog, (CMetadata)oColumn);
                String sTitle = bundle.formatString("TableColumnsPanel2.ExtAttrsDialogTitle.fmt", (Object)sName);
                WAPropertyDialog dlg = new WAPropertyDialog((Frame)Workspace.getWorkspace(), sTitle, true);
                dlg.setEditable(this.isEditable());
                WAExtAttrPropertyTab tabExtAttrs = new WAExtAttrPropertyTab((CMetadata)oColumnDialog);
                dlg.setMainPanel((WAPanel)tabExtAttrs);
                dlg.setResizable(true);
                dlg.setPreferredSize(new Dimension(600, 300));
                dlg.show();
                if (dlg.getReturnValue() != 1) break block6;
                try {
                    AssociationList alExtensions = oColumn.getExtensions();
                    alExtensions.removeAllElements();
                    AssociationList alDialogExtensions = oColumnDialog.getExtensions();
                    int nDialogExtensions = alDialogExtensions.size();
                    for (int iDialogExtension = 0; iDialogExtension < nDialogExtensions; ++iDialogExtension) {
                        Extension oDialogExtension = (Extension)alDialogExtensions.get(iDialogExtension);
                        Extension oExtension = (Extension)Workspace.getMdFactory().createComplexMetadataObject(store, (CMetadata)oDialogExtension);
                        oExtension.setName(oDialogExtension.getName());
                        oExtension.setDesc(oDialogExtension.getDesc());
                        oExtension.setValue(oDialogExtension.getValue());
                        alExtensions.add((Object)oExtension);
                    }
                    this.m_mdlColumns.setValueAt(new Boolean(nDialogExtensions > 0), iSelectedRow, 13);
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                }
                this.m_tblColumns.selectRow(aSelectedRows[0]);
                this.setDataChanged(true);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showImpactAnalysis(boolean bForward) {
        if (!this.m_bShowColumnImpact) {
            return;
        }
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            int[] aRows = this.m_tblColumns.getSelectedRowsFromSelectedCells();
            int iRow = this.m_tblColumns.convertRowIndexToModel(aRows[0]);
            Column oColumn = (Column)this.m_mdlColumns.getValueAt(iRow, 14);
            if (oColumn.isNewObject()) {
                return;
            }
            ImpactAnalysisOMAView view = this.findImpactAnalysisView(oColumn, bForward);
            if (view != null) {
                WsViewFactory.showExistingView((WsOMAView)view);
            } else {
                MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                MdObjectStore store = factory.createObjectStore();
                Column oDetail = (Column)Workspace.getMdFactory().createComplexMetadataObject(store, (CMetadata)oColumn);
                MdStoreUtil.copyObjectAttributes((CMetadata)oColumn, (CMetadata)oDetail);
                view = new ImpactAnalysisOMAView(oDetail, bForward);
                WsViewFactory.attachViewToFrame((CMetadata)oDetail, (WorkspaceOMAView)view, (WAPropertyFrame)new WASplittablePropertyFrame((CMetadata)oDetail, ""));
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private ImpactAnalysisOMAView findImpactAnalysisView(Column oColumn, boolean bForward) {
        return null;
    }

    protected ListSelectionListener createTableSelectionListener() {
        return new cTableSelectionListener();
    }

    protected WsTableRowModelListener createTableRowModelListener() {
        return new cTableRowModelListener();
    }

    protected TableModelListener createTableModelListener() {
        return new cTableModelListener();
    }

    protected WsPopupMenuRequestListener createRowHeaderPopupMenuRequestListener() {
        return new cRowHeaderPopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createTablePopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createViewportPopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    protected void createActions() {
        this.m_actNew = this.createNewAction();
        this.m_actImport = this.createImportAction();
        this.m_actDelete = this.createDeleteAction();
        this.m_actNotes = this.createNotesAction();
        this.m_actExtAttrs = this.createExtAttrsAction();
        this.m_actMoveUp = this.createMoveUpAction();
        this.m_actMoveDown = this.createMoveDownAction();
        if (this.m_bShowColumnImpact) {
            this.m_actImpactAnalysis = this.createImpactAnalysisAction();
            this.m_actReverseImpactAnalysis = this.createReverseImpactAnalysisAction();
        }
    }

    protected void updateActions() {
        int[] aSelectedRows = this.m_tblColumns.getSelectedRowsFromSelectedCells();
        boolean bEditable = this.isEditable();
        boolean bSelected = aSelectedRows.length > 0;
        boolean bOneSelected = aSelectedRows.length == 1;
        boolean bNotFirst = bSelected;
        boolean bNotLast = bSelected;
        int iLastRow = this.m_tblColumns.getRowCount() - 1;
        int nSelectedRows = aSelectedRows.length;
        for (int iSelectedRow = 0; iSelectedRow < nSelectedRows; ++iSelectedRow) {
            if (aSelectedRows[iSelectedRow] == 0) {
                bNotFirst = false;
            }
            if (aSelectedRows[iSelectedRow] != iLastRow) continue;
            bNotLast = false;
        }
        this.m_actNew.setEnabled(bEditable);
        this.m_actImport.setEnabled(bEditable);
        this.m_actDelete.setEnabled(bEditable && bSelected);
        this.m_actNotes.setEnabled(bOneSelected);
        this.m_actExtAttrs.setEnabled(bOneSelected);
        this.m_actMoveUp.setEnabled(bEditable && bNotFirst && this.m_bRowsReorderable);
        this.m_actMoveDown.setEnabled(bEditable && bNotLast && this.m_bRowsReorderable);
        if (this.m_bShowColumnImpact) {
            this.m_actImpactAnalysis.setEnabled(bOneSelected);
            this.m_actReverseImpactAnalysis.setEnabled(bOneSelected);
        }
    }

    protected WsAbstractAction createNewAction() {
        return new cNewAction();
    }

    protected WsAbstractAction createImportAction() {
        return new cImportAction();
    }

    protected WsAbstractAction createDeleteAction() {
        return new cDeleteAction();
    }

    protected WsAbstractAction createNotesAction() {
        return new cNotesAction();
    }

    protected WsAbstractAction createExtAttrsAction() {
        return new cExtAttrsAction();
    }

    protected WsAbstractAction createMoveUpAction() {
        return new cMoveUpAction();
    }

    protected WsAbstractAction createMoveDownAction() {
        return new cMoveDownAction();
    }

    protected WsAbstractAction createImpactAnalysisAction() {
        return new cImpactAnalysisAction();
    }

    protected WsAbstractAction createReverseImpactAnalysisAction() {
        return new cReverseImpactAnalysisAction();
    }

    protected class cTableSelectionListener
    implements ListSelectionListener {
        protected cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            TableColumnsPanel2.this.updateActions();
        }
    }

    protected class cTableRowModelListener
    implements WsTableRowModelListener {
        protected cTableRowModelListener() {
        }

        public void rowDragged(TableRowModelEvent e) {
            TableColumnsPanel2.this.setDataChanged(true);
            TableColumnsPanel2.this.m_bOrderChanged = true;
        }

        public void rowsHidden(WsTableRowModelEvent e) {
        }

        public void rowsShown(WsTableRowModelEvent e) {
        }

        public void rowsRemapped(ChangeEvent e) {
            if (!TableColumnsPanel2.this.m_bSortIgnore) {
                TableColumnsPanel2.this.setDataChanged(true);
                TableColumnsPanel2.this.m_bOrderChanged = true;
            }
        }
    }

    protected class cTableModelListener
    implements TableModelListener {
        protected cTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (TableColumnsPanel2.this.isListeningForChanges()) {
                TableColumnsPanel2.this.setDataChanged(true);
            }
        }
    }

    public class cRowHeaderPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = TableColumnsPanel2.this.m_tblColumns.createRowHeaderPopupMenu();
            WsUIUtilities.addSpaceIconToPopupMenu((JPopupMenu)mnuPopup);
            if (mnuPopup.getComponentCount() != 0) {
                mnuPopup.addSeparator();
            }
            mnuPopup.add(new JMenuItem((Action)TableColumnsPanel2.this.m_actNew));
            mnuPopup.add(new JMenuItem((Action)TableColumnsPanel2.this.m_actImport));
            mnuPopup.add(new JMenuItem((Action)TableColumnsPanel2.this.m_actDelete));
            mnuPopup.addSeparator();
            mnuPopup.add(new JMenuItem((Action)TableColumnsPanel2.this.m_actNotes));
            mnuPopup.add(new JMenuItem((Action)TableColumnsPanel2.this.m_actExtAttrs));
            if (TableColumnsPanel2.this.m_bShowColumnImpact) {
                mnuPopup.addSeparator();
                mnuPopup.add(new JMenuItem((Action)TableColumnsPanel2.this.m_actImpactAnalysis));
                mnuPopup.add(new JMenuItem((Action)TableColumnsPanel2.this.m_actReverseImpactAnalysis));
            }
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    public class cTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem((Action)TableColumnsPanel2.this.m_actNew));
            mnuPopup.add(new JMenuItem((Action)TableColumnsPanel2.this.m_actImport));
            mnuPopup.add(new JMenuItem((Action)TableColumnsPanel2.this.m_actDelete));
            mnuPopup.addSeparator();
            mnuPopup.add(new JMenuItem((Action)TableColumnsPanel2.this.m_actNotes));
            mnuPopup.add(new JMenuItem((Action)TableColumnsPanel2.this.m_actExtAttrs));
            if (TableColumnsPanel2.this.m_bShowColumnImpact) {
                mnuPopup.addSeparator();
                mnuPopup.add(new JMenuItem((Action)TableColumnsPanel2.this.m_actImpactAnalysis));
                mnuPopup.add(new JMenuItem((Action)TableColumnsPanel2.this.m_actReverseImpactAnalysis));
            }
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cNewAction
    extends WsAbstractAction {
        public cNewAction() {
            super(bundle, "TableColumnsPanel2.New", true);
            this.setMenuSupportId("new");
        }

        public void actionPerformed(ActionEvent e) {
            TableColumnsPanel2.this.createNewRow();
        }
    }

    protected class cImportAction
    extends WsAbstractAction {
        public cImportAction() {
            super(bundle, "TableColumnsPanel2.Import", true);
            this.setMenuSupportId("importcolumns");
            this.setHidable(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (!TableColumnsPanel2.this.m_tblColumns.stopCellEditing()) {
                return;
            }
            try {
                MdObjectStore store = (MdObjectStore)TableColumnsPanel2.this.m_oTable.getObjectStore();
                MdObjectStore storeChild = Workspace.getMdFactory().createObjectStore((MdStore)store);
                try {
                    ObjectsSelectorPanel pnl = new ObjectsSelectorPanel(Workspace.getWorkspace().getUserContext(), 4);
                    String sImportDialogTitle = bundle.getString("TableColumnsPanel2.ImportColumnsDialogTitle.txt");
                    WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sImportDialogTitle, true, (WAPanel)pnl);
                    dlg.setResizable(true);
                    dlg.setHelpProduct("shared");
                    dlg.setHelpTopic("import_column_win");
                    dlg.show();
                    if (dlg.getReturnValue() == 1) {
                        SimpleObject[] aColumns = pnl.getSelectedObjects();
                        Root[] aMDColumns = ObjectConverter.getInstance().convertToJOMAObjects(storeChild, aColumns);
                        boolean bCaseSensitive = DBMSNamesPropertyHandler.needQuotes((DataTable)TableColumnsPanel2.this.m_oTable);
                        List<Root> lColumns = Arrays.asList(aMDColumns);
                        int nColumns = lColumns.size();
                        ArrayList<List> lRowsValues = new ArrayList<List>(nColumns);
                        ArrayList<String> lDuplicateColumns = new ArrayList<String>();
                        for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                            Column oColumn = (Column)lColumns.get(iColumn);
                            String sColumn = oColumn.getName();
                            boolean bDuplicateError = false;
                            for (int iExistingColumn = 0; iExistingColumn < TableColumnsPanel2.this.m_mdlColumns.getRowCount(); ++iExistingColumn) {
                                boolean bEquals;
                                ColumnsTableModel2 cfr_ignored_0 = TableColumnsPanel2.this.m_mdlColumns;
                                String sExistingColumn = (String)TableColumnsPanel2.this.m_mdlColumns.getValueAt(iExistingColumn, 0);
                                boolean bl = bEquals = bCaseSensitive ? sExistingColumn.equals(sColumn) : sExistingColumn.equalsIgnoreCase(sColumn);
                                if (!bEquals) continue;
                                lDuplicateColumns.add(sColumn);
                                bDuplicateError = true;
                                break;
                            }
                            if (bDuplicateError) continue;
                            Column oNewColumn = WsColumnMetadataUtil.createMetadataColumnCopy((Column)oColumn, (MdObjectStore)store, (String)TableColumnsPanel2.this.m_oTable.getRepositoryID());
                            oNewColumn.setTable(TableColumnsPanel2.this.m_oTable);
                            lRowsValues.add(TableColumnsPanel2.this.m_mdlColumns.getRowValuesForColumn(oNewColumn));
                        }
                        if (!lRowsValues.isEmpty()) {
                            TableColumnsPanel2.this.m_tblColumns.undoableInsertRowsAfterLastSelectedRow(lRowsValues);
                        }
                        if (lDuplicateColumns.size() > 0) {
                            String sMessage = bundle.getString("TableColumnsPanel2.DuplicateColumnsRemovedWarning.txt");
                            MessageUtil.displayListMessage((String)sMessage, lDuplicateColumns);
                        }
                    }
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                }
                finally {
                    storeChild.dispose();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        private Column copyColumn(MdObjectStore store, Column column, String sReposID) throws MdException, RemoteException {
            Column newColumn = (Column)Workspace.getMdFactory().createComplexMetadataObject(store, column.getName(), "Column", sReposID);
            MdStoreUtil.copyObjectAttributes((CMetadata)column, (CMetadata)newColumn);
            return newColumn;
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction {
        public cDeleteAction() {
            super(bundle, "TableColumnsPanel2.Delete", true);
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent e) {
            int[] aSelectedRows = TableColumnsPanel2.this.m_tblColumns.getSelectedRowsFromSelectedCells();
            for (int xSelectedRow = 0; xSelectedRow < aSelectedRows.length; ++xSelectedRow) {
                int iSelectedRow = TableColumnsPanel2.this.m_tblColumns.convertRowIndexToModel(aSelectedRows[xSelectedRow]);
                Column oColumn = (Column)TableColumnsPanel2.this.m_mdlColumns.getValueAt(iSelectedRow, 14);
                String sName = (String)TableColumnsPanel2.this.m_mdlColumns.getValueAt(iSelectedRow, 0);
                try {
                    if (!oColumn.getIndexes().isEmpty()) {
                        MessageUtil.displayMessage((String)bundle.formatString("TableColumnsPanel2.NoDeleteIndexMessage.txt", (Object)sName), (int)2);
                        return;
                    }
                    AssociationList lKeys = oColumn.getKeys();
                    if (lKeys.isEmpty()) continue;
                    for (int iKey = 0; iKey < lKeys.size(); ++iKey) {
                        Key key = (Key)lKeys.get(iKey);
                        if (!key.getCMetadataType().equals("UniqueKey") && !key.getCMetadataType().equals("ForeignKey")) continue;
                        MessageUtil.displayMessage((String)bundle.formatString("TableColumnsPanel2.NoDeleteKeyMessage.txt", (Object)sName), (int)2);
                        return;
                    }
                    int eAnswer = MessageUtil.displayMessage((String)bundle.formatString("TableColumnsPanel2.DeleteOtherKeyWarningMessage.fmt.txt", (Object)sName), (int)2, (int)2);
                    if (eAnswer == 0) continue;
                    return;
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                    continue;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            TableColumnsPanel2.this.m_tblColumns.undoableDeleteSelectedRows();
        }
    }

    protected class cNotesAction
    extends WsAbstractAction {
        public cNotesAction() {
            super(bundle, "TableColumnsPanel2.Notes", true);
        }

        public void actionPerformed(ActionEvent e) {
            TableColumnsPanel2.this.showNotesDialog();
        }
    }

    protected class cExtAttrsAction
    extends WsAbstractAction {
        public cExtAttrsAction() {
            super(bundle, "TableColumnsPanel2.ExtAttrs", true);
        }

        public void actionPerformed(ActionEvent e) {
            TableColumnsPanel2.this.showExtAttrsDialog();
        }
    }

    protected class cMoveUpAction
    extends WsAbstractAction {
        public cMoveUpAction() {
            super(bundle, "TableColumnsPanel2.MoveUp", true);
        }

        public void actionPerformed(ActionEvent e) {
            TableColumnsPanel2.this.m_tblColumns.undoableMoveSelectedRows(-1);
            TableColumnsPanel2.this.setDataChanged(true);
            TableColumnsPanel2.this.m_bOrderChanged = true;
        }
    }

    protected class cMoveDownAction
    extends WsAbstractAction {
        public cMoveDownAction() {
            super(bundle, "TableColumnsPanel2.MoveDown", true);
        }

        public void actionPerformed(ActionEvent e) {
            TableColumnsPanel2.this.m_tblColumns.undoableMoveSelectedRows(1);
            TableColumnsPanel2.this.setDataChanged(true);
            TableColumnsPanel2.this.m_bOrderChanged = true;
        }
    }

    protected class cImpactAnalysisAction
    extends WsAbstractAction {
        public cImpactAnalysisAction() {
            super(bundle, "TableColumnsPanel2.ImpactAnalysis");
            this.setMenuSupportId("impactanalysis");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            TableColumnsPanel2.this.showImpactAnalysis(true);
        }
    }

    protected class cReverseImpactAnalysisAction
    extends WsAbstractAction {
        public cReverseImpactAnalysisAction() {
            super(bundle, "TableColumnsPanel2.ReverseImpactAnalysis");
            this.setMenuSupportId("reverseimpactanalysis");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            TableColumnsPanel2.this.showImpactAnalysis(false);
        }
    }
}

