/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.visuals.PhysicalStoragePane;
import com.sas.wadmin.visuals.WAPhysicalStorageTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;

public class TDPhysicalTab
extends WsDescriptionWizardTab {
    private static WAdminResource m_bundle = WAdminResource.getBundle(WAPhysicalStorageTab.class);
    private PhysicalStoragePane m_physicalStoragePane = null;
    private String m_libname = null;

    public TDPhysicalTab() {
        super(m_bundle.getString("TDPhysicalTab.Top.txt"));
        this._initialize();
        this.setHelpTopic(this.m_physicalStoragePane.getHelpTopic());
    }

    public void saveSettingsAndCleanUp() {
        this.m_physicalStoragePane.saveSettingsAndCleanUp();
        this.m_physicalStoragePane = null;
        this.m_libname = null;
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        boolean rc = false;
        if (!bSaveToModel) {
            WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
            PhysicalTable targetTable = (PhysicalTable)myParent.getWizardData("TDNEWTABLE");
            this.m_physicalStoragePane.setMetadataObject((CMetadata)targetTable);
            rc = this.m_physicalStoragePane.doDataExchange(false);
        } else {
            rc = this.m_physicalStoragePane.doDataExchange(true);
        }
        return rc;
    }

    public void onNext() {
        try {
            this.doDataExchange(true);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public boolean validateData() {
        boolean rc = false;
        rc = this.m_physicalStoragePane.validateData();
        if (this.m_physicalStoragePane.getLibrary() != null) {
            try {
                this.m_libname = this.m_physicalStoragePane.getLibrary().getName();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        } else {
            int iChoice = MessageUtil.displayMessage((String)m_bundle.getString("TDPhysicalTab.NoLibrary.msg.txt"), (String)m_bundle.getString("TDPhysicalTab.NoLibrary.Title.txt"), (int)2, (int)2);
            if (iChoice == 0) {
                this.m_libname = m_bundle.getString("PhysicalStoragePane.Library.none.txt");
            } else {
                rc = false;
            }
        }
        return rc;
    }

    public String createFinishString() {
        WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
        CMetadata repos = (CMetadata)myParent.getWizardData("REPOSITORY");
        String sGroup = "Ungrouped";
        Tree groupTree = (Tree)myParent.getWizardData("GROUP");
        if (groupTree != null) {
            try {
                sGroup = groupTree.getName();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        PhysicalTable targetTable = (PhysicalTable)myParent.getWizardData("TDNEWTABLE");
        String sSASTableName = this.m_physicalStoragePane.getNameField() != null ? this.m_physicalStoragePane.getNameField() : m_bundle.getString("PhysicalStoragePane.TableName.none.txt");
        String temp = null;
        try {
            temp = m_bundle.formatString("TDPhysicalTab.FIrepository.txt", (Object)repos.getName()) + m_bundle.getString("Common.newline.txt") + m_bundle.formatString("TDPhysicalTab.FIgroup.txt", (Object)sGroup) + m_bundle.getString("Common.newline.txt") + m_bundle.getString("Common.newline.txt") + m_bundle.getString("TDPhysicalTab.FIname.txt") + " " + targetTable.getName() + m_bundle.getString("Common.newline.txt") + m_bundle.getString("TDPhysicalTab.FIsasdsname.txt") + " " + sSASTableName + m_bundle.getString("Common.newline.txt") + m_bundle.getString("TDPhysicalTab.FIsasdsloc.txt") + " " + this.m_libname + m_bundle.getString("Common.newline.txt") + m_bundle.getString("TDPhysicalTab.FInumofcols.txt") + " " + targetTable.getColumns().size() + m_bundle.getString("Common.newline.txt") + m_bundle.getString("Common.newline.txt");
            for (int i = 0; i < targetTable.getColumns().size(); ++i) {
                String sName = ((Column)targetTable.getColumns().get(i)).getSASColumnName();
                String sDesc = ((Column)targetTable.getColumns().get(i)).getDesc();
                String sType = ((Column)targetTable.getColumns().get(i)).getSASColumnType();
                String sLen = String.valueOf(((Column)targetTable.getColumns().get(i)).getSASColumnLength());
                String sInformat = ((Column)targetTable.getColumns().get(i)).getSASInformat();
                String sFormat = ((Column)targetTable.getColumns().get(i)).getSASFormat();
                temp = temp + m_bundle.getString("TDPhysicalTab.FIcName.txt") + " " + sName + m_bundle.getString("Common.newline.txt") + m_bundle.getString("TDPhysicalTab.FIcDesc.txt") + " " + sDesc + m_bundle.getString("Common.newline.txt") + m_bundle.getString("TDPhysicalTab.FIcType.txt") + " " + sType + m_bundle.getString("Common.newline.txt") + m_bundle.getString("TDPhysicalTab.FIcLen.txt") + " " + sLen + m_bundle.getString("Common.newline.txt") + m_bundle.getString("TDPhysicalTab.FIcInformat.txt") + " " + sInformat + m_bundle.getString("Common.newline.txt") + m_bundle.getString("TDPhysicalTab.FIcFormat.txt") + " " + sFormat + m_bundle.getString("Common.newline.txt") + m_bundle.getString("Common.newline.txt");
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            return " ";
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        temp = temp + "\n";
        return temp;
    }

    private void _initialize() {
        this.m_physicalStoragePane = new PhysicalStoragePane(null, false);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.m_physicalStoragePane), "Center");
    }
}

