/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectListener;
import com.sas.metadata.remote.OrderByClause;
import com.sas.metadata.remote.Select;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationStep;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.workspace.DNDObject;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAUndoable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class SASSortByPropertyTab
extends WAPropertyTab
implements MdObjectListener,
AncestorListener {
    private static WAdminResource bundle = WAdminResource.getBundle(SASSortByPropertyTab.class);
    protected WAPanel m_panel;
    protected DNDTable m_table;
    protected SASSortByModel m_tableModel;
    protected DNDScrollPane m_tableScrollPane;
    protected JLabel m_tableLabel;
    protected ArrayList m_cellChoices;
    protected Vector m_columns = new Vector();
    protected DNDList m_list;
    protected DefaultListModel m_listModel;
    protected JScrollPane m_listScrollPane;
    protected JLabel m_listBoxLabel;
    protected JButton m_addItemButton;
    protected JButton m_addAllButton;
    protected JButton m_removeItemButton;
    protected JButton m_removeAllButton;
    protected WAPanel m_buttonPanel;
    protected WAPanel m_pnlUpDownButtons;
    protected JButton m_btnMoveUp;
    protected JButton m_btnMoveDown;
    protected WsAbstractAction m_actAddItem;
    protected WsAbstractAction m_actAddAll;
    protected WsAbstractAction m_actRemoveItem;
    protected WsAbstractAction m_actRemoveAll;
    protected WsAbstractAction m_actMoveUp;
    protected WsAbstractAction m_actMoveDown;
    protected CMetadata m_metadata;
    protected EventListenerList m_listenerList = new EventListenerList();
    protected String m_bundlePrefix = "SASSortByPropertyTab";
    protected String m_leftLabel;
    protected String m_leftMnem;
    protected String m_leftTooltip;
    protected String m_rightLabel;
    protected String m_rightMnem;
    protected String m_rightTooltip;
    protected boolean m_sourceTable = true;
    protected boolean m_bIgnoreActionUpdates = false;
    final int BUTTON_WIDTH = 50;
    final int BUTTON_HEIGHT = 24;
    final int SCROLL_PANE_WIDTH = 165;
    final int SCROLL_PANE_HEIGHT = 315;
    protected DeleteTableRowAction m_deleteTableRowAction;
    protected static String[][] m_sortOrderArray = new String[][]{{"Ascending", bundle.getString("SASSortByPropertyTab.Ascending.txt")}, {"Descending", bundle.getString("SASSortByPropertyTab.Descending.txt")}};

    public SASSortByPropertyTab(CMetadata metadata) {
        this(metadata, false, "", "sort_by_columns_tab");
    }

    public SASSortByPropertyTab(CMetadata metadata, boolean sourceTable, String bundlePrefix, String helpTopic) {
        if (bundlePrefix.trim().compareTo("") != 0) {
            this.m_bundlePrefix = bundlePrefix;
        }
        this.m_leftLabel = bundle.getString(this.m_bundlePrefix + ".Left.Label.txt");
        this.m_leftMnem = bundle.getString(this.m_bundlePrefix + ".Left.mnem");
        this.m_leftTooltip = bundle.getString(this.m_bundlePrefix + ".Left.Tooltip.txt");
        this.m_rightLabel = bundle.getString(this.m_bundlePrefix + ".Right.Label.txt");
        this.m_rightMnem = bundle.getString(this.m_bundlePrefix + ".Right.mnem");
        this.m_rightTooltip = bundle.getString(this.m_bundlePrefix + ".Right.Tooltip.txt");
        this.setup(metadata, sourceTable, helpTopic);
    }

    public SASSortByPropertyTab(CMetadata metadata, boolean sourceTable, String rightLabel, String rightMnem, String helpTopic) {
        this.m_leftLabel = bundle.getString(this.m_bundlePrefix + ".Left.Label.txt");
        this.m_leftMnem = bundle.getString(this.m_bundlePrefix + ".Left.mnem");
        this.m_leftTooltip = bundle.getString(this.m_bundlePrefix + ".Left.Tooltip.txt");
        this.m_rightLabel = rightLabel;
        this.m_rightMnem = rightMnem;
        this.m_rightTooltip = bundle.getString(this.m_bundlePrefix + ".Right.Tooltip.txt");
        this.setup(metadata, sourceTable, helpTopic);
    }

    public SASSortByPropertyTab(CMetadata metadata, boolean sourceTable, String leftLabel, String leftMnem, String rightLabel, String rightMnem, String helpTopic) {
        this.m_leftLabel = leftLabel;
        this.m_leftMnem = leftMnem;
        this.m_leftTooltip = bundle.getString(this.m_bundlePrefix + ".Left.Tooltip.txt");
        this.m_rightLabel = rightLabel;
        this.m_rightMnem = rightMnem;
        this.m_rightTooltip = bundle.getString(this.m_bundlePrefix + ".Right.Tooltip.txt");
        this.setup(metadata, sourceTable, helpTopic);
    }

    public SASSortByPropertyTab(CMetadata metadata, boolean sourceTable, String leftLabel, String leftMnem, String leftTooltip, String rightLabel, String rightMnem, String rightTooltip, String helpTopic) {
        this.m_leftLabel = leftLabel;
        this.m_leftMnem = leftMnem;
        this.m_leftTooltip = leftTooltip;
        this.m_rightLabel = rightLabel;
        this.m_rightMnem = rightMnem;
        this.m_rightTooltip = rightTooltip;
        this.setup(metadata, sourceTable, helpTopic);
    }

    public void setup(CMetadata metadata, boolean sourceTable, String helpTopic) {
        this.m_sourceTable = sourceTable;
        try {
            if (metadata.getCMetadataType().compareTo("TransformationStep") == 0) {
                AssociationList transList = ((TransformationStep)metadata).getTransformations();
                this.m_metadata = (Transformation)transList.get(0);
            } else {
                this.m_metadata = metadata;
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        this.initialize();
        this.layoutWidgets();
        try {
            this.m_metadata.addMdObjectListener((MdObjectListener)this);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        this.setHelpTopic(helpTopic);
    }

    public void initialize() {
        this.m_panel = new WAPanel();
        this.m_actAddItem = this.createAddItemAction();
        this.m_actAddAll = this.createAddAllAction();
        this.m_actRemoveItem = this.createRemoveItemAction();
        this.m_actRemoveAll = this.createRemoveAllAction();
        this.m_actMoveUp = this.createMoveUpAction();
        this.m_actMoveDown = this.createMoveDownAction();
        this.m_buttonPanel = new WAPanel();
        this.m_pnlUpDownButtons = new WAPanel();
        this.m_addItemButton = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actAddItem);
        this.m_addAllButton = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actAddAll);
        this.m_removeItemButton = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actRemoveItem);
        this.m_removeAllButton = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actRemoveAll);
        this.m_btnMoveUp = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actMoveUp);
        this.m_btnMoveDown = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actMoveDown);
        Border border = BorderFactory.createBevelBorder(1);
        this.m_listModel = new DefaultListModel();
        this.m_list = new DNDList(this.m_listModel);
        this.m_list.initialize();
        this.m_list.setToolTipText(this.m_leftTooltip);
        this.m_listBoxLabel = new JLabel(this.m_leftLabel);
        this.m_listBoxLabel.setLabelFor(this.m_list);
        this.m_listBoxLabel.setDisplayedMnemonic(this.m_leftMnem.charAt(0));
        ListSelectionModel llsm = this.m_list.getSelectionModel();
        llsm.addListSelectionListener(new ListBoxListSelectionListener());
        this.m_list.addMouseListener(new ListMouseListener());
        this.m_list.addFocusListener(new ListFocusListener());
        this.m_listScrollPane = new JScrollPane();
        this.m_listScrollPane.getViewport().setView(this.m_list);
        this.m_listScrollPane.setVerticalScrollBarPolicy(20);
        this.m_listScrollPane.setHorizontalScrollBarPolicy(31);
        this.m_listScrollPane.setBorder(border);
        this.m_listScrollPane.setPreferredSize(new Dimension(115, 315));
        this.m_tableModel = this.createTableModel();
        this.m_table = new DNDTable(this.m_tableModel);
        this.m_table.initialize();
        this.m_table.setAutoResizeMode(1);
        this.m_table.setSelectionMode(2);
        this.m_table.setColumnHidingEnabled(false);
        this.m_table.setColumnHoldingEnabled(false);
        this.m_table.setRowHoldingEnabled(false);
        this.m_table.setRowHeaderVisible(true);
        this.m_table.setMultipleSelectionDragEnabled(true);
        this.m_table.setUndoManager((UndoManager)this.waum);
        ((WsDefaultTableRowModel)this.m_table.getRowModel()).addRowModelListener((WsTableRowModelListener)new TableRowModelListener());
        this.m_table.setToolTipText(this.m_rightTooltip);
        this.m_tableLabel = new JLabel(this.m_rightLabel);
        this.m_tableLabel.setLabelFor((Component)((Object)this.m_table));
        this.m_tableLabel.setDisplayedMnemonic(this.m_rightMnem.charAt(0));
        ListSelectionModel tlsm = this.m_table.getSelectionModel();
        tlsm.addListSelectionListener(new TableSelectionListener());
        this.m_table.addMouseListener(new ListMouseListener());
        this.m_tableModel.addTableModelListener(new ModelListener());
        this.m_deleteTableRowAction = new DeleteTableRowAction();
        this.m_table.getActionMap().put((Object)this.m_deleteTableRowAction, (Action)((Object)this.m_deleteTableRowAction));
        this.m_table.getInputMap().put(KeyStroke.getKeyStroke(127, 0), (Object)this.m_deleteTableRowAction);
        this.m_tableScrollPane = new DNDScrollPane();
        this.m_tableScrollPane.getViewport().setView((Component)((Object)this.m_table));
        this.m_tableScrollPane.setVerticalScrollBarPolicy(20);
        this.m_tableScrollPane.setHorizontalScrollBarPolicy(31);
        this.m_tableScrollPane.setBorder(border);
        this.m_tableScrollPane.setPreferredSize(new Dimension(215, 315));
        this.m_tableScrollPane.setToolTipText(this.m_rightTooltip);
    }

    protected SASSortByModel createTableModel() {
        return new SASSortByModel((Transformation)this.m_metadata);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.m_panel.setLayout((LayoutManager)new GridBagLayout());
        this.m_buttonPanel.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlUpDownButtons.setLayout((LayoutManager)new GridBagLayout());
        this.m_panel.add((Component)this.m_listBoxLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_panel.add((Component)this.m_listScrollPane, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_panel.add((Component)this.m_buttonPanel, (Object)new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 11, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.m_panel.add((Component)this.m_tableLabel, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_panel.add((Component)this.m_tableScrollPane, (Object)new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_panel.add((Component)this.m_pnlUpDownButtons, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.m_buttonPanel.add((Component)this.m_addItemButton, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.m_buttonPanel.add((Component)this.m_addAllButton, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.m_buttonPanel.add((Component)this.m_removeItemButton, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.m_buttonPanel.add((Component)this.m_removeAllButton, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.m_pnlUpDownButtons.add((Component)this.m_btnMoveUp, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.m_pnlUpDownButtons.add((Component)this.m_btnMoveDown, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.enableButtons();
        this.m_list.setEnabled(bEditable);
        this.m_table.setEnabled(bEditable);
        this.m_table.setCellSelectionEnabled(bEditable);
        this.m_table.getTableHeader().setReorderingAllowed(bEditable);
    }

    public void updateWorkspaceUIComponents(boolean active) {
        super.updateWorkspaceUIComponents(active);
        this.m_deleteTableRowAction.setActive(active);
    }

    public void addItemsToTable() {
        if (!this.isEditable()) {
            return;
        }
        int[] index = this.m_list.getSelectedIndices();
        int count = 0;
        int lastSelection = -1;
        Vector<String[]> undoVector = new Vector<String[]>();
        ArrayList rows = new ArrayList();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 0; i < index.length; ++i) {
            String[] undoValues;
            lastSelection = index[i] - count;
            String colName = (String)this.m_listModel.get(lastSelection);
            ArrayList<String> row = new ArrayList<String>();
            row.add(colName);
            columnNames.add(colName);
            if (this.m_cellChoices == null || this.m_cellChoices.size() == 0) {
                row.add(null);
                this.m_listModel.remove(lastSelection);
                undoValues = new String[3];
                undoValues[0] = colName;
                undoValues[1] = String.valueOf(this.m_tableModel.getRowCount() - 1);
                undoVector.add(i, undoValues);
            } else {
                row.add((String)this.m_cellChoices.get(0));
                this.m_listModel.remove(lastSelection);
                undoValues = new String[]{colName, (String)this.m_cellChoices.get(0), String.valueOf(this.m_tableModel.getRowCount() - 1)};
                undoVector.add(i, undoValues);
            }
            rows.add(row);
            ++count;
        }
        CompoundEdit undo = new CompoundEdit();
        if (undoVector.size() > 0) {
            cUndoableChange edit = new cUndoableChange("ADD", undoVector);
            undo.addEdit((UndoableEdit)((Object)edit));
        }
        this.m_table.undoableInsertRows(this.m_table.getRowCount() - 1, rows, undo);
        undo.end();
        this.waum.addEdit((UndoableEdit)undo);
        TableModel tableModel = this.m_table.getModel();
        for (int selectionIndex = 0; selectionIndex < tableModel.getRowCount(); ++selectionIndex) {
            String columnName = (String)tableModel.getValueAt(selectionIndex, 0);
            if (!columnNames.contains(columnName)) continue;
            this.m_table.addRowSelectionInterval(selectionIndex, selectionIndex);
        }
        this.enableButtons();
        this.m_table.requestFocus();
    }

    public void removeItemsFromTable() {
        if (!this.isEditable()) {
            return;
        }
        int count = 0;
        int[] index = this.m_table.getSelectedRowsFromSelectedCells();
        if (index.length == 0) {
            return;
        }
        this.m_table.convertRowIndexesToModel(index);
        Vector<String[]> undoVector = new Vector<String[]>();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 0; i < index.length; ++i) {
            String colName = (String)this.m_tableModel.getValueAt(index[i], 0);
            String sortOrder = "";
            if (this.m_tableModel.getColumnCount() > 1) {
                sortOrder = (String)this.m_tableModel.getValueAt(index[i], 1);
            }
            columnNames.add(colName);
            String[] undoValues = new String[]{colName, sortOrder, String.valueOf(index[i])};
            undoVector.add(i, undoValues);
            ++count;
        }
        CompoundEdit edit = new CompoundEdit();
        this.m_table.undoableDeleteSelectedRows(edit);
        if (undoVector.size() > 0) {
            cUndoableChange undo = new cUndoableChange("REMOVE", undoVector);
            edit.addEdit((UndoableEdit)((Object)undo));
        }
        this.fillListBox();
        edit.end();
        this.waum.addEdit((UndoableEdit)edit);
        ListModel listModel = this.m_list.getModel();
        for (int selectionIndex = 0; selectionIndex < listModel.getSize(); ++selectionIndex) {
            String item = (String)listModel.getElementAt(selectionIndex);
            if (!columnNames.contains(item)) continue;
            this.m_list.addSelectionInterval(selectionIndex, selectionIndex);
        }
        this.enableButtons();
        this.m_list.requestFocus();
    }

    public void enableButtons() {
        if (this.m_bIgnoreActionUpdates) {
            return;
        }
        this.m_addItemButton.setEnabled(this.m_list.getSelectedIndex() > -1 && this.isEditable());
        int[] selectedRows = this.m_table.getSelectedRowsFromSelectedCells();
        this.m_removeItemButton.setEnabled(selectedRows != null && selectedRows.length > 0 && this.isEditable());
        this.m_deleteTableRowAction.setEnabled(selectedRows != null && selectedRows.length > 0 && this.isEditable());
        this.m_addAllButton.setEnabled(this.m_listModel.getSize() > 0 && this.isEditable());
        this.m_removeAllButton.setEnabled(this.m_tableModel.getRowCount() > 0 && this.isEditable());
        this.m_btnMoveUp.setEnabled(selectedRows != null && selectedRows.length == 1 && selectedRows[0] != 0 && this.isEditable());
        this.m_btnMoveDown.setEnabled(selectedRows != null && selectedRows.length == 1 && selectedRows[0] != this.m_table.getRowCount() - 1 && this.isEditable());
    }

    public boolean validateData() {
        return true;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        if (this.m_metadata.getFQID().indexOf(36) == -1) {
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths(this.m_metadata, null, null, "", 8);
        }
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_tableModel.moveDataToModel();
        this.m_cellChoices = this.m_tableModel.getCellChoices();
        Select s = (Select)this.m_metadata;
        AssociationList ptList = this.m_sourceTable ? s.getClassifierSources() : s.getClassifierTargets();
        if (ptList.size() > 0) {
            DataTable pt = (DataTable)ptList.get(0);
            AssociationList columnsList = pt.getColumns();
            this.m_columns.clear();
            for (int i = 0; i < columnsList.size(); ++i) {
                Column col = (Column)columnsList.get(i);
                String colName = col.getSASColumnName();
                this.m_columns.addElement(colName);
            }
            this.fillListBox();
            this.enableButtons();
        }
        this.setDataChanged(false);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_tableModel.moveDataToStore();
        this.setDataChanged(false);
    }

    protected void fillListBox() {
        this.m_listModel.clear();
        for (int i = 0; i < this.m_columns.size(); ++i) {
            String colName = (String)this.m_columns.get(i);
            boolean inTable = false;
            for (int j = 0; j < this.m_tableModel.getRowCount(); ++j) {
                String dm_colName = (String)this.m_tableModel.getValueAt(j, 0);
                if (!dm_colName.equals(colName)) continue;
                inTable = true;
                break;
            }
            if (inTable) continue;
            this.m_listModel.addElement(colName);
        }
    }

    public CMetadata getMetadata() {
        return this.m_metadata;
    }

    public void addChangeListener(ChangeListener l) {
        this.m_listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_listenerList.remove(ChangeListener.class, l);
    }

    public void stateChanged(ChangeEvent e) {
        this.setDataChanged(this.isEditable());
    }

    public void objectsChanged(ChangeEvent e, Vector vObjects) {
    }

    public void objectsAdded(ChangeEvent e, Vector vObjects) {
    }

    public void objectsRemoved(ChangeEvent e, Vector vObjects) {
    }

    public void objectsCreated(ChangeEvent e, Vector vObjects) {
    }

    public void objectsDeleted(ChangeEvent e, Vector vObjects) {
    }

    @Override
    public void ancestorAdded(AncestorEvent e) {
    }

    @Override
    public void ancestorMoved(AncestorEvent e) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent e) {
    }

    public void MdObjectModified(MdEvent e) {
    }

    public void drop(DropTargetDropEvent event) {
        try {
            Vector dndObj = null;
            Transferable transfer = event.getTransferable();
            if (transfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                dndObj = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
                Object tempObj = dndObj.get(0);
                if (tempObj instanceof DNDList) {
                    event.acceptDrop(2);
                    this.addItemsToTable();
                    event.getDropTargetContext().dropComplete(true);
                } else {
                    event.rejectDrop();
                }
            } else {
                event.rejectDrop();
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            event.rejectDrop();
        }
    }

    protected WsAbstractAction createAddItemAction() {
        return new cAddItemAction();
    }

    protected WsAbstractAction createAddAllAction() {
        return new cAddAllAction();
    }

    protected WsAbstractAction createRemoveItemAction() {
        return new cRemoveItemAction();
    }

    protected WsAbstractAction createRemoveAllAction() {
        return new cRemoveAllAction();
    }

    protected WsAbstractAction createMoveUpAction() {
        return new cMoveUpAction();
    }

    protected WsAbstractAction createMoveDownAction() {
        return new cMoveDownAction();
    }

    class DNDList
    extends JList
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        DragSource m_dragSource;
        DropTarget m_dropTarget;

        public DNDList(DefaultListModel dlm) {
            super(dlm);
        }

        public void initialize() {
            this.m_dragSource = new DragSource();
            this.m_dragSource.createDefaultDragGestureRecognizer(this, 2, this);
            this.m_dropTarget = new DropTarget(this, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (SASSortByPropertyTab.this.m_list.getSelectedIndices().length == 1) {
                DNDObject DNDO = new DNDObject((Object)this);
                this.m_dragSource.startDrag(dge, null, (Transferable)DNDO, this);
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            try {
                Vector dndObj = null;
                Transferable transfer = event.getTransferable();
                if (transfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                    dndObj = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
                    Object tempObj = dndObj.get(0);
                    if (tempObj instanceof DNDTable) {
                        event.acceptDrop(2);
                        SASSortByPropertyTab.this.removeItemsFromTable();
                        event.getDropTargetContext().dropComplete(true);
                    } else {
                        event.rejectDrop();
                    }
                } else {
                    event.rejectDrop();
                }
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                event.rejectDrop();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    class ListBoxListSelectionListener
    implements ListSelectionListener {
        ListBoxListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || !SASSortByPropertyTab.this.isEditable()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                SASSortByPropertyTab.this.m_table.clearSelection();
            }
            SASSortByPropertyTab.this.enableButtons();
        }
    }

    class ListMouseListener
    extends MouseAdapter {
        ListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (SASSortByPropertyTab.this.m_list == e.getSource()) {
                    SASSortByPropertyTab.this.addItemsToTable();
                } else {
                    SASSortByPropertyTab.this.removeItemsFromTable();
                }
            }
        }
    }

    class ListFocusListener
    extends FocusAdapter {
        ListFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            JList list = (JList)e.getComponent();
            if (list.getSelectedIndex() == -1 && SASSortByPropertyTab.this.isEditable() && list.getModel().getSize() > 0) {
                list.setSelectedIndex(0);
            }
            SASSortByPropertyTab.this.enableButtons();
        }
    }

    public class SASSortByModel
    extends WsAbstractTableModel {
        protected boolean[] isColumnEditable = new boolean[]{false, true};
        public static final int COLUMN_COL = 0;
        public static final int SORTORDER_COL = 1;
        public static final int TOTAL_COLS = 2;
        protected static final int COLUMN_COL_WIDTH = 75;
        protected static final int SORTORDER_COL_WIDTH = 75;

        public SASSortByModel(Transformation inObject) {
            SASSortByPropertyTab.this.m_metadata = inObject;
            if (SASSortByPropertyTab.this.m_cellChoices == null) {
                SASSortByPropertyTab.this.m_cellChoices = new ArrayList();
            }
            SASSortByPropertyTab.this.m_cellChoices.add(m_sortOrderArray[0][1]);
            SASSortByPropertyTab.this.m_cellChoices.add(m_sortOrderArray[1][1]);
            this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
            this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("SASSortByPropertyTab.column.name.txt"), 75);
            this.m_aColumns[0].setEditable(false);
            WsEnumeratedTableColumn sortOrderColumn = new WsEnumeratedTableColumn(1, bundle.getString("SASSortByPropertyTab.sortOrder.txt"), 75);
            if (SASSortByPropertyTab.this.m_cellChoices != null && SASSortByPropertyTab.this.m_cellChoices.size() > 0) {
                sortOrderColumn.setPossibleValues(SASSortByPropertyTab.this.m_cellChoices.toArray(new String[0]));
            }
            this.m_aColumns[1] = sortOrderColumn;
        }

        public SASSortByModel() {
        }

        public void setMetadataObject(CMetadata inObject) {
            SASSortByPropertyTab.this.m_metadata = inObject;
        }

        public void populateStore() {
        }

        public void moveDataToModel() throws MdException, RemoteException {
            for (int i = this.getRowCount() - 1; i >= 0; --i) {
                this.deleteRow(i);
            }
            Select s = (Select)SASSortByPropertyTab.this.m_metadata;
            OrderByClause obc = s.getOrderByForSelect();
            AssociationList byColumnsList = obc == null ? new AssociationList("Columns") : obc.getColumns();
            AssociationList ptList = SASSortByPropertyTab.this.m_sourceTable ? s.getClassifierSources() : s.getClassifierTargets();
            AssociationList columnsList = null;
            if (ptList.size() > 0) {
                DataTable pt = (DataTable)ptList.get(0);
                columnsList = pt.getColumns();
            }
            if (columnsList != null && columnsList.size() > 0) {
                block1: for (int i = 0; i < byColumnsList.size(); ++i) {
                    Column col = (Column)byColumnsList.get(i);
                    for (int j = 0; j < columnsList.size(); ++j) {
                        Column clCol = (Column)columnsList.get(j);
                        if (clCol != col) continue;
                        String colName = col.getSASColumnName();
                        String sortOrder = col.getSortOrder();
                        String trnsSortOrder = "";
                        trnsSortOrder = sortOrder.equals(m_sortOrderArray[0][0]) ? m_sortOrderArray[0][1] : m_sortOrderArray[1][1];
                        this.insertRow(colName, trnsSortOrder);
                        continue block1;
                    }
                }
            }
        }

        public void moveDataToStore() throws MdException, RemoteException {
            AssociationList byColumns;
            boolean change = false;
            Select s = (Select)SASSortByPropertyTab.this.m_metadata;
            OrderByClause obc = s.getOrderByForSelect();
            if (obc == null) {
                obc = (OrderByClause)Workspace.getMdFactory().createComplexMetadataObject(SASSortByPropertyTab.this.m_metadata.getObjectStore(), null, "Order By Clause", "OrderByClause", SASSortByPropertyTab.this.m_metadata.getRepositoryID(), null);
                obc.setOwningSelect(s);
            }
            if ((byColumns = obc.getColumns()).size() != this.getRowCount()) {
                change = true;
            } else {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    int index = SASSortByPropertyTab.this.m_table.convertRowIndexToModel(i);
                    String dm_colName = (String)this.getValueAt(index, 0);
                    Column col = (Column)byColumns.get(i);
                    String cl_colName = col.getSASColumnName();
                    if (cl_colName.compareTo(dm_colName) == 0) continue;
                    change = true;
                    break;
                }
            }
            AssociationList ptList = SASSortByPropertyTab.this.m_sourceTable ? s.getClassifierSources() : s.getClassifierTargets();
            if (ptList.size() > 0) {
                DataTable table = (DataTable)ptList.get(0);
                AssociationList allColumns = table.getColumns();
                if (change) {
                    byColumns.removeAllElements();
                    block1: for (int i = 0; i < this.getRowCount(); ++i) {
                        int index = SASSortByPropertyTab.this.m_table.convertRowIndexToModel(i);
                        String dm_colName = (String)this.getValueAt(index, 0);
                        for (int j = 0; j < allColumns.size(); ++j) {
                            Column col = (Column)allColumns.get(j);
                            String cl_colName = col.getSASColumnName();
                            if (cl_colName.compareTo(dm_colName) != 0) continue;
                            byColumns.add((Object)col);
                            continue block1;
                        }
                    }
                }
                for (int i = 0; i < allColumns.size(); ++i) {
                    boolean inByColumns = false;
                    Column col = (Column)allColumns.get(i);
                    String cl_colName = col.getSASColumnName();
                    String cl_sortOrder = col.getSortOrder();
                    for (int j = 0; j < this.getRowCount(); ++j) {
                        int index = SASSortByPropertyTab.this.m_table.convertRowIndexToModel(j);
                        String dm_colName = (String)this.getValueAt(index, 0);
                        String dm_transSortOrder = (String)this.getValueAt(index, 1);
                        String dm_sortOrder = "";
                        dm_sortOrder = m_sortOrderArray[0][1].equals(dm_transSortOrder) ? m_sortOrderArray[0][0] : m_sortOrderArray[1][0];
                        if (cl_colName.compareTo(dm_colName) != 0) continue;
                        if (cl_sortOrder == null || cl_sortOrder.compareTo(dm_sortOrder) != 0) {
                            col.setSortOrder(dm_sortOrder);
                        }
                        inByColumns = true;
                        break;
                    }
                    if (inByColumns || cl_sortOrder == null || cl_sortOrder.compareTo("") == 0) continue;
                    col.setSortOrder(WsColumnMetadataUtil.NONE);
                }
            }
        }

        public int getColumnCount() {
            return 2;
        }

        public boolean isCellEditable(int row, int col) {
            boolean coledit = this.isColumnEditable[col];
            return coledit;
        }

        public boolean insertRow(String colName, String sortOrder) {
            ArrayList<String> m = new ArrayList<String>();
            m.add(colName);
            m.add(sortOrder);
            super.insertRow(this.getRowCount() - 1, m);
            return true;
        }

        public ArrayList getCellChoices() {
            return SASSortByPropertyTab.this.m_cellChoices;
        }
    }

    class DNDTable
    extends WsTable
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        DragSource m_dragSource;
        DropTarget m_dropTarget;

        public DNDTable(SASSortByModel ssbm) {
            super((WsAbstractTableModel)ssbm);
        }

        public void initialize() {
            this.m_dragSource = new DragSource();
            this.m_dragSource.createDefaultDragGestureRecognizer((Component)((Object)this), 2, this);
            this.m_dropTarget = new DropTarget((Component)((Object)this), this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (SASSortByPropertyTab.this.m_table.getSelectedRowsFromSelectedCells().length == 1) {
                DNDObject DNDO = new DNDObject((Object)this);
                this.m_dragSource.startDrag(dge, null, (Transferable)DNDO, this);
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            try {
                Vector dndObj = null;
                Transferable transfer = event.getTransferable();
                if (transfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                    dndObj = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
                    Object tempObj = dndObj.get(0);
                    if (tempObj instanceof DNDList) {
                        event.acceptDrop(2);
                        SASSortByPropertyTab.this.addItemsToTable();
                        event.getDropTargetContext().dropComplete(true);
                    } else {
                        event.rejectDrop();
                    }
                } else {
                    event.rejectDrop();
                }
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                event.rejectDrop();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    protected class TableRowModelListener
    implements WsTableRowModelListener {
        protected TableRowModelListener() {
        }

        public void rowDragged(TableRowModelEvent e) {
            SASSortByPropertyTab.this.setDataChanged(true);
        }

        public void rowsHidden(WsTableRowModelEvent e) {
        }

        public void rowsShown(WsTableRowModelEvent e) {
        }

        public void rowsRemapped(ChangeEvent e) {
            SASSortByPropertyTab.this.setDataChanged(true);
        }
    }

    class TableSelectionListener
    implements ListSelectionListener {
        TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || !SASSortByPropertyTab.this.isEditable()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                SASSortByPropertyTab.this.m_list.clearSelection();
            }
            SASSortByPropertyTab.this.enableButtons();
        }
    }

    class ModelListener
    implements TableModelListener {
        ModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            SASSortByPropertyTab.this.setDataChanged(SASSortByPropertyTab.this.isEditable());
        }
    }

    protected class DeleteTableRowAction
    extends WsAbstractAction {
        public DeleteTableRowAction() {
            super(bundle, "SASSortByPropertyTab.Delete", true);
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent e) {
            SASSortByPropertyTab.this.removeItemsFromTable();
        }
    }

    class DNDScrollPane
    extends JScrollPane
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        DropTarget m_dropTarget = new DropTarget(this, this);

        @Override
        public void drop(DropTargetDropEvent event) {
            try {
                Vector dndObj = null;
                Transferable transfer = event.getTransferable();
                if (transfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                    dndObj = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
                    Object tempObj = dndObj.get(0);
                    if (tempObj instanceof DNDList) {
                        event.acceptDrop(2);
                        SASSortByPropertyTab.this.addItemsToTable();
                        event.getDropTargetContext().dropComplete(true);
                    } else {
                        event.rejectDrop();
                    }
                } else {
                    event.rejectDrop();
                }
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                event.rejectDrop();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    protected class cUndoableChange
    extends WAUndoable {
        Vector m_vector;
        String m_changeType;

        public cUndoableChange(String changeType, Vector undoVector) {
            this.m_changeType = changeType;
            this.m_vector = undoVector;
        }

        public void undo() {
            super.undo();
            if (this.m_changeType.equals("ADD")) {
                this.remove();
            } else if (this.m_changeType.equals("REMOVE")) {
                this.add();
            }
        }

        public void redo() {
            super.redo();
            if (this.m_changeType.equals("ADD")) {
                this.add();
            } else if (this.m_changeType.equals("REMOVE")) {
                this.remove();
            }
        }

        public void add() {
            ArrayList<String> columnNames = new ArrayList<String>();
            for (int v = 0; v < this.m_vector.size(); ++v) {
                String[] values = (String[])this.m_vector.get(v);
                String colName = values[0];
                columnNames.add(colName);
                int index = -1;
                for (int i = 0; i < SASSortByPropertyTab.this.m_listModel.size(); ++i) {
                    if (!((String)SASSortByPropertyTab.this.m_listModel.get(i)).equals(colName)) continue;
                    index = i;
                    break;
                }
                if (index <= -1) continue;
                SASSortByPropertyTab.this.m_listModel.remove(index);
            }
            TableModel tableModel = SASSortByPropertyTab.this.m_table.getModel();
            for (int selectionIndex = 0; selectionIndex < tableModel.getRowCount(); ++selectionIndex) {
                String columnName = (String)tableModel.getValueAt(selectionIndex, 0);
                if (!columnNames.contains(columnName)) continue;
                SASSortByPropertyTab.this.m_table.addRowSelectionInterval(selectionIndex, selectionIndex);
            }
            SASSortByPropertyTab.this.m_table.requestFocus();
        }

        public void remove() {
            SASSortByPropertyTab.this.fillListBox();
            ArrayList<String> columnNames = new ArrayList<String>();
            for (int itemIndex = 0; itemIndex < this.m_vector.size(); ++itemIndex) {
                String[] values = (String[])this.m_vector.get(itemIndex);
                columnNames.add(values[0]);
            }
            ListModel listModel = SASSortByPropertyTab.this.m_list.getModel();
            for (int selectionIndex = 0; selectionIndex < listModel.getSize(); ++selectionIndex) {
                String item = (String)listModel.getElementAt(selectionIndex);
                if (!columnNames.contains(item)) continue;
                SASSortByPropertyTab.this.m_list.addSelectionInterval(selectionIndex, selectionIndex);
            }
            SASSortByPropertyTab.this.m_list.requestFocus();
        }
    }

    protected class cAddItemAction
    extends WsAbstractAction {
        public cAddItemAction() {
            super(bundle, "SASSortByPropertyTab.AddItem", true);
        }

        public void actionPerformed(ActionEvent e) {
            SASSortByPropertyTab.this.addItemsToTable();
        }
    }

    protected class cAddAllAction
    extends WsAbstractAction {
        public cAddAllAction() {
            super(bundle, "SASSortByPropertyTab.AddAll", true);
        }

        public void actionPerformed(ActionEvent e) {
            SASSortByPropertyTab.this.m_list.setSelectionInterval(0, SASSortByPropertyTab.this.m_listModel.getSize() - 1);
            SASSortByPropertyTab.this.addItemsToTable();
        }
    }

    protected class cRemoveItemAction
    extends WsAbstractAction {
        public cRemoveItemAction() {
            super(bundle, "SASSortByPropertyTab.RemoveItem", true);
        }

        public void actionPerformed(ActionEvent e) {
            SASSortByPropertyTab.this.removeItemsFromTable();
        }
    }

    protected class cRemoveAllAction
    extends WsAbstractAction {
        public cRemoveAllAction() {
            super(bundle, "SASSortByPropertyTab.RemoveAll", true);
        }

        public void actionPerformed(ActionEvent e) {
            SASSortByPropertyTab.this.m_table.selectAll();
            SASSortByPropertyTab.this.removeItemsFromTable();
        }
    }

    protected class cMoveUpAction
    extends WsAbstractAction {
        public cMoveUpAction() {
            super(bundle, "SASSortByPropertyTab.MoveUp", true);
        }

        public void actionPerformed(ActionEvent e) {
            SASSortByPropertyTab.this.m_bIgnoreActionUpdates = true;
            SASSortByPropertyTab.this.m_table.undoableMoveSelectedRows(-1);
            SASSortByPropertyTab.this.setDataChanged(true);
            SASSortByPropertyTab.this.m_bIgnoreActionUpdates = false;
            SASSortByPropertyTab.this.enableButtons();
        }
    }

    protected class cMoveDownAction
    extends WsAbstractAction {
        public cMoveDownAction() {
            super(bundle, "SASSortByPropertyTab.MoveDown", true);
        }

        public void actionPerformed(ActionEvent e) {
            SASSortByPropertyTab.this.m_bIgnoreActionUpdates = true;
            SASSortByPropertyTab.this.m_table.undoableMoveSelectedRows(1);
            SASSortByPropertyTab.this.setDataChanged(true);
            SASSortByPropertyTab.this.m_bIgnoreActionUpdates = false;
            SASSortByPropertyTab.this.enableButtons();
        }
    }
}

