/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.wadmin.plugins.TransformHiddenInterface;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.ProcessLibFolderNode;
import com.sas.wadmin.visuals.ProcessLibTransformNode;
import com.sas.wadmin.visuals.ProcessTreeRootNode;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTreeModel;
import com.sas.workspace.WsTreeNode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProcessTreeModel
extends WorkspaceTreeModel {
    WsTreeNode m_libraryNode = null;

    public ProcessTreeModel() {
        super((WsTreeNode)new ProcessTreeRootNode());
        ProcessTreeRootNode nodeRoot = (ProcessTreeRootNode)((Object)this.getRoot());
        nodeRoot.setHasExpanded(true);
        nodeRoot.setIsExpanded(true);
        this.setAsksAllowsChildren(false);
        this.setName("Process");
    }

    public void addTransformation(TransformInterface transform) {
        this.buildTree(transform.getCategory(), (WsTreeNode)this.getRoot(), transform);
    }

    public void objectsCreated(MdEvent e, List lObjects) {
        try {
            TransformManager.getInstance().objectsCreated(this.getObjects(lObjects));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void objectsModified(MdEvent e, List lObjects) {
        try {
            TransformManager.getInstance().objectsModified(this.getObjects(lObjects));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void objectDeleted(MdEvent e, String sFQID) {
        ArrayList lNodes = this.findNodes(sFQID);
        if (!lNodes.isEmpty()) {
            TransformInterface transform = ((ProcessLibTransformNode)((Object)lNodes.get(0))).getTransformationObject();
            TransformManager.getInstance().removeTransformation(transform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCreatedObjects(Map mapObjects) {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "WorkspaceTreeModel:updateCreateObjects");
            try {
                List lObjects = this.createObjectsInStore(store, mapObjects);
                this.populateObjects(lObjects);
                TransformManager.getInstance().objectsCreated(lObjects);
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateModifiedObjects(Map mapObjects) {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "WorkspaceTreeModel:updateCreateObjects");
            try {
                List lObjects = this.createObjectsInStore(store, mapObjects);
                if (lObjects == null) {
                    return;
                }
                this.populateObjects(lObjects);
                TransformManager.getInstance().objectsModified(lObjects);
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected void removeDeletedObjects(String[] saFQIDs) {
        WsTreeNode nodeRoot = (WsTreeNode)this.getRoot();
        for (int iFQID = 0; iFQID < saFQIDs.length; ++iFQID) {
            ArrayList lNodes = this.findNodes(nodeRoot, saFQIDs[iFQID]);
            if (lNodes.isEmpty()) continue;
            TransformInterface transform = ((ProcessLibTransformNode)((Object)lNodes.get(0))).getTransformationObject();
            TransformManager.getInstance().removeTransformation(transform);
        }
    }

    private List createObjectsInStore(MdObjectStore store, Map mapObjects) throws RemoteException {
        Set setKeys = mapObjects.keySet();
        if (setKeys.size() == 0) {
            return null;
        }
        String[] saKeys = new String[setKeys.size()];
        setKeys.toArray(saKeys);
        ArrayList<CMetadata> lObjects = new ArrayList<CMetadata>(saKeys.length);
        for (int iKey = 0; iKey < saKeys.length; ++iKey) {
            lObjects.add(Workspace.getMdFactory().createComplexMetadataObject(store, (String)null, (String)mapObjects.get(saKeys[iKey]), saKeys[iKey]));
        }
        return lObjects;
    }

    public void objectsCheckedIn(ArrayList alObjects) {
        TransformManager.getInstance().objectsModified(alObjects);
    }

    private void buildTree(String sPath, WsTreeNode nodeParent, TransformInterface transform) {
        if (transform instanceof TransformHiddenInterface) {
            return;
        }
        while (sPath.length() > 0) {
            String sFolder;
            int iSep = sPath.indexOf(46);
            if (iSep == -1) {
                sFolder = sPath;
                sPath = "";
            } else {
                sFolder = sPath.substring(0, iSep);
                sPath = sPath.substring(iSep + 1);
            }
            WsTreeNode nodeFolder = this.findFolder(nodeParent, sFolder);
            if (nodeFolder == null) {
                nodeFolder = new ProcessLibFolderNode(sFolder);
                this.addChild(nodeFolder, nodeParent);
            }
            nodeParent = nodeFolder;
        }
        ProcessLibTransformNode newnode = new ProcessLibTransformNode(transform);
        this.addChild(newnode, nodeParent);
    }

    private WsTreeNode findFolder(WsTreeNode nodeParent, String sFolderName) {
        for (int iChild = 0; iChild < nodeParent.getChildCount(); ++iChild) {
            WsTreeNode nodeChild = (WsTreeNode)nodeParent.getChildAt(iChild);
            if (!nodeChild.getName().equalsIgnoreCase(sFolderName)) continue;
            return nodeChild;
        }
        return null;
    }

    public void removeTransformation(String sTransformClass) {
        ProcessLibTransformNode node = this.findTransformationNode(sTransformClass);
        if (node != null) {
            WsTreeNode nodeParent;
            do {
                nodeParent = (WsTreeNode)node.getParent();
                this.removeChild(node);
            } while ((node = nodeParent).getChildCount() == 0);
        }
    }

    private ProcessLibTransformNode findTransformationNode(String sTransformClass) {
        return this.findTransformationNode((WsTreeNode)this.getRoot(), sTransformClass);
    }

    private ProcessLibTransformNode findTransformationNode(WsTreeNode node, String sTransformClass) {
        for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
            ProcessLibTransformNode nodeTransform;
            WsTreeNode nodeChild = (WsTreeNode)node.getChildAt(iChild);
            if (!(nodeChild instanceof ProcessLibTransformNode ? (nodeTransform = (ProcessLibTransformNode)nodeChild).getTransformationObject().getTransformClass().equals(sTransformClass) : (nodeTransform = this.findTransformationNode(nodeChild, sTransformClass)) != null)) continue;
            return nodeTransform;
        }
        return null;
    }
}

