/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.model.tree.OSNodeFilter;
import com.sas.wadmin.visuals.ObjectsSelectorTreeModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTree;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ObjectSelectorPanel
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ObjectSelectorPanel.class);
    public static final int CUSTOM_TREE = 1;
    public static final int MINING_TREE = 2;
    public static final int ALL_TREES = 255;
    private WATextArea m_txtDescription;
    private JSeparator m_separator;
    private WsTree m_tree;
    private JScrollPane m_scrTree;
    private JCheckBox m_ckbSortColumns;
    private JLabel m_lblSelection;
    private WATextField m_txtSelection;
    private WsAbstractAction m_actClear;
    private JButton m_btnClear;
    private String m_sSelectionType;
    private String m_sDescription;
    private MdObjectStore m_storeReturnedObject;
    private boolean m_bReturnExistingObject;
    private Root m_mdoSelected;
    private boolean m_bExpandRepositoryNodes;
    private boolean m_bShowClear;
    private boolean m_bOptional;
    private boolean m_bUpdateDataChanged;
    private boolean m_bDoDataExchanged;
    private MdObjectStore m_storeLocal;
    private ObjectsSelectorTreeModel m_mdlTree;

    public ObjectSelectorPanel(String sSelectionType) {
        this(sSelectionType, null);
    }

    public ObjectSelectorPanel(String sSelectionType, String sDescription) {
        this(sSelectionType, sDescription, true);
    }

    public ObjectSelectorPanel(String sSelectionType, String sDescription, boolean bShowClear) {
        this.m_sSelectionType = sSelectionType;
        this.m_sDescription = sDescription;
        this.m_bShowClear = bShowClear;
        this.initialize();
    }

    protected void initialize() {
        try {
            this.m_storeLocal = Workspace.getWorkspace().getMdObjectFactory().createObjectStore(null, "ObjectsSelectorPanel");
            this.setReturnExistingObject(true);
            if (this.m_sDescription != null) {
                this.m_txtDescription = new WATextArea();
                this.m_txtDescription.setText(this.m_sDescription);
                this.m_txtDescription.setColumns(30);
                this.m_txtDescription.setBehavior(1);
                this.m_txtDescription.setAutosize(true);
                this.m_separator = new JSeparator(0);
            }
            if (this.m_sSelectionType.equals("Column")) {
                this.m_ckbSortColumns = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ObjectsSelectorPanel.Checkbox.SortColumns");
                this.m_ckbSortColumns.addActionListener(new cSortColumnsListener());
            }
            this.m_mdlTree = new ObjectsSelectorTreeModel(this.m_storeLocal);
            this.setTypesToShow(new String[]{"PhysicalTable", "Column"});
            this.m_tree = new WsTree((DefaultTreeModel)((Object)this.m_mdlTree));
            this.m_tree.getSelectionModel().setSelectionMode(1);
            this.m_tree.setPopupMenuEnabled(false);
            this.m_tree.setEditable(false);
            this.m_tree.addTreeSelectionListener((TreeSelectionListener)new cTreeSelectionListener());
            this.m_scrTree = new JScrollPane((Component)this.m_tree);
            this.m_mdlTree.addListenersToTree((JTree)this.m_tree);
            this.m_txtSelection = new WATextField();
            this.m_txtSelection.setBehavior(2);
            int w = this.m_bShowClear ? 1 : 2;
            String sLabelKey = "ObjectSelectorPanel.Label.Selected" + this.m_sSelectionType;
            this.m_lblSelection = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtSelection, (WAdminResource)bundle, (String)sLabelKey);
            this.m_actClear = new cClearAction();
            this.m_btnClear = new JButton((Action)this.m_actClear);
            this.setPreferredSize(new Dimension(450, 300));
            this.setLayout(new GridBagLayout());
            if (this.m_sDescription != null) {
                this.add((Component)this.m_txtDescription, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.add(this.m_separator, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 5, 0), 0, 0));
            }
            this.add(this.m_scrTree, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            if (this.m_sSelectionType.equals("Column")) {
                this.add(this.m_ckbSortColumns, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            }
            this.add(this.m_lblSelection, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)this.m_txtSelection, new GridBagConstraints(1, 4, w, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
            if (this.m_bShowClear) {
                this.add(this.m_btnClear, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void setRepositoriesToShow(List lRepositories) {
        this.m_mdlTree.setRepositories(lRepositories);
    }

    public List getRepositoriesToShow() {
        return this.m_mdlTree.getRepositories();
    }

    public void addInventoryNodes(String[] title, String[] saType) {
        this.m_mdlTree.addInventoryNodes(title, saType);
    }

    public void addInventoryNode(String title, String saType) {
        this.addInventoryNodes(new String[]{title}, new String[]{saType});
    }

    public void setExpandRepositoryNodes(boolean bExpandRepositoryNodes) {
        this.m_bExpandRepositoryNodes = bExpandRepositoryNodes;
    }

    public boolean isExpandRepositoryNodes() {
        return this.m_bExpandRepositoryNodes;
    }

    public void setNodeFilter(OSNodeFilter filter) {
        this.m_mdlTree.setNodeFilter(filter);
    }

    public void setTreesToShow(int eTree) {
        this.m_mdlTree.setTreesToShow(eTree);
    }

    public int getTreesToShow() {
        return this.m_mdlTree.getTreesToShow();
    }

    public void setTypesToShow(String[] saTypes) {
        this.m_mdlTree.setTypesToShow(saTypes);
    }

    public String[] getTypesToShow() {
        return this.m_mdlTree.getTypesToShow();
    }

    public void setColumnTypeToShow(int eType) {
        this.m_mdlTree.setColumnTypeToShow(eType);
    }

    public int getColumnTypeToShow() {
        return this.m_mdlTree.getColumnTypeToShow();
    }

    public void setReturnExistingObject(boolean bExisting) {
        this.m_bReturnExistingObject = bExisting;
    }

    public boolean isReturnExistingObject() {
        return this.m_bReturnExistingObject;
    }

    public void setReturnedObjectStore(MdObjectStore store) {
        this.m_storeReturnedObject = store;
    }

    public MdObjectStore getReturnedObjectsStore() {
        return this.m_storeReturnedObject;
    }

    public void setSelectedObject(Root mdoSelected) {
        this.m_mdoSelected = mdoSelected;
    }

    public Root getSelectedObject() {
        return this.m_mdoSelected;
    }

    public void setTreeModelComparator(Comparator cmp) {
        this.m_mdlTree.setComparator(cmp);
    }

    public Comparator getTreeModelComparator() {
        return this.m_mdlTree.getComparator();
    }

    public void setSelectionOptional(boolean bOptional) {
        this.m_bOptional = bOptional;
    }

    public boolean isSelectionOptional() {
        return this.m_bOptional;
    }

    public void setUpdateDataChanged(boolean bUpdateDataChanged) {
        this.m_bUpdateDataChanged = bUpdateDataChanged;
    }

    public boolean isUpdatingDataChanged() {
        return this.m_bUpdateDataChanged;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tree.setEnabled(bEditable);
    }

    public void setDefaultAction(Action actDefault) {
        super.setDefaultAction(actDefault);
        if (actDefault instanceof AbstractAction) {
            this.m_tree.setUserDefaultAction((AbstractAction)actDefault);
        }
    }

    public boolean validateData() {
        WsTreeNode node = this.m_tree.getSelectedNode();
        if (node == null) {
            if (this.m_bOptional) {
                return true;
            }
            String sMessageKey = "ObjectSelectorPanel.Error." + this.m_sSelectionType + "SelectionRequired.txt";
            MessageUtil.displayMessage((String)bundle.getString(sMessageKey), (int)0);
            return false;
        }
        try {
            Root mdoData;
            if (node instanceof WsDataTreeNode && (mdoData = (Root)((WsDataTreeNode)node).getMetadata()).getCMetadataType().equals(this.m_sSelectionType)) {
                return true;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        String sMessageKey = "ObjectSelectorPanel.Error." + this.m_sSelectionType + "SelectionRequired.txt";
        MessageUtil.displayMessage((String)bundle.getString(sMessageKey), (int)0);
        return false;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.setStorePopulated(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDataToView() throws MdException, RemoteException {
        if (this.getRepositoriesToShow() == null || this.getRepositoriesToShow().isEmpty()) {
            List lRepositories = Workspace.getWorkspace().getSelectedRepositories();
            this.setRepositoriesToShow(lRepositories);
        }
        TreePath pathRoot = new TreePath(this.m_mdlTree.getRoot());
        this.m_tree.collapsePath(pathRoot);
        this.m_tree.expandPath(pathRoot);
        if (this.m_mdoSelected == null) {
            return;
        }
        this.setListeningForChanges(false);
        try {
            Root mdoCopy = this.copyObject(this.m_mdoSelected, this.m_storeLocal, true);
            WsDataTreeNode node = this.m_mdlTree.find(mdoCopy);
            if (node != null) {
                TreePath path = new TreePath(node.getPath());
                this.m_tree.setSelectionPath(path);
                this.m_tree.scrollPathToVisible(path);
            }
        }
        finally {
            this.setListeningForChanges(true);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        WsDataTreeNode nodeSelected;
        if (this.m_storeReturnedObject == null) {
            throw new IllegalStateException("A store in which to return the object must be specified.");
        }
        if (this.m_mdoSelected != null && !this.m_bReturnExistingObject) {
            this.m_mdoSelected.delete();
            this.m_mdoSelected = null;
        }
        this.m_mdoSelected = (nodeSelected = (WsDataTreeNode)this.m_tree.getSelectedNode()) != null ? this.copyObject((Root)nodeSelected.getMetadata(), this.m_storeReturnedObject, this.m_bReturnExistingObject) : null;
        this.setDataChanged(false);
    }

    protected Root copyObject(Root oObject, MdObjectStore store, boolean bExisting) throws MdException, RemoteException {
        Workspace workspace = Workspace.getWorkspace();
        MdFactory factory = workspace.getMdObjectFactory();
        String sName = oObject.getName();
        String sType = oObject.getCMetadataType();
        String sFQID = bExisting ? oObject.getFQID() : workspace.getDefaultRepository().getFQID().substring(9, 17);
        int fState = bExisting ? 2 : 1;
        Root oReturn = (Root)factory.createComplexMetadataObject(store, sName, sType, sFQID);
        MdStoreUtil.copyObjectAttributes((CMetadata)oObject, (CMetadata)oReturn, (int)fState);
        if (sType.equals("Column") && bExisting) {
            DataTable oTable = ((Column)oObject).getTable();
            DataTable oReturnTable = (DataTable)Workspace.getMdFactory().createComplexMetadataObject(store, (CMetadata)oTable);
            MdStoreUtil.copyObjectAttributes((CMetadata)oTable, (CMetadata)oReturnTable, (int)fState);
            ((Column)oReturn).setTable(oReturnTable);
        }
        return oReturn;
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            if (!this.m_bDoDataExchanged) {
                this.m_bDoDataExchanged = true;
                this.moveDataToView();
                this.populateStore();
            }
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
    }

    public void saveSettingsAndCleanUp() {
        try {
            this.m_storeLocal.dispose();
            Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void onNext() {
        try {
            this.moveDataToStore();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void onBack() {
        try {
            this.m_storeLocal.dispose();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected class cSortColumnsListener
    implements ActionListener {
        protected cSortColumnsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ObjectSelectorPanel.this.m_mdlTree.setSortColumns(ObjectSelectorPanel.this.m_ckbSortColumns.isSelected());
        }
    }

    protected class cTreeSelectionListener
    implements TreeSelectionListener {
        protected cTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (ObjectSelectorPanel.this.m_bUpdateDataChanged) {
                ObjectSelectorPanel.this.setDataChanged(true);
            }
            ObjectSelectorPanel.this.m_txtSelection.setText("");
            WsTreeNode node = ObjectSelectorPanel.this.m_tree.getSelectedNode();
            if (node instanceof WsDataTreeNode) {
                Root mdoData = (Root)((WsDataTreeNode)node).getMetadata();
                try {
                    if (mdoData.getCMetadataType().equals(ObjectSelectorPanel.this.m_sSelectionType)) {
                        ObjectSelectorPanel.this.m_txtSelection.setText(node.getName());
                    }
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
        }
    }

    protected class cClearAction
    extends WsAbstractAction {
        public cClearAction() {
            super(bundle, "ObjectSelectorPanel.Action.Clear", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ObjectSelectorPanel.this.m_tree.clearSelection();
        }
    }
}

