/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.efi2.NewDelimitedExternalTableWizard;
import com.sas.wadmin.efi2.NewFixedWidthExternalTableWizard;
import com.sas.wadmin.efi2.NewUserWrittenExternalTableWizard;
import com.sas.wadmin.plugins.NewObjectInterface;
import com.sas.wadmin.visuals.JobTreeNode;
import com.sas.wadmin.visuals.NewDocumentWizard;
import com.sas.wadmin.visuals.NewGlobalsWizard;
import com.sas.wadmin.visuals.NewGroupTypeWizard;
import com.sas.wadmin.visuals.NewGroupWizard;
import com.sas.wadmin.visuals.NewGroupWizardTab;
import com.sas.wadmin.visuals.NewJobWizard;
import com.sas.wadmin.visuals.NewNoteWizard;
import com.sas.wadmin.visuals.NewReportWizard;
import com.sas.wadmin.visuals.TargetTableDesigner;
import com.sas.workspace.AbstractDesigner;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAWizardModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WizardTabInfo;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.mgmt.visuals.LibraryWizard;
import com.sas.workspace.mgmt.visuals.ServerWizard;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.plugins.MultipleNodeInterface;
import com.sas.workspace.plugins.TreeNodeInterface;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class NewObjectWizard
extends AbstractDesigner {
    public static final String DELIMITED_EXTERNAL_TABLE = "Delimited";
    public static final String FIXED_WIDTH_EXTERNAL_TABLE = "FixedWidth";
    public static final String USER_WRITTEN_EXTERNAL_TABLE = "UserWritten";
    public static final String NEW_OBJECT_KEY = "NEWOBJECT";
    protected int transitionListSize = 2;
    private static WAdminResource bundle = WAdminResource.getBundle(NewObjectWizard.class);
    protected CMetadata m_newObject = null;
    protected NewObjectInterface m_jobPlugin;
    protected NewGlobalsWizard m_globalsWizard = null;
    protected boolean m_fSuccess = true;
    protected Tree m_groupTree;
    public static final int DEFAULT = 0;
    public static final int EXTERNALTABLES = 1;

    public static boolean isTypeSupported(String sType) {
        return sType.equals("Cube") || sType.equals("ExternalTable") || sType.equals("PhysicalTable") || sType.equals("TextStore") || sType.equals("Document") || sType.equals("Job") || sType.equals("SASLibrary") || sType.equals("DeployedComponent") || sType.equals("Tree");
    }

    public NewObjectWizard(Frame frame, String title, int type) {
        super(frame, title);
        this.setHelpProduct("wdb");
        this.setHelpTopic("newobjectwiz");
        this.addWizardData("FINISHINFO", "");
        this.addWizardData("ELEMENT", " ");
        this.addWizardData("NAME", " ");
        this.addWizardData("TREE", null);
        this.m_wizardModel = new WATransitionWizardModel();
        this.setWizardModel((WAWizardModel)this.m_wizardModel);
        AbstractDesigner.cAbstractDesignerRootNode nodeRoot = new AbstractDesigner.cAbstractDesignerRootNode((AbstractDesigner)this, bundle.getString("NewObjectTree.Top.txt"), bundle.getString("NewObjectTree.tooltip.txt"));
        this.m_treeModel = new cNewObjectWizardTreeModel((AbstractDesigner.cAbstractDesignerTreeNode)nodeRoot);
        ImageIcon image = bundle.getImageIcon("NewObjectWizard.image");
        this.addTab(bundle.getString("NewObjectWizard.Title"), "NewObjectWizardtab1", (WAPropertyTab)new cSelectTab(bundle.getString("NewObjectWizard.Select"), "NewObjectWizardtab1"), "wa_object_type.gif", image, false);
        if (type == 0) {
            this.buildTree(new TargetTableDesigner(), nodeRoot);
            this.buildTree(new NewJobWizard(), nodeRoot);
            this.buildTree(new NewNoteWizard(), nodeRoot);
            this.buildTree(new NewDocumentWizard(), nodeRoot);
            this.buildTree(new NewGroupTypeWizard("NewGroupWizard", NewGroupWizardTab.GROUPTYPE_GENERIC), nodeRoot);
            this.buildTree(new NewDelimitedExternalTableWizard(null), nodeRoot);
            this.buildTree(new NewFixedWidthExternalTableWizard(null), nodeRoot);
            this.buildTree(new NewUserWrittenExternalTableWizard(null), nodeRoot);
            this.m_globalsWizard = new NewGlobalsWizard();
            for (int i = 0; i < this.m_globalsWizard.getNames().size(); ++i) {
                this.buildTree(this.m_treeModel, (String)this.m_globalsWizard.getNames().get(i), (AbstractDesigner.cAbstractDesignerTreeNode)nodeRoot, this.m_globalsWizard, false, true, i);
            }
            ArrayList plugins = Workspace.getWorkspace().getPluginLoader().getPlugins("com.sas.wadmin.plugins.NewObjectInterface");
            for (int i = 0; i < plugins.size(); ++i) {
                NewObjectInterface plugin = (NewObjectInterface)plugins.get(i);
                if (plugin instanceof MultipleNodeInterface) {
                    MultipleNodeInterface inter = (MultipleNodeInterface)plugin;
                    for (int j = 0; j < inter.getNames().size(); ++j) {
                        this.buildTree(this.m_treeModel, (String)inter.getNames().get(j), (AbstractDesigner.cAbstractDesignerTreeNode)nodeRoot, plugin, false, true, j);
                    }
                    continue;
                }
                this.buildTree(this.m_treeModel, plugin.getCategory(), (AbstractDesigner.cAbstractDesignerTreeNode)nodeRoot, plugin, false, false);
            }
        } else if (type == 1) {
            this.buildTree(new NewDelimitedExternalTableWizard(null), nodeRoot);
            this.buildTree(new NewFixedWidthExternalTableWizard(null), nodeRoot);
            this.buildTree(new NewUserWrittenExternalTableWizard(null), nodeRoot);
            this.m_globalsWizard = new NewGlobalsWizard();
        }
        this.m_tree.expandPath(new TreePath(nodeRoot.getPath()));
        int numChildren = nodeRoot.getChildCount();
        AbstractDesigner.cAbstractDesignerRootNode nodeParent = nodeRoot;
        for (int i = 0; i < numChildren; ++i) {
            AbstractDesigner.cAbstractDesignerTreeNode childNode = (AbstractDesigner.cAbstractDesignerTreeNode)nodeParent.getChildAt(i);
            this.m_tree.expandPath(new TreePath(childNode.getPath()));
        }
        this.m_tree.setSelectionRow(0);
        String[][] transitionList = new String[][]{{"NewObjectWizardtab1", "NEXT", "temptab2"}, {"temptab2", "NEXT", "temptab3"}};
        this.m_wizardModel.addTransitions(transitionList);
    }

    public NewObjectWizard(Frame frame, String title, ArrayList aMetadataTypes) {
        super(frame, title);
        NewObjectInterface plugin;
        this.addWizardData("FINISHINFO", "");
        this.addWizardData("ELEMENT", " ");
        this.addWizardData("NAME", " ");
        this.addWizardData("TREE", null);
        this.m_wizardModel = new WATransitionWizardModel();
        this.setWizardModel((WAWizardModel)this.m_wizardModel);
        AbstractDesigner.cAbstractDesignerRootNode nodeRoot = new AbstractDesigner.cAbstractDesignerRootNode((AbstractDesigner)this, bundle.getString("NewObjectTree.Top.txt"), bundle.getString("NewObjectTree.tooltip.txt"));
        this.m_treeModel = new AbstractDesigner.cAbstractDesignerTreeModel((AbstractDesigner)this, (AbstractDesigner.cAbstractDesignerTreeNode)nodeRoot);
        ImageIcon image = bundle.getImageIcon("NewObjectWizard.image");
        this.addTab(bundle.getString("NewObjectWizard.Title"), "NewObjectWizardtab1", (WAPropertyTab)new cSelectTab(bundle.getString("NewObjectWizard.Select"), "NewObjectWizardtab1"), "wa_object_type.gif", image, false);
        ArrayList plugins = Workspace.getWorkspace().getPluginLoader().getPlugins("com.sas.wadmin.plugins.NewObjectInterface");
        for (int i = 0; i < plugins.size(); ++i) {
            String type;
            plugin = (NewObjectInterface)plugins.get(i);
            if (!(plugin instanceof TreeNodeInterface) || !aMetadataTypes.contains(type = ((TreeNodeInterface)plugin).getCMetadataType())) continue;
            this.buildTree(this.m_treeModel, plugin.getCategory(), (AbstractDesigner.cAbstractDesignerTreeNode)nodeRoot, plugin, false, false);
        }
        if (aMetadataTypes.contains("PhysicalTable")) {
            plugin = new NewGlobalsWizard();
            this.m_globalsWizard = (NewGlobalsWizard)plugin;
            MultipleNodeInterface inter = (MultipleNodeInterface)plugin;
            for (int i = 0; i < inter.getNames().size(); ++i) {
                if (!((String)inter.getNames().get(i)).equals(bundle.getString("NewGlobalsWizard.Name.SourceDesigner.txt"))) continue;
                this.buildTree(this.m_treeModel, (String)inter.getNames().get(i), (AbstractDesigner.cAbstractDesignerTreeNode)nodeRoot, plugin, false, true, i);
            }
            plugin = new TargetTableDesigner();
            this.buildTree(this.m_treeModel, plugin.getCategory(), (AbstractDesigner.cAbstractDesignerTreeNode)nodeRoot, plugin, false, false);
        }
        if (aMetadataTypes.contains("Job")) {
            plugin = new NewJobWizard();
            this.buildTree(this.m_treeModel, plugin.getCategory(), (AbstractDesigner.cAbstractDesignerTreeNode)nodeRoot, plugin, false, false);
        }
        if (aMetadataTypes.contains("TextStore")) {
            plugin = new NewNoteWizard();
            this.buildTree(this.m_treeModel, plugin.getCategory(), (AbstractDesigner.cAbstractDesignerTreeNode)nodeRoot, plugin, false, false);
        }
        if (aMetadataTypes.contains("Document")) {
            plugin = new NewDocumentWizard();
            this.buildTree(this.m_treeModel, plugin.getCategory(), (AbstractDesigner.cAbstractDesignerTreeNode)nodeRoot, plugin, false, false);
        }
        if (aMetadataTypes.contains("Report")) {
            plugin = new NewReportWizard();
            this.buildTree(this.m_treeModel, plugin.getCategory(), (AbstractDesigner.cAbstractDesignerTreeNode)nodeRoot, plugin, false, false);
        }
        this.m_tree.expandPath(new TreePath(nodeRoot.getPath()));
        int numChildren = nodeRoot.getChildCount();
        AbstractDesigner.cAbstractDesignerRootNode nodeParent = nodeRoot;
        for (int i = 0; i < numChildren; ++i) {
            AbstractDesigner.cAbstractDesignerTreeNode childNode = (AbstractDesigner.cAbstractDesignerTreeNode)nodeParent.getChildAt(i);
            this.m_tree.expandPath(new TreePath(childNode.getPath()));
        }
        this.m_tree.setSelectionRow(0);
        String[][] transitionList = new String[][]{{"NewObjectWizardtab1", "NEXT", "temptab2"}, {"temptab2", "NEXT", "temptab3"}};
        this.m_wizardModel.addTransitions(transitionList);
    }

    public NewObjectWizard(Frame frame, String title, Tree tree) {
        this(frame, title);
        this.addWizardData("GROUP", tree);
        this.m_groupTree = tree;
    }

    public NewObjectWizard(Frame frame, String title) {
        this(frame, title, 0);
    }

    public NewObjectWizard(Frame frame, String title, NewObjectInterface plugin, String sGroupType) {
        super(frame, title);
        this.addWizardData("FINISHINFO", "");
        this.addWizardData("ELEMENT", " ");
        this.addWizardData("NAME", " ");
        this.addWizardData("TREE", null);
        this.m_wizardModel = new WATransitionWizardModel();
        this.setWizardModel((WAWizardModel)this.m_wizardModel);
        this.addWizardData("GROUP", null);
        plugin.initializeWizard((WAWizardDialog)this, this.m_wizardModel);
    }

    public NewObjectWizard(Frame frmParent, String sTitle, String sType, String sSubType) {
        this(frmParent, sTitle, sType, sSubType, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NewObjectWizard(Frame frmParent, String sTitle, String sType, String sSubType, SimpleObject folder) {
        super(frmParent, sTitle);
        Workspace work = Workspace.getWorkspace();
        this.addWizardData("FINISHINFO", "");
        this.addWizardData("ELEMENT", " ");
        this.addWizardData("NAME", " ");
        this.addWizardData("TREE", null);
        this.addWizardData("FOLDER", folder);
        this.m_wizardModel = new WATransitionWizardModel();
        this.setWizardModel((WAWizardModel)this.m_wizardModel);
        NewObjectInterface plugin = null;
        ArrayList plugins = Workspace.getWorkspace().getPluginLoader().getPlugins("com.sas.wadmin.plugins.NewObjectInterface");
        boolean fFound = false;
        for (int i = 0; i < plugins.size(); ++i) {
            String type;
            NewObjectInterface tempPlugin = (NewObjectInterface)plugins.get(i);
            if (!(tempPlugin instanceof TreeNodeInterface) || !(type = ((TreeNodeInterface)tempPlugin).getCMetadataType()).equals(sType)) continue;
            plugin = tempPlugin;
            fFound = true;
            break;
        }
        if (!fFound) {
            if (sType.equals("ExternalTable")) {
                if (sSubType == null) {
                    throw new UnsupportedOperationException("A subtype must be specified for the new external table wizard");
                }
                if (sSubType.equals(DELIMITED_EXTERNAL_TABLE)) {
                    plugin = new NewDelimitedExternalTableWizard(folder);
                } else if (sSubType.equals(FIXED_WIDTH_EXTERNAL_TABLE)) {
                    plugin = new NewFixedWidthExternalTableWizard(folder);
                } else {
                    if (!sSubType.equals(USER_WRITTEN_EXTERNAL_TABLE)) throw new UnsupportedOperationException("An invalid subtype was specified for the new external table wizard: " + sSubType);
                    plugin = new NewUserWrittenExternalTableWizard(folder);
                }
            } else if (sType.equals("PhysicalTable")) {
                plugin = new TargetTableDesigner();
            } else if (sType.equals("Report")) {
                plugin = new NewReportWizard();
            } else if (sType.equals("TextStore")) {
                plugin = new NewNoteWizard();
            } else if (sType.equals("Document")) {
                plugin = new NewDocumentWizard();
            } else if (sType.equals("Job")) {
                plugin = new NewJobWizard();
            } else {
                if (sType.equals("SASLibrary")) {
                    try {
                        Tree tree = null;
                        tree = folder != null ? (Tree)ObjectConverter.getInstance().convertToJOMAObject(this.m_parentStore, folder) : WsMetadataUtil.getDefaultFolder((MdObjectStore)this.m_parentStore);
                        String sRepositoryID = "";
                        sRepositoryID = work.isChangeManagementOn() || tree == null ? work.getDefaultRepository().getFQID() : "A0000001." + tree.getRepositoryID();
                        LibraryWizard wizard = new LibraryWizard((JFrame)work, sRepositoryID, bundle.getString("NewLibraryWizard.Title.txt"), null, this.m_parentStore, null, tree);
                        wizard.show();
                        if (wizard.getReturnValue() == 1) {
                            this.addWizardData(NEW_OBJECT_KEY, wizard.getWizardData("Library"));
                        }
                    }
                    catch (RemoteException ex) {
                        Workspace.handleRemoteException((RemoteException)ex);
                    }
                    catch (ServiceException ex) {
                        MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
                    }
                    catch (MdException ex) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                    }
                    this.dispose();
                    return;
                }
                if (sType.equals("DeployedComponent")) {
                    try {
                        ServerWizard wizard = new ServerWizard((JFrame)work, work.getDefaultRepository().getFQID());
                        wizard.show();
                    }
                    catch (RemoteException ex) {
                        Workspace.handleRemoteException((RemoteException)ex);
                    }
                    this.dispose();
                    return;
                }
                if (!sType.equals("Tree")) throw new UnsupportedOperationException("Illegal type specified for new object wizard: " + sType);
                plugin = new NewGroupWizard();
            }
        }
        plugin.initializeWizard((WAWizardDialog)this, this.m_wizardModel);
        this.show();
    }

    public boolean isSuccessfullyInitialized() {
        return this.m_fSuccess;
    }

    public void handleGlobals() {
        if (this.getWizardData("GLOBALSWIZARD") != null) {
            NewGlobalsWizard wizard = (NewGlobalsWizard)this.getWizardData("GLOBALSWIZARD");
            if (this.m_groupTree == null) {
                wizard.launchGlobalWizard();
            } else {
                wizard.launchGlobalWizard(this.m_groupTree);
            }
            this.onCancel();
        }
    }

    protected void writeMetadata() {
        this.m_oMetadata = (CMetadata)this.getWizardData("MASTEROBJECT");
        try {
            if (this.m_oMetadata instanceof Root) {
                WsMetadataUtil.updateModifiedByFor((Root)((Root)this.m_oMetadata));
            }
            String str1 = bundle.getString("WriteMetadataProgressIndicator.Msg.Message.txt");
            String str2 = bundle.getString("WriteMetadataProgressIndicator.Msg.Title");
            OpRequestUI request = new OpRequestUI((JDialog)((Object)this), str1, str2);
            request.setProgressShownOnStatusBar(false);
            request.setDelayBeforeProgressCancelDialog(200);
            request.execute((Runnable)new InitializeRunnableWrite(), (Runnable)new InitializeRunnableLaunchPFD());
            Workspace.getDefaultLogger().debug((Object)"Finished waiting on write");
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Writing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected void onNext() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            WAPropertyTab tabCurrent = this.m_WizardModel.getCurrent().getTab();
            this.m_bNextValid = tabCurrent.validateData();
            if (!this.m_bNextValid) {
                return;
            }
            tabCurrent.onNext();
            WizardTabInfo info = this.m_WizardModel.next();
            if (info == null) {
                return;
            }
            if (!WAWizardDialog.isUsingNewStyle()) {
                this.setTitle(info.getTitle());
            }
            this.m_pnlWizard.showPanel(info);
            this.doDataExchangeOnCurrentPanel(false);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void buildTree(NewObjectInterface plugin, AbstractDesigner.cAbstractDesignerRootNode nodeRoot) {
        this.buildTree(this.m_treeModel, plugin.getCategory(), (AbstractDesigner.cAbstractDesignerTreeNode)nodeRoot, plugin, false, false);
    }

    protected class cNewObjectWizardTreeModel
    extends AbstractDesigner.cAbstractDesignerTreeModel {
        public cNewObjectWizardTreeModel(AbstractDesigner.cAbstractDesignerTreeNode nodeRoot) {
            super((AbstractDesigner)NewObjectWizard.this, nodeRoot);
        }

        public void addChild(AbstractDesigner.cAbstractDesignerTreeNode nodeNew, AbstractDesigner.cAbstractDesignerTreeNode nodeParent) {
            AbstractDesigner.cAbstractDesignerTreeNode nodeChild;
            int iChild;
            String sNew = nodeNew.toString();
            int nChildren = nodeParent.getChildCount();
            for (iChild = 0; iChild < nChildren && (nodeChild = (AbstractDesigner.cAbstractDesignerTreeNode)nodeParent.getChildAt(iChild)).toString().compareToIgnoreCase(sNew) <= 0; ++iChild) {
            }
            this.insertNodeInto((MutableTreeNode)nodeNew, (MutableTreeNode)nodeParent, iChild);
        }
    }

    protected class cSelectTab
    extends WsDescriptionWizardTab {
        protected String m_initialTab;
        protected boolean m_fRemovedOnce;
        WAWizardDialog myParent;

        public cSelectTab(String name, String initialTab) {
            super(name);
            this.m_fRemovedOnce = false;
            this.m_initialTab = initialTab;
            this._initialize();
        }

        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            if (!bSaveToModel) {
                this.myParent = (WAWizardDialog)this.getTopLevelAncestor();
                if (this.myParent.getWizardData("PREVIOUSSELECTEDNODE") != null) {
                    this.myParent.removeWizardData("PREVIOUSSELECTEDNODE");
                }
            }
            return true;
        }

        public void _initialize() {
            NewObjectWizard.this.m_tree = new AbstractDesigner.cAbstractDesignerTree((AbstractDesigner)NewObjectWizard.this, NewObjectWizard.this.m_treeModel);
            NewObjectWizard.this.m_tree.addMouseListener((MouseListener)new MouseClickListener());
            JScrollPane treeScrollPane = new JScrollPane((Component)NewObjectWizard.this.m_tree);
            this.setLayout(new GridBagLayout());
            this.add(treeScrollPane, new GridBagConstraints(0, 0, 3, 2, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public boolean validateData() {
            Object nodetype = NewObjectWizard.this.m_tree.getLastSelectedPathComponent();
            if (nodetype instanceof AbstractDesigner.cAbstractDesignerPluginNode) {
                AbstractDesigner.cAbstractDesignerPluginNode node = (AbstractDesigner.cAbstractDesignerPluginNode)nodetype;
                this.myParent.addWizardData("SELECTEDNODE", (Object)node.getNodeName());
                if (this.myParent.getWizardData("PREVIOUSSELECTEDNODE") == null) {
                    this.myParent.addWizardData("PREVIOUSSELECTEDNODE", (Object)node.getNodeName());
                }
                if (NewObjectWizard.this.m_globalsWizard.checkGlobalSelection(node.getNodeName())) {
                    this.myParent.addWizardData("GLOBALSWIZARD", (Object)NewObjectWizard.this.m_globalsWizard);
                    NewObjectWizard.this.m_wizardModel.removeTransition(this.m_initialTab, "NEXT");
                    NewObjectWizard.this.m_wizardModel.removeTransition("temptab2", "NEXT");
                    return true;
                }
                if (node.getPlugin() instanceof NewObjectInterface) {
                    NewObjectInterface plugin = (NewObjectInterface)node.getPlugin();
                    boolean fInitialized = true;
                    String nextTabName = null;
                    try {
                        nextTabName = plugin.getInitialTabName();
                    }
                    catch (Exception e) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                        fInitialized = false;
                    }
                    NewObjectWizard.this.m_wizardModel.removeTransition(this.m_initialTab, "NEXT");
                    NewObjectWizard.this.m_wizardModel.removeTransition("temptab2", "NEXT");
                    if (!fInitialized || !NewObjectWizard.this.m_wizardModel.isTransitionAlreadyAdded(nextTabName)) {
                        plugin.initializeWizard(this.myParent, NewObjectWizard.this.m_wizardModel);
                        if (!fInitialized) {
                            nextTabName = plugin.getInitialTabName();
                        }
                        this.myParent.pack();
                        NewObjectWizard.this.m_wizardModel.addTransition(this.m_initialTab, "NEXT", nextTabName);
                    } else {
                        NewObjectWizard.this.m_wizardModel.addTransition(this.m_initialTab, "NEXT", nextTabName);
                    }
                }
                return true;
            }
            MessageUtil.displayMessage((String)bundle.getString("NewObjectWizard.mustselect.txt"), (int)0);
            return false;
        }

        class MouseClickListener
        implements MouseListener {
            String option = "";

            MouseClickListener() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Object nodetype = NewObjectWizard.this.m_tree.getLastSelectedPathComponent();
                if (nodetype instanceof AbstractDesigner.cAbstractDesignerPluginNode) {
                    AbstractDesigner.cAbstractDesignerPluginNode node = (AbstractDesigner.cAbstractDesignerPluginNode)nodetype;
                    if (!this.option.equalsIgnoreCase(node.getNodeName())) {
                        cSelectTab.this.myParent.addWizardData("PREVIOUSSELECTEDNODE", (Object)this.option);
                        this.option = node.getNodeName();
                    } else {
                        cSelectTab.this.myParent.addWizardData("PREVIOUSSELECTEDNODE", (Object)node.getNodeName());
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }
        }
    }

    protected class InitializeRunnableWrite
    implements Runnable {
        @Override
        public void run() {
            boolean setMacroVariableStatus = false;
            Workspace.getDefaultLogger().debug((Object)"Starting write from new object wizard");
            try {
                ArrayList outputTables;
                CMetadata object;
                CMetadata object1;
                NewObjectWizard.this.m_oMetadata.updateMetadataAll();
                Workspace.getDefaultLogger().debug((Object)"Finished write");
                Boolean isEM = (Boolean)NewObjectWizard.this.getWizardData("EMFLAG");
                if (isEM != null && isEM.booleanValue() && (object1 = (CMetadata)NewObjectWizard.this.getWizardData("TDNEWTABLE")) != null) {
                    CMetadata object2 = Workspace.getMdFactory().createSimpleMetadataObject(object1);
                    NewObjectWizard.this.addWizardData("NEWSIMPLETABLE", object2);
                }
                if ((object = (CMetadata)NewObjectWizard.this.getWizardData("JOBOBJECT")) != null) {
                    CMetadata newObject = Workspace.getMdFactory().createSimpleMetadataObject(object);
                    NewObjectWizard.this.addWizardData("SIMPLEJOBOBJECT", newObject);
                    Workspace.getDefaultLogger().debug((Object)("ID of new job is " + newObject.getFQID()));
                    setMacroVariableStatus = true;
                }
                if ((outputTables = (ArrayList)NewObjectWizard.this.getWizardData("NJWOUTPUTTABLES")) != null && outputTables.size() > 0) {
                    ArrayList<CMetadata> newSimpleTables = new ArrayList<CMetadata>(outputTables.size());
                    for (int i = 0; i < outputTables.size(); ++i) {
                        CMetadata table = (CMetadata)outputTables.get(i);
                        CMetadata newObject = Workspace.getMdFactory().createSimpleMetadataObject(table);
                        newSimpleTables.add(newObject);
                    }
                    NewObjectWizard.this.addWizardData("SIMPLETABLEOBJECTS", newSimpleTables);
                }
                if (setMacroVariableStatus) {
                    OptionsPropertyHandler oph = new OptionsPropertyHandler((Root)NewObjectWizard.this.m_oMetadata);
                    if (Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("Workspace.EnableMacroVariables", true)) {
                        oph.setSpecificProperty("MACROS", "YES");
                    } else {
                        oph.setSpecificProperty("MACROS", "NO");
                    }
                    if (Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("Workspace.EnableParallelMacros", false)) {
                        oph.setSpecificProperty("PARALLEL", "YES");
                    } else {
                        oph.setSpecificProperty("PARALLEL", "NO");
                    }
                }
                Workspace.getDefaultLogger().debug((Object)"Disposing of PFD store");
                NewObjectWizard.this.m_oMetadata.getObjectStore().dispose();
                Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Writing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    protected class InitializeRunnableLaunchPFD
    implements Runnable {
        @Override
        public void run() {
            Workspace.getDefaultLogger().debug((Object)"Starting to launch PFD from new object wizard");
            CMetadata object = (CMetadata)NewObjectWizard.this.getWizardData("SIMPLEJOBOBJECT");
            try {
                if (object == null || object.isNewObject()) {
                    return;
                }
                ArrayList outputTables = (ArrayList)NewObjectWizard.this.getWizardData("SIMPLETABLEOBJECTS");
                String str1 = bundle.getString("LaunchPFDMetadataProgressIndicator.Msg.Message");
                String str2 = bundle.getString("LaunchPFDMetadataProgressIndicator.Msg.Title");
                OpRequestUI request = new OpRequestUI((JDialog)((Object)NewObjectWizard.this), str1, str2);
                request.setProgressShownOnStatusBar(false);
                request.setDelayBeforeProgressCancelDialog(200);
                request.execute((Runnable)new InitializeRunnableDoTheLaunch(object, outputTables));
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    protected class InitializeRunnableDoTheLaunch
    implements Runnable {
        CMetadata m_object;
        ArrayList m_outputTables;

        public InitializeRunnableDoTheLaunch(CMetadata object, ArrayList outputTables) {
            this.m_object = object;
            this.m_outputTables = outputTables;
        }

        @Override
        public void run() {
            Workspace.getDefaultLogger().debug((Object)"Doing the launch");
            JobTreeNode.showNewProcessView(this.m_object, this.m_outputTables);
        }
    }
}

