/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreListener;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.plugins.NewObjectInterface;
import com.sas.wadmin.visuals.GroupWizardTab;
import com.sas.wadmin.visuals.WAExtAttrPropertyTab;
import com.sas.wadmin.visuals.WANotesPropertyTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.WAGeneralPanel;
import com.sas.workspace.visuals.WAGeneralPropertyTab;
import com.sas.workspace.visuals.WizardFinishTab;
import com.sas.workspace.visuals.WsGenericGeneralPropertyTab;
import com.sas.workspace.visuals.objectselector.ObjectsSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class NewJobWizard
implements NewObjectInterface {
    protected WAWizardDialog m_wizardDialog;
    protected WATransitionWizardModel m_wizardModel;
    protected String m_name = bundle.getString("NewJobWizard.pluginname.txt");
    protected ImageIcon m_icon = bundle.getImageIcon("NewJobWizard.image");
    protected String m_tooltip = bundle.getString("NewJobWizard.ToolTip.txt");
    protected String m_category = bundle.getString("NewJobWizard.Category.txt");
    private static WAdminResource bundle = WAdminResource.getBundle(NewJobWizard.class);
    protected Job m_job = null;

    public String getDescription() {
        return bundle.getString("NewJobWizard.description.txt");
    }

    public void initPlugin() {
    }

    public void dispose() {
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public boolean initializeWizard(WAWizardDialog wizardDialog, WATransitionWizardModel wizardModel) {
        this.m_wizardDialog = wizardDialog;
        this.m_wizardModel = wizardModel;
        ImageIcon image = bundle.getImageIcon("NewJobWizard.StartTab.image");
        this.m_wizardDialog.addTab(bundle.getString("NewJobWizardTab1.Title.txt"), "NewJobWizardtab1", (WAPropertyTab)new cJobGeneralWizardTab(), "starttab.gif", (Icon)image);
        image = bundle.getImageIcon("NewJobWizard.TableSelectionTab.image");
        cSelectOutputTablesWizardTab tabTables = new cSelectOutputTablesWizardTab();
        this.m_wizardDialog.addTab(bundle.getString("NewJobWizardTab2.Title.txt"), "NewJobWizardtab2", (WAPropertyTab)tabTables, "tableselectiontab.image", (Icon)image);
        this.m_wizardDialog.addTabToCleanupOnCancel((WAPropertyTab)tabTables);
        image = bundle.getImageIcon("gen_target_location.image");
        GroupWizardTab groupTab = new GroupWizardTab();
        this.m_wizardDialog.addTab(bundle.getString("GroupWizardTab.Title.txt"), "GroupingTab", (WAPropertyTab)groupTab, "gen_target_location.gif", (Icon)image, true);
        image = bundle.getImageIcon("SourceDesigner.FinishTab.image");
        this.m_wizardDialog.addTab(bundle.getString("FinishTab.Title.txt"), "NewJobWizardtab3", (WAPropertyTab)new WizardFinishTab(), "warehouse_w6.gif", (Icon)image);
        String[][] transitionList = new String[][]{{"NewJobWizardtab1", "NEXT", "NewJobWizardtab2"}, {"NewJobWizardtab2", "NEXT", "GroupingTab"}, {"GroupingTab", "NEXT", "NewJobWizardtab3"}};
        wizardModel.addTransitions(transitionList);
        this.m_wizardModel = wizardModel;
        return true;
    }

    @Override
    public String getInitialTabName() {
        return "NewJobWizardtab1";
    }

    public String[] getLastTabNames() {
        String[] value = new String[]{"NewJobWizardtab3"};
        return value;
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    @Override
    public String getToolTip() {
        return this.m_tooltip;
    }

    @Override
    public String getCategory() {
        return this.m_category;
    }

    class cJobGeneralWizardTab
    extends WsDescriptionWizardTab
    implements MdStoreListener {
        protected JButton m_additionalBtn;
        protected WAGeneralPanel m_generalPanel;
        private static final String PUBLICTYPE_JOB = "Job";

        public cJobGeneralWizardTab() {
            super(bundle.getString("cJobGeneralWizardTab.Description.txt"));
            this._initialize();
            this.setHelpProduct("wdb");
            this.setHelpTopic("newjobwiz_1");
        }

        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
            if (!bSaveToModel) {
                MdObjectStore store = (MdObjectStore)myParent.getWizardData("OBJECTSTORE");
                store.addMdStoreListener((MdStoreListener)this);
                if (NewJobWizard.this.m_job == null) {
                    boolean genNLSDateFormat;
                    boolean genJobStatusHandlingLast;
                    boolean parallelMacroOption;
                    CMetadata repos = Workspace.getWorkspace().getDefaultRepository();
                    NewJobWizard.this.m_job = (Job)Workspace.getMdFactory().createComplexMetadataObject(store, "", PUBLICTYPE_JOB, repos.getFQID().substring(9, 17));
                    NewJobWizard.this.m_job.setName(WsMetadataNameUtil.getUniqueNameForType((String)PUBLICTYPE_JOB, (String)bundle.getString("cJobGeneralWizardTab.DefaultJobName.txt")));
                    NewJobWizard.this.m_job.setIsActive(1);
                    OptionsPropertyHandler oph = new OptionsPropertyHandler((Root)NewJobWizard.this.m_job);
                    WorkspaceFile wsFile = Workspace.getWorkspace().getAppDefaultsFile();
                    boolean macroOption = wsFile.getPropertyBoolean("Workspace.EnableMacroVariables", true);
                    if (macroOption) {
                        oph.setSpecificProperty("MACROS", "YES");
                    }
                    if (parallelMacroOption = wsFile.getPropertyBoolean("Workspace.EnableParallelMacros", false)) {
                        oph.setSpecificProperty("PARALLEL", "YES");
                    }
                    if (genJobStatusHandlingLast = wsFile.getPropertyBoolean("Workspace.GenerateJobStatusHandlingLast", true)) {
                        oph.setSpecificProperty("STATUSHANDLINGLAST", "YES");
                    }
                    if (genNLSDateFormat = wsFile.getPropertyBoolean("Workspace.UseNLSDateFormat", true)) {
                        oph.setSpecificProperty("USENLSDATEFORMAT", "YES");
                    }
                }
                this.m_generalPanel.setMetadataObject((Root)NewJobWizard.this.m_job);
                this.m_generalPanel.doDataExchange(false);
                NewJobWizard.this.m_job.setPublicType(PUBLICTYPE_JOB);
                NewJobWizard.this.m_job.setUsageVersion("1000000.0");
            } else {
                myParent.fixupID((CMetadata)NewJobWizard.this.m_job);
                myParent.setMasterObject((CMetadata)NewJobWizard.this.m_job);
                if (myParent.getWizardData("GROUP") != null) {
                    Tree newTree = (Tree)myParent.getWizardData("GROUP");
                    NewJobWizard.this.m_job.getTrees().add((Object)newTree);
                }
                myParent.addWizardData("JOBOBJECT", (Object)NewJobWizard.this.m_job);
                myParent.addWizardData("NEWOBJECT", (Object)NewJobWizard.this.m_job);
            }
            return true;
        }

        public void _initialize() {
            this.setLayout(new GridBagLayout());
            this.m_generalPanel = new WAGeneralPanel(bundle.getString("WAGeneralPropertyTab.Title.txt"), false, false, false);
            this.m_generalPanel.setPreferredSize(new Dimension(200, 100));
            this.add((Component)this.m_generalPanel, new GridBagConstraints(0, 0, 3, 2, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.m_additionalBtn = new JButton(bundle.getString("TDInfoTab.AdditionalProp.txt"));
            this.m_additionalBtn.setMnemonic(bundle.getString("TDInfoTab.AdditionalProp.mnem").charAt(0));
            this.m_additionalBtn.setToolTipText(bundle.getString("TDInfoTab.AdditionalProp.Tooltip.txt"));
            this.m_additionalBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        MdObjectStore store = Workspace.getMdFactory().createObjectStore(NewJobWizard.this.m_job.getObjectStore());
                        WAPropertyDialog buttonDialog = new WAPropertyDialog((Frame)Workspace.getWorkspace(), bundle.getString("TDInfoTab.AdditionalProp.Dialog.Title.txt"), true);
                        cJobGeneralWizardTab.this.m_generalPanel.doDataExchange(true);
                        Job tempNewJob = (Job)Workspace.getMdFactory().createComplexMetadataObject(store, NewJobWizard.this.m_job.getObjectStore(), NewJobWizard.this.m_job.getName(), NewJobWizard.this.m_job.getCMetadataType(), NewJobWizard.this.m_job.getId());
                        buttonDialog.setMetadataObject((CMetadata)tempNewJob);
                        buttonDialog.addTab(bundle.getString("Mapping.Tabgroup.General.txt"), (WAPropertyTab)new WAGeneralPropertyTab((CMetadata)tempNewJob));
                        buttonDialog.addTab(bundle.getString("Mapping.Tabgroup.Notes.txt"), (WAPropertyTab)new WANotesPropertyTab((CMetadata)tempNewJob));
                        buttonDialog.addTab(bundle.getString("Mapping.Tabgroup.ExtendedAttributes.txt"), (WAPropertyTab)new WAExtAttrPropertyTab((CMetadata)tempNewJob));
                        buttonDialog.addTab(bundle.getString("WsGenericGeneralPropertyTab.Title.txt"), (WAPropertyTab)new WsGenericGeneralPropertyTab((CMetadata)tempNewJob));
                        buttonDialog.show();
                    }
                    catch (MdException e) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                }
            });
            this.add(this.m_additionalBtn, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 0, 0));
        }

        public boolean validateData() {
            boolean state = this.m_generalPanel.validateData();
            if (!state) {
                return state;
            }
            try {
                this.m_generalPanel.doDataExchange(true);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            return true;
        }

        public String createFinishString() {
            WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
            CMetadata repos = (CMetadata)myParent.getWizardData("REPOSITORY");
            String sGroup = "";
            try {
                Tree groupTree = (Tree)myParent.getWizardData("GROUP");
                if (groupTree != null) {
                    sGroup = groupTree.getName();
                }
                String temp = bundle.formatString("NewJobWizardTab.finishinfo.txt", (Object)repos.getName(), (Object)sGroup);
                temp = temp + "\n\n";
                return temp;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return "";
            }
        }

        public void MdObjectsModified(MdEvent e, List items) {
            try {
                this.m_generalPanel.doDataExchange(false);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        public void MdObjectsRemoved(MdEvent e, List items) {
        }

        public void MdObjectsAdded(MdEvent e, List items) {
        }
    }

    protected class cSelectOutputTablesWizardTab
    extends WsDescriptionWizardTab {
        protected ObjectsSelectorPanel m_objectsSelector;

        public cSelectOutputTablesWizardTab() {
            super(bundle.getString("cSelectOutputTablesWizardTab.Description.txt"));
            this._initialize();
            this.setHelpProduct("wdb");
            this.setHelpTopic("newjobwiz_2");
        }

        public void _initialize() {
            this.m_objectsSelector = new ObjectsSelectorPanel(Workspace.getWorkspace().getUserContext(), -1);
            String[] aSelectableTypes = new String[]{"Table", "ExternalFile"};
            String[] aVisibleTypes = new String[]{"Table", "ExternalFile", "Library"};
            this.m_objectsSelector.setSelectableTypes(aSelectableTypes);
            this.m_objectsSelector.setVisibleTypes(aVisibleTypes);
            this.m_objectsSelector.setInventoryTypes(aVisibleTypes);
            this.m_objectsSelector.setSourceLabel(bundle.getString("ObjectsSelectorPanel.AvailableTables.txt"), bundle.getString("ObjectsSelectorPanel.AvailableTables.mnem").charAt(0));
            this.m_objectsSelector.setTargetLabel(bundle.getString("ObjectsSelectorPanel.SelectedTables.txt"), bundle.getString("ObjectsSelectorPanel.SelectedTables.mnem").charAt(0));
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_objectsSelector, "Center");
        }

        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
            MdObjectStore store = (MdObjectStore)myParent.getWizardData("OBJECTSTORE");
            this.m_objectsSelector.doDataExchange(bSaveToModel);
            if (bSaveToModel) {
                SimpleObject[] aTables = this.m_objectsSelector.getSelectedObjects();
                Root[] aMDTables = ObjectConverter.getInstance().convertToJOMAObjects(store, aTables);
                ArrayList<Root> tables = new ArrayList<Root>(Arrays.asList(aMDTables));
                Job job = (Job)myParent.getWizardData("NEWOBJECT");
                myParent.setMasterObject((CMetadata)job);
                if (tables.size() > 0) {
                    myParent.addWizardData("NJWOUTPUTTABLES", tables);
                }
            }
            return true;
        }

        public boolean validateData() {
            return this.m_objectsSelector.validateData();
        }

        public void onNext() {
            try {
                this.m_objectsSelector.doDataExchange(true);
                super.onNext();
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
        }

        public void saveSettingsAndCleanUp() {
            this.m_objectsSelector.saveSettingsAndCleanUp();
        }

        public String createFinishString() {
            StringBuffer temp = new StringBuffer();
            SimpleObject[] aTables = this.m_objectsSelector.getSelectedObjects();
            for (int i = 0; i < aTables.length; ++i) {
                String newString = aTables[i].getName();
                temp = i == aTables.length - 1 ? temp.append(newString) : temp.append(newString + ", ");
            }
            return temp.toString();
        }
    }
}

