/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.model.tree.InventoryNodeFactory;
import com.sas.wadmin.visuals.InventoryTreeNode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTreeNode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class MultiInventoryTreeNode
extends InventoryTreeNode {
    protected ArrayList m_alTypes = new ArrayList();
    protected ArrayList m_alAddXMLSelects = new ArrayList();
    protected ArrayList m_alRemoveXMLSelects = new ArrayList();
    private List m_lLogicalTypes = new ArrayList();
    private Root m_mdoKludge;

    public MultiInventoryTreeNode(String sName, String sReposId) {
        super(sName, "", sReposId);
        this.m_actNew.setEnabled(false);
    }

    public void addType(String sType) {
        this.addType(sType, null, null);
    }

    public void addType(String sType, String sXMLSelect) {
        this.addType(sType, sXMLSelect, null);
    }

    public void addType(String sType, String sAddXMLSelect, String sRemoveXMLSelect) {
        this.m_alTypes.add(sType);
        this.m_alAddXMLSelects.add(sAddXMLSelect);
        this.m_alRemoveXMLSelects.add(sRemoveXMLSelect);
    }

    public void addType(TypeInterface type) {
        this.m_lLogicalTypes.add(type);
    }

    @Override
    public boolean isValidParentFor(CMetadata oMetadata) {
        try {
            int iType;
            if (!this.getRepositoryFQID().substring(9).equals(oMetadata.getRepositoryID())) {
                return false;
            }
            for (iType = 0; iType < this.m_alTypes.size(); ++iType) {
                this.m_sType = (String)this.m_alTypes.get(iType);
                this.m_sAddXMLSelect = (String)this.m_alAddXMLSelects.get(iType);
                this.m_sRemoveXMLSelect = (String)this.m_alRemoveXMLSelects.get(iType);
                if (!super.isValidParentFor(oMetadata)) continue;
                return true;
            }
            for (iType = 0; iType < this.m_lLogicalTypes.size(); ++iType) {
                TypeInterface type = (TypeInterface)this.m_lLogicalTypes.get(iType);
                if (!(oMetadata instanceof PrimaryType) || !type.getPublicType().equals(((PrimaryType)oMetadata).getPublicType())) continue;
                this.m_mdoKludge = (Root)oMetadata;
                return true;
            }
            return false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    @Override
    public void addChildren() {
        for (int iType = 0; iType < this.m_alTypes.size(); ++iType) {
            this.m_sType = (String)this.m_alTypes.get(iType);
            this.m_sAddXMLSelect = (String)this.m_alAddXMLSelects.get(iType);
            this.m_sRemoveXMLSelect = (String)this.m_alRemoveXMLSelects.get(iType);
            super.addChildren();
        }
        try {
            InventoryNodeFactory factory = (InventoryNodeFactory)this.getTreeModel().getNodeFactory();
            if (factory == null) {
                return;
            }
            for (int iType = 0; iType < this.m_lLogicalTypes.size(); ++iType) {
                TypeInterface type = (TypeInterface)this.m_lLogicalTypes.get(iType);
                List lLogicalObjects = type.getObjectFactory().getAllObjects(this.getRepositoryFQID());
                for (int iLogicalObject = 0; iLogicalObject < lLogicalObjects.size(); ++iLogicalObject) {
                    LogicalObjectInterface lobData = (LogicalObjectInterface)lLogicalObjects.get(iLogicalObject);
                    WsTreeNode nodeData = factory.createObjectNode(lobData, this);
                    this.addChild(nodeData);
                }
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    @Override
    public WsTreeNode createChild(CMetadata oMetadata) {
        WsDataTreeNode nodeChild = null;
        if (this.m_mdoKludge != null) {
            try {
                if (this.m_mdoKludge.getObjectStore() != null && oMetadata.getFQID().equals(this.m_mdoKludge.getFQID())) {
                    nodeChild = this.getTreeModel().getNodeFactory().createObjectNode(this.m_mdoKludge, (WsTreeNode)this);
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            this.m_mdoKludge = null;
        }
        if (nodeChild == null) {
            nodeChild = WorkspaceTree.createDataTreeNode((CMetadata)oMetadata, (String)"com.sas.wadmin.visuals.", (String)"TreeNode");
        }
        nodeChild.setAllowsChildren(this.allowsGrandChildren());
        return nodeChild;
    }
}

