/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Prototype;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.undo.UndoManager;

public class MacroOptionsDefineTemplatesPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(MacroOptionsDefineTemplatesPanel.class);
    private boolean m_bIsInputType;
    private WsTable m_tblTemplates;
    private WsAbstractTableModel m_mdlTemplates;
    private JScrollPane m_scrTemplates;
    private WAPanel m_pnlButtons;
    private JButton m_btnNew;
    private JButton m_btnDelete;
    private WsAbstractAction m_actNew;
    private WsAbstractAction m_actDelete;
    private ArrayList m_listOfMacroNames = new ArrayList();
    private ArrayList m_listOfMacroPrompts = new ArrayList();
    private List m_listOfAssociationProperties = null;
    private Prototype m_prototype;
    private MdObjectStore m_childStore;
    private static final String DEFAULT_INPUT_FMT = "_INPUT{0}";
    private static final String DEFAULT_OUTPUT_FMT = "_OUTPUT{0}";
    public static final int MAX_CHARS_FOR_SASNAME = 32;

    public MacroOptionsDefineTemplatesPanel(MdObjectStore childStore, boolean isInputType, Prototype prototype) {
        this.setHelpTopic("sas_code_template_inputs");
        this.m_bIsInputType = isInputType;
        this.m_prototype = prototype;
        this.m_childStore = childStore;
        this.initialize();
    }

    protected void initialize() {
        this.m_mdlTemplates = new cTemplateTableModel();
        this.m_tblTemplates = new WsTable(this.m_mdlTemplates);
        this.m_tblTemplates.setToolTipText(bundle.getString("MacroOptionsDefineTemplatesPanel.TemplateTable.ToolTip.txt"));
        this.m_tblTemplates.setColumnHidingEnabled(false);
        this.m_tblTemplates.setRowSelectionAllowed(true);
        this.m_tblTemplates.setSortingEnabled(false);
        this.m_tblTemplates.setRowsReorderable(false);
        this.m_tblTemplates.setRowHoldingEnabled(false);
        this.m_tblTemplates.setColumnHoldingEnabled(false);
        this.m_tblTemplates.setColumnHeaderVisible(true);
        this.m_tblTemplates.setColumnHeaderPopupMenuEnabled(false);
        this.m_tblTemplates.setColumnsReorderable(false);
        this.m_tblTemplates.setAutoResizeMode(3);
        this.m_tblTemplates.setUndoManager((UndoManager)this.waum);
        this.m_scrTemplates = new JScrollPane((Component)this.m_tblTemplates);
        this.m_tblTemplates.getSelectionModel().addListSelectionListener(new cTableSelectionListener());
        this.m_tblTemplates.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)new cTablePopupMenuRequestListener());
        this.m_tblTemplates.setViewportPopupMenuRequestListener((WsPopupMenuRequestListener)new cTablePopupMenuRequestListener());
        this.m_actNew = new cNewAction();
        this.m_btnNew = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNew);
        this.m_actDelete = new cDeleteAction();
        this.m_btnDelete = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDelete);
        this.m_pnlButtons = new WAPanel();
        this.m_pnlButtons.setLayout((LayoutManager)new WsButtonsLayout());
        this.m_pnlButtons.add((Component)this.m_btnNew);
        this.m_pnlButtons.add((Component)this.m_btnDelete);
        this.setLayout(new GridBagLayout());
        this.add(this.m_scrTemplates, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_pnlButtons, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.m_tblTemplates.getActionMap().put(this.m_actDelete, (Action)this.m_actDelete);
        this.m_tblTemplates.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDelete);
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_listOfAssociationProperties = MacroPluginUtilities.getAssociationProperties(this.m_childStore, this.m_bIsInputType, this.m_prototype);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_mdlTemplates.moveDataToModel();
        if (this.m_mdlTemplates.getRowCount() > 0) {
            this.m_tblTemplates.selectCell(0, 0);
        }
        this.updateActions();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_mdlTemplates.moveDataToStore();
        this.setDataChanged(false);
    }

    public boolean validateData() {
        return this.m_tblTemplates.stopCellEditing();
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_actDelete.setEnabled(bEditable);
        this.m_actNew.setEnabled(bEditable);
        this.m_tblTemplates.setEditable(bEditable);
    }

    public List getMacroNamesList() {
        return this.m_listOfMacroNames;
    }

    public void setMacroNamesList(ArrayList listOfNames) {
        this.m_listOfMacroNames = listOfNames;
    }

    public List getMacroPromptsList() {
        return this.m_listOfMacroPrompts;
    }

    public void setMacroPromptsList(ArrayList listOfPrompts) {
        this.m_listOfMacroPrompts = listOfPrompts;
    }

    public void setValue(String option, String value) {
        int row = this.findRow(option);
        if (row >= 0) {
            this.m_mdlTemplates.setValueAt((Object)value, row, 1);
        }
    }

    public String getValue(String option) {
        int rowIndex = this.findRow(option);
        return rowIndex >= 0 ? (String)this.m_mdlTemplates.getValueAt(rowIndex, 1) : "";
    }

    public int findRow(String option) {
        for (int rowIndex = 0; rowIndex < this.m_mdlTemplates.getRowCount(); ++rowIndex) {
            String name = (String)this.m_mdlTemplates.getValueAt(rowIndex, 0);
            if (!name.equalsIgnoreCase(option)) continue;
            return rowIndex;
        }
        return -1;
    }

    protected void updateActions() {
        this.m_actNew.setEnabled(this.m_tblTemplates.isEditable());
        this.m_actDelete.setEnabled(this.m_tblTemplates.isEditable() && this.m_tblTemplates.getSelectedRowsFromSelectedCells().length > 0);
    }

    protected class cTemplateTableModel
    extends WsAbstractTableModel {
        private static final int W_MACRO_NAME_COL = 100;
        private static final int W_PROMPT_COL = 300;
        private static final int MACRO_NAME_COL = 0;
        private static final int PROMPT_COL = 1;
        private static final int ORIGINAL_MACRO_NAME_COL = 2;
        private static final int ORIGINAL_PROMPT_COL = 3;
        private static final int TOTAL_VISIBLE_COLS = 2;
        private static final int TOTAL_HIDDEN_COLS = 2;
        private static final int MAX_PROMPT_LENGTH = 128;

        public cTemplateTableModel() {
            this.initialize();
        }

        protected void initialize() {
            this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
            cMacroNameStringColumn nameColumn = new cMacroNameStringColumn(this, 0, bundle.getString("MacroOptionsDefineTemplatesPanel.cTemplateTableModel.MacroNameColumn.title"), 100, 32);
            if (MacroOptionsDefineTemplatesPanel.this.m_bIsInputType) {
                nameColumn.setFormatString(MacroOptionsDefineTemplatesPanel.DEFAULT_INPUT_FMT);
            } else {
                nameColumn.setFormatString(MacroOptionsDefineTemplatesPanel.DEFAULT_OUTPUT_FMT);
            }
            this.m_aColumns[0] = nameColumn;
            cPromptStringColumn promptColumn = new cPromptStringColumn(1, bundle.getString("MacroOptionsDefineTemplatesPanel.cTemplateTableModel.PromptColumn.title"), 300, 128);
            promptColumn.setDefaultValue(bundle.getString("MacroOptionsDefineTemplatesPanel.DefaultTemplate.txt"));
            this.m_aColumns[1] = promptColumn;
            this.m_aColumns[2] = new WsStringTableColumn(2);
            this.m_aColumns[3] = new WsStringTableColumn(3);
        }

        public int getColumnCount() {
            return 2;
        }

        public int getHiddenColumnCount() {
            return 2;
        }

        public void populateStore() throws MdException, RemoteException {
        }

        public void moveDataToModel() throws MdException, RemoteException {
            int rowCount;
            int i;
            if (MacroOptionsDefineTemplatesPanel.this.m_listOfAssociationProperties == null && MacroOptionsDefineTemplatesPanel.this.m_listOfMacroNames.size() == 0) {
                return;
            }
            if (MacroOptionsDefineTemplatesPanel.this.m_listOfMacroNames.size() > 0) {
                for (i = 0; i < MacroOptionsDefineTemplatesPanel.this.m_listOfMacroNames.size(); ++i) {
                    ArrayList row = new ArrayList();
                    row.add(0, MacroOptionsDefineTemplatesPanel.this.m_listOfMacroNames.get(i));
                    row.add(1, MacroOptionsDefineTemplatesPanel.this.m_listOfMacroPrompts.get(i));
                    row.add(2, MacroOptionsDefineTemplatesPanel.this.m_listOfMacroNames.get(i));
                    row.add(3, MacroOptionsDefineTemplatesPanel.this.m_listOfMacroPrompts.get(i));
                    this.m_lData.add(row);
                }
            } else {
                for (i = 0; i < MacroOptionsDefineTemplatesPanel.this.m_listOfAssociationProperties.size(); ++i) {
                    ArrayList<String> row = new ArrayList<String>();
                    AssociationProperty property = (AssociationProperty)MacroOptionsDefineTemplatesPanel.this.m_listOfAssociationProperties.get(i);
                    if (MacroPluginUtilities.isTemplateDefault(property)) continue;
                    String macroName = MacroPluginUtilities.getMacroNameFromProperty(property);
                    row.add(0, macroName);
                    row.add(1, property.getName());
                    row.add(2, macroName);
                    row.add(3, property.getName());
                    this.m_lData.add(row);
                }
            }
            if ((rowCount = this.m_lData.size()) > 0) {
                this.fireTableRowsInserted(0, rowCount - 1);
            }
        }

        public void moveDataToStore() throws MdException, RemoteException {
            MacroOptionsDefineTemplatesPanel.this.m_listOfMacroNames.clear();
            MacroOptionsDefineTemplatesPanel.this.m_listOfMacroPrompts.clear();
            for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
                MacroOptionsDefineTemplatesPanel.this.m_listOfMacroNames.add(this.getValueAt(rowIndex, 0));
                MacroOptionsDefineTemplatesPanel.this.m_listOfMacroPrompts.add(this.getValueAt(rowIndex, 1));
            }
        }
    }

    protected class cTableSelectionListener
    implements ListSelectionListener {
        protected cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            MacroOptionsDefineTemplatesPanel.this.updateActions();
        }
    }

    public class cTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem((Action)MacroOptionsDefineTemplatesPanel.this.m_actNew));
            mnuPopup.add(new JMenuItem((Action)MacroOptionsDefineTemplatesPanel.this.m_actDelete));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cNewAction
    extends WsAbstractAction {
        public cNewAction() {
            super(bundle, "MacroOptionsDefineTemplatesPanel.New", true);
        }

        public void actionPerformed(ActionEvent e) {
            MacroOptionsDefineTemplatesPanel.this.m_tblTemplates.undoableInsertRowAfterLastSelectedRow(MacroOptionsDefineTemplatesPanel.this.m_mdlTemplates.createDefaultRowValues());
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction {
        public cDeleteAction() {
            super(bundle, "MacroOptionsDefineTemplatesPanel.Delete", true);
        }

        public void actionPerformed(ActionEvent e) {
            MacroOptionsDefineTemplatesPanel.this.m_tblTemplates.undoableDeleteSelectedRows();
        }
    }

    protected class cPromptStringColumn
    extends WsStringTableColumn {
        public cPromptStringColumn(int iModelIndex, String sName, int cxWidth, int maxLength) {
            super(iModelIndex, sName, cxWidth, maxLength);
        }

        public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
            if (((String)oValue).trim().length() == 0) {
                String sMessage = bundle.formatString("MacroOptionsDefineTemplatesPanel.cPromptStringColumn.BlankError.fmt", (Object)this.getName());
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            return true;
        }
    }

    protected class cMacroNameStringColumn
    extends WsUniqueNameTableColumn {
        public cMacroNameStringColumn(WsAbstractTableModel mdlTable, int iModelIndex, String sName, int cxWidth, int nMaximum) {
            super(mdlTable, iModelIndex, sName, cxWidth, nMaximum);
        }

        public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
            if (((String)oValue).trim().length() > 20) {
                String sMessage = bundle.formatString("MacroOptionsDefineTemplatesPanel.cMacroNameStringColumn.NameTooLong.fmt", (Object)oValue.toString());
                MessageUtil.displayMessage((String)sMessage, (int)2);
            }
            return true;
        }
    }
}

