/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.etl.models.job.impl.GeneratedTransformNames;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.wadmin.visuals.WAGeneralWizardPanel;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.metadata.GeneratedTransformationUtilities;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.visuals.WAGeneralPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class MacroGeneralPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(MacroGeneralPanel.class);
    private static final int FOLDER_NAMES_SAVED = 1;
    private WAGeneralWizardPanel m_pnlGeneral;
    private WAComboBox m_cmbFolder;
    private JLabel m_lblFolder;
    private String m_strNewProcessLibraryFolderName = "";
    private Root m_oMetadata = null;

    public MacroGeneralPanel(Prototype oMetadata) {
        this.m_pnlGeneral = new WAGeneralWizardPanel(bundle.getString("cGeneralTab.Top.txt"), null, false);
        this.m_pnlGeneral.getGeneralPanel().setMetadataObject((Root)oMetadata);
        this.m_pnlGeneral.getGeneralPanel().enableNameValidation(true);
        this.m_oMetadata = oMetadata;
        this.initialize();
    }

    public MacroGeneralPanel() {
        this.m_pnlGeneral = new WAGeneralWizardPanel(bundle.getString("cGeneralTab.Top.txt"), null, true);
        this.m_pnlGeneral.getGeneralPanel().enableNameValidation(true);
        this.initialize();
    }

    protected void initialize() {
        this.m_lblFolder = new JLabel(bundle.getString("MacroPluginWizard.cGeneralTab.Folder.txt"));
        this.m_cmbFolder = new WAComboBox();
        this.m_cmbFolder.setEditable(true);
        this.m_cmbFolder.setSorted(true);
        this.m_lblFolder.setDisplayedMnemonic(bundle.getString("MacroPluginWizard.cGeneralTab.Folder.mnem").charAt(0));
        this.m_cmbFolder.setToolTipText(bundle.getString("MacroPluginWizard.cGeneralTab.Folder.ToolTip.txt"));
        this.m_lblFolder.setLabelFor((Component)this.m_cmbFolder);
        this.listenForDataChangesTo((JComboBox)this.m_cmbFolder);
        this.listenForDataChangesTo((WAPanel)this.m_pnlGeneral);
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_pnlGeneral), new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lblFolder, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.m_cmbFolder, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_pnlGeneral.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_pnlGeneral.moveDataToView();
        this.setListeningForChanges(false);
        String noFolder = bundle.getString("cGeneralTab.NoFolder.txt");
        this.m_cmbFolder.loadItems("MacroPluginWizard.ProcessLibraryFolder", 1);
        ArrayList<Object> itemsToAdd = new ArrayList<Object>();
        for (int i = 0; i < this.m_cmbFolder.getItemCount(); ++i) {
            if (itemsToAdd.contains(this.m_cmbFolder.getItemAt(i))) continue;
            itemsToAdd.add(this.m_cmbFolder.getItemAt(i));
        }
        this.m_cmbFolder.removeAllItems();
        String strFolderName = null;
        if (this.m_oMetadata != null) {
            String strGUID = MacroPluginUtilities.getGuid((Prototype)this.m_oMetadata);
            GeneratedTransformNames gtNames = new GeneratedTransformNames(strGUID);
            if (gtNames.isNameStoredInBundle()) {
                strFolderName = gtNames.getTreeLocation();
                this.m_pnlGeneral.getGeneralPanel().setNameField(gtNames.getName());
                this.m_pnlGeneral.getGeneralPanel().setDescriptionField(gtNames.getDescription());
            } else {
                strFolderName = GeneratedTransformationUtilities.getProcessTreePath((Root)this.m_oMetadata);
            }
        }
        if (strFolderName == null) {
            strFolderName = (String)this.m_cmbFolder.getItemAt(0);
        }
        if (!itemsToAdd.contains(noFolder)) {
            itemsToAdd.add(noFolder);
        }
        ITreeNode rootNode = (ITreeNode)TransformManager.getInstance().getTransformationsTreeModel().getRoot();
        Enumeration e = rootNode.children();
        while (e.hasMoreElements()) {
            ITreeNode o = (ITreeNode)e.nextElement();
            if (!o.getAllowsChildren() || itemsToAdd.contains(o.toString())) continue;
            itemsToAdd.add(o.toString());
        }
        this.m_cmbFolder.addItems(itemsToAdd);
        if (strFolderName == null || strFolderName.trim().length() == 0) {
            strFolderName = noFolder;
        }
        this.m_cmbFolder.setSelectedItem((Object)strFolderName);
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_pnlGeneral.moveDataToStore();
        this.m_cmbFolder.saveItems("MacroPluginWizard.ProcessLibraryFolder", 1);
        this.m_strNewProcessLibraryFolderName = this.getProcessLibraryFolderName();
        if (this.m_oMetadata != null) {
            GeneratedTransformationUtilities.setProcessTreePath((Root)this.m_oMetadata, (String)this.m_strNewProcessLibraryFolderName);
        }
        this.m_cmbFolder.removeAllItems();
        this.setDataChanged(false);
    }

    public boolean validateData() {
        return this.m_pnlGeneral.validateData();
    }

    public WAGeneralPanel getGeneralPanel() {
        return this.m_pnlGeneral.getGeneralPanel();
    }

    public void setEditable(boolean bEditable) {
        this.m_pnlGeneral.setEditable(bEditable);
        this.m_lblFolder.setEnabled(bEditable);
        this.m_cmbFolder.setEnabled(bEditable);
    }

    public String getProcessLibraryFolderName() {
        String strName = (String)this.m_cmbFolder.getSelectedItem();
        if (strName == null || strName.equals(bundle.getString("cGeneralTab.NoFolder.txt"))) {
            strName = "";
        }
        return strName;
    }

    public void setProcessLibraryFolderName(String strName) {
        boolean fFound = false;
        for (int i = 0; i < this.m_cmbFolder.getItemCount(); ++i) {
            String strFolderName = (String)this.m_cmbFolder.getItemAt(i);
            if (!strFolderName.equalsIgnoreCase(strName)) continue;
            this.m_cmbFolder.setSelectedIndex(i);
            fFound = true;
            break;
        }
    }

    public String getNameText() {
        return this.m_pnlGeneral.getGeneralPanel().getNameComponent().getText().trim();
    }

    public String getDescription() {
        return this.m_pnlGeneral.getGeneralPanel().getDescriptionComponent().getText().trim();
    }

    public Tree getOwningTree() {
        return this.m_pnlGeneral.getGeneralPanel().getOwningTree();
    }
}

