/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.LogicalObjectView;
import com.sas.wadmin.visuals.WAExtAttrPropertyTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractOMAView;
import com.sas.workspace.visuals.WsGenericGeneralPropertyTab;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.Icon;

public class LogicalObjectPropertiesView
extends WsAbstractOMAView
implements LogicalObjectView {
    private static WAdminResource bundle = WAdminResource.getBundle(LogicalObjectPropertiesView.class);
    private LogicalObjectInterface m_lobData;

    public WAPanel createMainPanel() {
        WATabbedPanel tabPanel = new WATabbedPanel();
        this.addTabs(tabPanel);
        return tabPanel;
    }

    protected void addTabs(WATabbedPanel tabPanel) {
        try {
            List lTabs = Factory.getInstance().getPropertyTabs(this.m_lobData, this.getMetadata(), null);
            if (lTabs != null && !lTabs.isEmpty()) {
                for (int iTab = 0; iTab < lTabs.size(); ++iTab) {
                    WAPropertyTab tab = (WAPropertyTab)lTabs.get(iTab);
                    if (!this.getShouldShowAdvancedTabs() && (tab instanceof WsGenericGeneralPropertyTab || tab instanceof WAExtAttrPropertyTab)) continue;
                    tabPanel.addTab(tab.getName(), tab);
                }
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        if (this.getShouldShowAdvancedTabs()) {
            this.addAuthorizationTab(tabPanel, (CMetadata)this.getMetadata());
        }
    }

    @Override
    public void setLogicalObject(LogicalObjectInterface lobData) {
        this.m_lobData = lobData;
    }

    public LogicalObjectInterface getLogicalObject() {
        return this.m_lobData;
    }

    protected Icon getFrameIcon() {
        return this.m_lobData.getIcon();
    }

    protected String getFrameTitle() {
        return bundle.formatString("LogicalObjectPropertiesView.Title.fmt.txt", (Object)this.m_lobData.getName());
    }
}

