/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.wadmin.visuals.AbstractConnectPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JLabel;

public class LibraryDetailsPanel
extends AbstractConnectPanel {
    private static WAdminResource bundle;
    protected WATextField m_textField1;
    protected WATextField m_textField2;
    protected WATextField m_textField3;
    protected WATextField m_schemaField;
    protected JLabel m_labelText1;
    protected JLabel m_labelText2;
    protected JLabel m_labelText3;
    protected JLabel m_schemaLabel;
    private String m_dbmsType;
    private String m_property1;
    private String m_property2;
    private String m_property3;
    private SASClientConnection conn;
    private boolean m_showSchema;

    protected LibraryDetailsPanel(String dbmsType, String property1, String property2, String property3, boolean showSchema) {
        this.m_dbmsType = dbmsType;
        this.m_property1 = property1.toUpperCase();
        this.m_property2 = property2.toUpperCase();
        this.m_property3 = property3.toUpperCase();
        this.m_showSchema = showSchema;
        this.initialize();
        this.layoutWidgets();
    }

    public void initialize() {
        bundle = WAdminResource.getBundle(LibraryDetailsPanel.class);
        this.m_textField1 = new WATextField();
        this.m_textField2 = new WATextField();
        this.m_textField3 = new WATextField();
        this.m_schemaField = new WATextField();
        this.m_labelText1 = new JLabel();
        this.m_labelText2 = new JLabel();
        this.m_labelText3 = new JLabel();
        this.m_schemaLabel = new JLabel();
        String panelName = this.m_dbmsType + "ConnectPanel.";
        if (this.m_property1.length() > 0) {
            this.m_labelText1.setText(bundle.getString(panelName + "Label.textField1.txt"));
            this.m_labelText1.setDisplayedMnemonic(bundle.getString(panelName + "Label.textField1.mnem").charAt(0));
            this.m_labelText1.setLabelFor((Component)this.m_textField1);
            this.m_textField1.setToolTipText(bundle.getString(panelName + "textField1.Tooltip.txt"));
            this.m_textField1.setEditable(false);
        } else {
            this.m_labelText1.setVisible(false);
            this.m_textField1.setVisible(false);
        }
        if (this.m_property2.length() > 0) {
            this.m_labelText2.setText(bundle.getString(panelName + "Label.textField2.txt"));
            this.m_labelText2.setDisplayedMnemonic(bundle.getString(panelName + "Label.textField2.mnem").charAt(0));
            this.m_labelText2.setLabelFor((Component)this.m_textField2);
            this.m_textField2.setToolTipText(bundle.getString(panelName + "textField2.Tooltip.txt"));
            this.m_textField2.setEditable(false);
        } else {
            this.m_labelText2.setVisible(false);
            this.m_textField2.setVisible(false);
        }
        if (this.m_property3.length() > 0) {
            this.m_labelText3.setText(bundle.getString(panelName + "Label.textField3.txt"));
            this.m_labelText3.setDisplayedMnemonic(bundle.getString(panelName + "Label.textField3.mnem").charAt(0));
            this.m_labelText3.setLabelFor((Component)this.m_textField3);
            this.m_textField3.setToolTipText(bundle.getString(panelName + "textField3.Tooltip.txt"));
            this.m_textField3.setEditable(false);
        } else {
            this.m_labelText3.setVisible(false);
            this.m_textField3.setVisible(false);
        }
        if (this.m_showSchema) {
            this.m_schemaLabel.setText(bundle.getString(panelName + "Label.Schema.txt"));
            this.m_schemaLabel.setDisplayedMnemonic(bundle.getString(panelName + "Label.Schema.mnem").charAt(0));
            this.m_schemaLabel.setLabelFor((Component)this.m_schemaField);
            this.m_schemaField.setToolTipText(bundle.getString(panelName + "SchemaTooltip.txt"));
            this.m_schemaField.setEditable(false);
        } else {
            this.m_schemaLabel.setVisible(false);
            this.m_schemaField.setVisible(false);
        }
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_labelText1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.m_textField1, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 10, 10), 0, 0));
        this.add(this.m_labelText2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.m_textField2, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 10, 10), 0, 0));
        this.add(this.m_labelText3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.m_textField3, new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 10, 10), 0, 0));
        this.add(this.m_schemaLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.m_schemaField, new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 10, 10), 0, 0));
    }

    @Override
    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        if (!saveToModel) {
            if (!this.validateLibraryMetadata()) {
                return false;
            }
            boolean prop1Found = false;
            boolean prop2Found = false;
            boolean prop3Found = false;
            this.clearAllFields();
            if (this.m_property1.length() < 1) {
                prop1Found = true;
            }
            if (this.m_property2.length() < 1) {
                prop2Found = true;
            }
            if (this.m_property3.length() < 1) {
                prop3Found = true;
            }
            try {
                for (int p = 0; p < this.conn.getProperties().size(); ++p) {
                    String propName = ((Property)this.conn.getProperties().elementAt(p)).getPropertyName();
                    String propValue = ((Property)this.conn.getProperties().elementAt(p)).getDefaultValue();
                    if (!prop1Found && propName.compareToIgnoreCase(this.m_property1) == 0) {
                        this.m_textField1.setText(propValue);
                        prop1Found = true;
                    } else if (!prop2Found && propName.compareToIgnoreCase(this.m_property2) == 0) {
                        this.m_textField2.setText(propValue);
                        prop2Found = true;
                    } else if (!prop3Found && propName.compareToIgnoreCase(this.m_property3) == 0) {
                        this.m_textField3.setText(propValue);
                        prop3Found = true;
                    }
                    if (prop1Found && prop2Found && prop3Found) break;
                }
                if (this.m_showSchema) {
                    AssociationList pkgs = this.m_library.getUsingPackages();
                    if (!pkgs.isEmpty()) {
                        this.m_schemaField.setText(((DatabaseSchema)pkgs.get(0)).getSchemaName());
                    } else {
                        this.m_schemaField.setText("");
                    }
                }
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().debug((Object)"Exception", (Throwable)e);
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                return false;
            }
        }
        return true;
    }

    protected boolean validateLibraryMetadata() {
        try {
            this.conn = this.m_library.getLibraryConnection();
            if (this.conn == null) {
                MessageUtil.displayMessage((String)"ERROR: Library is required to have a Connection.", (int)0);
                return false;
            }
            if (this.conn.getProperties() == null) {
                return false;
            }
        }
        catch (MdException mde) {
            String sMessage = mde.getMessage();
            MessageUtil.displayMessage((String)sMessage, (int)0);
            return false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return true;
    }

    protected void clearAllFields() {
        this.m_textField1.setText("");
        this.m_textField2.setText("");
        this.m_textField3.setText("");
        this.m_schemaField.setText("");
    }
}

