/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.wadmin.app.AppPropertiesDialogFactory;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.visuals.ASTERConnectPanel;
import com.sas.wadmin.visuals.AbstractConnectPanel;
import com.sas.wadmin.visuals.EngineDesigner;
import com.sas.wadmin.visuals.FEDERATIONSERVERConnectPanel;
import com.sas.wadmin.visuals.GREENPLUMConnectPanel;
import com.sas.wadmin.visuals.LibraryDetailsPanel;
import com.sas.wadmin.visuals.NEOVIEWConnectPanel;
import com.sas.wadmin.visuals.NETEZZAConnectPanel;
import com.sas.wadmin.visuals.POSTGRESConnectPanel;
import com.sas.wadmin.visuals.SASIOHNAConnectPanel;
import com.sas.wadmin.visuals.SYBASEIQConnectPanel;
import com.sas.wadmin.visuals.VERTICAConnectPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.mgmt.visuals.Library;
import com.sas.workspace.mgmt.visuals.LibraryWizard;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.VersionUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class LibraryConnectPanel
extends AbstractConnectPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(LibraryConnectPanel.class);
    protected ArrayList m_cardClasses;
    protected ArrayList m_cardClassesNames;
    protected CardLayout m_EngineTypeCards;
    protected List vSASLibraryList;
    protected String m_strXMLSelectString;
    protected String m_strEngineTypeToLookFor;
    protected String m_strSASLibraryToSelect;
    protected SASLibrary m_foundLibrary;
    protected int m_iLibrarySelectedIndex;
    protected int m_strSelectedIndex;
    protected cComboItemListener libListener;
    protected WAPanel m_pnlEngineType;
    protected WAPanel m_containerPanel;
    protected AbstractConnectPanel m_selectedPanel;
    protected JButton m_editButton;
    protected JButton m_newButton;
    protected WAComboBox m_libraryBox;
    protected WAWizardDialog myParent;

    public LibraryConnectPanel(String engineType) {
        try {
            this.initialize();
            if (engineType.equalsIgnoreCase("NEOVIEW")) {
                this.m_pnlEngineType = new NEOVIEWConnectPanel();
            } else if (engineType.equalsIgnoreCase("NETEZZA")) {
                this.m_pnlEngineType = new NETEZZAConnectPanel();
            } else if (engineType.equalsIgnoreCase("ASTER")) {
                this.m_pnlEngineType = new ASTERConnectPanel();
            } else if (engineType.equalsIgnoreCase("SYBASEIQ")) {
                this.m_pnlEngineType = new SYBASEIQConnectPanel();
            } else if (engineType.equalsIgnoreCase("GREENPLM")) {
                this.m_pnlEngineType = new GREENPLUMConnectPanel();
            } else if (engineType.equalsIgnoreCase("FEDSVR")) {
                this.m_pnlEngineType = new FEDERATIONSERVERConnectPanel();
            } else if (engineType.equalsIgnoreCase("POSTGRES")) {
                this.m_pnlEngineType = new POSTGRESConnectPanel();
            } else if (engineType.equalsIgnoreCase("SASIOHNA")) {
                this.m_pnlEngineType = new SASIOHNAConnectPanel();
            } else if (engineType.equalsIgnoreCase("VERTICA")) {
                this.m_pnlEngineType = new VERTICAConnectPanel();
            } else {
                String panelClassName = "com.sas.wadmin.visuals." + engineType + "ConnectPanel";
                Class<?> LoadedClass = Class.forName(panelClassName);
                this.m_pnlEngineType = (LibraryDetailsPanel)((Object)LoadedClass.newInstance());
            }
            this.setLayout(new GridBagLayout());
            this._layoutWidgets();
            this.m_selectedPanel = (LibraryDetailsPanel)this.m_pnlEngineType;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            MessageUtil.displayMessage((String)e.getMessage());
        }
    }

    public LibraryConnectPanel(ArrayList enginePanelClasses, int iInitialPanel) {
        try {
            this.initialize();
            this.m_cardClasses = new ArrayList(1);
            this.m_cardClassesNames = new ArrayList(1);
            this.m_EngineTypeCards = new CardLayout();
            for (int i = 0; i < enginePanelClasses.size(); ++i) {
                String strName = (String)enginePanelClasses.get(i);
                Class<?> LoadedClass = Class.forName(strName);
                AbstractConnectPanel panel = (AbstractConnectPanel)((Object)LoadedClass.newInstance());
                this.m_cardClasses.add(panel);
                this.m_cardClassesNames.add(enginePanelClasses.get(i));
            }
            this.setLayout(new GridBagLayout());
            this.layoutCards();
            this._layoutWidgets();
            this.setSourcePanel(iInitialPanel);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            MessageUtil.displayMessage((String)e.getMessage());
        }
    }

    public void initialize() {
        this.m_pnlEngineType = new WAPanel();
        this.m_containerPanel = new WAPanel();
        this.m_libraryBox = new WAComboBox();
        this.vSASLibraryList = new ArrayList();
        this.m_strSASLibraryToSelect = this.m_workspace.getAppDefaultsFile().getPropertyString("LibraryConnectPanel.LastLibrarySelected");
        this.m_strSelectedIndex = 0;
        this.m_iLibrarySelectedIndex = 0;
    }

    protected void _layoutWidgets() {
        JLabel tempLabel = new JLabel(bundle.getString("LibraryConnectPanel.Label.Library.txt"));
        tempLabel.setDisplayedMnemonic(bundle.getString("LibraryConnectPanel.Label.Library.mnem").charAt(0));
        tempLabel.setLabelFor((Component)this.m_libraryBox);
        this.m_libraryBox.setSorted(true);
        this.m_libraryBox.setToolTipText(bundle.getString("LibraryConnectPanel.LibraryToolTip.txt"));
        this.m_newButton = new JButton(bundle.getString("Common.New2.txt"));
        this.m_newButton.setToolTipText(bundle.getString("LibraryConnectPanel.NewLibraryToolTip.txt"));
        this.m_newButton.setMnemonic(bundle.getString("Common.New2.mnem").charAt(0));
        cNewButtonListener newButtonListener = new cNewButtonListener();
        this.m_newButton.addActionListener(newButtonListener);
        this.m_containerPanel.setLayout((LayoutManager)new GridBagLayout());
        TitledBorder titledBorder1 = new TitledBorder(bundle.getString("LibraryConnectPanel.Details.txt"));
        this.m_containerPanel.setBorder((Border)titledBorder1);
        this.m_editButton = new JButton(bundle.getString("Common.Edit.txt"));
        this.m_editButton.setToolTipText(bundle.getString("LibraryConnectPanel.EditLibraryToolTip.txt"));
        this.m_editButton.setMnemonic(bundle.getString("Common.Edit.mnem").charAt(0));
        cEditButtonListener editButtonListener = new cEditButtonListener();
        this.m_editButton.addActionListener(editButtonListener);
        this.m_containerPanel.add((Component)this.m_pnlEngineType, (Object)new GridBagConstraints(0, 0, 4, 3, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.m_containerPanel.add((Component)this.m_editButton, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(tempLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.m_libraryBox, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.m_newButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.m_containerPanel, new GridBagConstraints(0, 1, 4, 3, 1.0, 1.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    protected void layoutCards() {
        this.m_pnlEngineType.setLayout((LayoutManager)this.m_EngineTypeCards);
        for (int i = 0; i < this.m_cardClasses.size(); ++i) {
            AbstractConnectPanel pnl = (AbstractConnectPanel)((Object)this.m_cardClasses.get(i));
            this.m_pnlEngineType.add((Component)((Object)pnl), this.m_cardClassesNames.get(i));
        }
    }

    @Override
    public void setSASLibraryToSelect(String fqid) {
        this.m_strSASLibraryToSelect = fqid;
    }

    public String getSASLibraryToSelect() {
        return this.m_strSASLibraryToSelect;
    }

    public void setEngine(String strEngine) {
        this.m_strEngineTypeToLookFor = strEngine;
    }

    @Override
    public boolean validateData() {
        return ((LibraryDetailsPanel)this.m_selectedPanel).validateLibraryMetadata();
    }

    @Override
    public void setSelectionCriteria(String strXMLSelectString, String strEngineType) {
        this.m_strXMLSelectString = strXMLSelectString;
        this.m_strEngineTypeToLookFor = strEngineType.toUpperCase();
    }

    @Override
    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        this.myParent = (WAWizardDialog)this.getTopLevelAncestor();
        if (!saveToModel) {
            this.initializeLibraryCombo();
        } else {
            this.saveSelectedLibraryToAppDefaultFile();
        }
        return true;
    }

    public void saveSelectedLibraryToAppDefaultFile() throws RemoteException {
        Object obj = this.m_libraryBox.getSelectedItem();
        if (obj != null && obj instanceof CMetadata) {
            this.m_workspace.getAppDefaultsFile().setPropertyString("LibraryConnectPanel.LastLibrarySelected", ((CMetadata)obj).getFQID());
        }
    }

    public void initializeLibraryCombo() {
        if (!(this.myParent instanceof EngineDesigner)) {
            this.queryMetadata();
            if (this.m_libraryBox.hasItems()) {
                this.m_libraryBox.removeAllItems();
            }
        } else {
            Object smcLibrary = this.myParent.getWizardData("SELECTEDLIBRARY");
            if (smcLibrary != null) {
                this.vSASLibraryList.add(smcLibrary);
            }
        }
        this.m_libraryBox.addItems(this.vSASLibraryList);
        this.libListener = new cComboItemListener();
        this.m_libraryBox.addItemListener((ItemListener)this.libListener);
        if (!this.vSASLibraryList.isEmpty()) {
            if (this.m_strSASLibraryToSelect.length() > 0) {
                try {
                    for (int i = 0; i < this.m_libraryBox.getItemCount(); ++i) {
                        if (!((SASLibrary)this.m_libraryBox.getItemAt(i)).getFQID().equalsIgnoreCase(this.m_strSASLibraryToSelect)) continue;
                        this.m_libraryBox.setSelectedIndex(i);
                    }
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
                if (this.m_libraryBox.getSelectedIndex() < 0) {
                    this.m_libraryBox.setSelectedIndex(0);
                }
            } else {
                this.m_libraryBox.setSelectedIndex(0);
            }
            this.m_editButton.setEnabled(true);
        } else {
            this.m_editButton.setEnabled(false);
        }
    }

    public void setSourcePanel(String strSelectedSource) {
        int index = 0;
        for (int i = 0; i < this.m_cardClassesNames.size(); ++i) {
            String name = (String)this.m_cardClassesNames.get(i);
            if (name.compareTo(strSelectedSource) != 0) continue;
            index = i;
            break;
        }
        this.m_strSelectedIndex = index;
        this.m_selectedPanel = (AbstractConnectPanel)((Object)this.m_cardClasses.get(index));
        this.m_EngineTypeCards.show((Container)this.m_pnlEngineType, (String)this.m_cardClassesNames.get(index));
    }

    public void setSourcePanel(int index) {
        this.m_strSelectedIndex = index;
        this.m_selectedPanel = (AbstractConnectPanel)((Object)this.m_cardClasses.get(index));
        this.m_EngineTypeCards.show((Container)this.m_pnlEngineType, (String)this.m_cardClassesNames.get(index));
    }

    @Override
    public SASLibrary getLibrary() {
        return (SASLibrary)this.m_libraryBox.getSelectedItem();
    }

    @Override
    public RelationalSchema getSchema2() throws MdException, RemoteException {
        SASLibrary iLib = (SASLibrary)this.m_libraryBox.getSelectedItem();
        if (iLib.getIsDBMSLibname() > 0 && iLib.getEngine().toUpperCase().startsWith("REMOTE")) {
            return (SASLibrary)((SASLibrary)this.m_libraryBox.getSelectedItem()).getUsingPackages().elementAt(0);
        }
        if (this.m_strEngineTypeToLookFor.equalsIgnoreCase("SAS") || this.m_strEngineTypeToLookFor.startsWith("XML") || this.m_strEngineTypeToLookFor.equalsIgnoreCase("OTHER") && iLib.getIsDBMSLibname() == 0) {
            return null;
        }
        return (RelationalSchema)((SASLibrary)this.m_libraryBox.getSelectedItem()).getUsingPackages().elementAt(0);
    }

    @Override
    public DatabaseSchema getSchema() throws MdException, RemoteException {
        SASLibrary iLib = (SASLibrary)this.m_libraryBox.getSelectedItem();
        if (this.m_strEngineTypeToLookFor.compareTo("SAS") == 0 || this.m_strEngineTypeToLookFor.compareTo("OTHER") == 0 && iLib.getIsDBMSLibname() == 0) {
            return null;
        }
        return (DatabaseSchema)((SASLibrary)this.m_libraryBox.getSelectedItem()).getUsingPackages().elementAt(0);
    }

    public void selectHandler() {
        this.myParent.setCursor(Cursor.getPredefinedCursor(3));
        this.m_library = (SASLibrary)this.m_libraryBox.getSelectedItem();
        this.m_selectedPanel.setLibrary(this.m_library);
        this.myParent.addWizardData("SELECTEDLIBRARY", (Object)this.m_library);
        try {
            this.m_selectedPanel.doDataExchange(false);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.myParent.setCursor(null);
    }

    public void getLibraryDetails() {
        this.myParent.setCursor(Cursor.getPredefinedCursor(3));
        this.m_library = this.m_libraryBox.getSelectedItem() instanceof SASLibrary ? (SASLibrary)this.m_libraryBox.getSelectedItem() : null;
        this.m_selectedPanel.setLibrary(this.m_library);
        this.myParent.addWizardData("SELECTEDLIBRARY", (Object)this.m_library);
        try {
            this.m_selectedPanel.doDataExchange(false);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.myParent.setCursor(null);
    }

    protected void queryMetadata() {
        try {
            String sXMLtype;
            MdObjectStore store = (MdObjectStore)this.myParent.getWizardData("OBJECTSTORE");
            String sOptions = null;
            if (this.m_strXMLSelectString == null && this.m_strEngineTypeToLookFor == null) {
                Object smcLibrary = this.myParent.getWizardData("SELECTEDLIBRARY");
                if (smcLibrary != null) {
                    this.vSASLibraryList.add(smcLibrary);
                }
                return;
            }
            sOptions = this.m_strXMLSelectString != null ? this.m_strXMLSelectString : (this.m_strEngineTypeToLookFor.compareTo("SAS") == 0 ? "<XMLSELECT Search=\"@ISDBMSLIBNAME='0'\"/>" : (this.m_strEngineTypeToLookFor.equalsIgnoreCase("SASSHARE") ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'REMOTE']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("DB2UNXPC") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'DB2UNXPC']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("DB2OS390") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'DB2OS390']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCOTHER") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCOTHER']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCACCESS") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCACCESS']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCEXCEL") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCEXCEL']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCINFORMIX") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCINFORMIX']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCORACLE") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCORACLE']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCSQLSVR") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCSQLSVR']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCSQLSVRPC") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCSQLSVRPC']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCSYBASE") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCSYBASE']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCTERADATA") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCTERADATA']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCDB2OS390") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCDB2OS390']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCDB2UNXPC") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCDB2UNXPC']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBOTHER") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBOTHER']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBACCESS") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBACCESS']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBEXCEL") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBEXCEL']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBINFORMIX") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBINFORMIX']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBORACLE") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBORACLE']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBSQLSVR") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBSQLSVR']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBSQLSVRPC") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBSQLSVRPC']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBSYBASE") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBSYBASE']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBTERADATA") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBTERADATA']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBDB2OS390") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBDB2OS390']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBDB2UNXPC") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBDB2UNXPC']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("SPDE") == 0 ? "<XMLSELECT Search=\"@ENGINE='" + this.m_strEngineTypeToLookFor + "'\"/>" : (this.m_strEngineTypeToLookFor.compareTo("NEOVIEW") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'NEOVIEW']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("NETEZZA") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'NETEZZA']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ASTER") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ASTER']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("SYBASEIQ") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'SYBASEIQ']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("GREENPLM") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'GREENPLM']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("FEDSVR") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'SAS FEDERATION SERVER']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("POSTGRES") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'POSTGRES']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("SASIOHNA") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'SASIOHNA']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("VERTICA") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'VERTICA']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("SASIOIMP") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'SASIOIMP']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("SASIOPI") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'PI System']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("SASIOHWQ") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'HAWQ']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("SASIORST") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'Redshift']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("JDBC") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'SASIOJDB']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBNETEZZA") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBNETEZZA']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("SASIOLA") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'SASIOLA']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("CAS") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'CAS']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("SASIOMGO") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'MONGODB']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("SASIOSLF") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'SALESFORCE']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("SASIOGBQ") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'BIGQUERY']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("SASIOSNF") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'SASIOSNF']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("SASIOYLB") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'YELLOWBRICK']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("SASIOSK") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'SPARK']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("SASHDAT") == 0 ? "<XMLSelect search=\"*[@Engine='SASHDAT'][LibraryConnection/SASClientConnection/Source/*[@ProductName = 'HADOOP']]\"/>" : (this.m_strEngineTypeToLookFor.startsWith("XMLV2") ? ((sXMLtype = this.m_strEngineTypeToLookFor.substring(5)).length() < 1 ? "<XMLSELECT Search=\"@ENGINE='XMLV2'\"/>" : "<XMLSELECT search=\"*[@Engine='XMLV2'][Properties/Property[@PropertyName='XMLTYPE' AND @DefaultValue='" + sXMLtype + "']]\"/>") : (this.m_strEngineTypeToLookFor.startsWith("XML") ? ((sXMLtype = this.m_strEngineTypeToLookFor.substring(3)).length() < 1 ? "<XMLSELECT Search=\"@ENGINE='XML'\"/>" : "<XMLSELECT search=\"*[@Engine='XML'][Properties/Property[@PropertyName='XMLTYPE' AND @DefaultValue='" + sXMLtype + "']]\"/>") : (this.m_strEngineTypeToLookFor.compareTo("JSON") == 0 ? "<XMLSELECT Search=\"@ENGINE='JSON'\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OTHER") == 0 ? "<XMLSelect search=\"*[UsingPrototype/*[@Name = 'Generic Library' OR @Name = 'Library.Generic.Prototype.Name.xmlKey.txt']]\"/>" : "<XMLSELECT Search=\"@ENGINE='" + this.m_strEngineTypeToLookFor + "' and @ISDBMSLIBNAME='1'\"/>")))))))))))))))))))))))))))))))))))))))))))))))))))))));
            List listWithCheckouts = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, Workspace.getWorkspace().getDefaultRepository().getFQID(), "SASLibrary", 8584, sOptions);
            this.vSASLibraryList = !listWithCheckouts.isEmpty() ? Workspace.removeCheckouts((List)listWithCheckouts) : listWithCheckouts;
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_editButton.setEnabled(editable);
        this.m_newButton.setEnabled(editable);
        this.m_libraryBox.setEnabled(editable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showEditDialog() throws RemoteException, MdException {
        MdObjectStore childStore = Workspace.getMdFactory().createObjectStore(null, "LibraryConnectPanel.EditLibrary");
        try {
            SASLibrary selectedLibrary = (SASLibrary)this.m_libraryBox.getSelectedItem();
            SASLibrary oLibrary = (SASLibrary)Workspace.getMdFactory().createComplexMetadataObject(childStore, null, selectedLibrary.getName(), selectedLibrary.getCMetadataType(), selectedLibrary.getId(), null);
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oLibrary, null, null, "", 8);
            AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), ObjectConverter.getInstance().convertToSimpleObject((PrimaryType)oLibrary));
        }
        finally {
            childStore.dispose();
        }
    }

    class cNewButtonListener
    implements ActionListener {
        cNewButtonListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            Workspace work = Workspace.getWorkspace();
            MdObjectStore store = (MdObjectStore)LibraryConnectPanel.this.myParent.getWizardData("OBJECTSTORE");
            try {
                MdObjectStore childStore = Workspace.getMdFactory().createObjectStore();
                try {
                    Library library;
                    String[] aLibEngine;
                    LibraryWizard m_wizard;
                    WAWizardDialog wizardDialog = (WAWizardDialog)LibraryConnectPanel.this.getTopLevelAncestor();
                    Tree tree = (Tree)wizardDialog.getWizardData("GROUP");
                    if (tree == null) {
                        tree = WsMetadataUtil.getDefaultFolder((MdObjectStore)childStore);
                    }
                    String sRepositoryID = "";
                    sRepositoryID = work.isChangeManagementOn() || tree == null ? work.getDefaultRepository().getFQID() : "A0000001." + tree.getRepositoryID();
                    String engineName = LibraryConnectPanel.this.m_strEngineTypeToLookFor;
                    if (engineName != null) {
                        if (engineName.startsWith("ODBC")) {
                            engineName = "ODBC";
                        } else if (engineName.startsWith("OLEDB")) {
                            engineName = "OLEDB";
                        } else if (engineName.startsWith("XMLV2")) {
                            engineName = "XMLV2";
                        } else if (engineName.startsWith("XML")) {
                            engineName = "XML";
                        }
                    }
                    if (LibraryConnectPanel.this.m_strEngineTypeToLookFor == "OTHER" || LibraryConnectPanel.this.m_strEngineTypeToLookFor == null) {
                        m_wizard = new LibraryWizard((JFrame)work, sRepositoryID, bundle.getString("NewLibraryWizard.Title.txt"), null, childStore, null, tree);
                    } else if (LibraryConnectPanel.this.m_strEngineTypeToLookFor.equalsIgnoreCase("SASSHARE")) {
                        aLibEngine = new String[]{"REMOTE"};
                        m_wizard = new LibraryWizard((JFrame)work, sRepositoryID, bundle.getString("NewLibraryWizard.Title.txt"), aLibEngine, childStore, null, tree);
                    } else {
                        aLibEngine = new String[]{engineName};
                        m_wizard = new LibraryWizard((JFrame)work, sRepositoryID, bundle.getString("NewLibraryWizard.Title.txt"), aLibEngine, childStore, null, tree);
                    }
                    m_wizard.show();
                    if (!(m_wizard.getReturnValue() != 1 && m_wizard.getReturnValue() != 3 || (library = (Library)m_wizard.getWizardData("Library")) == null || library.getDeployedDataPackage().isNewObject())) {
                        SASLibrary sasLibraryObject = (SASLibrary)library.getDeployedDataPackage();
                        sasLibraryObject = (SASLibrary)Workspace.getMdFactory().createComplexMetadataObject(store, (CMetadata)sasLibraryObject);
                        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)sasLibraryObject, null, null, "", 8);
                        LibraryConnectPanel.this.m_libraryBox.addItem((Object)sasLibraryObject);
                        LibraryConnectPanel.this.m_libraryBox.setSelectedItem((Object)sasLibraryObject);
                        if (!LibraryConnectPanel.this.m_editButton.isEnabled()) {
                            LibraryConnectPanel.this.m_editButton.setEnabled(true);
                        }
                    }
                }
                catch (ServiceException se) {
                    MessageUtil.displayServiceExceptionMessage((ServiceException)se);
                }
                finally {
                    childStore.dispose();
                    Workspace.getMdFactory().dumpDetailHashMap();
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    class cEditButtonListener
    implements ActionListener {
        cEditButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                if (!PrototypeUtil.isPrototypeCompatible((Root)((SASLibrary)LibraryConnectPanel.this.m_libraryBox.getSelectedItem()), (Component)LibraryConnectPanel.this.getTopLevelAncestor())) {
                    VersionUtil.displayPropertiesMessage((Window)((Window)LibraryConnectPanel.this.getTopLevelAncestor()), (String)bundle.getString("apptitle"));
                    return;
                }
                LibraryConnectPanel.this.showEditDialog();
                int index = LibraryConnectPanel.this.m_libraryBox.getSelectedIndex();
                LibraryConnectPanel.this.m_libraryBox.setSelectedIndex(index);
                LibraryConnectPanel.this.getLibraryDetails();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
        }
    }

    class cComboItemListener
    implements ItemListener {
        cComboItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            if (ie.getStateChange() == 1) {
                LibraryConnectPanel.this.getLibraryDetails();
            }
        }
    }

    class cLibraryBoxListener
    implements ActionListener {
        cLibraryBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (LibraryConnectPanel.this.m_libraryBox.getItemCount() > 0) {
                LibraryConnectPanel.this.selectHandler();
            }
        }
    }
}

