/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.KeyAssociation;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.UniqueKey;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.wadmin.model.IndexColumnTableModel;
import com.sas.wadmin.visuals.IndexTableCellRenderer;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATable;
import com.sas.workspace.WATableModel;
import com.sas.workspace.WAUndoable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTablePairingsPanel;
import com.sas.workspace.WsUIUtilities;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.undo.UndoableEdit;

public class KeyColumnMappingsPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(KeyColumnMappingsPanel.class);
    protected MdObjectStore store;
    protected String reposID;
    protected UniqueKey primaryKey;
    protected ForeignKey foreignKey;
    protected WATable sourceTable;
    protected DataTable foreignKeyTable;
    protected DataTable primaryKeyTable;
    protected WATable targetTable;
    protected IndexColumnTableModel sourceModel;
    protected IndexColumnTableModel targetModel;
    protected JButton newButton;
    protected JButton deleteButton;
    protected JButton impExpButton;
    protected JPanel buttonPanel;
    protected WsTablePairingsPanel mappingPanel;
    protected WsAbstractAction newAction;
    protected WsAbstractAction deleteAction;
    protected WsAbstractAction exportAction;
    protected WsAbstractAction importAction;
    protected ListSelectionListener tableRowSelectionListener;
    protected boolean showForeignKeyInLeftTable = false;
    protected Column deletedForeignKeyColumn;

    public KeyColumnMappingsPanel() {
        this.initialize();
        this.layoutWidgets();
    }

    public KeyColumnMappingsPanel(UniqueKey key, ForeignKey fKey, MdObjectStore objStore, boolean switchTables) {
        this.store = objStore;
        this.showForeignKeyInLeftTable = switchTables;
        this.setKeys(key, fKey);
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.tableRowSelectionListener = this.createTableRowSelectionListener();
        this.sourceModel = new IndexColumnTableModel();
        this.targetModel = new IndexColumnTableModel();
        this.mappingPanel = new WsTablePairingsPanel();
        this.mappingPanel.addPairingEventListener(this.createPairingEventListener());
        this.mappingPanel.setPopupMenuRequestListener(this.createPopupMenuListener());
        this.mappingPanel.addTableSelectionListener(this.createTableSelectionListener());
        this.newAction = this.createNewAction();
        this.deleteAction = this.createDeleteAction();
        if (this.showForeignKeyInLeftTable) {
            this.importAction = this.createImportAction();
            this.impExpButton = WsUIUtilities.createTextButton((WsAbstractAction)this.importAction);
        } else {
            this.exportAction = this.createExportAction();
            this.impExpButton = WsUIUtilities.createTextButton((WsAbstractAction)this.exportAction);
        }
        this.newButton = WsUIUtilities.createTextButton((WsAbstractAction)this.newAction);
        this.deleteButton = WsUIUtilities.createTextButton((WsAbstractAction)this.deleteAction);
        this.buttonPanel = new JPanel();
    }

    protected void layoutWidgets() {
        this.buttonPanel.setLayout((LayoutManager)new WsButtonsLayout(0, 0));
        this.buttonPanel.add(this.newButton);
        this.buttonPanel.add(this.deleteButton);
        this.buttonPanel.add(this.impExpButton);
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)this.mappingPanel, "Center");
        this.add(this.buttonPanel, "South");
    }

    public void setKeys(UniqueKey key, ForeignKey fKey) {
        this.primaryKey = key;
        this.foreignKey = fKey;
        try {
            AssociationList alKeyAssoc = this.foreignKey.getKeyAssociations();
            int alSize = alKeyAssoc.size();
            this.reposID = alSize > 0 ? ((KeyAssociation)alKeyAssoc.get(0)).getRepositoryID() : this.foreignKey.getRepositoryID();
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void setObjectStore(MdObjectStore objStore) {
        this.store = objStore;
    }

    public boolean validateData() {
        ArrayList list = this.mappingPanel.getPairings();
        if (list.size() < 1) {
            try {
                MessageUtil.displayMessage((String)bundle.formatString("KeyColumnMappingsPanel.ErrorNoLinks.txt", (Object)this.foreignKey.getName()), (int)0);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            return false;
        }
        return true;
    }

    public void refresh() {
        this.mappingPanel.removeAllPairings();
        this.addAllPairings();
        this.mappingPanel.repaint();
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        if (this.store == null) {
            this.store = Workspace.getMdFactory().createObjectStore();
        }
        this.primaryKeyTable = this.primaryKey.getTable();
        this.foreignKeyTable = this.foreignKey.getTable();
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.sourceTable = this.createTable(this.sourceModel);
        this.targetTable = this.createTable(this.targetModel);
        if (this.showForeignKeyInLeftTable) {
            this.sourceModel.setGoToServer(false);
            this.sourceModel.setupModel((CMetadata)this.foreignKeyTable);
            this.mappingPanel.addSourceTable(this.foreignKeyTable.getName(), this.sourceTable);
            this.targetModel.setGoToServer(false);
            this.targetModel.setupModel((CMetadata)this.primaryKey);
            this.mappingPanel.addTargetTable(this.primaryKeyTable.getName(), this.targetTable);
        } else {
            this.sourceModel.setGoToServer(false);
            this.sourceModel.setupModel((CMetadata)this.primaryKey);
            this.mappingPanel.addSourceTable(this.primaryKeyTable.getName(), this.sourceTable);
            if (this.foreignKey.isNewObject()) {
                this.targetModel.setGoToServer(false);
            } else {
                this.targetModel.setGoToServer(true);
            }
            this.targetModel.setupModel((CMetadata)this.foreignKeyTable);
            this.mappingPanel.addTargetTable(this.foreignKeyTable.getName(), this.targetTable);
        }
        this.addAllPairings();
        this.mappingPanel.repaint();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        AssociationList fkColumns = this.foreignKey.getKeyedColumns();
        AssociationList keyAssocs = this.foreignKey.getKeyAssociations();
        int size = keyAssocs.size();
        for (int i = --size; i > -1; --i) {
            this.store.removeObjectFromStore((CMetadata)keyAssocs.get(i), null);
        }
        fkColumns.removeAllElements();
        fkColumns.flushAll();
        fkColumns.setState(16);
        ArrayList alPairings = this.mappingPanel.getPairings(0, 0);
        for (int j = 0; j < alPairings.size(); ++j) {
            KeyAssociation keyAssoc;
            WsTablePairingsPanel.cPairing pairing = (WsTablePairingsPanel.cPairing)alPairings.get(j);
            Column sourceColumn = (Column)this.sourceModel.getValueAt(pairing.getSource(), 16);
            Column targetColumn = (Column)this.targetModel.getValueAt(pairing.getTarget(), 16);
            if (this.showForeignKeyInLeftTable) {
                fkColumns.addElement((Object)sourceColumn);
                keyAssoc = (KeyAssociation)Workspace.getMdFactory().createComplexMetadataObject(this.store, null, targetColumn.getSASColumnName() + "." + sourceColumn.getSASColumnName(), "KeyAssociation", this.reposID);
                keyAssoc.setOwningForeignKey(this.foreignKey);
                keyAssoc.setForeignKeyColumn(sourceColumn);
                keyAssoc.setUniqueKeyColumn(targetColumn);
                continue;
            }
            fkColumns.addElement((Object)targetColumn);
            keyAssoc = (KeyAssociation)Workspace.getMdFactory().createComplexMetadataObject(this.store, null, sourceColumn.getSASColumnName() + "." + targetColumn.getSASColumnName(), "KeyAssociation", this.reposID);
            keyAssoc.setOwningForeignKey(this.foreignKey);
            keyAssoc.setForeignKeyColumn(targetColumn);
            keyAssoc.setUniqueKeyColumn(sourceColumn);
        }
    }

    public ForeignKey getForeignKey() {
        return this.foreignKey;
    }

    public Column getDeletedForeignKeyColumn() {
        return this.deletedForeignKeyColumn;
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        if (saveToModel) {
            this.moveDataToStore();
        } else {
            this.populateStore();
            this.moveDataToView();
        }
        return true;
    }

    protected WATable createTable(IndexColumnTableModel model) {
        WATable table = new WATable((WATableModel)model);
        table.setEditable(false);
        table.enableHeaderMenu(true);
        table.setAutoResizeMode(0);
        table.getTableHeader().setReorderingAllowed(true);
        table.setCellSelectionEnabled(false);
        table.setRowSelectionAllowed(true);
        table.setSelectionMode(0);
        table.hideColumn(16);
        table.hideColumn(11);
        table.hideColumn(12);
        table.hideColumn(13);
        table.hideColumn(14);
        table.hideColumn(15);
        int mask = Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt("MappingPanel.Shown", 7);
        table.parseColumnsMask(mask);
        TableColumn colName = table.getColumnModel().getColumn(0);
        TableColumn colDesc = table.getColumnModel().getColumn(1);
        TableColumn colLength = table.getColumnModel().getColumn(2);
        colName.setPreferredWidth(175);
        colDesc.setPreferredWidth(225);
        colLength.setPreferredWidth(50);
        colLength.setMinWidth(50);
        IndexTableCellRenderer itcr = new IndexTableCellRenderer();
        colName.setCellRenderer(itcr);
        table.getSelectionModel().addListSelectionListener(this.tableRowSelectionListener);
        table.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.deleteAction);
        table.getActionMap().put(this.deleteAction, (Action)this.deleteAction);
        return table;
    }

    public void addAllPairings() {
        try {
            AssociationList keyAssocList = this.foreignKey.getKeyAssociations();
            int numOfKeyAssoc = keyAssocList.size();
            if (numOfKeyAssoc > 0) {
                for (int i = 0; i < numOfKeyAssoc; ++i) {
                    KeyAssociation keyAssoc = (KeyAssociation)keyAssocList.get(i);
                    Column sourceColumn = keyAssoc.getUniqueKeyColumn();
                    Column targetColumn = keyAssoc.getForeignKeyColumn();
                    int sourceRow = this.primaryKey.getKeyedColumns().getObjectIDs().indexOf(sourceColumn.getFQID());
                    int targetRow = this.foreignKeyTable.getColumns().getObjectIDs().indexOf(targetColumn.getFQID());
                    if (this.showForeignKeyInLeftTable) {
                        this.mappingPanel.addPairing(targetRow, sourceRow);
                        continue;
                    }
                    this.mappingPanel.addPairing(sourceRow, targetRow);
                }
            }
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void doNew() {
        int sourceRow = this.mappingPanel.getSourceTable().getSelectedRow();
        int targetRow = this.mappingPanel.getTargetTable().getSelectedRow();
        if (sourceRow == -1 || targetRow == -1) {
            return;
        }
        if (!this.mappingPanel.pairingExists(sourceRow, targetRow)) {
            if (this.validatePairing(sourceRow, targetRow)) {
                if (this.newButton.hasFocus()) {
                    this.mappingPanel.getSourceTable().requestFocus();
                }
                this.addPairing(sourceRow, targetRow);
                this.waum.addEdit((UndoableEdit)((Object)new UndoableAdd(sourceRow, targetRow)));
                this.setDataChanged(true);
                this.updateUIComponents();
                this.fireKeyColumnAddedEvent();
            } else {
                MessageUtil.displayMessage((String)bundle.getString("KeyColumnMappingsPanel.InvalidLinkError.txt"), (int)0);
            }
        }
    }

    public void doDelete() {
        int sourceRow = this.mappingPanel.getSourceTable().getSelectedRow();
        int targetRow = this.mappingPanel.getTargetTable().getSelectedRow();
        if (this.deleteButton.hasFocus()) {
            this.mappingPanel.getSourceTable().requestFocus();
        }
        WsTablePairingsPanel.cPairing pairing = this.mappingPanel.getRealPairing(sourceRow, targetRow);
        this.deletePairings(pairing);
        this.waum.addEdit((UndoableEdit)((Object)new UndoableDelete(pairing)));
        this.fireKeyColumnRemovedEvent();
        this.setDataChanged(true);
    }

    public void deletePairings(WsTablePairingsPanel.cPairing pairing) {
        int sourceRow = pairing.getSource();
        Column sourceColumn = (Column)this.sourceModel.getValueAt(sourceRow, 16);
        int targetRow = pairing.getTarget();
        Column targetColumn = (Column)this.targetModel.getValueAt(targetRow, 16);
        this.mappingPanel.removePairing(pairing);
        this.deletedForeignKeyColumn = this.showForeignKeyInLeftTable ? sourceColumn : targetColumn;
    }

    public boolean validatePairing(int sourceRow, int targetRow) {
        try {
            Column targetColumn = (Column)this.targetModel.getValueAt(targetRow, 16);
            Column sourceColumn = (Column)this.sourceModel.getValueAt(sourceRow, 16);
            if (targetColumn.getSASColumnType().equalsIgnoreCase(sourceColumn.getSASColumnType())) {
                if (targetColumn.getSASColumnType().equalsIgnoreCase("N")) {
                    if (targetColumn.getSASColumnLength() == sourceColumn.getSASColumnLength()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public void addPairing(int sourceRow, int targetRow) {
        this.mappingPanel.addPairing(sourceRow, targetRow);
        this.mappingPanel.selectPairing(sourceRow, targetRow);
    }

    public void doExport() {
        boolean isColumnAdded;
        int sourceRow = this.sourceTable.getSelectedRow();
        int targetRow = this.targetTable.getRowCount();
        if (this.impExpButton.hasFocus()) {
            this.mappingPanel.getSourceTable().requestFocus();
        }
        if (!(isColumnAdded = this.addColumnToTargetTable(sourceRow, targetRow))) {
            String sourceName = (String)this.sourceModel.getValueAt(sourceRow, 0);
            targetRow = this.findColumnNameInTable(sourceName);
        }
        this.addPairing(sourceRow, targetRow);
        this.waum.addEdit((UndoableEdit)((Object)new UndoableExport(sourceRow, targetRow)));
        this.updateUIComponents();
        this.setDataChanged(true);
        this.fireKeyColumnAddedEvent();
    }

    public void doImport() {
        boolean isColumnAdded;
        int targetRow = this.targetTable.getSelectedRow();
        int sourceRow = this.sourceTable.getRowCount();
        if (this.impExpButton.hasFocus()) {
            this.mappingPanel.getTargetTable().requestFocus();
        }
        if (!(isColumnAdded = this.addColumnToTargetTable(sourceRow, targetRow))) {
            String targetName = (String)this.targetModel.getValueAt(targetRow, 0);
            sourceRow = this.findColumnNameInTable(targetName);
        }
        this.addPairing(sourceRow, targetRow);
        this.waum.addEdit((UndoableEdit)((Object)new UndoableExport(sourceRow, targetRow)));
        this.updateUIComponents();
        this.setDataChanged(true);
        this.fireKeyColumnAddedEvent();
        this.fireKeyColumnImportedEvent();
    }

    public boolean addColumnToTargetTable(int sourceRow, int targetRow) {
        Column column = this.showForeignKeyInLeftTable ? (Column)this.targetModel.getValueAt(targetRow, 16) : (Column)this.sourceModel.getValueAt(sourceRow, 16);
        Column newColumn = null;
        try {
            String tabReposID = this.foreignKeyTable.getRepositoryID();
            boolean isColumnUnique = this.validateColumnNameUniqueness(this.foreignKeyTable, column.getSASColumnName());
            if (!isColumnUnique) {
                MessageUtil.displayMessage((String)bundle.formatString("KeyColumnMappingsPanel.InvalidColumn.txt", (Object)column.getSASColumnName()), (int)0);
                return false;
            }
            newColumn = (Column)Workspace.getMdFactory().createComplexMetadataObject(this.store, null, column.getName(), "Column", tabReposID);
            newColumn.setPublicType("Column");
            newColumn.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
            newColumn.setColumnName(column.getSASColumnName());
            newColumn.setDesc(column.getDesc());
            newColumn.setSASColumnName(column.getSASColumnName());
            newColumn.setSASColumnType(column.getSASColumnType());
            newColumn.setSASColumnLength(column.getSASColumnLength());
            newColumn.setSASInformat(column.getSASInformat());
            newColumn.setSASFormat(column.getSASFormat());
            newColumn.setIsDiscrete(column.getIsDiscrete());
            newColumn.setIsNullable(column.getIsNullable());
            newColumn.setColumnType(column.getColumnType());
            newColumn.setColumnLength(column.getColumnLength());
            newColumn.setSortOrder(column.getSortOrder());
            newColumn.setSummaryRole(column.getSummaryRole());
            this.foreignKeyTable.getColumns().add((Object)newColumn);
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Creating");
            return false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        ArrayList newRow = this.createTableRow(newColumn);
        if (this.showForeignKeyInLeftTable) {
            this.sourceModel.insertAt(newRow, sourceRow);
        } else {
            this.targetModel.insertAt(newRow, targetRow);
        }
        return true;
    }

    protected boolean validateColumnNameUniqueness(DataTable table, String name) {
        try {
            AssociationList lCols = table.getColumns();
            for (int i = 0; i < lCols.size(); ++i) {
                Column col = (Column)lCols.get(i);
                if (!name.equalsIgnoreCase(col.getSASColumnName())) continue;
                return false;
            }
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            return false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return true;
    }

    protected int findColumnNameInTable(String name) {
        int row = 0;
        try {
            Column col;
            AssociationList lCols = this.foreignKeyTable.getColumns();
            for (row = 0; row < lCols.size() && !name.equalsIgnoreCase((col = (Column)lCols.get(row)).getSASColumnName()); ++row) {
            }
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            return 0;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return row;
    }

    protected ArrayList createTableRow(Column column) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(column.getSASColumnName());
            row.add(column.getDesc());
            row.add(new Integer(column.getSASColumnLength()));
            row.add(WsColumnMetadataUtil.getColumnViewTypeString((Column)column));
            String string = column.getSummaryRole();
            if (string == null || string.length() == 0) {
                row.add("");
            } else {
                row.add(string);
            }
            string = column.getSortOrder();
            if (string == null || string.length() == 0) {
                row.add("");
            } else {
                row.add(string);
            }
            string = column.getSASInformat();
            if (string == null || string.length() == 0) {
                row.add("");
            } else {
                row.add(string);
            }
            string = column.getSASFormat();
            if (string == null || string.length() == 0) {
                row.add("");
            } else {
                row.add(string);
            }
            int boo = column.getIsNullable();
            if (boo == 0) {
                row.add(bundle.getString("Common.No.txt"));
            } else {
                row.add(bundle.getString("Common.Yes.txt"));
            }
            if (column.getKeys(false).size() > 0) {
                row.add(IndexColumnTableModel.PRIMARY);
            } else {
                row.add(IndexColumnTableModel.NONE);
            }
            row.add("");
            if (column.getNotes(false).size() > 0 || column.getDocuments(false).size() > 0) {
                row.add(IndexColumnTableModel.PRIMARY);
            } else {
                row.add(IndexColumnTableModel.NONE);
            }
            if (column.getExtensions(false).size() > 0) {
                row.add(IndexColumnTableModel.PRIMARY);
            } else {
                row.add(IndexColumnTableModel.NONE);
            }
            ArrayList<Object> nl = new ArrayList<Object>();
            AssociationList nList = column.getNotes(false);
            for (int x = 0; x < nList.size(); ++x) {
                nl.add(nList.get(x));
            }
            row.add(nl);
            ArrayList<Object> el = new ArrayList<Object>();
            AssociationList exList = column.getExtensions(false);
            for (int y = 0; y < exList.size(); ++y) {
                el.add(exList.get(y));
            }
            row.add(el);
            ArrayList<Object> dl = new ArrayList<Object>();
            AssociationList dList = column.getDocuments(false);
            for (int z = 0; z < dList.size(); ++z) {
                dl.add(dList.get(z));
            }
            row.add(dl);
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        row.add(column);
        return row;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.newAction.setActive(bActive);
        this.exportAction.setActive(bActive);
        this.deleteAction.setActive(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        if (bEditable) {
            this.updateUIComponents();
        } else {
            this.newAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
            if (this.showForeignKeyInLeftTable) {
                this.importAction.setEnabled(false);
            } else {
                this.exportAction.setEnabled(false);
            }
        }
        this.mappingPanel.setDraggingFromSourceTableEnabled(bEditable);
    }

    protected void updateUIComponents() {
        if (!this.isEditable()) {
            return;
        }
        WATable tblSource = this.mappingPanel.getSourceTable();
        WATable tblTarget = this.mappingPanel.getTargetTable();
        int sourceRow = tblSource != null ? tblSource.getSelectedRow() : -1;
        int targetRow = tblTarget != null ? tblTarget.getSelectedRow() : -1;
        boolean pairingExists = sourceRow == -1 || targetRow == -1 ? false : this.mappingPanel.pairingExists(sourceRow, targetRow);
        this.newAction.setEnabled(sourceRow != -1 && targetRow != -1 && !pairingExists);
        this.deleteAction.setEnabled(pairingExists);
        if (this.showForeignKeyInLeftTable) {
            if (targetRow != -1) {
                ArrayList al = this.mappingPanel.getPairings();
                boolean isExisting = false;
                for (int i = 0; i < al.size(); ++i) {
                    WsTablePairingsPanel.cPairing pairing = (WsTablePairingsPanel.cPairing)al.get(i);
                    int row = pairing.getTarget();
                    if (row != targetRow) continue;
                    isExisting = true;
                    break;
                }
                this.importAction.setEnabled(!isExisting);
            } else {
                this.importAction.setEnabled(false);
            }
        } else if (sourceRow != -1) {
            ArrayList al = this.mappingPanel.getPairings();
            boolean isExisting = false;
            for (int i = 0; i < al.size(); ++i) {
                WsTablePairingsPanel.cPairing pairing = (WsTablePairingsPanel.cPairing)al.get(i);
                int row = pairing.getSource();
                if (row != sourceRow) continue;
                isExisting = true;
                break;
            }
            this.exportAction.setEnabled(!isExisting);
        } else {
            this.exportAction.setEnabled(false);
        }
    }

    public void addKeyColumnEventListener(KeyColumnEventListener l) {
        this.listenerList.add(KeyColumnEventListener.class, l);
    }

    public void removeKeyColumnEventListener(KeyColumnEventListener l) {
        this.listenerList.add(KeyColumnEventListener.class, l);
    }

    public void fireKeyColumnAddedEvent() {
        Object[] alListeners = this.listenerList.getListenerList();
        KeyColumnEvent e = null;
        for (int iListener = alListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (alListeners[iListener] != KeyColumnEventListener.class) continue;
            if (e == null) {
                e = new KeyColumnEvent(this, 1);
            }
            ((KeyColumnEventListener)alListeners[iListener + 1]).keyColumnAdded(e);
        }
    }

    public void fireKeyColumnRemovedEvent() {
        Object[] alListeners = this.listenerList.getListenerList();
        KeyColumnEvent e = null;
        for (int iListener = alListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (alListeners[iListener] != KeyColumnEventListener.class) continue;
            if (e == null) {
                e = new KeyColumnEvent(this, 2);
            }
            ((KeyColumnEventListener)alListeners[iListener + 1]).keyColumnRemoved(e);
        }
    }

    public void fireKeyColumnImportedEvent() {
        Object[] alListeners = this.listenerList.getListenerList();
        KeyColumnEvent e = null;
        for (int iListener = alListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (alListeners[iListener] != KeyColumnEventListener.class) continue;
            if (e == null) {
                e = new KeyColumnEvent(this, 3);
            }
            ((KeyColumnEventListener)alListeners[iListener + 1]).keyColumnImported(e);
        }
    }

    protected WsAbstractAction createNewAction() {
        return new NewAction();
    }

    protected WsAbstractAction createDeleteAction() {
        return new DeleteAction();
    }

    protected WsAbstractAction createImportAction() {
        return new ImportAction();
    }

    protected WsAbstractAction createExportAction() {
        return new ExportAction();
    }

    public WsPopupMenuRequestListener createPopupMenuListener() {
        return new PopupMenuListener();
    }

    protected WsTablePairingsPanel.iTableSelectionListener createTableSelectionListener() {
        return new TableSelectionListener();
    }

    protected WsTablePairingsPanel.iPairingEventListener createPairingEventListener() {
        return new PairingEventListener();
    }

    public void saveSettingsAndCleanUp() {
        this.store = null;
        this.primaryKey = null;
        this.foreignKey = null;
        this.foreignKeyTable = null;
    }

    protected ListSelectionListener createTableRowSelectionListener() {
        return new TableRowSelectionListener();
    }

    protected class UndoableAdd
    extends WAUndoable {
        protected int sourceRow;
        protected int targetRow;

        public UndoableAdd(int source, int target) {
            this.sourceRow = source;
            this.targetRow = target;
        }

        public void undo() {
            super.undo();
            KeyColumnMappingsPanel.this.mappingPanel.removePairing(this.sourceRow, this.targetRow);
        }

        public void redo() {
            super.redo();
            KeyColumnMappingsPanel.this.addPairing(this.sourceRow, this.targetRow);
            KeyColumnMappingsPanel.this.setDataChanged(true);
        }
    }

    protected class UndoableDelete
    extends WAUndoable {
        protected WsTablePairingsPanel.cPairing pairing;

        public UndoableDelete(WsTablePairingsPanel.cPairing pair) {
            this.pairing = pair;
        }

        public void undo() {
            super.undo();
            int sourceRow = this.pairing.getSource();
            int targetRow = this.pairing.getTarget();
            KeyColumnMappingsPanel.this.addPairing(sourceRow, targetRow);
            KeyColumnMappingsPanel.this.setDataChanged(true);
        }

        public void redo() {
            super.redo();
            KeyColumnMappingsPanel.this.deletePairings(this.pairing);
        }
    }

    protected class UndoableExport
    extends WAUndoable {
        protected int sourceRow;
        protected int targetRow;

        public UndoableExport(int source, int target) {
            this.sourceRow = source;
            this.targetRow = target;
        }

        public void undo() {
            super.undo();
            KeyColumnMappingsPanel.this.mappingPanel.removePairing(this.sourceRow, this.targetRow);
        }

        public void redo() {
            super.redo();
            KeyColumnMappingsPanel.this.addColumnToTargetTable(this.sourceRow, this.targetRow);
            KeyColumnMappingsPanel.this.addPairing(this.sourceRow, this.targetRow);
            KeyColumnMappingsPanel.this.setDataChanged(true);
        }
    }

    public static interface KeyColumnEventListener
    extends EventListener {
        public void keyColumnAdded(KeyColumnEvent var1);

        public void keyColumnRemoved(KeyColumnEvent var1);

        public void keyColumnImported(KeyColumnEvent var1);
    }

    public class KeyColumnEvent
    extends AWTEvent {
        public static final int KEY_COLUMN_ADDED = 1;
        public static final int KEY_COLUMN_REMOVED = 2;
        public static final int KEY_COLUMN_IMPORTED = 3;

        public KeyColumnEvent(KeyColumnMappingsPanel src, int type) {
            super((Object)src, type);
        }
    }

    protected class NewAction
    extends WsAbstractAction {
        public NewAction() {
            super(bundle, "KeyColumnMappingsPanel.New", true);
            this.setMenuSupportId("new");
        }

        public void actionPerformed(ActionEvent e) {
            KeyColumnMappingsPanel.this.doNew();
        }
    }

    protected class DeleteAction
    extends WsAbstractAction {
        public DeleteAction() {
            super(bundle, "KeyColumnMappingsPanel.Delete", true);
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent e) {
            KeyColumnMappingsPanel.this.doDelete();
        }
    }

    protected class ImportAction
    extends WsAbstractAction {
        public ImportAction() {
            super(bundle, "KeyColumnMappingsPanel.Import", true);
        }

        public void actionPerformed(ActionEvent e) {
            KeyColumnMappingsPanel.this.doImport();
        }
    }

    protected class ExportAction
    extends WsAbstractAction {
        public ExportAction() {
            super(bundle, "KeyColumnMappingsPanel.Export", true);
        }

        public void actionPerformed(ActionEvent e) {
            KeyColumnMappingsPanel.this.doExport();
        }
    }

    protected class PopupMenuListener
    implements WsPopupMenuRequestListener {
        protected PopupMenuListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPop = new JPopupMenu();
            mnuPop.add(new JMenuItem((Action)KeyColumnMappingsPanel.this.newAction));
            mnuPop.add(new JMenuItem((Action)KeyColumnMappingsPanel.this.deleteAction));
            if (KeyColumnMappingsPanel.this.showForeignKeyInLeftTable) {
                mnuPop.add(new JMenuItem((Action)KeyColumnMappingsPanel.this.exportAction));
            }
            mnuPop.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class TableSelectionListener
    implements WsTablePairingsPanel.iTableSelectionListener {
        protected TableSelectionListener() {
        }

        public void tableSelected(WsTablePairingsPanel.cTableSelectionEvent e) {
            KeyColumnMappingsPanel.this.updateUIComponents();
        }
    }

    protected class PairingEventListener
    implements WsTablePairingsPanel.iPairingEventListener {
        protected PairingEventListener() {
        }

        public void pairingAdded(WsTablePairingsPanel.cPairingEvent e) {
            int targetRow;
            WsTablePairingsPanel.cPairing pairing = e.getPairing();
            int sourceRow = pairing.getSource();
            if (KeyColumnMappingsPanel.this.validatePairing(sourceRow, targetRow = pairing.getTarget())) {
                KeyColumnMappingsPanel.this.setDataChanged(true);
                KeyColumnMappingsPanel.this.fireKeyColumnAddedEvent();
            } else {
                MessageUtil.displayMessage((String)bundle.getString("KeyColumnMappingsPanel.InvalidLinkError.txt"), (int)0);
                KeyColumnMappingsPanel.this.mappingPanel.removePairing(sourceRow, targetRow);
            }
        }

        public void pairingRemoved(WsTablePairingsPanel.cPairingEvent e) {
            WsTablePairingsPanel.cPairing pairing = e.getPairing();
            KeyColumnMappingsPanel.this.deletePairings(pairing);
            KeyColumnMappingsPanel.this.waum.addEdit((UndoableEdit)((Object)new UndoableDelete(pairing)));
            KeyColumnMappingsPanel.this.setDataChanged(true);
            KeyColumnMappingsPanel.this.fireKeyColumnRemovedEvent();
        }
    }

    protected class TableRowSelectionListener
    implements ListSelectionListener {
        protected TableRowSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            KeyColumnMappingsPanel.this.updateUIComponents();
        }
    }
}

