/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.wadmin.model.IndexColumnTableModel;
import com.sas.workspace.WATable;
import com.sas.workspace.WATableModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsCompoundIcon;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class IndexTableCellRenderer
extends JLabel
implements TableCellRenderer {
    protected static Border m_brdrNoFocus = new EmptyBorder(1, 1, 1, 1);
    protected boolean m_bShowTypeIcon = true;
    protected boolean m_bShowKeyIcon = false;
    protected boolean m_bShowNotesIcon = false;
    protected boolean m_bShowExtAttrsIcon = false;
    ImageIcon m_iconBlank = bundle.getImageIcon("Common.EmptyIcon.image");
    ImageIcon m_iconKey = bundle.getImageIcon("Common.Key.image");
    ImageIcon m_iconNote = bundle.getImageIcon("Common.Note.image");
    ImageIcon m_iconExtAttr = bundle.getImageIcon("Common.ExtAttr.image");
    private static WAdminResource bundle = WAdminResource.getBundle(IndexTableCellRenderer.class);

    public void showTypeIcon(boolean bShow) {
        this.m_bShowTypeIcon = bShow;
    }

    public boolean isTypeIconShown() {
        return this.m_bShowTypeIcon;
    }

    public void showKeyIcon(boolean bShow) {
        this.m_bShowKeyIcon = bShow;
    }

    public boolean isKeyIconShown() {
        return this.m_bShowKeyIcon;
    }

    public void showNotesIcon(boolean bShow) {
        this.m_bShowNotesIcon = bShow;
    }

    public boolean isNotesIconShown() {
        return this.m_bShowNotesIcon;
    }

    public void showExtAttrsIcon(boolean bShow) {
        this.m_bShowExtAttrsIcon = bShow;
    }

    public boolean isExtAttrsIconShown() {
        return this.m_bShowExtAttrsIcon;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        WATableModel mdl = (WATableModel)table.getModel();
        WsCompoundIcon compoundIcon = new WsCompoundIcon();
        compoundIcon.setIconGap(1);
        int realRow = ((WATable)table).convertRowIndexToModel(row);
        this.setText((String)value);
        if (this.m_bShowKeyIcon) {
            Object k = mdl.getValueAt(realRow, 9);
            compoundIcon.addIcon((Icon)(((Integer)k).intValue() == IndexColumnTableModel.PRIMARY.intValue() ? this.m_iconKey : this.m_iconBlank));
        }
        if (this.m_bShowNotesIcon) {
            Object n = mdl.getValueAt(realRow, 11);
            compoundIcon.addIcon((Icon)(((Integer)n).intValue() == IndexColumnTableModel.PRIMARY.intValue() ? this.m_iconNote : this.m_iconBlank));
        }
        if (this.m_bShowExtAttrsIcon) {
            Object ea = mdl.getValueAt(realRow, 12);
            compoundIcon.addIcon((Icon)(((Integer)ea).intValue() == IndexColumnTableModel.PRIMARY.intValue() ? this.m_iconExtAttr : this.m_iconBlank));
        }
        if (this.m_bShowTypeIcon) {
            String sType = (String)mdl.getValueAt(realRow, 3);
            compoundIcon.addIcon(WsColumnMetadataUtil.getColumnViewTypeIcon((String)sType));
        }
        if (compoundIcon.getIconCount() == 0) {
            this.setIcon(null);
        } else {
            this.setIcon((Icon)compoundIcon);
        }
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(table.getForeground());
            super.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(m_brdrNoFocus);
        }
        Color back = this.getBackground();
        boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
        this.setOpaque(!colorMatch);
        return this;
    }

    public int getTextOffset() {
        int iOff = 0;
        if (this.m_bShowKeyIcon) {
            iOff += this.m_iconBlank.getIconWidth() + 1;
        }
        if (this.m_bShowNotesIcon) {
            iOff += this.m_iconBlank.getIconWidth() + 1;
        }
        if (this.m_bShowExtAttrsIcon) {
            iOff += this.m_iconBlank.getIconWidth() + 1;
        }
        if (this.m_bShowTypeIcon) {
            iOff += this.m_iconBlank.getIconWidth() + 1;
        }
        return iOff;
    }
}

