/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Transformation;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.ImpactAnalysisGraphTab;
import com.sas.wadmin.visuals.ImpactAnalysisReportTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAPropertyTabGroup;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WsColumnMetadataUtil;
import java.rmi.RemoteException;
import javax.swing.Icon;

public class ImpactAnalysisOMAView
extends WorkspaceOMAView {
    private Classifier m_oTable;
    private Column m_oColumn;
    private boolean m_bForward;
    private Prototype m_oTransformPrototype;
    private Transformation m_oTransformation;
    private static WAdminResource bundle = WAdminResource.getBundle(ImpactAnalysisOMAView.class);

    public ImpactAnalysisOMAView(Classifier oTable, boolean bForward) {
        this.m_oTable = oTable;
        this.m_bForward = bForward;
    }

    public ImpactAnalysisOMAView(Column oColumn, boolean bForward) {
        this.m_oColumn = oColumn;
        this.m_bForward = bForward;
    }

    public ImpactAnalysisOMAView(Prototype oPrototype) {
        this.m_oTransformPrototype = oPrototype;
    }

    public ImpactAnalysisOMAView(TransformInterface oTransform, Prototype oPrototype, boolean bForward) {
        this(oPrototype);
    }

    public ImpactAnalysisOMAView(Transformation oTrans, boolean bForward) {
        this.m_oTransformation = oTrans;
        this.m_bForward = bForward;
    }

    protected String getFrameTitle() {
        try {
            if (this.m_oTable != null) {
                if (this.m_bForward) {
                    return bundle.formatString("ImpactAnalysisOMAView.ImpactAnalysis.FrameTitle.fmt.txt", (Object)this.m_metadata.getName());
                }
                return bundle.formatString("ImpactAnalysisOMAView.ReverseImpactAnalysis.FrameTitle.fmt.txt", (Object)this.m_metadata.getName());
            }
            if (this.m_oColumn != null) {
                DataTable table = this.m_oColumn.getTable();
                String sTableName = table == null ? "" : table.getName();
                String sMetadataName = this.m_metadata.getName();
                if (this.m_bForward) {
                    return bundle.formatString("ImpactAnalysisOMAView.ColumnImpactAnalysis.FrameTitle.fmt.txt", (Object)sTableName, (Object)sMetadataName);
                }
                return bundle.formatString("ImpactAnalysisOMAView.ColumnReverseImpactAnalysis.FrameTitle.fmt.txt", (Object)sTableName, (Object)sMetadataName);
            }
            if (this.m_oTransformPrototype != null) {
                return bundle.formatString("ImpactAnalysisOMAView.TransformImpactAnalysis.FrameTitle.fmt.txt", (Object)this.m_oTransformPrototype.getName());
            }
            if (this.m_oTransformation != null) {
                if (this.m_bForward) {
                    return bundle.formatString("ImpactAnalysisOMAView.ImpactAnalysis.FrameTitle.fmt.txt", (Object)this.m_oTransformation.getName());
                }
                return bundle.formatString("ImpactAnalysisOMAView.ReverseImpactAnalysis.FrameTitle.fmt.txt", (Object)this.m_oTransformation.getName());
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            return "";
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
        throw new IllegalStateException("Invalid impact analysis view");
    }

    protected Icon getFrameIcon() {
        if (this.m_oColumn != null) {
            return WsColumnMetadataUtil.getColumnTypeIcon((Column)this.m_oColumn);
        }
        if (this.m_oTable != null) {
            return WAdminResource.getTypeIcon((CMetadata)this.m_oTable);
        }
        if (this.m_oTransformPrototype != null) {
            return WAdminResource.getTypeIcon((CMetadata)this.m_oTransformPrototype);
        }
        return WAdminResource.getTypeIcon((CMetadata)this.m_oTransformation);
    }

    public WAPropertyTabGroup createView() {
        ImpactAnalysisGraphTab graphTab;
        ImpactAnalysisReportTab reportTab;
        super.createView();
        WAPropertyTabGroup tabs = new WAPropertyTabGroup();
        String sReportTabTitle = bundle.getString("ImpactAnalysisOMAView.ReportTabTitle.txt");
        String sGraphTabTitle = bundle.getString("ImpactAnalysisOMAView.GraphTabTitle.txt");
        if (this.m_oTable != null) {
            reportTab = new ImpactAnalysisReportTab(this.m_oTable, this.m_bForward);
            graphTab = new ImpactAnalysisGraphTab((CMetadata)this.m_oTable, this.m_bForward);
        } else if (this.m_oColumn != null) {
            reportTab = new ImpactAnalysisReportTab(this.m_oColumn, this.m_bForward);
            graphTab = new ImpactAnalysisGraphTab((CMetadata)this.m_oColumn, this.m_bForward);
        } else if (this.m_oTransformPrototype != null) {
            reportTab = new ImpactAnalysisReportTab(this.m_oTransformPrototype);
            graphTab = new ImpactAnalysisGraphTab((CMetadata)this.m_oTransformPrototype, true);
        } else if (this.m_oTransformation != null) {
            reportTab = new ImpactAnalysisReportTab(this.m_oTransformation, this.m_bForward);
            graphTab = new ImpactAnalysisGraphTab((CMetadata)this.m_oTransformation, this.m_bForward);
        } else {
            throw new IllegalStateException("Unknown type of impact analysis");
        }
        tabs.addTab(sReportTabTitle, (WAPropertyTab)reportTab);
        tabs.addTab(sGraphTabTitle, (WAPropertyTab)graphTab);
        return tabs;
    }

    public boolean isForward() {
        return this.m_bForward;
    }
}

