/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.wadmin.visuals.DBMSLibraryConnectWizardTab;
import com.sas.wadmin.visuals.SASImporter;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.plugins.MultipleNodeInterface;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class HawqImporter
extends SASImporter
implements MultipleNodeInterface {
    private static WAdminResource bundle = WAdminResource.getBundle(HawqImporter.class);
    private ArrayList m_NameList;
    private ArrayList m_ToolTipList;
    private ArrayList m_DescriptionsList;
    private ArrayList m_ImageIconList;

    @Override
    public void initPlugin() {
        this.m_LIBRARY_TAB = "HawqImportertab1";
        this.m_TABLES_TAB = "HawqImportertab2";
        String[][] standardTransitionList = new String[][]{{this.m_LIBRARY_TAB, "NEXT", this.m_TABLES_TAB}, {this.m_TABLES_TAB, "NEXT", "SASImportertab4"}};
        this.m_transitionList = standardTransitionList;
        this.m_name = bundle.getString("HawqImporter.pluginname.txt");
        this.m_icon = bundle.getImageIcon("HawqImporter.image");
        this.m_tooltip = bundle.getString("HawqImporter.ToolTip.txt");
        this.buildNameList();
        this.buildTooltipList();
        this.buildIconList();
        this.buildDescriptionList();
    }

    public void buildDescriptionList() {
        this.m_DescriptionsList = new ArrayList();
        this.m_DescriptionsList.add(bundle.getString("HawqImporter.description.HAWQ.notrans"));
    }

    public void buildIconList() {
        this.m_ImageIconList = new ArrayList();
        this.m_ImageIconList.add(bundle.getImageIcon("HawqImporter.image"));
    }

    public void buildNameList() {
        this.m_NameList = new ArrayList();
        String folderName = bundle.getString("HawqImporter.FolderName.DatabaseSources.txt") + ".";
        this.m_NameList.add(folderName + bundle.getString("HawqImporter.Name.HAWQ.txt"));
    }

    public void buildTooltipList() {
        this.m_ToolTipList = new ArrayList();
        this.m_ToolTipList.add(bundle.getString("HawqImporter.ToolTip.HAWQ.txt"));
    }

    @Override
    protected void createLibraryTab() {
        ImageIcon image = bundle.getImageIcon("SourceDesigner.ConnectInfo.image");
        this.m_libraryTab = new DBMSLibraryConnectWizardTab("SASIOHWQ", bundle.getString("HawqConnectWizardTab.Description.txt"));
        this.m_libraryTab.setHelpTopic("HAWQ_win");
        this.m_libraryTab.setEngineType("SASIOHWQ");
        this.m_wizardDialog.addTab(bundle.getString("HawqConnectWizardTab.Title.txt"), this.m_LIBRARY_TAB, (WAPropertyTab)this.m_libraryTab, "wa_source_connectInfo.gif", (Icon)image, false);
    }

    @Override
    public String getDescription() {
        return bundle.getString("HawqImporter.description.txt");
    }

    @Override
    public String getCategory() {
        return bundle.getString("HawqImporter.FolderName.DatabaseSources.txt");
    }

    public ArrayList getDescriptions() {
        return this.m_DescriptionsList;
    }

    public ArrayList getIcons() {
        return this.m_ImageIconList;
    }

    public ArrayList getNames() {
        return this.m_NameList;
    }

    public ArrayList getToolTips() {
        return this.m_ToolTipList;
    }

    @Override
    public boolean isEngineSupported(String engineName) {
        return engineName.equalsIgnoreCase("SASIOHWQ");
    }

    public void updateEngineName(WAWizardDialog wizardDialog) {
        String nodeName = (String)wizardDialog.getWizardData("SELECTEDNODE");
        if (nodeName.equalsIgnoreCase(bundle.getString("HawqImporter.Name.HAWQ.txt"))) {
            this.m_strEngine = bundle.getString("HawqImporter.description.HAWQ.notrans");
        }
        wizardDialog.addWizardData("ENGINETYPE", (Object)this.m_strEngine);
    }
}

