/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.ServiceType;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EventOptionsPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(EventOptionsPanel.class);
    protected Root m_Metadata;
    protected List m_Components;
    protected List m_Services;
    protected List m_Listeners;
    protected List m_Events;
    protected MdObjectStore m_objectStore;
    protected AssociationList m_Properties;
    protected Property m_oSoftware;
    protected Property m_oService;
    protected Property m_oListener;
    protected Property m_oEvent;
    protected JLabel m_lblSoftware;
    protected JLabel m_lblService;
    protected JLabel m_lblListener;
    protected JLabel m_lblEvent;
    protected WAComboBox m_cmbSoftware;
    protected WAComboBox m_cmbService;
    protected WAComboBox m_cmbListener;
    protected WAComboBox m_cmbEvent;
    protected WsAbstractAction m_actSoftware;
    protected WsAbstractAction m_actService;
    protected WsAbstractAction m_actListener;
    protected WsAbstractAction m_actEvent;

    public EventOptionsPanel(Property iMetadata) {
        this.m_Metadata = iMetadata;
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("wdb");
        this.setHelpTopic("event_options_win");
    }

    protected void initialize() {
        this.createActions();
        this.m_cmbSoftware = new WAComboBox();
        this.m_cmbSoftware.addActionListener((ActionListener)this.m_actSoftware);
        this.m_lblSoftware = new JLabel(bundle.getString("EventOptions.Software.lbl.txt"));
        this.m_lblSoftware.setDisplayedMnemonic(bundle.getString("EventOptions.Software.lbl.mnem").charAt(0));
        this.m_lblSoftware.setLabelFor((Component)this.m_cmbSoftware);
        this.m_cmbService = new WAComboBox();
        this.m_cmbService.addActionListener((ActionListener)this.m_actService);
        this.m_lblService = new JLabel(bundle.getString("EventOptions.Service.lbl.txt"));
        this.m_lblService.setDisplayedMnemonic(bundle.getString("EventOptions.Service.lbl.mnem").charAt(0));
        this.m_lblService.setLabelFor((Component)this.m_cmbService);
        this.m_cmbListener = new WAComboBox();
        this.m_cmbListener.addActionListener((ActionListener)this.m_actListener);
        this.m_lblListener = new JLabel(bundle.getString("EventOptions.Listener.lbl.txt"));
        this.m_lblListener.setDisplayedMnemonic(bundle.getString("EventOptions.Listener.lbl.mnem").charAt(0));
        this.m_lblListener.setLabelFor((Component)this.m_cmbListener);
        this.m_cmbEvent = new WAComboBox();
        this.m_cmbEvent.addActionListener((ActionListener)this.m_actEvent);
        this.m_lblEvent = new JLabel(bundle.getString("EventOptions.Event.lbl.txt"));
        this.m_lblEvent.setDisplayedMnemonic(bundle.getString("EventOptions.Event.lbl.mnem").charAt(0));
        this.m_lblEvent.setLabelFor((Component)this.m_cmbEvent);
        this.listenForDataChangesTo((JComboBox)this.m_cmbSoftware);
        this.listenForDataChangesTo((JComboBox)this.m_cmbService);
        this.listenForDataChangesTo((JComboBox)this.m_cmbListener);
        this.listenForDataChangesTo((JComboBox)this.m_cmbEvent);
        this.setPreferredSize(new Dimension(510, 300));
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblSoftware, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.m_cmbSoftware, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lblService, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.m_cmbService, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lblListener, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.m_cmbListener, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lblEvent, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.m_cmbEvent, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 4, 2, 2, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void populateStore() throws MdException, RemoteException {
        boolean goToServer;
        if (this.isStorePopulated()) {
            return;
        }
        if (this.m_Metadata.isNewObject()) {
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_Metadata, null, null, "", 8);
        }
        CMetadata repos = null;
        repos = Workspace.getWorkspace().getDefaultRepository();
        String sOptions = "<XMLSELECT Search=\"SoftwareComponent[@ClassIdentifier='ABC1234567890']\"/><TEMPLATES><SoftwareComponent Id=\"\" Name=\"\" Desc=\"\"><SoftwareTrees/></SoftwareComponent></TEMPLATES>";
        this.m_Components = null;
        boolean goToServerSaveState = goToServer = this.m_Metadata.getObjectStore().getIsGoToServerForMetadata();
        goToServer = false;
        if (!goToServer) {
            this.m_Metadata.getObjectStore().setIsGotToServerForMetadata(!goToServer);
            this.m_Components = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_Metadata.getObjectStore(), repos.getFQID(), "SoftwareComponent", 8588, sOptions);
            this.m_Metadata.getObjectStore().setIsGotToServerForMetadata(goToServer);
        }
        goToServer = goToServerSaveState;
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_Properties = this.m_Metadata.getProperties();
        for (int iProperty = 0; iProperty < this.m_Properties.size(); ++iProperty) {
            Property oProperty = (Property)this.m_Properties.get(iProperty);
            if (oProperty.getPropertyRole().equals("SoftwareComponent")) {
                this.m_oSoftware = oProperty;
                continue;
            }
            if (oProperty.getPropertyRole().equals("ServiceComponent")) {
                this.m_oService = oProperty;
                continue;
            }
            if (oProperty.getPropertyRole().equals("ListenerType")) {
                this.m_oListener = oProperty;
                continue;
            }
            if (!oProperty.getPropertyRole().equals("Event")) continue;
            this.m_oEvent = oProperty;
        }
        this.populateComboBox(this.m_Components, this.m_cmbSoftware);
        if (this.m_oSoftware != null) {
            for (int iComponent = 0; iComponent < this.m_Components.size(); ++iComponent) {
                SoftwareComponent oComponent = (SoftwareComponent)this.m_Components.get(iComponent);
                if (!oComponent.getName().equals(this.m_oSoftware.getName())) continue;
                this.m_cmbSoftware.setSelectedItem((Object)oComponent);
            }
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_Properties.removeAllElements();
        MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
        if (this.m_cmbSoftware.getItemCount() > 0) {
            Event oEvent = (Event)this.m_cmbEvent.getSelectedItem();
            SoftwareComponent oSoftware = (SoftwareComponent)this.m_cmbSoftware.getSelectedItem();
            ServiceComponent oService = (ServiceComponent)this.m_cmbService.getSelectedItem();
            String oListenerType = (String)this.m_cmbListener.getSelectedItem();
            Property oEventProperty = (Property)factory.createComplexMetadataObject((MdObjectStore)this.m_Metadata.getObjectStore(), oEvent.getName(), "Property", this.m_Metadata.getRepositoryID());
            oEventProperty.setPropertyName(oEvent.getName());
            oEventProperty.setName(oEvent.getName());
            oEventProperty.setDesc(oEvent.getDesc());
            oEventProperty.setPropertyRole("Event");
            PropertyType propType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(this.m_Metadata.getObjectStore(), null, "String", "PropertyType", this.m_Metadata.getRepositoryID(), null);
            propType.setSQLType(12);
            oEventProperty.setOwningType(propType);
            oEventProperty.setDefaultValue("evntname=" + oEvent.getName());
            this.m_Properties.add((Object)oEventProperty);
            Property oSoftwareProperty = (Property)factory.createComplexMetadataObject((MdObjectStore)this.m_Metadata.getObjectStore(), oSoftware.getName(), "Property", this.m_Metadata.getRepositoryID());
            oSoftwareProperty.setPropertyName(oSoftware.getName());
            oSoftwareProperty.setName(oSoftware.getName());
            oSoftwareProperty.setDesc(oSoftware.getDesc());
            oSoftwareProperty.setPropertyRole("SoftwareComponent");
            propType.setSQLType(12);
            oSoftwareProperty.setOwningType(propType);
            oSoftwareProperty.setDefaultValue(oSoftware.getName());
            this.m_Properties.add((Object)oSoftwareProperty);
            Property oServiceProperty = (Property)factory.createComplexMetadataObject((MdObjectStore)this.m_Metadata.getObjectStore(), oService.getName(), "Property", this.m_Metadata.getRepositoryID());
            oServiceProperty.setPropertyName(oService.getName());
            oServiceProperty.setName(oService.getName());
            oServiceProperty.setDesc(oService.getDesc());
            oServiceProperty.setPropertyRole("ServiceComponent");
            propType.setSQLType(12);
            oServiceProperty.setOwningType(propType);
            oServiceProperty.setDefaultValue(oService.getName());
            this.m_Properties.add((Object)oServiceProperty);
            Property oListenerProperty = (Property)factory.createComplexMetadataObject((MdObjectStore)this.m_Metadata.getObjectStore(), oListenerType, "Property", this.m_Metadata.getRepositoryID());
            oListenerProperty.setPropertyName(oListenerType);
            oListenerProperty.setName(oListenerType);
            oListenerProperty.setDesc(oListenerType);
            oListenerProperty.setPropertyRole("ListenerType");
            propType.setSQLType(12);
            oListenerProperty.setOwningType(propType);
            oListenerProperty.setDefaultValue(oListenerType);
            this.m_Properties.add((Object)oListenerProperty);
        }
        this.setDataChanged(false);
    }

    public void populateComboBox(List lValues, WAComboBox cmb) {
        cmb.removeAllItems();
        int nValues = lValues.size();
        for (int iValue = 0; iValue < nValues; ++iValue) {
            cmb.addItem(lValues.get(iValue));
        }
    }

    public boolean validateData() {
        return true;
    }

    public void setMetadataObject(Root metadata) {
        this.m_Metadata = metadata;
    }

    public void setStore(MdObjectStore iStore) {
        this.m_objectStore = iStore;
    }

    protected void createActions() {
        this.m_actSoftware = this.createSoftwareAction();
        this.m_actService = this.createServiceAction();
    }

    protected WsAbstractAction createSoftwareAction() {
        return new cSoftwareAction();
    }

    protected WsAbstractAction createServiceAction() {
        return new cServiceAction();
    }

    protected class cSoftwareAction
    extends WsAbstractAction {
        public cSoftwareAction() {
            super(bundle, "EventOptions.Software", false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                EventOptionsPanel.this.m_Services = new Vector();
                if (EventOptionsPanel.this.m_cmbSoftware.getItemAt(0) != null) {
                    SoftwareComponent oSoftware = (SoftwareComponent)EventOptionsPanel.this.m_cmbSoftware.getSelectedItem();
                    AssociationList oSoftwareTrees = oSoftware.getSoftwareTrees();
                    for (int iSoftwareTree = 0; iSoftwareTree < oSoftwareTrees.size(); ++iSoftwareTree) {
                        Tree oTree = (Tree)oSoftwareTrees.get(iSoftwareTree);
                        AssociationList oMembers = oTree.getMembers();
                        for (int iMember = 0; iMember < oMembers.size(); ++iMember) {
                            DeployedComponent oComponent = (DeployedComponent)oMembers.get(iMember);
                            if (!(oComponent instanceof ServiceComponent)) continue;
                            ServiceComponent oService = (ServiceComponent)oComponent;
                            AssociationList lServiceTypes = oService.getServiceTypes();
                            for (int iType = 0; iType < lServiceTypes.size(); ++iType) {
                                ServiceType oServiceType = (ServiceType)lServiceTypes.get(iType);
                                if (!oServiceType.getInterfaceName().equals("com.sas.services.events.broker.EventBrokerServiceInterface")) continue;
                                EventOptionsPanel.this.m_Services.add(oService);
                            }
                        }
                    }
                    EventOptionsPanel.this.populateComboBox(EventOptionsPanel.this.m_Services, EventOptionsPanel.this.m_cmbService);
                    if (EventOptionsPanel.this.m_oService != null) {
                        for (int iService = 0; iService < EventOptionsPanel.this.m_Services.size(); ++iService) {
                            ServiceComponent oComponent = (ServiceComponent)EventOptionsPanel.this.m_Services.get(iService);
                            if (!oComponent.getName().equals(EventOptionsPanel.this.m_oService.getName())) continue;
                            EventOptionsPanel.this.m_cmbService.setSelectedItem((Object)oComponent);
                        }
                    }
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    protected class cServiceAction
    extends WsAbstractAction {
        public cServiceAction() {
            super(bundle, "EventOptions.Service", false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                EventOptionsPanel.this.m_Listeners = new Vector();
                EventOptionsPanel.this.m_Events = new Vector();
                if (EventOptionsPanel.this.m_cmbService.getItemAt(0) != null) {
                    ServiceComponent oService = (ServiceComponent)EventOptionsPanel.this.m_cmbService.getSelectedItem();
                    AssociationList lInitProcesses = oService.getInitProcesses();
                    for (int iInitProcess = 0; iInitProcess < lInitProcesses.size(); ++iInitProcess) {
                        Transformation oProcess = (Transformation)lInitProcesses.get(iInitProcess);
                        AssociationList lTransformationSources = oProcess.getTransformationSources();
                        for (int iTransformation = 0; iTransformation < lTransformationSources.size(); ++iTransformation) {
                            PropertySet oPropertySet = (PropertySet)lTransformationSources.get(iTransformation);
                            if (!oPropertySet.getSetRole().equals("HTTP")) continue;
                            EventOptionsPanel.this.m_Listeners.add(oPropertySet.getSetRole());
                        }
                    }
                    EventOptionsPanel.this.populateComboBox(EventOptionsPanel.this.m_Listeners, EventOptionsPanel.this.m_cmbListener);
                    if (EventOptionsPanel.this.m_oListener != null) {
                        for (int iListener = 0; iListener < EventOptionsPanel.this.m_Listeners.size(); ++iListener) {
                            String oComponent = (String)EventOptionsPanel.this.m_Listeners.get(iListener);
                            if (!oComponent.equals(EventOptionsPanel.this.m_oListener.getName())) continue;
                            EventOptionsPanel.this.m_cmbListener.setSelectedItem((Object)oComponent);
                        }
                    }
                    AssociationList lRegisteredEvents = oService.getRegisteredEvents();
                    for (int iEvent = 0; iEvent < lRegisteredEvents.size(); ++iEvent) {
                        Event oEvent = (Event)lRegisteredEvents.get(iEvent);
                        EventOptionsPanel.this.m_Events.add(oEvent);
                    }
                    EventOptionsPanel.this.populateComboBox(EventOptionsPanel.this.m_Events, EventOptionsPanel.this.m_cmbEvent);
                    if (EventOptionsPanel.this.m_oEvent != null) {
                        for (int iSetEvent = 0; iSetEvent < EventOptionsPanel.this.m_Events.size(); ++iSetEvent) {
                            Event oComponent = (Event)EventOptionsPanel.this.m_Events.get(iSetEvent);
                            if (!oComponent.getName().equals(EventOptionsPanel.this.m_oEvent.getName())) continue;
                            EventOptionsPanel.this.m_cmbEvent.setSelectedItem((Object)oComponent);
                        }
                    }
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }
}

