/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.etl.models.IDocumentsContainer;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IDocument;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDialogTableCellEditor;
import com.sas.workspace.WsDialogTableCellEditorInterface;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableCellEditor;

public class DocumentsTableModelUsingMetadata
extends WsAbstractTableModel {
    boolean[] baColumnsEditable = new boolean[]{true, true};
    private static WAdminResource bundle = WAdminResource.getBundle(DocumentsTableModelUsingMetadata.class);
    public static final int NAME_COL = 0;
    public static final int URL_COL = 1;
    public static final int DOC_COL = 2;
    private static final int VISIBLE_COLS = 2;
    private static final int HIDDEN_COLS = 1;
    private IDocumentsContainer m_container;
    private IModelListener m_lsnrModel;

    public DocumentsTableModelUsingMetadata(IDocumentsContainer container) {
        this.m_container = container;
        this.m_lsnrModel = new ModelListener();
        this.createColumns();
        this.m_container.getModel().addModelListener(this.m_lsnrModel);
    }

    private void createColumns() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, bundle.getString("DocumentsTableModel.Name.txt"), 1000);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("DocumentsTableModel.Path.txt"), 1000);
        this.m_aColumns[2] = new WsObjectTableColumn();
        this.m_aColumns[1].setCellEditor((TableCellEditor)new WsDialogTableCellEditor());
    }

    public void setURLEditorDialogAdapter(WsDialogTableCellEditorInterface dialogAdapter) {
        WsDialogTableCellEditor editor = (WsDialogTableCellEditor)this.m_aColumns[1].getCellEditor();
        editor.setDialog(dialogAdapter);
    }

    public void moveDataToModel() {
        this.clear();
        IDocument[] aDocuments = this.m_container.getDocuments();
        for (int iDocument = 0; iDocument < aDocuments.length; ++iDocument) {
            ArrayList<String> lValues = new ArrayList<String>();
            lValues.add(aDocuments[iDocument].getName());
            lValues.add(aDocuments[iDocument].getURI());
            lValues.add((String)aDocuments[iDocument]);
            this.m_lData.add(lValues);
        }
        this.m_nRowInstances = this.m_lData.size();
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() {
        throw new UnsupportedOperationException("moveDataToStore not implemented.  changes are immediately made to the model");
    }

    public void populateStore() {
        throw new UnsupportedOperationException("populateStore not implemented.  Model does not use a store");
    }

    public int getColumnCount() {
        return 2;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public boolean isCellEditable(int row, int col) {
        return this.baColumnsEditable[col];
    }

    public void setValueAt(Object a, int row, int col) {
        IDocument oDoc = this.m_container.getDocuments()[row];
        if (col == 0) {
            oDoc.setName((String)a);
        } else if (col == 1) {
            oDoc.setURI((String)a);
        } else {
            super.setValueAt(a, row, col);
        }
    }

    public boolean validateName(String newName, int row) {
        ArrayList m = null;
        if (newName.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            m = (ArrayList)this.m_lData.get(i);
            String name = (String)m.get(0);
            if (!name.equals(newName) || i == row) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        this.m_container.getModel().removeModelListener(this.m_lsnrModel);
    }

    private void addDocument(IDocument doc) {
        ArrayList<String> lValues = new ArrayList<String>();
        lValues.add(doc.getName());
        lValues.add(doc.getURI());
        lValues.add((String)doc);
        int iIndex = this.m_container.getDocumentsList().indexOf(doc);
        if (iIndex != -1) {
            this.insertRow(iIndex - 1, lValues);
        }
    }

    private void removeDocument(IDocument doc) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            if (lValues.get(2) != doc) continue;
            this.deleteRow(iRow);
            return;
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            if (sType == "Object:DocumentAdded") {
                IDocument oDocument = (IDocument)ev.getData();
                DocumentsTableModelUsingMetadata.this.addDocument(oDocument);
            } else if (sType == "Object:DocumentRemoved") {
                IDocument oDocument = (IDocument)ev.getData();
                DocumentsTableModelUsingMetadata.this.removeDocument(oDocument);
            } else if (sType == "Object:NameChanged" && ev.getModelObject() instanceof IDocument) {
                IDocument oDocument = (IDocument)ev.getModelObject();
                int iIndex = DocumentsTableModelUsingMetadata.this.m_container.getDocumentsList().indexOf(oDocument);
                if (iIndex != -1) {
                    DocumentsTableModelUsingMetadata.super.setValueAt(oDocument.getName(), iIndex, 0);
                }
            } else if (sType == "Document:URIChanged") {
                IDocument oDocument = (IDocument)ev.getModelObject();
                int iIndex = DocumentsTableModelUsingMetadata.this.m_container.getDocumentsList().indexOf(oDocument);
                if (iIndex != -1) {
                    DocumentsTableModelUsingMetadata.super.setValueAt(oDocument.getURI(), iIndex, 1);
                }
            }
        }
    }
}

