/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.app.AppDialogFactory;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.model.JOMADocumentTableModel;
import com.sas.wadmin.visuals.DocumentTreeNode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsDialogTableCellEditorInterface;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectsSelectorPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class DocumentsPaneUsingMetadata
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(DocumentsPaneUsingMetadata.class);
    private WsTable m_tblDocuments;
    private JScrollPane m_scrDocuments;
    private JOMADocumentTableModel m_mdlDocuments;
    private JLabel m_lblDocuments;
    private JPopupMenu m_mnuDocuments;
    private JButton m_btnNew;
    private JButton m_btnDelete;
    private JButton m_btnAttach;
    private WsAbstractAction m_actNew;
    private WsAbstractAction m_actDelete;
    private WsAbstractAction m_actAttach;
    private WsAbstractAction m_actOpen;
    private Root m_oMetadata;
    private boolean updateDoc = false;

    public DocumentsPaneUsingMetadata(Root oMetadata) {
        this.m_oMetadata = oMetadata;
        this.initialize();
        this.layoutWidgets();
    }

    public boolean validateData() {
        if (!this.updateDoc) {
            return true;
        }
        this.updateDoc = false;
        for (int i = 0; i < this.m_mdlDocuments.getRowCount(); ++i) {
            String URL2 = (String)this.m_mdlDocuments.getValueAt(i, 1);
            if (URL2 != null && !URL2.equals("")) continue;
            this.m_tblDocuments.clearSelection();
            MessageUtil.displayMessage((String)bundle.getString("DocumentsPane.urlerror.txt"), (String)bundle.getString("DocumentsPane.error.txt"), (int)0);
            this.m_tblDocuments.editCellAt(i, 1);
            WsDefaultCellEditor uce = (WsDefaultCellEditor)this.m_tblDocuments.getCellEditor();
            JTextField j = (JTextField)uce.getComponent();
            j.requestFocus();
            return false;
        }
        ArrayList<String> documentNameConflicts = new ArrayList<String>();
        int i = 0;
        if (i < this.m_mdlDocuments.getRowCount()) {
            int changeDuplicateName;
            String name = (String)this.m_mdlDocuments.getValueAt(i, 0);
            Document doc = (Document)this.m_mdlDocuments.getValueAt(i, 2);
            boolean nameConflictOnServer = doc != null ? !WsMetadataNameUtil.isNameUnique((Root)doc, (String)name) : !WsMetadataNameUtil.isNameUnique((String)"Document", (String)name);
            boolean nameConflictOnTab = false;
            for (int j = 0; j < this.m_mdlDocuments.getRowCount(); ++j) {
                if (i == j || !this.m_mdlDocuments.getValueAt(j, 0).equals(name)) continue;
                nameConflictOnTab = true;
                break;
            }
            if (nameConflictOnServer || nameConflictOnTab) {
                documentNameConflicts.add(name);
            }
            if (documentNameConflicts.isEmpty()) {
                return true;
            }
            if (documentNameConflicts.size() == 1) {
                changeDuplicateName = MessageUtil.displayMessage((String)bundle.formatString("DocumentsPane.Error.OneDuplicateName.fmt.txt", documentNameConflicts.get(0)), (String)bundle.getString("DocumentsPane.DuplicateNameWarning.txt"), (int)2, (int)0);
                return changeDuplicateName != 0;
            }
            Collections.sort(documentNameConflicts);
            changeDuplicateName = MessageUtil.displayListMessage((String)bundle.getString("DocumentsPane.Error.ManyDuplicateNames.txt"), documentNameConflicts, (String)bundle.getString("DocumentsPane.DuplicateNameWarning.txt"), (int)2, (int)0);
            return changeDuplicateName != 0;
        }
        return true;
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            this.m_mdlDocuments.populateStore();
            this.m_mdlDocuments.moveDataToModel();
        } else {
            TableCellEditor ce = this.m_tblDocuments.getCellEditor();
            if (ce != null) {
                ce.stopCellEditing();
            }
            this.updateObjects();
        }
        return true;
    }

    private void updateObjects() {
        try {
            if (this.hasDataChanged()) {
                int nDocuments = this.m_mdlDocuments.getRowCount();
                for (int iDocument = 0; iDocument < nDocuments; ++iDocument) {
                    Document oDoc = (Document)this.m_mdlDocuments.getValueAt(iDocument, 2);
                    String sName = (String)this.m_mdlDocuments.getValueAt(iDocument, 0);
                    String sURL = (String)this.m_mdlDocuments.getValueAt(iDocument, 1);
                    if (!sName.equals(oDoc.getName())) {
                        oDoc.setName(sName);
                    }
                    if (sURL.equals(oDoc.getURI())) continue;
                    oDoc.setURI(sURL);
                }
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public WsAbstractAction getDeleteAction() {
        return this.m_actDelete;
    }

    protected void initialize() {
        this.createActions();
        this.createDocumentsMenu();
        this.m_mdlDocuments = new JOMADocumentTableModel(this.m_oMetadata);
        this.m_mdlDocuments.setURLEditorDialogAdapter(new URLEditorDialogAdapter());
        this.m_tblDocuments = new WsTable((WsAbstractTableModel)this.m_mdlDocuments);
        this.m_tblDocuments.setAutoResizeMode(1);
        this.m_tblDocuments.setCellSelectionEnabled(true);
        this.m_tblDocuments.setRowHeaderVisible(false);
        this.m_tblDocuments.getTableHeader().setReorderingAllowed(false);
        this.m_tblDocuments.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)new DocumentsNamePopupListener());
        this.m_lblDocuments = WsUIUtilities.createLabelForComponent((JComponent)this.m_tblDocuments, (String)bundle.getString("DocumentsPane.documents.assigned.txt"));
        TableColumn col = this.m_tblDocuments.getColumnModel().getColumn(0);
        col.setPreferredWidth(205);
        col = this.m_tblDocuments.getColumnModel().getColumn(1);
        col.setPreferredWidth(375);
        col.setCellRenderer(new PathCellRenderer());
        this.m_tblDocuments.addMouseListener((MouseListener)new DocClickListener());
        this.m_tblDocuments.getActionMap().put(this.m_actDelete, (Action)this.m_actDelete);
        this.m_tblDocuments.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDelete);
        this.m_btnNew = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNew);
        this.m_btnDelete = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDelete);
        this.m_btnAttach = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actAttach);
        this.m_tblDocuments.getSelectionModel().addListSelectionListener(new DocCellListener());
        this.m_mdlDocuments.addTableModelListener(new DocTableModelListener());
    }

    private void createActions() {
        this.m_actNew = this.createNewAction();
        this.m_actDelete = this.createDeleteAction();
        this.m_actAttach = this.createAttachAction();
        this.m_actOpen = new cOpenAction();
    }

    private void createDocumentsMenu() {
        this.m_mnuDocuments = new JPopupMenu();
        this.m_mnuDocuments.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actNew));
        this.m_mnuDocuments.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actDelete));
        this.m_mnuDocuments.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actOpen));
    }

    private WsAbstractAction createNewAction() {
        return new cNewAction();
    }

    private WsAbstractAction createDeleteAction() {
        return new cDeleteAction();
    }

    private WsAbstractAction createAttachAction() {
        return new cAttachAction();
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(bundle.getString("DocumentsPane.docString.txt")));
        this.m_scrDocuments = new JScrollPane((Component)this.m_tblDocuments);
        this.m_tblDocuments.setToolTipText(bundle.getString("DocumentsPane.docTip.txt"));
        this.m_scrDocuments.setToolTipText(bundle.getString("DocumentsPane.docTip.txt"));
        JPanel pnlButtons = new JPanel((LayoutManager)new WsButtonsLayout());
        pnlButtons.add(this.m_btnNew);
        pnlButtons.add(this.m_btnDelete);
        pnlButtons.add(this.m_btnAttach);
        this.add(this.m_lblDocuments, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_scrDocuments, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.add(pnlButtons, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 5, 0), 0, 0));
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tblDocuments.setEditable(bEditable);
        this.updateActions();
    }

    public void addDocFocusListener(FocusListener f) {
        WsDefaultCellEditor uce;
        this.m_tblDocuments.addFocusListener(f);
        DefaultCellEditor dce = (DefaultCellEditor)this.m_tblDocuments.getCellEditor(0, 0);
        if (dce != null) {
            dce.getComponent().addFocusListener(f);
        }
        if ((uce = (WsDefaultCellEditor)this.m_tblDocuments.getCellEditor(0, 1)) != null) {
            uce.getComponent().addFocusListener(f);
        }
    }

    private void updateActions() {
        boolean bEditable = this.isEditable();
        int[] aRows = this.m_tblDocuments.getSelectedRowsFromSelectedCells();
        int iRow = aRows != null && aRows.length > 0 ? aRows[0] : -1;
        boolean bSelected = iRow != -1;
        String sURL = null;
        if (bSelected) {
            try {
                Document obj = (Document)this.m_mdlDocuments.getRowValues(iRow).get(2);
                sURL = obj.getURI();
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
        boolean bOpenable = sURL != null && sURL.length() > 0;
        this.m_actNew.setEnabled(bEditable);
        this.m_actDelete.setEnabled(bEditable && bSelected);
        this.m_actAttach.setEnabled(bEditable);
        this.m_actOpen.setEnabled(bOpenable);
    }

    private void doNew() {
        SimpleObject obj = AppDialogFactory.getInstance().showNewDocumentDialog((JFrame)Workspace.getWorkspace(), null);
        if (this.m_tblDocuments.isEditing()) {
            this.m_tblDocuments.getCellEditor().cancelCellEditing();
        }
        if (obj == null) {
            return;
        }
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            Document oDoc = (Document)factory.createComplexMetadataObject((MdObjectStore)this.m_oMetadata.getObjectStore(), obj.getName(), obj.getMetadataType(), obj.getID());
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oDoc, null, null, null, 8);
            this.m_oMetadata.getDocuments().add((Object)oDoc);
            this.m_mdlDocuments.insertRow(oDoc);
            this.setDataChanged(true);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAttach() throws RemoteException {
        if (this.m_tblDocuments.isEditing()) {
            this.m_tblDocuments.getCellEditor().cancelCellEditing();
        }
        MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "AttachDocuments");
        ArrayList<String> salErrorValues = new ArrayList<String>();
        try {
            ObjectsSelectorPanel pnl = new ObjectsSelectorPanel(Workspace.getWorkspace().getUserContext(), 6);
            String sImportDialogTitle = bundle.getString("DocumentsPane.Attach.Title.txt");
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sImportDialogTitle, true, (WAPanel)pnl);
            dlg.setResizable(true);
            dlg.setHelpProduct("shared");
            dlg.setHelpTopic("sel_doc");
            dlg.show();
            ArrayList<Document> lFoundDocs = new ArrayList<Document>();
            if (dlg.getReturnValue() == 1) {
                SimpleObject[] aDocuments = pnl.getSelectedObjects();
                for (int iDocument = 0; iDocument < aDocuments.length; ++iDocument) {
                    SimpleObject document = aDocuments[iDocument];
                    Document mdoDoc = (Document)ObjectConverter.getInstance().convertToJOMAObject(store, document);
                    if (!this.isDuplicate(mdoDoc)) {
                        lFoundDocs.add(mdoDoc);
                        this.m_oMetadata.getDocuments().add((Object)mdoDoc);
                        this.m_mdlDocuments.insertRow(mdoDoc);
                        continue;
                    }
                    salErrorValues.add(mdoDoc.getName());
                }
                if (lFoundDocs.size() == 0) {
                    return;
                }
                if (salErrorValues.size() > 0) {
                    MessageUtil.displayListMessage((String)bundle.getString("NotesTab.DuplicateObject.txt"), salErrorValues, (int)1);
                }
                this.setDataChanged(true);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        finally {
            store.dispose();
        }
    }

    private boolean isDuplicate(Document oDoc) {
        try {
            if (this.m_oMetadata.getDocuments().indexOf((Object)oDoc) > -1) {
                return true;
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            return true;
        }
        return false;
    }

    private void doDelete() {
        int[] aRows;
        int iRow;
        if (this.m_tblDocuments.isEditing()) {
            this.m_tblDocuments.getCellEditor().cancelCellEditing();
        }
        int n = iRow = (aRows = this.m_tblDocuments.getSelectedRowsFromSelectedCells()) != null && aRows.length > 0 ? aRows[0] : -1;
        if (iRow != -1) {
            Document doc = (Document)this.m_mdlDocuments.getRowValues(iRow).get(2);
            try {
                int iIndex = this.m_oMetadata.getDocuments().indexOf((Object)doc);
                if (iIndex > -1) {
                    this.m_oMetadata.getDocuments().remove(iIndex);
                    this.m_mdlDocuments.deleteRow(iRow);
                    this.setDataChanged(true);
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
        }
    }

    private void doOpen() {
        int iRow;
        int[] aRows = this.m_tblDocuments.getSelectedRowsFromSelectedCells();
        int n = iRow = aRows != null && aRows.length > 0 ? aRows[0] : -1;
        if (iRow != -1) {
            DisplayDocumentThread docThread = new DisplayDocumentThread(1000L, iRow);
            docThread.start();
        }
    }

    private String getFilename() {
        String uDir;
        String whole;
        String sSelectedFile = null;
        FileDialog jfc = null;
        jfc = new FileDialog((Frame)Workspace.getWorkspace());
        jfc.setDirectory(Workspace.getWorkspace().getDefaultPath());
        jfc.setMode(0);
        jfc.setTitle(bundle.getString("DocumentsPane.SelectFileDialog.Title.txt"));
        jfc.setVisible(true);
        String uFile = jfc.getFile();
        if (uFile != null && (whole = (uDir = jfc.getDirectory()) + uFile) != null) {
            Workspace.getWorkspace().setDefaultPath(jfc.getDirectory().toString());
            sSelectedFile = whole;
        }
        return sSelectedFile;
    }

    private class URLEditorDialogAdapter
    implements WsDialogTableCellEditorInterface {
        private URLEditorDialogAdapter() {
        }

        public String showDialog(JTable tbl, int iRow, int iCol, String sValue) {
            return DocumentsPaneUsingMetadata.this.getFilename();
        }
    }

    private class DocumentsNamePopupListener
    implements WsPopupMenuRequestListener {
        private DocumentsNamePopupListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            DocumentsPaneUsingMetadata.this.m_mnuDocuments.show((Component)DocumentsPaneUsingMetadata.this.m_tblDocuments, ev.getX(), ev.getY());
        }
    }

    private class PathCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            StringBuffer buf = new StringBuffer();
            if (isSelected) {
                buf.append((String)value);
            } else {
                buf.append((String)value);
            }
            this.setText(buf.toString());
            if (isSelected) {
                super.setForeground(Color.yellow);
                super.setBackground(SystemColor.textHighlight);
            } else {
                super.setForeground(Color.blue);
                super.setBackground(table.getBackground());
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            Color back = this.getBackground();
            boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
            this.setOpaque(!colorMatch);
            return this;
        }
    }

    private class DocClickListener
    extends MouseAdapter {
        private DocClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isShiftDown() || e.isControlDown()) {
                return;
            }
            int row = DocumentsPaneUsingMetadata.this.m_tblDocuments.rowAtPoint(e.getPoint());
            int col = DocumentsPaneUsingMetadata.this.m_tblDocuments.columnAtPoint(e.getPoint());
            if (col != 1) {
                return;
            }
            if (DocumentsPaneUsingMetadata.this.m_tblDocuments.isCellSelected(row, DocumentsPaneUsingMetadata.this.m_tblDocuments.convertColumnIndexToModel(1))) {
                String loc = (String)DocumentsPaneUsingMetadata.this.m_mdlDocuments.getValueAt(row, 1);
                if (e.getClickCount() == 1 || loc.length() == 0) {
                    DocumentsPaneUsingMetadata.this.m_tblDocuments.clearSelection();
                    DocumentsPaneUsingMetadata.this.m_tblDocuments.editCellAt(row, 1);
                    WsDefaultCellEditor tce = (WsDefaultCellEditor)DocumentsPaneUsingMetadata.this.m_tblDocuments.getCellEditor(row, 1);
                    JComponent c = tce.getComponent();
                    if (c instanceof JTextField) {
                        ((Component)c).requestFocus();
                    }
                } else if (e.getClickCount() >= 2 && loc.length() > 0) {
                    DisplayDocumentThread elmo = new DisplayDocumentThread(1000L, row);
                    elmo.start();
                }
            }
        }
    }

    private class DocCellListener
    implements ListSelectionListener {
        private DocCellListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (DocumentsPaneUsingMetadata.this.m_tblDocuments.isEditing()) {
                DocumentsPaneUsingMetadata.this.m_tblDocuments.cancelCellEditing();
            }
            DocumentsPaneUsingMetadata.this.updateActions();
        }
    }

    private class DocTableModelListener
    implements TableModelListener {
        private DocTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            DocumentsPaneUsingMetadata.this.setDataChanged(true);
        }
    }

    private class cOpenAction
    extends WsAbstractAction {
        public cOpenAction() {
            super(bundle, "DocumentsPane.Open", 544);
        }

        public void actionPerformed(ActionEvent e) {
            DocumentsPaneUsingMetadata.this.doOpen();
        }
    }

    private class cNewAction
    extends WsAbstractAction {
        public cNewAction() {
            super(bundle, "DocumentsPane.New", 544);
            this.setMenuSupportId("newdoc");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            DocumentsPaneUsingMetadata.this.doNew();
        }
    }

    private class cDeleteAction
    extends WsAbstractAction {
        public cDeleteAction() {
            super(bundle, "DocumentsPane.Delete", 544);
        }

        public void actionPerformed(ActionEvent e) {
            DocumentsPaneUsingMetadata.this.doDelete();
        }
    }

    private class cAttachAction
    extends WsAbstractAction {
        public cAttachAction() {
            super(bundle, "DocumentsPane.Attach");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                DocumentsPaneUsingMetadata.this.doAttach();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    private class DisplayDocumentThread
    extends Thread {
        long milliSecs = 0L;
        int row = 0;

        public DisplayDocumentThread(long waitSecs, int r) {
            this.milliSecs = waitSecs;
            this.row = r;
        }

        @Override
        public void run() {
            String loc = (String)DocumentsPaneUsingMetadata.this.m_mdlDocuments.getValueAt(this.row, 1);
            try {
                DisplayDocumentThread.sleep(this.milliSecs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!DocumentsPaneUsingMetadata.this.m_tblDocuments.isEditing()) {
                DocumentTreeNode.displayURL(loc);
            }
        }
    }
}

