/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.visuals.DataValidationCustomTableModel;
import com.sas.wadmin.visuals.DataValidationDuplicatesTableModel;
import com.sas.wadmin.visuals.DataValidationInvalidTableModel;
import com.sas.wadmin.visuals.DataValidationMissingTableModel;
import com.sas.wadmin.visuals.DataValidationTableModel;
import com.sas.wadmin.visuals.DataValidationTableViewer;
import com.sas.workspace.WAPropertyTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;

public class DataValidationPropertyTab
extends WAPropertyTab {
    protected DataValidationTableViewer m_table;
    protected CMetadata m_metadata;
    protected ClassifierMap m_classifierMap;
    protected String m_validationType;

    public DataValidationPropertyTab(CMetadata metadata, String validationType) {
        this.m_validationType = validationType;
        this.m_metadata = metadata;
        this.initialize();
        String helpID = "";
        if (this.m_validationType.equalsIgnoreCase("Missing")) {
            helpID = "missing_values_tab";
        } else if (this.m_validationType.equalsIgnoreCase("Duplicate")) {
            helpID = "dup_values_tab";
        } else if (this.m_validationType.equalsIgnoreCase("Invalid")) {
            helpID = "invalid_values_tab";
        } else if (this.m_validationType.equalsIgnoreCase("Custom")) {
            helpID = "custom_validation_tab";
        }
        this.setHelpTopic(helpID);
    }

    protected void initialize() {
        this.m_table = new DataValidationTableViewer();
        this.listenForDataChangesTo(this.m_table);
        DataValidationTableModel tableModel = null;
        if (this.m_validationType.equalsIgnoreCase("Missing")) {
            tableModel = new DataValidationMissingTableModel(this.m_validationType);
        } else if (this.m_validationType.equalsIgnoreCase("Duplicate")) {
            tableModel = new DataValidationDuplicatesTableModel(this.m_validationType);
        } else if (this.m_validationType.equalsIgnoreCase("Invalid")) {
            tableModel = new DataValidationInvalidTableModel(this.m_validationType);
        } else if (this.m_validationType.equalsIgnoreCase("Custom")) {
            tableModel = new DataValidationCustomTableModel(this.m_validationType);
        }
        this.m_table.setupViewer(this.m_validationType, tableModel, this.waum);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.m_table), "Center");
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.m_classifierMap != null) {
            return;
        }
        if (this.m_metadata.getCMetadataType().compareTo("TransformationStep") == 0) {
            AssociationList transList = ((TransformationStep)this.m_metadata).getTransformations();
            this.m_classifierMap = (ClassifierMap)transList.get(0);
        } else {
            this.m_classifierMap = (ClassifierMap)this.m_metadata;
        }
        this.doDataExchange(false);
        this.setStorePopulated(true);
    }

    public boolean validateData() {
        return this.m_table.validateData();
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (bSaveToModel) {
            this.m_table.moveDataToStore();
        } else {
            this.m_table.getModel().setClassifierMap(this.m_classifierMap);
            this.m_table.moveDataToView();
        }
        this.setDataChanged(false);
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_table.setEditable(bEditable);
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        this.m_table.updateWorkspaceUIComponents(bActive);
    }
}

