/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.codegen.DataValidationMetadataHandler;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.DataValidationEditPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsExpressionTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;

public class DataValidationMissingEditPanel
extends DataValidationEditPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(DataValidationMissingEditPanel.class);
    protected JLabel m_lblColumn;
    protected WAComboBox m_cmbColumn;
    protected JLabel m_lblAction;
    protected WAComboBox m_cmbAction;
    protected JLabel m_lblExpression;
    protected WsExpressionTextField m_expExpression;
    protected cActionComboBoxListener m_actionListener = new cActionComboBoxListener();
    protected int m_changeAction = -1;
    protected List m_rowValues;
    protected DataValidationMetadataHandler m_handler;
    protected List m_actionList;
    protected List m_columnList;
    static final String HELP_ID = "missing_values_win";

    public DataValidationMissingEditPanel(DataValidationMetadataHandler handler, List rowValues) {
        this.m_handler = handler;
        this.m_rowValues = rowValues;
        this.initialize();
        this.setHelpTopic(HELP_ID);
    }

    protected void initialize() {
        super.initialize();
        this.m_cmbColumn = new WAComboBox();
        this.m_cmbColumn.setToolTipText(bundle.getString("DataValidationEditPanel.Column.tooltip.txt"));
        this.m_lblColumn = new JLabel(bundle.getString("DataValidationEditPanel.Column.label.txt"));
        this.m_lblColumn.setLabelFor((Component)this.m_cmbColumn);
        this.m_lblColumn.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Column.mnem").charAt(0));
        this.m_cmbAction = new WAComboBox();
        this.m_cmbAction.setToolTipText(bundle.getString("DataValidationEditPanel.Missing.Action.tooltip.txt"));
        this.m_lblAction = new JLabel(bundle.getString("DataValidationEditPanel.Missing.Action.label.txt"));
        this.m_lblAction.setLabelFor((Component)this.m_cmbAction);
        this.m_lblAction.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Missing.Action.mnem").charAt(0));
        this.m_cmbAction.addActionListener((ActionListener)this.m_actionListener);
        this.m_expExpression = new WsExpressionTextField(this.m_handler.getTargetTable(), "");
        this.m_expExpression.setToolTipText(bundle.getString("DataValidationEditPanel.Expression.tooltip.txt"));
        this.m_lblExpression = new JLabel(bundle.getString("DataValidationEditPanel.Expression.label.txt"));
        this.m_lblExpression.setLabelFor((Component)this.m_expExpression);
        this.m_lblExpression.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Expression.mnem").charAt(0));
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblColumn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_cmbColumn, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lblAction, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add((Component)this.m_cmbAction, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this.m_lblExpression, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add((Component)this.m_expExpression, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_columnList = this.m_handler.makeColumnList(this.m_handler.getTargetTable());
        this.m_cmbColumn.addItems(this.m_columnList);
        Column column = (Column)this.m_rowValues.get(this.m_handler.getColumnIndex());
        if (column == null && this.m_columnList.size() > 0) {
            this.m_cmbColumn.setSelectedIndex(0);
        } else if (column != null) {
            this.m_cmbColumn.setSelectedItem((Object)column);
        }
        this.m_actionList = this.m_handler.getActionList();
        this.m_changeAction = this.m_handler.getChangeAction();
        this.m_cmbAction.addItems(this.m_actionList);
        String action = (String)this.m_rowValues.get(this.m_handler.getActionIndex());
        if (action == null) {
            this.m_cmbAction.setSelectedIndex(0);
        } else {
            this.m_cmbAction.setSelectedItem((Object)action);
        }
        String expression = (String)this.m_rowValues.get(this.m_handler.getExpressionIndex());
        this.m_expExpression.setText(expression);
        this.enableExpressionComponent();
        this.setListeningForChanges(true);
    }

    @Override
    public boolean validateData() {
        if (this.m_cmbColumn.getSelectedIndex() < 0) {
            MessageUtil.displayMessage((String)bundle.getString("DataValidationEditPanel.MissingColumn.Error.txt"), (String)bundle.getString("DataValidationEditPanel.MissingColumn.Title.txt"), (int)0);
            this.m_cmbColumn.requestFocus();
            return false;
        }
        if (this.m_cmbAction.getSelectedIndex() < 0) {
            MessageUtil.displayMessage((String)bundle.getString("DataValidationEditPanel.MissingAction.Error.txt"), (String)bundle.getString("DataValidationEditPanel.MissingAction.Title.txt"), (int)0);
            this.m_cmbAction.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public List getRow() {
        ArrayList<Object> rowValues = new ArrayList<Object>(this.m_handler.getNumValues());
        for (int i = 0; i < this.m_handler.getNumValues(); ++i) {
            rowValues.add(null);
        }
        Column column = (Column)this.m_cmbColumn.getSelectedItem();
        String columnName = "";
        if (column != null) {
            try {
                columnName = column.getSASColumnName();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        rowValues.set(this.m_handler.getColumnIndex(), column);
        rowValues.set(this.m_handler.getColumnNameIndex(), columnName);
        rowValues.set(this.m_handler.getActionIndex(), this.m_cmbAction.getSelectedItem());
        rowValues.set(this.m_handler.getExpressionIndex(), this.m_expExpression.getText());
        return rowValues;
    }

    public void enableExpressionComponent() {
        if (this.m_cmbAction.getSelectedIndex() == this.m_changeAction) {
            this.m_expExpression.setEditable(true);
        } else {
            this.m_expExpression.setText("");
            this.m_expExpression.setEditable(false);
        }
    }

    public void saveSettingsAndCleanUp() {
        this.m_cmbAction.removeActionListener((ActionListener)this.m_actionListener);
        super.saveSettingsAndCleanUp();
    }

    class cActionComboBoxListener
    implements ActionListener {
        cActionComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataValidationMissingEditPanel.this.enableExpressionComponent();
        }
    }
}

