/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class CustomTreeUtilities {
    private static final WAdminResource bundle = WAdminResource.getBundle(CustomTreeUtilities.class);
    private static final String ClassIdentifier = "com.sas.wadmin.visuals.TheAppWA";

    private CustomTreeUtilities() {
    }

    public static Tree getRoot(String sRepositoryFQID) throws MdException, RemoteException {
        MdObjectStore store = Workspace.getWorkspace().getMdObjectFactory().createObjectStore(null, "CustomTreeUtilities.getRoot");
        try {
            Tree tree = CustomTreeUtilities.getRoot(sRepositoryFQID, store);
            return tree;
        }
        finally {
            store.dispose();
        }
    }

    public static Tree getRoot(String sRepositoryFQID, MdObjectStore store) throws MdException, RemoteException {
        SoftwareComponent oSoft = CustomTreeUtilities.getSoftwareComponent(sRepositoryFQID, store);
        if (oSoft == null) {
            return null;
        }
        AssociationList lTrees = oSoft.getSoftwareTrees();
        if (lTrees.isEmpty()) {
            return null;
        }
        return (Tree)lTrees.get(0);
    }

    private static SoftwareComponent getSoftwareComponent(String sRepositoryFQID, MdObjectStore store) throws MdException, RemoteException {
        StringBuffer sbOptions = new StringBuffer(100);
        sbOptions.append("<XMLSelect Search=\"@ClassIdentifier='");
        sbOptions.append(ClassIdentifier);
        sbOptions.append("'\"/>");
        sbOptions.append("<Templates>");
        sbOptions.append("<SoftwareComponent><SoftwareTrees/></SoftwareComponent>");
        sbOptions.append("<Tree><Groups/></Tree>");
        sbOptions.append("</Templates>");
        int fOptions = 396;
        List lSoftComponents = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, sRepositoryFQID, "SoftwareComponent", fOptions, sbOptions.toString());
        if (lSoftComponents.isEmpty()) {
            return null;
        }
        return (SoftwareComponent)lSoftComponents.get(0);
    }

    public static List getPath(Root oData) throws MdException, RemoteException {
        return CustomTreeUtilities.getPath(oData, (MdObjectStore)oData.getObjectStore());
    }

    public static List getPath(Root oData, MdObjectStore store) throws MdException, RemoteException {
        String sRepositoryFQID = "A0000001." + oData.getRepositoryID();
        return CustomTreeUtilities.getPath(oData, CustomTreeUtilities.getRoot(sRepositoryFQID, store), store);
    }

    public static List getPath(Root oData, Tree oRoot) throws MdException, RemoteException {
        return CustomTreeUtilities.getPath(oData, oRoot, (MdObjectStore)oData.getObjectStore());
    }

    public static List getPath(Root oData, Tree oRoot, MdObjectStore store) throws MdException, RemoteException {
        Object lTrees;
        AssociationList lGroups = oRoot.getGroups();
        if (lGroups.isEmpty()) {
            return new ArrayList();
        }
        Group oGroup = (Group)lGroups.get(0);
        StringBuffer sbTemplate = new StringBuffer(80);
        sbTemplate.append("<Templates>");
        ArrayList<String> lAttrs = new ArrayList<String>(1);
        boolean bTree = oData.getCMetadataType().equals("Tree");
        if (bTree) {
            lAttrs.add("Groups");
            lAttrs.add("ParentTree");
            sbTemplate.append("<Tree Name=\"\"><ParentTree/></Tree>");
        } else {
            lAttrs.add("Trees");
            sbTemplate.append("<Tree Name=\"\"><Groups/><ParentTree/></Tree>");
        }
        sbTemplate.append("</Templates>");
        int fFlags = 260;
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oData, null, lAttrs, sbTemplate.toString(), fFlags);
        if (bTree) {
            lTrees = new ArrayList(1);
            lTrees.add(oData);
        } else {
            lTrees = oData.getTrees();
        }
        for (int iTree = 0; iTree < lTrees.size(); ++iTree) {
            Group oGroupTree;
            Tree oTree = (Tree)lTrees.get(iTree);
            lGroups = oTree.getGroups();
            if (lGroups.isEmpty() || !(oGroupTree = (Group)lGroups.get(0)).getFQID().equals(oGroup.getFQID())) continue;
            return CustomTreeUtilities.getPathToRoot(oTree);
        }
        return new ArrayList();
    }

    private static List getPathToRoot(Tree oTree) throws MdException, RemoteException {
        ArrayList<Tree> lTreePath = new ArrayList<Tree>(2);
        while (oTree != null) {
            lTreePath.add(0, oTree);
            oTree = oTree.getParentTree();
        }
        return lTreePath;
    }

    public void addTree(Tree oParent, Tree oChild) throws MdException, RemoteException {
        this.addTree(oParent, oChild, -1);
    }

    public void addTree(Tree oParent, Tree oChild, int iChild) throws MdException, RemoteException {
        SoftwareComponent oSoft = CustomTreeUtilities.getSoftwareComponent("A000001." + oParent.getRepositoryID(), (MdObjectStore)oParent.getObjectStore());
        if (oSoft == null) {
            throw new MdException(bundle.getString("CustomTreeUtilities.NotFoundException.txt"));
        }
        AssociationList lGroups = oSoft.getGroups();
        if (lGroups.isEmpty()) {
            throw new MdException(bundle.getString("CustomTreeUtilities.CorruptException.txt"));
        }
        Group oGroup = (Group)lGroups.get(0);
        oGroup.getMembers().add((Object)oChild);
        if (iChild == -1) {
            oParent.getSubTrees().add((Object)oChild);
        } else {
            oParent.getSubTrees().add(iChild, (Object)oChild);
        }
    }

    public void removeTree(Tree oChild) throws MdException, RemoteException {
        SoftwareComponent oSoft = CustomTreeUtilities.getSoftwareComponent("A000001." + oChild.getRepositoryID(), (MdObjectStore)oChild.getObjectStore());
        if (oSoft == null) {
            throw new MdException(bundle.getString("CustomTreeUtilities.NotFoundException.txt"));
        }
        AssociationList lGroups = oSoft.getGroups();
        if (lGroups.isEmpty()) {
            throw new MdException(bundle.getString("CustomTreeUtilities.CorruptException.txt"));
        }
        Group oGroup = (Group)lGroups.get(0);
        oGroup.getMembers().remove((Object)oChild);
        Tree oParent = oChild.getParentTree();
        if (oParent != null) {
            oParent.getSubTrees().remove((Object)oChild);
        }
    }
}

