/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.undo.UndoManager;

public class ActionOptionsConfigPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(ActionOptionsConfigPanel.class);
    protected WsTable m_tblOptions;
    protected JButton m_btnNewOption;
    protected JButton m_btnDeleteOption;
    protected cOptionsTableModel m_mdlOptions;
    protected cActNewOption m_actNewOption;
    protected cActDeleteOption m_actDeleteOption;

    public ActionOptionsConfigPanel() {
        this.initialize();
    }

    protected void initialize() {
        this.m_actNewOption = new cActNewOption();
        this.m_actDeleteOption = new cActDeleteOption();
        this.m_actDeleteOption.setEnabled(false);
        this.m_mdlOptions = new cOptionsTableModel();
        this.m_mdlOptions.addTableModelListener(new cOptionsTableModelListener());
        this.m_tblOptions = new WsTable((WsAbstractTableModel)this.m_mdlOptions);
        this.m_tblOptions.setRowsReorderable(false);
        this.m_tblOptions.setRowHoldingEnabled(false);
        this.m_tblOptions.setColumnHoldingEnabled(false);
        this.m_tblOptions.setAutoResizeMode(4);
        this.m_tblOptions.setUndoManager((UndoManager)this.waum);
        this.m_tblOptions.getSelectionModel().addListSelectionListener(new cOptionsTableSelectionListener());
        this.m_tblOptions.getActionMap().put((Object)this.m_actDeleteOption, (Action)((Object)this.m_actDeleteOption));
        this.m_tblOptions.getInputMap().put(KeyStroke.getKeyStroke(127, 0), (Object)this.m_actDeleteOption);
        this.m_tblOptions.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)new cOptionsTablePopupMenuRequestListener());
        this.m_tblOptions.setViewportPopupMenuRequestListener((WsPopupMenuRequestListener)new cOptionsTablePopupMenuRequestListener());
        this.m_tblOptions.setOriginPopupMenuRequestListener((WsPopupMenuRequestListener)new cOptionsTablePopupMenuRequestListener());
        this.m_tblOptions.setRowHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)new cOptionsTablePopupMenuRequestListener());
        this.m_tblOptions.setColumnHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)new cOptionTableColumnHeaderPopupMenuRequestListener());
        this.m_btnNewOption = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNewOption);
        this.m_btnDeleteOption = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDeleteOption);
        this.setHelpProduct("wdb");
        this.setHelpTopic("action_options_config_win");
        JScrollPane scrOptions = new JScrollPane((Component)this.m_tblOptions);
        scrOptions.setMinimumSize(new Dimension(200, 160));
        scrOptions.setPreferredSize(new Dimension(250, 200));
        JPanel pnlOptionBtns = new JPanel((LayoutManager)new WsButtonsLayout());
        pnlOptionBtns.add(this.m_btnNewOption);
        pnlOptionBtns.add(this.m_btnDeleteOption);
        JPanel pnlOptions = new JPanel(new BorderLayout(0, 5));
        pnlOptions.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        pnlOptions.add((Component)scrOptions, "Center");
        pnlOptions.add((Component)pnlOptionBtns, "South");
        this.add(pnlOptions);
    }

    public boolean validateData() {
        return this.m_tblOptions.stopCellEditing();
    }

    public void populateStore() {
    }

    public void moveDataToModel() {
        this.setListeningForChanges(false);
        this.m_mdlOptions.moveDataToModel();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() {
        this.m_mdlOptions.moveDataToStore();
    }

    protected List getOptionsValues() {
        return this.m_mdlOptions.getNameValues();
    }

    protected void setOptionsValues(List lOptionsValues) {
        this.m_mdlOptions.setNameValues(lOptionsValues);
    }

    protected void newOption() {
        this.m_tblOptions.undoableInsertNewRow(this.m_tblOptions.getRowCount() - 1);
    }

    protected void deleteOption() {
        this.m_tblOptions.undoableDeleteSelectedRows();
    }

    protected void updateOptionActions() {
        int[] aSelectedRows = this.m_tblOptions.getSelectedRowsFromSelectedCells();
        this.m_actDeleteOption.setEnabled(aSelectedRows.length > 0);
    }

    protected class cActNewOption
    extends WsAbstractAction {
        public cActNewOption() {
            super(bundle, "ActionOptionsConfigPanel.NewOption");
        }

        public void actionPerformed(ActionEvent e) {
            ActionOptionsConfigPanel.this.newOption();
        }
    }

    protected class cActDeleteOption
    extends WsAbstractAction {
        public cActDeleteOption() {
            super(bundle, "ActionOptionsConfigPanel.DeleteOption");
        }

        public void actionPerformed(ActionEvent e) {
            ActionOptionsConfigPanel.this.deleteOption();
        }
    }

    class cOptionsTableModel
    extends WsAbstractTableModel {
        protected List m_lOptionValues = new ArrayList();
        protected static final int OPTIONS_COLUMN = 0;
        protected static final int COLUMN_COUNT = 1;

        public cOptionsTableModel() {
            WsUniqueNameTableColumn colOptions = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, bundle.getString("ActionOptionsConfigPanel.OptionsColumn.txt"), 200);
            colOptions.setMaximumCharacters(50);
            colOptions.setFormatString(bundle.getString("ActionOptionsConfigPanel.NewOptionName.fmt.txt"));
            this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount()];
            this.m_aColumns[0] = colOptions;
        }

        public int getColumnCount() {
            return 1;
        }

        public void populateStore() {
            this.setStorePopulated(true);
        }

        public void moveDataToModel() {
            this.clear();
            for (int i = 0; i < this.m_lOptionValues.size(); ++i) {
                ArrayList lRow = new ArrayList();
                lRow.add(this.m_lOptionValues.get(i));
                this.m_lData.add(lRow);
            }
            this.fireTableModelPopulated();
        }

        public void moveDataToStore() {
            this.m_lOptionValues.clear();
            for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
                this.m_lOptionValues.add(this.getValueAt(iRow, 0));
            }
        }

        protected List getNameValues() {
            return this.m_lOptionValues;
        }

        protected void setNameValues(List lOptionValues) {
            if (lOptionValues == null) {
                this.m_lOptionValues.clear();
            } else {
                this.m_lOptionValues = lOptionValues;
            }
        }
    }

    protected class cOptionsTableModelListener
    implements TableModelListener {
        protected cOptionsTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (ActionOptionsConfigPanel.this.isListeningForChanges()) {
                ActionOptionsConfigPanel.this.setDataChanged(true);
            }
        }
    }

    protected class cOptionsTableSelectionListener
    implements ListSelectionListener {
        protected cOptionsTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ActionOptionsConfigPanel.this.updateOptionActions();
        }
    }

    protected class cOptionsTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cOptionsTablePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem((Action)((Object)ActionOptionsConfigPanel.this.m_actNewOption)));
            mnuPopup.add(new JMenuItem((Action)((Object)ActionOptionsConfigPanel.this.m_actDeleteOption)));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cOptionTableColumnHeaderPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cOptionTableColumnHeaderPopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = ActionOptionsConfigPanel.this.m_tblOptions.createColumnHeaderPopupMenu();
            mnuPopup.addSeparator();
            mnuPopup.add(new JMenuItem((Action)((Object)ActionOptionsConfigPanel.this.m_actNewOption)));
            mnuPopup.add(new JMenuItem((Action)((Object)ActionOptionsConfigPanel.this.m_actDeleteOption)));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }
}

