/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.wadmin.viewdata2.CommonActionsFactory;
import com.sas.wadmin.viewdata2.ConnectionManager;
import com.sas.wadmin.viewdata2.ViewDataAbstractFactory;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.wadmin.viewdata2.ViewDataToolBar;
import com.sas.wadmin.viewdata2.impl.JobExternalTableModel;
import com.sas.wadmin.viewdata2.impl.JobPhysicalTableModel;
import com.sas.wadmin.viewdata2.impl.JobTableConnectionManager;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import java.rmi.RemoteException;

public class JobTableFactory
extends ViewDataAbstractFactory {
    private ITable m_table;
    private WsAppServer m_appServer;
    private WsAbstractAction m_editAction;
    private BaseModel m_mdl;
    private OMRAdapter m_omr;

    public JobTableFactory(ITable table, WsAppServer appServer, WsAbstractAction editAction) {
        this.m_table = table;
        this.m_appServer = appServer;
        this.m_editAction = editAction;
        this.m_mdl = new BaseModel();
        this.m_mdl.setDebugName(this.m_table.getName() + " ITable view data");
        this.m_mdl.setModelEventsEnabled(false);
        try {
            this.m_omr = new OMRAdapter((IModel)this.m_mdl, Workspace.getMdFactory(), this.m_table.getName() + " ITable view data");
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    @Override
    public void dispose() throws ViewDataException {
        if (this.m_mdl != null) {
            this.m_mdl.dispose();
        }
        if (this.m_omr != null) {
            this.m_omr.dispose();
        }
        super.dispose();
    }

    @Override
    protected ConnectionManager createConnectionManager() throws ViewDataException {
        this.setFactoryDisposable(false);
        try {
            JobTableConnectionManager manager = new JobTableConnectionManager(this.m_table, this.m_appServer);
            manager.setEditable(false);
            manager.init();
            JobTableConnectionManager jobTableConnectionManager = manager;
            return jobTableConnectionManager;
        }
        finally {
            this.setFactoryDisposable(true);
        }
    }

    @Override
    public ViewDataModel createModel() throws ViewDataException {
        this.setFactoryDisposable(false);
        try {
            if (this.m_table instanceof IExternalTable) {
                JobExternalTableModel jobExternalTableModel = new JobExternalTableModel((IExternalTable)this.m_table, this.createDefaultConnectionManager());
                return jobExternalTableModel;
            }
            JobPhysicalTableModel jobPhysicalTableModel = new JobPhysicalTableModel((IPhysicalTable)this.m_table, this.createDefaultConnectionManager());
            return jobPhysicalTableModel;
        }
        finally {
            this.setFactoryDisposable(true);
        }
    }

    @Override
    public ViewDataToolBar createToolBar() throws ViewDataException {
        ViewDataToolBar toolbar = super.createToolBar();
        toolbar.addComponent(CommonActionsFactory.getGoToRowWidget(this.createDefaultTable()));
        toolbar.addSeparator();
        toolbar.addFlatToolButton(CommonActionsFactory.getGoToFirstRowAction(this.createDefaultTable()));
        toolbar.addFlatToolButton(CommonActionsFactory.getGoToLastRowAction(this.createDefaultTable()));
        toolbar.addSeparator();
        if (this.isDatasetEditable() && this.m_editAction != null) {
            toolbar.addFlatToggleButton(CommonActionsFactory.getNullBrowseModeAction());
            toolbar.addFlatToolButton(this.m_editAction);
            toolbar.addSeparator();
        }
        toolbar.addFlatToolButton(this.getAction("Common:Print"));
        toolbar.addFlatToolButton(this.getAction("Common:Refresh"));
        toolbar.addSeparator();
        toolbar.addFlatToolButton(CommonActionsFactory.getCopyAction(this.createDefaultTable()));
        toolbar.addSeparator();
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowSearchScreenAction(this.createDefaultSearchToolArea()));
        toolbar.addSeparator();
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowSortScreenAction(this.createDefaultQueryOptionsDialog()));
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowFilterScreenAction(this.createDefaultQueryOptionsDialog()));
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowSubsetScreenAction(this.createDefaultQueryOptionsDialog()));
        toolbar.addSeparator();
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowMetadataColumnNameAction(this.createDefaultModel()));
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowMetadataColumnLabelAction(this.createDefaultModel()));
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowMetadataColumnMetadataNameAction(this.createDefaultModel()));
        toolbar.addSeparator();
        toolbar.addFlatToggleButton(CommonActionsFactory.getApplyMetadataFormatsAction(this.createDefaultModel()));
        return toolbar;
    }

    @Override
    protected PhysicalTable getPhysicalTable() throws ViewDataException {
        if (this.m_table instanceof IPhysicalTable && this.m_omr != null) {
            try {
                this.m_omr.populateFor((IOMRPersistable)this.m_table);
                IServer server = ModelUIUtilities.getServerForAppServer((IModel)this.m_mdl, this.m_appServer);
                ILibrary lib = ((IPhysicalTable)this.m_table).getClientLibrary(server);
                if (lib != null) {
                    this.m_omr.populateFor((IOMRPersistable)lib);
                }
                return (PhysicalTable)this.m_omr.acquireOMRObject((IOMRPersistable)this.m_table);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (BadLibraryDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isDatasetEditable() throws ViewDataException {
        if (this.m_table == null || !(this.m_table instanceof IPhysicalTable)) {
            return false;
        }
        PhysicalTable physicalTable = this.getPhysicalTable();
        if (this.m_editAction == null || !Workspace.getWorkspace().isObjectEditable((CMetadata)physicalTable)) {
            return false;
        }
        IPhysicalTable modelPhysicalTable = (IPhysicalTable)this.m_table;
        this.setFactoryDisposable(false);
        try {
            if (!"DATA".equals(physicalTable.getMemberType())) {
                boolean bl = false;
                return bl;
            }
            IServer server = ModelUIUtilities.getServerForAppServer((IModel)this.m_mdl, this.m_appServer);
            ILibrary lib = modelPhysicalTable.getClientLibrary(server);
            if (lib == null) {
                boolean bl = false;
                return bl;
            }
            if (!"BASE".equals(lib.getEngine()) || physicalTable.getSASTableName().indexOf("&") != -1) {
                boolean bl = false;
                return bl;
            }
            IServer[] aLibraryServers = lib.getServers();
            if (aLibraryServers.length == 0) {
                boolean bl = this.isDefaultAppServerWorkspace();
                return bl;
            }
            for (int i = 0; i < aLibraryServers.length; ++i) {
                IServer[] aSubComponents = aLibraryServers[i].getSubComponents();
                for (int j = 0; j < aSubComponents.length; ++j) {
                    if ("440196D4-90F0-11D0-9F41-00A024BB830C".compareTo(aSubComponents[j].getClassIdentifier()) != 0) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            throw new ViewDataException(e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (BadLibraryDefinitionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (NullPointerException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        finally {
            this.setFactoryDisposable(true);
        }
        return false;
    }
}

