/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2.impl;

import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.viewdata2.ViewDataAbstractFactory;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataPanel;
import com.sas.wadmin.viewdata2.impl.ExternalTableBrowseFactory;
import com.sas.wadmin.viewdata2.impl.MetadataConnectionManager;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.metadata.EFIDataModel;
import com.sas.workspace.visuals.SASLogDialog;
import java.awt.Frame;
import java.rmi.RemoteException;

public class ExternalTablePanel
extends ViewDataPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(ExternalTablePanel.class);
    private ExternalTable m_externalTable;

    public ExternalTablePanel(ExternalTable externalTable) throws ViewDataException {
        try {
            if (EFIDataModel.isLegacyEFIObject((ExternalTable)externalTable)) {
                MessageUtil.displayMessage((String)bundle.getString("ExternalTablePanel.LegacyEFIError.txt"));
                throw new ViewDataException(bundle.getString("ExternalTablePanel.LegacyEFIError.txt"));
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            throw new ViewDataException(e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.m_externalTable = externalTable;
    }

    @Override
    protected ViewDataAbstractFactory createFactory() throws ViewDataException {
        return new ExternalTableBrowseFactory(this.getExternalTable());
    }

    protected ExternalTable getExternalTable() {
        return this.m_externalTable;
    }

    @Override
    protected void onFetchError(String msg, ViewDataException e) {
        super.onFetchError(msg, e);
        if (e.hasCause() && e.causeInstanceOf(WsAppServerCodeException.class)) {
            this.showWsAppServerCodeException((WsAppServerCodeException)e.getCause());
        } else {
            MessageUtil.displayDetailsMessage((String)bundle.getString("ExternalTablePanel.ErrorFetchingData.txt"), (int)0, (String)msg);
        }
    }

    protected void showWsAppServerCodeException(WsAppServerCodeException e) {
        Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        int showMessage = MessageUtil.displayMessage((String)bundle.getString("PhysicalTablePanel.WsAppServerCodeException.txt"), (int)0, (int)0);
        if (showMessage == 0) {
            SASLogDialog logDlg = new SASLogDialog((Frame)Workspace.getWorkspace(), bundle.getString("PhysicalTablePanel.WsAppServerCodeExceptionTitle.txt"), true, ((MetadataConnectionManager)this.getFactory().getDefaultConnectionManager()).getAppServer());
            logDlg.setResizable(true);
            logDlg.show();
        }
    }
}

