/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2.impl;

import com.sas.wadmin.viewdata2.ConnectionManager;
import com.sas.wadmin.viewdata2.ViewDataJDBCModel;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsDateTableColumn;
import com.sas.workspace.WsDecimalTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class EditModel
extends ViewDataJDBCModel {
    public static final String PROPERTY_TABLE_SQL_NAME = "TableSQLName";
    public static final String PROPERTY_TABLE_DISPLAY_NAME = "TableDisplayName";
    private String m_libref;
    private String m_tableSQLName;
    private String m_tableDisplayName;
    private boolean m_bUpdatingColumns = false;

    public EditModel(String tableSQLName, ConnectionManager connManager) {
        this("WORK", tableSQLName, connManager);
    }

    public EditModel(String libref, String tableSQLName, ConnectionManager connManager) {
        this.setLibRef(libref);
        this.setTableSQLName(tableSQLName);
        this.setConnectionManager(connManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateColumnInformation() {
        if (this.getDataManager() == null) {
            return;
        }
        if (this.m_bUpdatingColumns) {
            return;
        }
        this.m_bUpdatingColumns = true;
        try {
            WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
            int colCount = this.getColumnCount();
            this.m_aColumns = new WsAbstractTableColumn[colCount];
            block11: for (int i = 0; i < colCount; ++i) {
                String label = this.getColumnDisplayName(i);
                int type = this.getColumnJDBCType(i);
                switch (type) {
                    case 2: 
                    case 3: 
                    case 6: 
                    case 8: {
                        this.m_aColumns[i] = new WsDecimalTableColumn(i, label, 75, 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
                        ((WsDecimalTableColumn)this.m_aColumns[i]).setMissingValue(new Double(Double.MAX_VALUE));
                        ((WsDecimalTableColumn)this.m_aColumns[i]).setAllowNegative(true);
                        continue block11;
                    }
                    case 4: {
                        this.m_aColumns[i] = new WsIntegerTableColumn(i, label, 75, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
                        ((WsIntegerTableColumn)this.m_aColumns[i]).setMissingValue(new Integer(Integer.MAX_VALUE));
                        ((WsIntegerTableColumn)this.m_aColumns[i]).setAllowNegative(true);
                        continue block11;
                    }
                    case 91: {
                        this.m_aColumns[i] = new WsDateTableColumn(i, label, 75);
                        ((WsDateTableColumn)this.m_aColumns[i]).setShowAsBlankDate(UNKNOWN_DATE);
                        ((WsDateTableColumn)this.m_aColumns[i]).setDateFormat((DateFormat)new SimpleDateFormat(file.getPropertyString("ViewData.DefaultDateFormat", "yyyy-MM-dd")));
                        continue block11;
                    }
                    case 92: 
                    case 93: {
                        this.m_aColumns[i] = new WsDateTableColumn(i, label, 75);
                        ((WsDateTableColumn)this.m_aColumns[i]).setShowAsBlankDate(UNKNOWN_DATE);
                        ((WsDateTableColumn)this.m_aColumns[i]).setDateFormat((DateFormat)new SimpleDateFormat(file.getPropertyString("ViewData.DefaultDateTimeFormat", "yyyy-MM-dd HH:mm:ss")));
                        continue block11;
                    }
                    default: {
                        this.m_aColumns[i] = new WsStringTableColumn(i, label, 75);
                        int precision = this.getColumnPrecision(i);
                        if (precision <= 0) continue block11;
                        ((WsStringTableColumn)this.m_aColumns[i]).setMaximumCharacters(precision);
                    }
                }
            }
            this.fireTableStructureChanged();
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        finally {
            this.m_bUpdatingColumns = false;
        }
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public String getQuery() {
        String query = "SELECT * FROM " + this.getLibRef() + "." + this.getTableSQLName();
        Workspace.getDefaultLogger().info((Object)query);
        return query;
    }

    public void setTableDisplayName(String tableDisplayName) {
        String oldName = this.m_tableDisplayName;
        this.m_tableDisplayName = tableDisplayName;
        if (this.m_tableDisplayName != null && !this.m_tableDisplayName.equals(oldName)) {
            this.firePropertyChanged(PROPERTY_TABLE_DISPLAY_NAME, oldName, this.m_tableDisplayName);
        }
    }

    @Override
    public String getTableDisplayName() {
        if (this.m_tableDisplayName != null) {
            return this.m_tableDisplayName;
        }
        return this.getTableSQLName();
    }

    public void setTableSQLName(String tableSQLName) {
        String oldName = this.m_tableSQLName;
        this.m_tableSQLName = tableSQLName;
        if (this.m_tableSQLName != null && !this.m_tableSQLName.equals(oldName)) {
            this.firePropertyChanged(PROPERTY_TABLE_SQL_NAME, oldName, this.m_tableSQLName);
        }
    }

    @Override
    public String getTableSQLName() {
        return this.m_tableSQLName;
    }

    public void setLibRef(String libref) {
        this.m_libref = libref;
    }

    @Override
    public String getLibRef() {
        return this.m_libref;
    }

    @Override
    protected String getTableOptions() {
        return "";
    }

    @Override
    protected String getParameterizedMacroDeclaration() {
        return null;
    }

    @Override
    public String getTrueColumnFormat(int iColumn) {
        return "";
    }
}

