/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ViewDataGlobalOptionsTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ViewDataGlobalOptionsTab.class);
    private static final String[] ON_EDIT_ERROR_VALUE = new String[]{bundle.getString("ViewDataGlobalOptionsTab.MultiRowErrorsPrompt.txt"), bundle.getString("ViewDataGlobalOptionsTab.MultiRowErrorsIgnore.txt"), bundle.getString("ViewDataGlobalOptionsTab.MultiRowErrorsAbort.txt")};
    private static final String[] DATE_FORMATS = new String[]{"ddMMMyyyy", "M/dd", "M/dd/yy", "MM/dd/yy", "dd-MMM-yy", "dd-MMM-yyyy", "MMMM dd, yyyy"};
    protected static final String DATE_FORMAT_KEY = "ViewData.DateFormat.";
    private static final String[] DATETIME_FORMATS = new String[]{"MM/dd/yyyy hh:mm:ss a", "MM/dd/yyyy kk:mm:ss a"};
    protected static final String DATETIME_FORMAT_KEY = "ViewData.DateTimeFormat.";
    private JCheckBox m_clearQueryOptionsOnRefresh;
    private JCheckBox m_promptOnLongRunningNavigation;
    private JCheckBox m_columnNameInHeader;
    private JCheckBox m_descriptionInHeader;
    private JCheckBox m_columnMDNameInHeader;
    private JCheckBox m_applyMetadataFormats;
    private JCheckBox m_applyPermanentFormats;
    private JSpinner m_recentSearchStringsCount;
    private JCheckBox m_ignoreInvalidColumnNames;
    private WAComboBox m_multiRowOperationErrorHandling;
    private WAComboBox m_defaultDateFormat;
    private WAComboBox m_defaultDateTimeFormat;
    private JCheckBox m_editSCD2Tables;
    private JCheckBox m_deleteRowsWithoutPrompt;
    private JLabel m_lblOffsetThreshold;
    private WAIntTextField m_txtOffsetThreshold;
    private JCheckBox m_ckbRowLimit;
    private JLabel m_lblRowLimit;
    private WAIntTextField m_txtRowLimit;

    public ViewDataGlobalOptionsTab() {
        this.initialize();
        this.layoutWidgets();
        this.setName(bundle.getString("ViewDataGlobalOptionsTab.Name.txt"));
    }

    protected void initialize() {
        int mnemonic;
        super.initialize();
        this.m_clearQueryOptionsOnRefresh = WsUIUtilities.createCheckBox((WsAbstractToggleAction)new ClearQueryOptionsOnRefreshAction());
        this.m_promptOnLongRunningNavigation = WsUIUtilities.createCheckBox((WsAbstractToggleAction)new PromptOnLongRunningNavigationAction());
        String bundleStr = null;
        String labelText = null;
        int mnemonicsIndex = -1;
        bundleStr = bundle.formatString("ViewDataGlobalOptionsTab.PromptOnLongRunningNavigation.tip", (Object)1000, (Object)10000000);
        this.m_promptOnLongRunningNavigation.setToolTipText(bundleStr);
        this.m_txtOffsetThreshold = new WAIntTextField();
        this.m_txtOffsetThreshold.setColumns(10);
        this.m_txtOffsetThreshold.setMaxCharacters((int)(Math.log10(1.0E7) + 1.1));
        bundleStr = bundle.getString("ViewDataGlobalOptionsTab.OffsetThresholdLabel.txt");
        labelText = Util.getLabelWithoutMnemonic((String)bundleStr);
        this.m_lblOffsetThreshold = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtOffsetThreshold, (String)labelText);
        mnemonicsIndex = Util.getDisplayedMnemonicIndex((String)bundleStr);
        if (mnemonicsIndex > -1) {
            mnemonic = Util.getDisplayedMnemonic((String)bundleStr);
            this.m_lblOffsetThreshold.setDisplayedMnemonic(mnemonic);
            this.m_lblOffsetThreshold.setDisplayedMnemonicIndex(mnemonicsIndex);
        }
        this.m_ckbRowLimit = WsUIUtilities.createCheckBox((WsAbstractToggleAction)new RowLimitAction());
        bundleStr = bundle.formatString("ViewDataGlobalOptionsTab.RowLimitOption.tip", (Object)1000, (Object)200000000);
        this.m_ckbRowLimit.setToolTipText(bundleStr);
        this.m_txtRowLimit = new WAIntTextField();
        this.m_txtRowLimit.setColumns(10);
        this.m_txtRowLimit.setMaxCharacters((int)(Math.log10(2.0E8) + 1.1));
        bundleStr = bundle.getString("ViewDataGlobalOptionsTab.RowLimitLabel.txt");
        labelText = Util.getLabelWithoutMnemonic((String)bundleStr);
        this.m_lblRowLimit = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtRowLimit, (String)labelText);
        mnemonicsIndex = Util.getDisplayedMnemonicIndex((String)bundleStr);
        if (mnemonicsIndex > -1) {
            mnemonic = Util.getDisplayedMnemonic((String)bundleStr);
            this.m_lblRowLimit.setDisplayedMnemonic(mnemonic);
            this.m_lblRowLimit.setDisplayedMnemonicIndex(mnemonicsIndex);
        }
        this.m_columnNameInHeader = WsUIUtilities.createCheckBox((WsAbstractToggleAction)new ColumnNameInHeaderAction());
        this.m_descriptionInHeader = WsUIUtilities.createCheckBox((WsAbstractToggleAction)new ColumnDescriptionInHeaderAction());
        this.m_columnMDNameInHeader = WsUIUtilities.createCheckBox((WsAbstractToggleAction)new ColumnMetadataNameInHeaderAction());
        this.m_applyMetadataFormats = WsUIUtilities.createCheckBox((WsAbstractToggleAction)new ApplyMetadataFormatsAction());
        this.m_applyPermanentFormats = WsUIUtilities.createCheckBox((WsAbstractToggleAction)new ApplyPermanentFormatsAction());
        this.m_recentSearchStringsCount = new JSpinner(new SpinnerNumberModel(0, 0, 999, 1));
        this.m_ignoreInvalidColumnNames = WsUIUtilities.createCheckBox((WsAbstractToggleAction)new IgnoreInvalidColumnNamesAction());
        this.m_multiRowOperationErrorHandling = new WAComboBox();
        this.m_defaultDateFormat = new WAComboBox();
        this.m_defaultDateFormat.setEditable(true);
        this.m_defaultDateFormat.setMinimumSize(new Dimension(175, 20));
        this.m_defaultDateFormat.setPreferredSize(new Dimension(175, 20));
        this.m_defaultDateTimeFormat = new WAComboBox();
        this.m_defaultDateTimeFormat.setEditable(true);
        this.m_defaultDateTimeFormat.setMinimumSize(new Dimension(175, 20));
        this.m_defaultDateTimeFormat.setPreferredSize(new Dimension(175, 20));
        this.m_editSCD2Tables = WsUIUtilities.createCheckBox((WsAbstractToggleAction)new AllowSCD2EditAction());
        this.m_deleteRowsWithoutPrompt = WsUIUtilities.createCheckBox((WsAbstractToggleAction)new DeleteWithoutPromptAction());
        this.setHelpProduct("wdb");
        this.setHelpTopic("options_view_data");
    }

    protected void layoutWidgets() {
        WAPanel generalPanel = this.getGeneralPanel();
        WAPanel columnHeadersPanel = this.getColumnHeadersPanel();
        WAPanel formatsPanel = this.getFormatsPanel();
        WAPanel searchPanel = this.getSearchPanel();
        WAPanel editingPanel = this.getEditingPanel();
        this.setLayout(new GridBagLayout());
        this.add((Component)generalPanel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)columnHeadersPanel, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)formatsPanel, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)searchPanel, new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)editingPanel, new GridBagConstraints(0, 4, 1, 1, 0.5, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        int i;
        super.moveDataToView();
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        this.m_clearQueryOptionsOnRefresh.setSelected(file.getPropertyBoolean("ViewData.RefreshClearQueryoptions", false));
        this.m_promptOnLongRunningNavigation.setSelected(file.getPropertyBoolean("ViewData.PromptForLongRunningNavigation", true));
        boolean checked = this.m_promptOnLongRunningNavigation.isSelected();
        int offsetThreshold = file.getPropertyInt("ViewData.OffsetThresholdValue", 10000);
        this.m_txtOffsetThreshold.setValue(offsetThreshold);
        this.m_lblOffsetThreshold.setEnabled(checked);
        this.m_txtOffsetThreshold.setEnabled(checked);
        checked = file.getPropertyBoolean("ViewData.RowLimit", false);
        this.m_ckbRowLimit.setSelected(checked);
        int rowLimit = file.getPropertyInt("ViewData.RowLimitValue", 100000);
        this.m_txtRowLimit.setValue(rowLimit);
        this.m_lblRowLimit.setEnabled(checked);
        this.m_txtRowLimit.setEnabled(checked);
        this.m_columnNameInHeader.setSelected(file.getPropertyBoolean("ViewData.ShowColumnNameInColumnHeader", true));
        this.m_descriptionInHeader.setSelected(file.getPropertyBoolean("ViewData.ShowDescriptionInColumnHeader", false));
        this.m_columnMDNameInHeader.setSelected(file.getPropertyBoolean("ViewData.ShowMetadataNameInColumnHeader", false));
        this.m_applyPermanentFormats.setSelected(file.getPropertyBoolean("ViewData.ShowPermanentFormats", false));
        this.m_applyMetadataFormats.setSelected(file.getPropertyBoolean("ViewData.ShowFormattedData", true));
        this.onApplyMetadataFormatsClicked();
        this.m_recentSearchStringsCount.setValue(new Integer(file.getPropertyInt("ViewData.RecentSearches", 10)));
        this.m_ignoreInvalidColumnNames.setSelected(file.getPropertyBoolean("ViewData.IgnoreInvalidColumnNames", false));
        this.m_defaultDateFormat.removeAllItems();
        this.m_defaultDateFormat.loadItems(DATE_FORMAT_KEY, Integer.MAX_VALUE);
        this.m_defaultDateTimeFormat.removeAllItems();
        this.m_defaultDateTimeFormat.loadItems(DATETIME_FORMAT_KEY, Integer.MAX_VALUE);
        this.m_multiRowOperationErrorHandling.removeAllItems();
        for (i = 0; i < ON_EDIT_ERROR_VALUE.length; ++i) {
            this.m_multiRowOperationErrorHandling.addItem((Object)ON_EDIT_ERROR_VALUE[i]);
        }
        this.m_multiRowOperationErrorHandling.setSelectedIndex(file.getPropertyInt("ViewData.MultiRowOperationErrors", 0));
        if (this.m_defaultDateFormat.getItemCount() == 0) {
            for (i = 0; i < DATE_FORMATS.length; ++i) {
                this.m_defaultDateFormat.addItem((Object)DATE_FORMATS[i]);
            }
        }
        this.m_defaultDateFormat.setSelectedItem((Object)file.getPropertyString("ViewData.DefaultDateFormat", "yyyy-MM-dd"));
        if (this.m_defaultDateTimeFormat.getItemCount() == 0) {
            for (i = 0; i < DATETIME_FORMATS.length; ++i) {
                this.m_defaultDateTimeFormat.addItem((Object)DATETIME_FORMATS[i]);
            }
        }
        this.m_defaultDateTimeFormat.setSelectedItem((Object)file.getPropertyString("ViewData.DefaultDateTimeFormat", "yyyy-MM-dd HH:mm:ss"));
        this.m_editSCD2Tables.setSelected(file.getPropertyBoolean("ViewData.EditSCD2Tables", false));
        this.m_deleteRowsWithoutPrompt.setSelected(file.getPropertyBoolean("ViewData.DeleteRowsWithoutPrompt", false));
    }

    public void moveDataToStore() throws MdException, RemoteException {
        super.moveDataToStore();
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        if (!(file.getPropertyBoolean("ViewData.RefreshClearQueryoptions", false) != this.m_clearQueryOptionsOnRefresh.isSelected() || file.getPropertyBoolean("ViewData.PromptForLongRunningNavigation", true) != this.m_promptOnLongRunningNavigation.isSelected() || this.m_promptOnLongRunningNavigation.isSelected() && file.getPropertyInt("ViewData.OffsetThresholdValue", 10000) != this.m_txtOffsetThreshold.getValue() || file.getPropertyBoolean("ViewData.RowLimit", false) != this.m_ckbRowLimit.isSelected() || this.m_ckbRowLimit.isSelected() && file.getPropertyInt("ViewData.RowLimitValue", 100000) != this.m_txtRowLimit.getValue() || file.getPropertyBoolean("ViewData.ShowColumnNameInColumnHeader", true) != this.m_columnNameInHeader.isSelected() || file.getPropertyBoolean("ViewData.ShowDescriptionInColumnHeader", false) != this.m_descriptionInHeader.isSelected() || file.getPropertyBoolean("ViewData.ShowMetadataNameInColumnHeader", false) != this.m_columnMDNameInHeader.isSelected() || file.getPropertyBoolean("ViewData.ShowFormattedData", true) != this.m_applyMetadataFormats.isSelected() || file.getPropertyBoolean("ViewData.ShowPermanentFormats", false) != this.m_applyPermanentFormats.isSelected() || file.getPropertyInt("ViewData.RecentSearches", 10) != ((Integer)this.m_recentSearchStringsCount.getValue()).intValue() || file.getPropertyBoolean("ViewData.IgnoreInvalidColumnNames", false) != this.m_ignoreInvalidColumnNames.isSelected() || file.getPropertyInt("ViewData.MultiRowOperationErrors", 0) != this.m_multiRowOperationErrorHandling.getSelectedIndex() || !file.getPropertyString("ViewData.DefaultDateFormat", DATE_FORMATS[0]).equals(this.m_defaultDateFormat.getSelectedItem()) || !file.getPropertyString("ViewData.DefaultDateTimeFormat", DATETIME_FORMATS[0]).equals(this.m_defaultDateTimeFormat.getSelectedItem()) || file.getPropertyBoolean("ViewData.EditSCD2Tables", false) != this.m_editSCD2Tables.isSelected() || file.getPropertyBoolean("ViewData.DeleteRowsWithoutPrompt", false) != this.m_deleteRowsWithoutPrompt.isSelected())) {
            return;
        }
        file.setPropertyBoolean("ViewData.RefreshClearQueryoptions", this.m_clearQueryOptionsOnRefresh.isSelected());
        file.setPropertyBoolean("ViewData.PromptForLongRunningNavigation", this.m_promptOnLongRunningNavigation.isSelected());
        if (this.m_promptOnLongRunningNavigation.isSelected()) {
            file.setPropertyInt("ViewData.OffsetThresholdValue", this.m_txtOffsetThreshold.getValue());
        }
        file.setPropertyBoolean("ViewData.RowLimit", this.m_ckbRowLimit.isSelected());
        if (this.m_ckbRowLimit.isSelected()) {
            file.setPropertyInt("ViewData.RowLimitValue", this.m_txtRowLimit.getValue());
        }
        file.setPropertyBoolean("ViewData.ShowColumnNameInColumnHeader", this.m_columnNameInHeader.isSelected());
        file.setPropertyBoolean("ViewData.ShowDescriptionInColumnHeader", this.m_descriptionInHeader.isSelected());
        file.setPropertyBoolean("ViewData.ShowMetadataNameInColumnHeader", this.m_columnMDNameInHeader.isSelected());
        file.setPropertyBoolean("ViewData.ShowFormattedData", this.m_applyMetadataFormats.isSelected());
        file.setPropertyBoolean("ViewData.ShowPermanentFormats", this.m_applyPermanentFormats.isSelected());
        file.setPropertyInt("ViewData.RecentSearches", ((Integer)this.m_recentSearchStringsCount.getValue()).intValue());
        file.setPropertyBoolean("ViewData.IgnoreInvalidColumnNames", this.m_ignoreInvalidColumnNames.isSelected());
        file.setPropertyInt("ViewData.MultiRowOperationErrors", this.m_multiRowOperationErrorHandling.getSelectedIndex());
        this.m_defaultDateFormat.saveItems(DATE_FORMAT_KEY, Integer.MAX_VALUE);
        this.m_defaultDateTimeFormat.saveItems(DATETIME_FORMAT_KEY, Integer.MAX_VALUE);
        file.setPropertyString("ViewData.DefaultDateFormat", this.m_defaultDateFormat.getSelectedItem().toString());
        file.setPropertyString("ViewData.DefaultDateTimeFormat", this.m_defaultDateTimeFormat.getSelectedItem().toString());
        file.setPropertyBoolean("ViewData.EditSCD2Tables", this.m_editSCD2Tables.isSelected());
        file.setPropertyBoolean("ViewData.DeleteRowsWithoutPrompt", this.m_deleteRowsWithoutPrompt.isSelected());
    }

    public boolean validateData() {
        return this.validateGeneralPanel() && this.validateColumnHeadersPanel() && this.validateFormatsPanel() && this.validateSearchPanel() && this.validateEditingPanel();
    }

    protected WAPanel getGeneralPanel() {
        WAPanel generalPanel = new WAPanel();
        generalPanel.setLayout((LayoutManager)new GridBagLayout());
        generalPanel.setBorder((Border)new TitledBorder(" " + bundle.getString("ViewDataGlobalOptionsTab.GeneralPanel.txt") + " "));
        generalPanel.add((Component)this.m_clearQueryOptionsOnRefresh, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 5, 0, 5), 0, 0));
        generalPanel.add((Component)this.m_promptOnLongRunningNavigation, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 5, 0, 0), 0, 0));
        int labelTopOffset = 8;
        generalPanel.add((Component)this.m_lblOffsetThreshold, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(labelTopOffset, 9, 0, 5), 0, 0));
        generalPanel.add((Component)this.m_txtOffsetThreshold, (Object)new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 1, 0, 5), 0, 0));
        generalPanel.add((Component)this.m_ckbRowLimit, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 5, 0, 0), 0, 0));
        generalPanel.add((Component)this.m_lblRowLimit, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(labelTopOffset, 9, 1, 5), 0, 0));
        generalPanel.add((Component)this.m_txtRowLimit, (Object)new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 1, 5, 5), 0, 0));
        return generalPanel;
    }

    protected WAPanel getColumnHeadersPanel() {
        WAPanel columnHeadersPanel = new WAPanel();
        columnHeadersPanel.setLayout((LayoutManager)new GridBagLayout());
        columnHeadersPanel.setBorder((Border)new TitledBorder(" " + bundle.getString("ViewDataGlobalOptionsTab.ColumnHeadersPanel.txt") + " "));
        columnHeadersPanel.add((Component)this.m_columnNameInHeader, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 5, 0, 5), 0, 0));
        columnHeadersPanel.add((Component)this.m_descriptionInHeader, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 5, 0, 5), 0, 0));
        columnHeadersPanel.add((Component)this.m_columnMDNameInHeader, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(4, 5, 5, 5), 0, 0));
        return columnHeadersPanel;
    }

    protected WAPanel getFormatsPanel() {
        WAPanel formatsPanel = new WAPanel();
        formatsPanel.setLayout((LayoutManager)new GridBagLayout());
        formatsPanel.setBorder((Border)new TitledBorder(" " + bundle.getString("ViewDataGlobalOptionsTab.FormatsPanel.txt") + " "));
        formatsPanel.add((Component)this.m_applyPermanentFormats, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 5, 5, 5), 0, 0));
        formatsPanel.add((Component)this.m_applyMetadataFormats, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 5, 0, 5), 0, 0));
        return formatsPanel;
    }

    protected WAPanel getSearchPanel() {
        WAPanel searchPanel = new WAPanel();
        searchPanel.setLayout((LayoutManager)new GridBagLayout());
        searchPanel.setBorder((Border)new TitledBorder(" " + bundle.getString("ViewDataGlobalOptionsTab.SearchPanel.txt") + " "));
        JLabel recentSearchesLabel1 = new JLabel(bundle.getString("ViewDataGlobalOptionsTab.RecentSearchStringsLabel1.txt"));
        recentSearchesLabel1.setLabelFor(this.m_recentSearchStringsCount);
        recentSearchesLabel1.setDisplayedMnemonic(bundle.getString("ViewDataGlobalOptionsTab.RecentSearchStringsLabel1.mnen").charAt(0));
        JLabel recentSearchesLabel2 = new JLabel(bundle.getString("ViewDataGlobalOptionsTab.RecentSearchStringsLabel2.txt"));
        searchPanel.add((Component)recentSearchesLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 5, 5, 5), 0, 0));
        searchPanel.add((Component)this.m_recentSearchStringsCount, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 5, 5, 5), 0, 0));
        searchPanel.add((Component)recentSearchesLabel2, (Object)new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 5, 5, 5), 0, 0));
        searchPanel.add((Component)this.m_ignoreInvalidColumnNames, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 18, 0, new Insets(4, 5, 5, 5), 0, 0));
        return searchPanel;
    }

    protected WAPanel getEditingPanel() {
        WAPanel editingPanel = new WAPanel();
        editingPanel.setLayout((LayoutManager)new GridBagLayout());
        editingPanel.setBorder((Border)new TitledBorder(" " + bundle.getString("ViewDataGlobalOptionsTab.EditingPanel.txt") + " "));
        JLabel editingErrorsLabel = new JLabel(bundle.getString("ViewDataGlobalOptionsTab.MultiRowErrorsLabel.txt"));
        editingErrorsLabel.setLabelFor((Component)this.m_multiRowOperationErrorHandling);
        editingErrorsLabel.setDisplayedMnemonic(bundle.getString("ViewDataGlobalOptionsTab.MultiRowErrorsLabel.mnen").charAt(0));
        JLabel defaultDateFormatLabel = new JLabel(bundle.getString("ViewDataGlobalOptionsTab.DefaultDateFormat.txt"));
        defaultDateFormatLabel.setLabelFor((Component)this.m_defaultDateFormat);
        defaultDateFormatLabel.setDisplayedMnemonic(bundle.getString("ViewDataGlobalOptionsTab.DefaultDateFormat.mnen").charAt(0));
        JLabel defaultDateTimeFormatLabel = new JLabel(bundle.getString("ViewDataGlobalOptionsTab.DefaultDateTimeFormat.txt"));
        defaultDateTimeFormatLabel.setLabelFor((Component)this.m_defaultDateTimeFormat);
        defaultDateTimeFormatLabel.setDisplayedMnemonic(bundle.getString("ViewDataGlobalOptionsTab.DefaultDateTimeFormat.mnen").charAt(0));
        editingPanel.add((Component)this.m_editSCD2Tables, (Object)new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(4, 5, 0, 5), 0, 0));
        editingPanel.add((Component)this.m_deleteRowsWithoutPrompt, (Object)new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(4, 5, 0, 5), 0, 0));
        editingPanel.add((Component)editingErrorsLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 5, 0, 5), 0, 0));
        editingPanel.add((Component)this.m_multiRowOperationErrorHandling, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 5, 0, 5), 0, 0));
        editingPanel.add((Component)defaultDateFormatLabel, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 5, 0, 5), 0, 0));
        editingPanel.add((Component)this.m_defaultDateFormat, (Object)new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 5, 0, 5), 0, 0));
        editingPanel.add((Component)defaultDateTimeFormatLabel, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 5, 0, 5), 0, 0));
        editingPanel.add((Component)this.m_defaultDateTimeFormat, (Object)new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 5, 0, 5), 0, 0));
        return editingPanel;
    }

    protected boolean validateGeneralPanel() {
        int rowLimit;
        int offsetThreshold;
        String varName = null;
        String messageOffsetThreshold = null;
        String messageRowLimit = null;
        boolean bOffsetThreshold = true;
        if (this.m_promptOnLongRunningNavigation.isSelected() && ((offsetThreshold = this.m_txtOffsetThreshold.getValue()) > 10000000 || offsetThreshold < 1000)) {
            bOffsetThreshold = false;
            varName = bundle.getString("ViewDataGlobalOptionsTab.OffsetThresholdLabelName.txt");
            messageOffsetThreshold = bundle.formatString("ViewDataGlobalOptionsTab.VariantValueError.txt", (Object)varName, (Object)1000, (Object)10000000);
        }
        boolean bRowLimit = true;
        if (this.m_ckbRowLimit.isSelected() && ((rowLimit = this.m_txtRowLimit.getValue()) > 200000000 || rowLimit < 1000)) {
            bRowLimit = false;
            varName = bundle.getString("ViewDataGlobalOptionsTab.RowLimitLabelName.txt");
            messageRowLimit = bundle.formatString("ViewDataGlobalOptionsTab.VariantValueError.txt", (Object)varName, (Object)1000, (Object)200000000);
        }
        String message = null;
        if (!bOffsetThreshold && !bRowLimit) {
            message = messageOffsetThreshold + "\r\n\r\n" + messageRowLimit;
        } else if (!bOffsetThreshold) {
            message = messageOffsetThreshold;
        } else if (!bRowLimit) {
            message = messageRowLimit;
        }
        if (!bOffsetThreshold || !bRowLimit) {
            MessageUtil.displayMessage(message, (int)0, (int)-1);
            if (!bOffsetThreshold) {
                this.m_txtOffsetThreshold.requestFocus();
            } else if (!bRowLimit) {
                this.m_txtRowLimit.requestFocus();
            }
        }
        return bOffsetThreshold && bRowLimit;
    }

    protected boolean validateColumnHeadersPanel() {
        return true;
    }

    protected boolean validateFormatsPanel() {
        return true;
    }

    protected boolean validateSearchPanel() {
        return true;
    }

    protected boolean validateEditingPanel() {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.m_defaultDateFormat.getText());
            dateFormat.format(new Date());
        }
        catch (IllegalArgumentException e) {
            Workspace.getDefaultLogger().warn((Object)e.getMessage());
            MessageUtil.displayMessage((String)bundle.getString("ViewDataGlobalOptionsTab.DefaultDateFormatError.txt"), (int)0);
            this.m_defaultDateFormat.requestFocus();
            return false;
        }
        try {
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat(this.m_defaultDateTimeFormat.getText());
            dateTimeFormat.format(new Date());
        }
        catch (IllegalArgumentException e) {
            Workspace.getDefaultLogger().warn((Object)e.getMessage());
            MessageUtil.displayMessage((String)bundle.getString("ViewDataGlobalOptionsTab.DefaultDateTimeFormatError.txt"), (int)0);
            this.m_defaultDateTimeFormat.requestFocus();
            return false;
        }
        return true;
    }

    protected void onClearQueryOptionsOnRefreshClicked() {
    }

    protected void onPromptOnLongRunningNavigationClicked() {
        boolean checked = this.m_promptOnLongRunningNavigation.isSelected();
        this.m_lblOffsetThreshold.setEnabled(checked);
        this.m_txtOffsetThreshold.setEnabled(checked);
    }

    protected void onRowLimitClicked() {
        boolean checked = this.m_ckbRowLimit.isSelected();
        this.m_lblRowLimit.setEnabled(checked);
        this.m_txtRowLimit.setEnabled(checked);
    }

    protected void onColumnNameInHeaderClicked() {
    }

    protected void onColumnDescriptionInHeaderClicked() {
    }

    protected void onColumnMetadataNameInHeaderClicked() {
    }

    protected void onApplyMetadataFormatsClicked() {
        if (this.m_applyMetadataFormats.isSelected()) {
            this.m_applyPermanentFormats.setSelected(true);
            this.m_applyPermanentFormats.setEnabled(false);
        } else {
            this.m_applyPermanentFormats.setEnabled(true);
        }
    }

    protected void onApplyPermanentFormatsClicked() {
    }

    protected void onIgnoreInvalidColumnNamesClicked() {
    }

    protected void onAllowSCD2EditClicked() {
    }

    protected void onDeleteWithoutPromptClicked() {
    }

    private class ClearQueryOptionsOnRefreshAction
    extends WsAbstractToggleAction {
        ClearQueryOptionsOnRefreshAction() {
            super(bundle, "ViewDataGlobalOptionsTab.ClearQueryOptionsOnRefresh", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataGlobalOptionsTab.this.onClearQueryOptionsOnRefreshClicked();
        }
    }

    private class PromptOnLongRunningNavigationAction
    extends WsAbstractToggleAction {
        PromptOnLongRunningNavigationAction() {
            super(bundle, "ViewDataGlobalOptionsTab.PromptOnLongRunningNavigation", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataGlobalOptionsTab.this.onPromptOnLongRunningNavigationClicked();
        }
    }

    private class RowLimitAction
    extends WsAbstractToggleAction {
        RowLimitAction() {
            super(bundle, "ViewDataGlobalOptionsTab.RowLimitOption", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataGlobalOptionsTab.this.onRowLimitClicked();
        }
    }

    private class ColumnNameInHeaderAction
    extends WsAbstractToggleAction {
        ColumnNameInHeaderAction() {
            super(bundle, "ViewDataGlobalOptionsTab.ColumnNameInHeader", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataGlobalOptionsTab.this.onColumnNameInHeaderClicked();
        }
    }

    private class ColumnDescriptionInHeaderAction
    extends WsAbstractToggleAction {
        ColumnDescriptionInHeaderAction() {
            super(bundle, "ViewDataGlobalOptionsTab.ColumnDescriptionInHeader", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataGlobalOptionsTab.this.onColumnDescriptionInHeaderClicked();
        }
    }

    private class ColumnMetadataNameInHeaderAction
    extends WsAbstractToggleAction {
        ColumnMetadataNameInHeaderAction() {
            super(bundle, "ViewDataGlobalOptionsTab.ColumnMDInHeader", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataGlobalOptionsTab.this.onColumnMetadataNameInHeaderClicked();
        }
    }

    private class ApplyMetadataFormatsAction
    extends WsAbstractToggleAction {
        ApplyMetadataFormatsAction() {
            super(bundle, "ViewDataGlobalOptionsTab.ShowMetadataFormats", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataGlobalOptionsTab.this.onApplyMetadataFormatsClicked();
        }
    }

    private class ApplyPermanentFormatsAction
    extends WsAbstractToggleAction {
        ApplyPermanentFormatsAction() {
            super(bundle, "ViewDataGlobalOptionsTab.ShowFormats", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataGlobalOptionsTab.this.onApplyPermanentFormatsClicked();
        }
    }

    private class IgnoreInvalidColumnNamesAction
    extends WsAbstractToggleAction {
        IgnoreInvalidColumnNamesAction() {
            super(bundle, "ViewDataGlobalOptionsTab.IgnoreInvalidColumnNames", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataGlobalOptionsTab.this.onIgnoreInvalidColumnNamesClicked();
        }
    }

    private class AllowSCD2EditAction
    extends WsAbstractToggleAction {
        AllowSCD2EditAction() {
            super(bundle, "ViewDataGlobalOptionsTab.AllowSCD2EditAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataGlobalOptionsTab.this.onAllowSCD2EditClicked();
        }
    }

    private class DeleteWithoutPromptAction
    extends WsAbstractToggleAction {
        DeleteWithoutPromptAction() {
            super(bundle, "ViewDataGlobalOptionsTab.DeleteRowsWithoutPrompt", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ViewDataGlobalOptionsTab.this.onDeleteWithoutPromptClicked();
        }
    }
}

