/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import java.rmi.RemoteException;
import java.util.List;

public abstract class ViewDataDataTableModel
extends ViewDataModel {
    private static WAdminResource bundle = WAdminResource.getBundle(ViewDataDataTableModel.class);
    private DataTable m_dataTable;
    private SASLibrary m_library;

    public ViewDataDataTableModel(DataTable dataTable) {
        this.setDataTable(dataTable);
    }

    @Override
    protected void postFetchDataProcessing() throws ViewDataException {
        if (!this.getViewDataPanel().isFromClosingFrame()) {
            this.setDisplayColumnsChanged(false);
        }
    }

    protected void setDataTable(DataTable dataTable) {
        this.m_dataTable = dataTable;
    }

    public DataTable getDataTable() {
        return this.m_dataTable;
    }

    protected void setLibrary(SASLibrary library) {
        this.m_library = library;
    }

    public SASLibrary getLibrary() {
        return this.m_library;
    }

    @Override
    public String getLibRef() {
        try {
            if (this.m_library != null) {
                return this.m_library.getLibref();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "WORK";
        }
        return "WORK";
    }

    @Override
    public String getTableDisplayName() {
        try {
            return this.getDataTable().getTableName();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    @Override
    public String getTableSQLName() {
        String tableName = "";
        try {
            tableName = this.getDataTable().getTableName();
            return this.prepareTableNameForQuery(tableName);
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return tableName;
    }

    protected String prepareTableNameForQuery(String tableName) throws MdException, RemoteException {
        if (this.isParameterized()) {
            int indexOfAmp = tableName.lastIndexOf(38);
            int indexOfPeriod = tableName.lastIndexOf(46);
            if (indexOfAmp != -1 && indexOfPeriod < indexOfAmp) {
                tableName = tableName + ".";
            }
        }
        return DBMSNamesUtil.getQuotedString((String)tableName, (DataTable)this.getDataTable());
    }

    public Column getColumnMetadata(int column) throws MdException, RemoteException {
        return this.getTrueColumnMetadata(this.convertColumnIndexToTrue(column));
    }

    @Override
    public int getTrueColumnCount() {
        try {
            return this.getColumnMetadata().size();
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return -1;
    }

    @Override
    public String getTrueColumnName(int column) {
        try {
            return this.getTrueColumnMetadata(column).getSASColumnName();
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return bundle.getString("ViewDataDataTableModel.UnknownColumnName.txt");
    }

    @Override
    public String getTrueColumnObjectName(int iColumn) {
        try {
            return this.getTrueColumnMetadata(iColumn).getName();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        return bundle.getString("ViewDataDataTableModel.UnknownColumnName.txt");
    }

    @Override
    public String getTrueColumnDescription(int iColumn) {
        try {
            return this.getTrueColumnMetadata(iColumn).getDesc();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        return "";
    }

    @Override
    public String getTrueColumnFormat(int iColumn) {
        try {
            return this.getTrueColumnMetadata(iColumn).getSASFormat();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        return "";
    }

    @Override
    public String getTrueColumnSQLName(int column) {
        try {
            return this.getTableSQLName() + "." + DBMSNamesUtil.getQuotedString((String)this.getTrueColumnMetadata(column).getSASColumnName(), (DataTable)this.getDataTable());
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return null;
    }

    @Override
    public String getTrueColumnSASType(int column) {
        try {
            return this.getTrueColumnMetadata(column).getSASColumnType();
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return "C";
    }

    @Override
    public int getTrueColumnPrecision(int column) {
        try {
            return ((Column)this.getColumnMetadata().get(column)).getSASColumnLength();
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return -1;
    }

    public Column getTrueColumnMetadata(int column) throws MdException, RemoteException {
        return (Column)this.getColumnMetadata().get(column);
    }

    public List getColumnMetadata() throws MdException, RemoteException {
        return this.getDataTable().getColumns();
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        super.moveDataToModel();
        this.initLibrary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initLibrary() throws MdException, RemoteException {
        WsAppServer defAppServer = WsAppServer.createDefaultAppServer();
        try {
            ServerContext iDefault = defAppServer.getServerContext();
            SASLibrary iLib = LibraryUtil.getLibrary((DataTable)this.getDataTable(), (ServerContext)iDefault);
            if (iLib == null) {
                throw new MdException(bundle.getString("ViewDataDataTableModel.LibrefFetchFail.txt"));
            }
            this.setLibrary(LibraryUtil.getClientLibrary((SASLibrary)iLib, (ServerContext)iDefault));
        }
        finally {
            defAppServer.dispose();
        }
    }

    @Override
    public boolean isFilterable() {
        return true;
    }

    @Override
    public boolean isSortable() {
        return true;
    }

    @Override
    public boolean isSubsetable() {
        return true;
    }

    @Override
    protected String getParameterizedMacroDeclaration() {
        try {
            StringBuffer buffer = new ParametersModel((Root)this.getDataTable()).getParameterMacroCode();
            if (buffer == null) {
                return null;
            }
            return buffer.toString();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String getTableOptions() {
        BaseModel model = new BaseModel();
        model.setUndoSupported(false);
        try {
            MdObjectStore m_store = Workspace.getMdFactory().createObjectStore();
            OMRAdapter omr = new OMRAdapter((IModel)model, Workspace.getMdFactory(), "viewTable");
            try {
                m_store.setGoToServerForMetadata(true);
                if (this.m_dataTable instanceof ExternalTable) {
                    String string = "";
                    return string;
                }
                IPhysicalTable pt = model.getObjectFactory().createPhysicalTable(this.m_dataTable.getId());
                omr.populateFor((IOMRPersistable)pt);
                pt.loadFromOMR(omr);
                String string = pt.getReadTableOptions(true);
                return string;
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (BadLibraryDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (BadServerDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (CodegenException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (ServerException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            finally {
                if (omr != null) {
                    omr.dispose();
                }
                if (m_store != null) {
                    m_store.dispose();
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        try {
            OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)this.getDataTable(), false);
            String dsOptions = OP.getOptionsString();
            if (dsOptions == null) return "";
            if (!dsOptions.trim().equals("")) return " (" + dsOptions + ") ";
            return "";
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            return "";
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        return "";
    }
}

