/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.wadmin.viewdata2.ViewDataUtil;

class SearchComparable
implements Comparable {
    private static boolean RUN_DEAD_CODE = false;
    private String m_searchString;
    private boolean m_caseSensitive;
    private boolean m_trimLeadingSpaces;
    private boolean m_trimTrailingSpaces;
    private MatchType m_matchType;

    public SearchComparable(String s) {
        this(s, MatchType.MATCH_EXACT);
    }

    public SearchComparable(String s, MatchType operator) {
        this(s, operator, true);
    }

    public SearchComparable(String s, MatchType operator, boolean caseSensitive) {
        this(s, operator, caseSensitive, false, true);
    }

    public SearchComparable(String s, MatchType operator, boolean caseSensitive, boolean trimLeadingSpaces, boolean trimTrailingSpaces) {
        if (trimLeadingSpaces) {
            s = ViewDataUtil.trimLeft(s);
        }
        if (trimTrailingSpaces) {
            s = ViewDataUtil.trimRight(s);
        }
        this.setSearchString(s);
        this.setCaseSensitive(caseSensitive);
        this.setMatchType(operator);
        this.setTrimLeadingSearch(trimLeadingSpaces);
        this.setTrimTrailingSearch(trimTrailingSpaces);
    }

    public int compareTo(Object o) {
        String compareString;
        String s1;
        String string = s1 = o == null || this.isCaseSensitive() ? (String)o : ((String)o).toUpperCase();
        if (s1 != null) {
            if (this.isTrimLeadingSearch()) {
                s1 = ViewDataUtil.trimLeft(s1);
            }
            if (this.isTrimTrailingSearch()) {
                s1 = ViewDataUtil.trimRight(s1);
            }
        }
        if (this.getSearchString() == null || "".equals(this.getSearchString())) {
            if (s1 == null || "".equals(s1)) {
                return 0;
            }
            return -1;
        }
        if (s1 == null || "".equals(s1)) {
            return -1;
        }
        String string2 = compareString = this.isCaseSensitive() ? this.getSearchString() : this.getSearchString().toUpperCase();
        if (this.getMatchType() == MatchType.MATCH_EXACT) {
            return s1.equals(compareString) ? 0 : -1;
        }
        if (this.getMatchType() == MatchType.MATCH_BEGINS) {
            return s1.startsWith(compareString) ? 0 : -1;
        }
        return s1.indexOf(compareString) != -1 ? 0 : -1;
    }

    public String getSearchString() {
        return this.m_searchString;
    }

    public void setSearchString(String searchString) {
        this.m_searchString = searchString;
    }

    public boolean isCaseSensitive() {
        return this.m_caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.m_caseSensitive = caseSensitive;
    }

    public MatchType getMatchType() {
        return this.m_matchType;
    }

    public void setMatchType(MatchType type) {
        this.m_matchType = type;
    }

    public boolean isTrimLeadingSearch() {
        return this.m_trimLeadingSpaces;
    }

    public void setTrimLeadingSearch(boolean search) {
        this.m_trimLeadingSpaces = search;
    }

    public boolean isTrimTrailingSearch() {
        return this.m_trimTrailingSpaces;
    }

    public void setTrimTrailingSearch(boolean search) {
        this.m_trimTrailingSpaces = search;
    }

    static {
        if (RUN_DEAD_CODE) {
            new MatchType();
        }
    }

    public static final class MatchType {
        public static final MatchType MATCH_EXACT = new MatchType();
        public static final MatchType MATCH_CONTAINS = new MatchType();
        public static final MatchType MATCH_BEGINS = new MatchType();

        private MatchType() {
        }
    }
}

